/*
 * Copyright 2013-2018 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateDirectoryConfigRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateDirectoryConfigRequest.Builder, CreateDirectoryConfigRequest> {
    private static final SdkField<String> DIRECTORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateDirectoryConfigRequest::directoryName)).setter(setter(Builder::directoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryName").build()).build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .getter(getter(CreateDirectoryConfigRequest::organizationalUnitDistinguishedNames))
            .setter(setter(Builder::organizationalUnitDistinguishedNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OrganizationalUnitDistinguishedNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceAccountCredentials> SERVICE_ACCOUNT_CREDENTIALS_FIELD = SdkField
            .<ServiceAccountCredentials> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateDirectoryConfigRequest::serviceAccountCredentials))
            .setter(setter(Builder::serviceAccountCredentials)).constructor(ServiceAccountCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccountCredentials").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_NAME_FIELD,
            ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD, SERVICE_ACCOUNT_CREDENTIALS_FIELD));

    private final String directoryName;

    private final List<String> organizationalUnitDistinguishedNames;

    private final ServiceAccountCredentials serviceAccountCredentials;

    private CreateDirectoryConfigRequest(BuilderImpl builder) {
        super(builder);
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedNames = builder.organizationalUnitDistinguishedNames;
        this.serviceAccountCredentials = builder.serviceAccountCredentials;
    }

    /**
     * <p>
     * The fully qualified name of the directory (for example, corp.example.com).
     * </p>
     * 
     * @return The fully qualified name of the directory (for example, corp.example.com).
     */
    public String directoryName() {
        return directoryName;
    }

    /**
     * <p>
     * The distinguished names of the organizational units for computer accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The distinguished names of the organizational units for computer accounts.
     */
    public List<String> organizationalUnitDistinguishedNames() {
        return organizationalUnitDistinguishedNames;
    }

    /**
     * <p>
     * The credentials for the service account used by the streaming instance to connect to the directory.
     * </p>
     * 
     * @return The credentials for the service account used by the streaming instance to connect to the directory.
     */
    public ServiceAccountCredentials serviceAccountCredentials() {
        return serviceAccountCredentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        hashCode = 31 * hashCode + Objects.hashCode(organizationalUnitDistinguishedNames());
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountCredentials());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDirectoryConfigRequest)) {
            return false;
        }
        CreateDirectoryConfigRequest other = (CreateDirectoryConfigRequest) obj;
        return Objects.equals(directoryName(), other.directoryName())
                && Objects.equals(organizationalUnitDistinguishedNames(), other.organizationalUnitDistinguishedNames())
                && Objects.equals(serviceAccountCredentials(), other.serviceAccountCredentials());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateDirectoryConfigRequest").add("DirectoryName", directoryName())
                .add("OrganizationalUnitDistinguishedNames", organizationalUnitDistinguishedNames())
                .add("ServiceAccountCredentials", serviceAccountCredentials()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryName":
            return Optional.ofNullable(clazz.cast(directoryName()));
        case "OrganizationalUnitDistinguishedNames":
            return Optional.ofNullable(clazz.cast(organizationalUnitDistinguishedNames()));
        case "ServiceAccountCredentials":
            return Optional.ofNullable(clazz.cast(serviceAccountCredentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateDirectoryConfigRequest, T> g) {
        return obj -> g.apply((CreateDirectoryConfigRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateDirectoryConfigRequest> {
        /**
         * <p>
         * The fully qualified name of the directory (for example, corp.example.com).
         * </p>
         * 
         * @param directoryName
         *        The fully qualified name of the directory (for example, corp.example.com).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(String directoryName);

        /**
         * <p>
         * The distinguished names of the organizational units for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedNames
         *        The distinguished names of the organizational units for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames);

        /**
         * <p>
         * The distinguished names of the organizational units for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedNames
         *        The distinguished names of the organizational units for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedNames(String... organizationalUnitDistinguishedNames);

        /**
         * <p>
         * The credentials for the service account used by the streaming instance to connect to the directory.
         * </p>
         * 
         * @param serviceAccountCredentials
         *        The credentials for the service account used by the streaming instance to connect to the directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials);

        /**
         * <p>
         * The credentials for the service account used by the streaming instance to connect to the directory.
         * </p>
         * This is a convenience that creates an instance of the {@link ServiceAccountCredentials.Builder} avoiding the
         * need to create one manually via {@link ServiceAccountCredentials#builder()}.
         *
         * When the {@link Consumer} completes, {@link ServiceAccountCredentials.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceAccountCredentials(ServiceAccountCredentials)}.
         * 
         * @param serviceAccountCredentials
         *        a consumer that will call methods on {@link ServiceAccountCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAccountCredentials(ServiceAccountCredentials)
         */
        default Builder serviceAccountCredentials(Consumer<ServiceAccountCredentials.Builder> serviceAccountCredentials) {
            return serviceAccountCredentials(ServiceAccountCredentials.builder().applyMutation(serviceAccountCredentials).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String directoryName;

        private List<String> organizationalUnitDistinguishedNames = DefaultSdkAutoConstructList.getInstance();

        private ServiceAccountCredentials serviceAccountCredentials;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateDirectoryConfigRequest model) {
            super(model);
            directoryName(model.directoryName);
            organizationalUnitDistinguishedNames(model.organizationalUnitDistinguishedNames);
            serviceAccountCredentials(model.serviceAccountCredentials);
        }

        public final String getDirectoryName() {
            return directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        public final Collection<String> getOrganizationalUnitDistinguishedNames() {
            return organizationalUnitDistinguishedNames;
        }

        @Override
        public final Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier
                    .copy(organizationalUnitDistinguishedNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitDistinguishedNames(String... organizationalUnitDistinguishedNames) {
            organizationalUnitDistinguishedNames(Arrays.asList(organizationalUnitDistinguishedNames));
            return this;
        }

        public final void setOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier
                    .copy(organizationalUnitDistinguishedNames);
        }

        public final ServiceAccountCredentials.Builder getServiceAccountCredentials() {
            return serviceAccountCredentials != null ? serviceAccountCredentials.toBuilder() : null;
        }

        @Override
        public final Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        public final void setServiceAccountCredentials(ServiceAccountCredentials.BuilderImpl serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials != null ? serviceAccountCredentials.build() : null;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateDirectoryConfigRequest build() {
            return new CreateDirectoryConfigRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
