/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.appstream.model.AppStreamException;
import software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetRequest;
import software.amazon.awssdk.services.appstream.model.AssociateApplicationFleetResponse;
import software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.AssociateApplicationToEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.AssociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.AssociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackRequest;
import software.amazon.awssdk.services.appstream.model.BatchAssociateUserStackResponse;
import software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackRequest;
import software.amazon.awssdk.services.appstream.model.BatchDisassociateUserStackResponse;
import software.amazon.awssdk.services.appstream.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appstream.model.CopyImageRequest;
import software.amazon.awssdk.services.appstream.model.CopyImageResponse;
import software.amazon.awssdk.services.appstream.model.CreateAppBlockRequest;
import software.amazon.awssdk.services.appstream.model.CreateAppBlockResponse;
import software.amazon.awssdk.services.appstream.model.CreateApplicationRequest;
import software.amazon.awssdk.services.appstream.model.CreateApplicationResponse;
import software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.CreateDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.CreateEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.CreateEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.CreateFleetRequest;
import software.amazon.awssdk.services.appstream.model.CreateFleetResponse;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.model.CreateImageBuilderStreamingUrlResponse;
import software.amazon.awssdk.services.appstream.model.CreateStackRequest;
import software.amazon.awssdk.services.appstream.model.CreateStackResponse;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlRequest;
import software.amazon.awssdk.services.appstream.model.CreateStreamingUrlResponse;
import software.amazon.awssdk.services.appstream.model.CreateUpdatedImageRequest;
import software.amazon.awssdk.services.appstream.model.CreateUpdatedImageResponse;
import software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionRequest;
import software.amazon.awssdk.services.appstream.model.CreateUsageReportSubscriptionResponse;
import software.amazon.awssdk.services.appstream.model.CreateUserRequest;
import software.amazon.awssdk.services.appstream.model.CreateUserResponse;
import software.amazon.awssdk.services.appstream.model.DeleteAppBlockRequest;
import software.amazon.awssdk.services.appstream.model.DeleteAppBlockResponse;
import software.amazon.awssdk.services.appstream.model.DeleteApplicationRequest;
import software.amazon.awssdk.services.appstream.model.DeleteApplicationResponse;
import software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.DeleteDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.DeleteEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.DeleteEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.DeleteFleetRequest;
import software.amazon.awssdk.services.appstream.model.DeleteFleetResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImagePermissionsResponse;
import software.amazon.awssdk.services.appstream.model.DeleteImageRequest;
import software.amazon.awssdk.services.appstream.model.DeleteImageResponse;
import software.amazon.awssdk.services.appstream.model.DeleteStackRequest;
import software.amazon.awssdk.services.appstream.model.DeleteStackResponse;
import software.amazon.awssdk.services.appstream.model.DeleteUsageReportSubscriptionRequest;
import software.amazon.awssdk.services.appstream.model.DeleteUsageReportSubscriptionResponse;
import software.amazon.awssdk.services.appstream.model.DeleteUserRequest;
import software.amazon.awssdk.services.appstream.model.DeleteUserResponse;
import software.amazon.awssdk.services.appstream.model.DescribeAppBlocksRequest;
import software.amazon.awssdk.services.appstream.model.DescribeAppBlocksResponse;
import software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeApplicationFleetAssociationsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeApplicationsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeApplicationsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeDirectoryConfigsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeEntitlementsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeEntitlementsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImageBuildersRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImageBuildersResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeImagesRequest;
import software.amazon.awssdk.services.appstream.model.DescribeImagesResponse;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeSessionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeStacksRequest;
import software.amazon.awssdk.services.appstream.model.DescribeStacksResponse;
import software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeUsageReportSubscriptionsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeUserStackAssociationsResponse;
import software.amazon.awssdk.services.appstream.model.DescribeUsersRequest;
import software.amazon.awssdk.services.appstream.model.DescribeUsersResponse;
import software.amazon.awssdk.services.appstream.model.DisableUserRequest;
import software.amazon.awssdk.services.appstream.model.DisableUserResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateApplicationFleetResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateApplicationFromEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetRequest;
import software.amazon.awssdk.services.appstream.model.DisassociateFleetResponse;
import software.amazon.awssdk.services.appstream.model.EnableUserRequest;
import software.amazon.awssdk.services.appstream.model.EnableUserResponse;
import software.amazon.awssdk.services.appstream.model.EntitlementAlreadyExistsException;
import software.amazon.awssdk.services.appstream.model.EntitlementNotFoundException;
import software.amazon.awssdk.services.appstream.model.ExpireSessionRequest;
import software.amazon.awssdk.services.appstream.model.ExpireSessionResponse;
import software.amazon.awssdk.services.appstream.model.IncompatibleImageException;
import software.amazon.awssdk.services.appstream.model.InvalidAccountStatusException;
import software.amazon.awssdk.services.appstream.model.InvalidParameterCombinationException;
import software.amazon.awssdk.services.appstream.model.InvalidRoleException;
import software.amazon.awssdk.services.appstream.model.LimitExceededException;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedFleetsResponse;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksRequest;
import software.amazon.awssdk.services.appstream.model.ListAssociatedStacksResponse;
import software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsRequest;
import software.amazon.awssdk.services.appstream.model.ListEntitledApplicationsResponse;
import software.amazon.awssdk.services.appstream.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appstream.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appstream.model.OperationNotPermittedException;
import software.amazon.awssdk.services.appstream.model.RequestLimitExceededException;
import software.amazon.awssdk.services.appstream.model.ResourceAlreadyExistsException;
import software.amazon.awssdk.services.appstream.model.ResourceInUseException;
import software.amazon.awssdk.services.appstream.model.ResourceNotAvailableException;
import software.amazon.awssdk.services.appstream.model.ResourceNotFoundException;
import software.amazon.awssdk.services.appstream.model.StartFleetRequest;
import software.amazon.awssdk.services.appstream.model.StartFleetResponse;
import software.amazon.awssdk.services.appstream.model.StartImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.StartImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.StopFleetRequest;
import software.amazon.awssdk.services.appstream.model.StopFleetResponse;
import software.amazon.awssdk.services.appstream.model.StopImageBuilderRequest;
import software.amazon.awssdk.services.appstream.model.StopImageBuilderResponse;
import software.amazon.awssdk.services.appstream.model.TagResourceRequest;
import software.amazon.awssdk.services.appstream.model.TagResourceResponse;
import software.amazon.awssdk.services.appstream.model.UntagResourceRequest;
import software.amazon.awssdk.services.appstream.model.UntagResourceResponse;
import software.amazon.awssdk.services.appstream.model.UpdateApplicationRequest;
import software.amazon.awssdk.services.appstream.model.UpdateApplicationResponse;
import software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigRequest;
import software.amazon.awssdk.services.appstream.model.UpdateDirectoryConfigResponse;
import software.amazon.awssdk.services.appstream.model.UpdateEntitlementRequest;
import software.amazon.awssdk.services.appstream.model.UpdateEntitlementResponse;
import software.amazon.awssdk.services.appstream.model.UpdateFleetRequest;
import software.amazon.awssdk.services.appstream.model.UpdateFleetResponse;
import software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsRequest;
import software.amazon.awssdk.services.appstream.model.UpdateImagePermissionsResponse;
import software.amazon.awssdk.services.appstream.model.UpdateStackRequest;
import software.amazon.awssdk.services.appstream.model.UpdateStackResponse;
import software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable;
import software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable;
import software.amazon.awssdk.services.appstream.waiters.AppStreamWaiter;

/**
 * Service client for accessing Amazon AppStream. This can be created using the static {@link #builder()} method.
 *
 * <fullname>Amazon AppStream 2.0</fullname>
 * <p>
 * This is the <i>Amazon AppStream 2.0 API Reference</i>. This documentation provides descriptions and syntax for each
 * of the actions and data types in AppStream 2.0. AppStream 2.0 is a fully managed, secure application streaming
 * service that lets you stream desktop applications to users without rewriting applications. AppStream 2.0 manages the
 * AWS resources that are required to host and run your applications, scales automatically, and provides access to your
 * users on demand.
 * </p>
 * <note>
 * <p>
 * You can call the AppStream 2.0 API operations by using an interface VPC endpoint (interface endpoint). For more
 * information, see <a href=
 * "https://docs.aws.amazon.com/appstream2/latest/developerguide/access-api-cli-through-interface-vpc-endpoint.html"
 * >Access AppStream 2.0 API Operations and CLI Commands Through an Interface VPC Endpoint</a> in the <i>Amazon
 * AppStream 2.0 Administration Guide</i>.
 * </p>
 * </note>
 * <p>
 * To learn more about AppStream 2.0, see the following resources:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href="http://aws.amazon.com/appstream2">Amazon AppStream 2.0 product page</a>
 * </p>
 * </li>
 * <li>
 * <p>
 * <a href="http://aws.amazon.com/documentation/appstream2">Amazon AppStream 2.0 documentation</a>
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppStreamClient extends AwsClient {
    String SERVICE_NAME = "appstream";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appstream2";

    /**
     * <p>
     * Associates the specified application with the specified fleet. This is only supported for Elastic fleets.
     * </p>
     *
     * @param associateApplicationFleetRequest
     * @return Result of the AssociateApplicationFleet operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateApplicationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateApplicationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateApplicationFleetResponse associateApplicationFleet(
            AssociateApplicationFleetRequest associateApplicationFleetRequest) throws ConcurrentModificationException,
            LimitExceededException, ResourceNotFoundException, InvalidParameterCombinationException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified application with the specified fleet. This is only supported for Elastic fleets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApplicationFleetRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateApplicationFleetRequest#builder()}
     * </p>
     *
     * @param associateApplicationFleetRequest
     *        A {@link Consumer} that will call methods on {@link AssociateApplicationFleetRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateApplicationFleet operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateApplicationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateApplicationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateApplicationFleetResponse associateApplicationFleet(
            Consumer<AssociateApplicationFleetRequest.Builder> associateApplicationFleetRequest)
            throws ConcurrentModificationException, LimitExceededException, ResourceNotFoundException,
            InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        return associateApplicationFleet(AssociateApplicationFleetRequest.builder()
                .applyMutation(associateApplicationFleetRequest).build());
    }

    /**
     * <p>
     * Associates an application to entitle.
     * </p>
     *
     * @param associateApplicationToEntitlementRequest
     * @return Result of the AssociateApplicationToEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateApplicationToEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateApplicationToEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateApplicationToEntitlementResponse associateApplicationToEntitlement(
            AssociateApplicationToEntitlementRequest associateApplicationToEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates an application to entitle.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApplicationToEntitlementRequest.Builder}
     * avoiding the need to create one manually via {@link AssociateApplicationToEntitlementRequest#builder()}
     * </p>
     *
     * @param associateApplicationToEntitlementRequest
     *        A {@link Consumer} that will call methods on {@link AssociateApplicationToEntitlementRequest.Builder} to
     *        create a request.
     * @return Result of the AssociateApplicationToEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateApplicationToEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateApplicationToEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateApplicationToEntitlementResponse associateApplicationToEntitlement(
            Consumer<AssociateApplicationToEntitlementRequest.Builder> associateApplicationToEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            LimitExceededException, AwsServiceException, SdkClientException, AppStreamException {
        return associateApplicationToEntitlement(AssociateApplicationToEntitlementRequest.builder()
                .applyMutation(associateApplicationToEntitlementRequest).build());
    }

    /**
     * <p>
     * Associates the specified fleet with the specified stack.
     * </p>
     *
     * @param associateFleetRequest
     * @return Result of the AssociateFleet operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateFleetResponse associateFleet(AssociateFleetRequest associateFleetRequest) throws LimitExceededException,
            InvalidAccountStatusException, ResourceNotFoundException, ConcurrentModificationException,
            IncompatibleImageException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified fleet with the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateFleetRequest#builder()}
     * </p>
     *
     * @param associateFleetRequest
     *        A {@link Consumer} that will call methods on {@link AssociateFleetRequest.Builder} to create a request.
     * @return Result of the AssociateFleet operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.AssociateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/AssociateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateFleetResponse associateFleet(Consumer<AssociateFleetRequest.Builder> associateFleetRequest)
            throws LimitExceededException, InvalidAccountStatusException, ResourceNotFoundException,
            ConcurrentModificationException, IncompatibleImageException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, AppStreamException {
        return associateFleet(AssociateFleetRequest.builder().applyMutation(associateFleetRequest).build());
    }

    /**
     * <p>
     * Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with
     * fleets that are joined to an Active Directory domain.
     * </p>
     *
     * @param batchAssociateUserStackRequest
     * @return Result of the BatchAssociateUserStack operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.BatchAssociateUserStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchAssociateUserStack"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateUserStackResponse batchAssociateUserStack(BatchAssociateUserStackRequest batchAssociateUserStackRequest)
            throws OperationNotPermittedException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Associates the specified users with the specified stacks. Users in a user pool cannot be assigned to stacks with
     * fleets that are joined to an Active Directory domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchAssociateUserStackRequest.Builder} avoiding
     * the need to create one manually via {@link BatchAssociateUserStackRequest#builder()}
     * </p>
     *
     * @param batchAssociateUserStackRequest
     *        A {@link Consumer} that will call methods on {@link BatchAssociateUserStackRequest.Builder} to create a
     *        request.
     * @return Result of the BatchAssociateUserStack operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.BatchAssociateUserStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchAssociateUserStack"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchAssociateUserStackResponse batchAssociateUserStack(
            Consumer<BatchAssociateUserStackRequest.Builder> batchAssociateUserStackRequest)
            throws OperationNotPermittedException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            AppStreamException {
        return batchAssociateUserStack(BatchAssociateUserStackRequest.builder().applyMutation(batchAssociateUserStackRequest)
                .build());
    }

    /**
     * <p>
     * Disassociates the specified users from the specified stacks.
     * </p>
     *
     * @param batchDisassociateUserStackRequest
     * @return Result of the BatchDisassociateUserStack operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.BatchDisassociateUserStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchDisassociateUserStack"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateUserStackResponse batchDisassociateUserStack(
            BatchDisassociateUserStackRequest batchDisassociateUserStackRequest) throws OperationNotPermittedException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified users from the specified stacks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link BatchDisassociateUserStackRequest.Builder} avoiding
     * the need to create one manually via {@link BatchDisassociateUserStackRequest#builder()}
     * </p>
     *
     * @param batchDisassociateUserStackRequest
     *        A {@link Consumer} that will call methods on {@link BatchDisassociateUserStackRequest.Builder} to create a
     *        request.
     * @return Result of the BatchDisassociateUserStack operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.BatchDisassociateUserStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/BatchDisassociateUserStack"
     *      target="_top">AWS API Documentation</a>
     */
    default BatchDisassociateUserStackResponse batchDisassociateUserStack(
            Consumer<BatchDisassociateUserStackRequest.Builder> batchDisassociateUserStackRequest)
            throws OperationNotPermittedException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            AppStreamException {
        return batchDisassociateUserStack(BatchDisassociateUserStackRequest.builder()
                .applyMutation(batchDisassociateUserStackRequest).build());
    }

    /**
     * <p>
     * Copies the image within the same region or to a new region within the same AWS account. Note that any tags you
     * added to the image will not be copied.
     * </p>
     *
     * @param copyImageRequest
     * @return Result of the CopyImage operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyImageResponse copyImage(CopyImageRequest copyImageRequest) throws ResourceAlreadyExistsException,
            ResourceNotFoundException, ResourceNotAvailableException, LimitExceededException, InvalidAccountStatusException,
            IncompatibleImageException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Copies the image within the same region or to a new region within the same AWS account. Note that any tags you
     * added to the image will not be copied.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CopyImageRequest.Builder} avoiding the need to
     * create one manually via {@link CopyImageRequest#builder()}
     * </p>
     *
     * @param copyImageRequest
     *        A {@link Consumer} that will call methods on {@link CopyImageRequest.Builder} to create a request.
     * @return Result of the CopyImage operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CopyImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CopyImage" target="_top">AWS API
     *      Documentation</a>
     */
    default CopyImageResponse copyImage(Consumer<CopyImageRequest.Builder> copyImageRequest)
            throws ResourceAlreadyExistsException, ResourceNotFoundException, ResourceNotAvailableException,
            LimitExceededException, InvalidAccountStatusException, IncompatibleImageException, AwsServiceException,
            SdkClientException, AppStreamException {
        return copyImage(CopyImageRequest.builder().applyMutation(copyImageRequest).build());
    }

    /**
     * <p>
     * Creates an app block.
     * </p>
     * <p>
     * App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3
     * bucket. It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard
     * disk includes the application binaries and other files necessary to launch your applications. Multiple
     * applications can be assigned to a single app block.
     * </p>
     * <p>
     * This is only supported for Elastic fleets.
     * </p>
     *
     * @param createAppBlockRequest
     * @return Result of the CreateAppBlock operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateAppBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateAppBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppBlockResponse createAppBlock(CreateAppBlockRequest createAppBlockRequest)
            throws ConcurrentModificationException, LimitExceededException, OperationNotPermittedException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an app block.
     * </p>
     * <p>
     * App blocks are an Amazon AppStream 2.0 resource that stores the details about the virtual hard disk in an S3
     * bucket. It also stores the setup script with details about how to mount the virtual hard disk. The virtual hard
     * disk includes the application binaries and other files necessary to launch your applications. Multiple
     * applications can be assigned to a single app block.
     * </p>
     * <p>
     * This is only supported for Elastic fleets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateAppBlockRequest.Builder} avoiding the need to
     * create one manually via {@link CreateAppBlockRequest#builder()}
     * </p>
     *
     * @param createAppBlockRequest
     *        A {@link Consumer} that will call methods on {@link CreateAppBlockRequest.Builder} to create a request.
     * @return Result of the CreateAppBlock operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateAppBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateAppBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateAppBlockResponse createAppBlock(Consumer<CreateAppBlockRequest.Builder> createAppBlockRequest)
            throws ConcurrentModificationException, LimitExceededException, OperationNotPermittedException,
            ResourceAlreadyExistsException, AwsServiceException, SdkClientException, AppStreamException {
        return createAppBlock(CreateAppBlockRequest.builder().applyMutation(createAppBlockRequest).build());
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * <p>
     * Applications are an Amazon AppStream 2.0 resource that stores the details about how to launch applications on
     * Elastic fleet streaming instances. An application consists of the launch details, icon, and display name.
     * Applications are associated with an app block that contains the application binaries and other files. The
     * applications assigned to an Elastic fleet are the applications users can launch.
     * </p>
     * <p>
     * This is only supported for Elastic fleets.
     * </p>
     *
     * @param createApplicationRequest
     * @return Result of the CreateApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateApplicationResponse createApplication(CreateApplicationRequest createApplicationRequest)
            throws OperationNotPermittedException, ResourceAlreadyExistsException, LimitExceededException,
            ConcurrentModificationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an application.
     * </p>
     * <p>
     * Applications are an Amazon AppStream 2.0 resource that stores the details about how to launch applications on
     * Elastic fleet streaming instances. An application consists of the launch details, icon, and display name.
     * Applications are associated with an app block that contains the application binaries and other files. The
     * applications assigned to an Elastic fleet are the applications users can launch.
     * </p>
     * <p>
     * This is only supported for Elastic fleets.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link CreateApplicationRequest#builder()}
     * </p>
     *
     * @param createApplicationRequest
     *        A {@link Consumer} that will call methods on {@link CreateApplicationRequest.Builder} to create a request.
     * @return Result of the CreateApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateApplicationResponse createApplication(Consumer<CreateApplicationRequest.Builder> createApplicationRequest)
            throws OperationNotPermittedException, ResourceAlreadyExistsException, LimitExceededException,
            ConcurrentModificationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return createApplication(CreateApplicationRequest.builder().applyMutation(createApplicationRequest).build());
    }

    /**
     * <p>
     * Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required
     * to join fleets and image builders to Microsoft Active Directory domains.
     * </p>
     *
     * @param createDirectoryConfigRequest
     * @return Result of the CreateDirectoryConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectoryConfigResponse createDirectoryConfig(CreateDirectoryConfigRequest createDirectoryConfigRequest)
            throws ResourceNotFoundException, ResourceAlreadyExistsException, LimitExceededException,
            InvalidAccountStatusException, OperationNotPermittedException, InvalidRoleException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a Directory Config object in AppStream 2.0. This object includes the configuration information required
     * to join fleets and image builders to Microsoft Active Directory domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link CreateDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param createDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link CreateDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return Result of the CreateDirectoryConfig operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateDirectoryConfigResponse createDirectoryConfig(
            Consumer<CreateDirectoryConfigRequest.Builder> createDirectoryConfigRequest) throws ResourceNotFoundException,
            ResourceAlreadyExistsException, LimitExceededException, InvalidAccountStatusException,
            OperationNotPermittedException, InvalidRoleException, AwsServiceException, SdkClientException, AppStreamException {
        return createDirectoryConfig(CreateDirectoryConfigRequest.builder().applyMutation(createDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Creates a new entitlement. Entitlements control access to specific applications within a stack, based on user
     * attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and
     * streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream
     * view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.
     * </p>
     *
     * @param createEntitlementRequest
     * @return Result of the CreateEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws EntitlementAlreadyExistsException
     *         The entitlement already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEntitlementResponse createEntitlement(CreateEntitlementRequest createEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, LimitExceededException,
            EntitlementAlreadyExistsException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new entitlement. Entitlements control access to specific applications within a stack, based on user
     * attributes. Entitlements apply to SAML 2.0 federated user identities. Amazon AppStream 2.0 user pool and
     * streaming URL users are entitled to all applications in a stack. Entitlements don't apply to the desktop stream
     * view application, or to applications managed by a dynamic app provider using the Dynamic Application Framework.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateEntitlementRequest.Builder} avoiding the need
     * to create one manually via {@link CreateEntitlementRequest#builder()}
     * </p>
     *
     * @param createEntitlementRequest
     *        A {@link Consumer} that will call methods on {@link CreateEntitlementRequest.Builder} to create a request.
     * @return Result of the CreateEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws EntitlementAlreadyExistsException
     *         The entitlement already exists.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateEntitlementResponse createEntitlement(Consumer<CreateEntitlementRequest.Builder> createEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, LimitExceededException,
            EntitlementAlreadyExistsException, AwsServiceException, SdkClientException, AppStreamException {
        return createEntitlement(CreateEntitlementRequest.builder().applyMutation(createEntitlementRequest).build());
    }

    /**
     * <p>
     * Creates a fleet. A fleet consists of streaming instances that your users access for their applications and
     * desktops.
     * </p>
     *
     * @param createFleetRequest
     * @return Result of the CreateFleet operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(CreateFleetRequest createFleetRequest) throws ResourceAlreadyExistsException,
            ResourceNotAvailableException, ResourceNotFoundException, LimitExceededException, RequestLimitExceededException,
            InvalidAccountStatusException, InvalidRoleException, ConcurrentModificationException,
            InvalidParameterCombinationException, IncompatibleImageException, OperationNotPermittedException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a fleet. A fleet consists of streaming instances that your users access for their applications and
     * desktops.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFleetRequest#builder()}
     * </p>
     *
     * @param createFleetRequest
     *        A {@link Consumer} that will call methods on {@link CreateFleetRequest.Builder} to create a request.
     * @return Result of the CreateFleet operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFleetResponse createFleet(Consumer<CreateFleetRequest.Builder> createFleetRequest)
            throws ResourceAlreadyExistsException, ResourceNotAvailableException, ResourceNotFoundException,
            LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException, InvalidRoleException,
            ConcurrentModificationException, InvalidParameterCombinationException, IncompatibleImageException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        return createFleet(CreateFleetRequest.builder().applyMutation(createFleetRequest).build());
    }

    /**
     * <p>
     * Creates an image builder. An image builder is a virtual machine that is used to create an image.
     * </p>
     * <p>
     * The initial state of the builder is <code>PENDING</code>. When it is ready, the state is <code>RUNNING</code>.
     * </p>
     *
     * @param createImageBuilderRequest
     * @return Result of the CreateImageBuilder operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateImageBuilderResponse createImageBuilder(CreateImageBuilderRequest createImageBuilderRequest)
            throws LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException,
            ResourceAlreadyExistsException, ResourceNotAvailableException, ResourceNotFoundException, InvalidRoleException,
            ConcurrentModificationException, InvalidParameterCombinationException, IncompatibleImageException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an image builder. An image builder is a virtual machine that is used to create an image.
     * </p>
     * <p>
     * The initial state of the builder is <code>PENDING</code>. When it is ready, the state is <code>RUNNING</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageBuilderRequest.Builder} avoiding the
     * need to create one manually via {@link CreateImageBuilderRequest#builder()}
     * </p>
     *
     * @param createImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageBuilderRequest.Builder} to create a
     *        request.
     * @return Result of the CreateImageBuilder operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateImageBuilderResponse createImageBuilder(Consumer<CreateImageBuilderRequest.Builder> createImageBuilderRequest)
            throws LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException,
            ResourceAlreadyExistsException, ResourceNotAvailableException, ResourceNotFoundException, InvalidRoleException,
            ConcurrentModificationException, InvalidParameterCombinationException, IncompatibleImageException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        return createImageBuilder(CreateImageBuilderRequest.builder().applyMutation(createImageBuilderRequest).build());
    }

    /**
     * <p>
     * Creates a URL to start an image builder streaming session.
     * </p>
     *
     * @param createImageBuilderStreamingUrlRequest
     * @return Result of the CreateImageBuilderStreamingURL operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilderStreamingURL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateImageBuilderStreamingUrlResponse createImageBuilderStreamingURL(
            CreateImageBuilderStreamingUrlRequest createImageBuilderStreamingUrlRequest) throws OperationNotPermittedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a URL to start an image builder streaming session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateImageBuilderStreamingUrlRequest.Builder}
     * avoiding the need to create one manually via {@link CreateImageBuilderStreamingUrlRequest#builder()}
     * </p>
     *
     * @param createImageBuilderStreamingUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateImageBuilderStreamingURLRequest.Builder} to
     *        create a request.
     * @return Result of the CreateImageBuilderStreamingURL operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateImageBuilderStreamingURL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateImageBuilderStreamingURL"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateImageBuilderStreamingUrlResponse createImageBuilderStreamingURL(
            Consumer<CreateImageBuilderStreamingUrlRequest.Builder> createImageBuilderStreamingUrlRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return createImageBuilderStreamingURL(CreateImageBuilderStreamingUrlRequest.builder()
                .applyMutation(createImageBuilderStreamingUrlRequest).build());
    }

    /**
     * <p>
     * Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access
     * policies, and storage configurations.
     * </p>
     *
     * @param createStackRequest
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStackResponse createStack(CreateStackRequest createStackRequest) throws LimitExceededException,
            InvalidAccountStatusException, ResourceAlreadyExistsException, ConcurrentModificationException, InvalidRoleException,
            ResourceNotFoundException, InvalidParameterCombinationException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a stack to start streaming applications to users. A stack consists of an associated fleet, user access
     * policies, and storage configurations.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStackRequest.Builder} avoiding the need to
     * create one manually via {@link CreateStackRequest#builder()}
     * </p>
     *
     * @param createStackRequest
     *        A {@link Consumer} that will call methods on {@link CreateStackRequest.Builder} to create a request.
     * @return Result of the CreateStack operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateStackResponse createStack(Consumer<CreateStackRequest.Builder> createStackRequest)
            throws LimitExceededException, InvalidAccountStatusException, ResourceAlreadyExistsException,
            ConcurrentModificationException, InvalidRoleException, ResourceNotFoundException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        return createStack(CreateStackRequest.builder().applyMutation(createStackRequest).build());
    }

    /**
     * <p>
     * Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL
     * enables application streaming to be tested without user setup.
     * </p>
     *
     * @param createStreamingUrlRequest
     * @return Result of the CreateStreamingURL operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStreamingURL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStreamingUrlResponse createStreamingURL(CreateStreamingUrlRequest createStreamingUrlRequest)
            throws ResourceNotFoundException, ResourceNotAvailableException, OperationNotPermittedException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a temporary URL to start an AppStream 2.0 streaming session for the specified user. A streaming URL
     * enables application streaming to be tested without user setup.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateStreamingUrlRequest.Builder} avoiding the
     * need to create one manually via {@link CreateStreamingUrlRequest#builder()}
     * </p>
     *
     * @param createStreamingUrlRequest
     *        A {@link Consumer} that will call methods on {@link CreateStreamingURLRequest.Builder} to create a
     *        request.
     * @return Result of the CreateStreamingURL operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateStreamingURL
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateStreamingURL" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateStreamingUrlResponse createStreamingURL(Consumer<CreateStreamingUrlRequest.Builder> createStreamingUrlRequest)
            throws ResourceNotFoundException, ResourceNotAvailableException, OperationNotPermittedException,
            InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        return createStreamingURL(CreateStreamingUrlRequest.builder().applyMutation(createStreamingUrlRequest).build());
    }

    /**
     * <p>
     * Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent
     * software.
     * </p>
     * <p>
     * For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html">Administer Your
     * AppStream 2.0 Images</a>, in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     *
     * @param createUpdatedImageRequest
     * @return Result of the CreateUpdatedImage operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUpdatedImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUpdatedImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUpdatedImageResponse createUpdatedImage(CreateUpdatedImageRequest createUpdatedImageRequest)
            throws LimitExceededException, InvalidAccountStatusException, OperationNotPermittedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ConcurrentModificationException,
            IncompatibleImageException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new image with the latest Windows operating system updates, driver updates, and AppStream 2.0 agent
     * software.
     * </p>
     * <p>
     * For more information, see the "Update an Image by Using Managed AppStream 2.0 Image Updates" section in <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/administer-images.html">Administer Your
     * AppStream 2.0 Images</a>, in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUpdatedImageRequest.Builder} avoiding the
     * need to create one manually via {@link CreateUpdatedImageRequest#builder()}
     * </p>
     *
     * @param createUpdatedImageRequest
     *        A {@link Consumer} that will call methods on {@link CreateUpdatedImageRequest.Builder} to create a
     *        request.
     * @return Result of the CreateUpdatedImage operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUpdatedImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUpdatedImage" target="_top">AWS
     *      API Documentation</a>
     */
    default CreateUpdatedImageResponse createUpdatedImage(Consumer<CreateUpdatedImageRequest.Builder> createUpdatedImageRequest)
            throws LimitExceededException, InvalidAccountStatusException, OperationNotPermittedException,
            ResourceAlreadyExistsException, ResourceNotFoundException, ConcurrentModificationException,
            IncompatibleImageException, AwsServiceException, SdkClientException, AppStreamException {
        return createUpdatedImage(CreateUpdatedImageRequest.builder().applyMutation(createUpdatedImageRequest).build());
    }

    /**
     * <p>
     * Creates a usage report subscription. Usage reports are generated daily.
     * </p>
     *
     * @param createUsageReportSubscriptionRequest
     * @return Result of the CreateUsageReportSubscription operation returned by the service.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUsageReportSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUsageReportSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUsageReportSubscriptionResponse createUsageReportSubscription(
            CreateUsageReportSubscriptionRequest createUsageReportSubscriptionRequest) throws InvalidRoleException,
            InvalidAccountStatusException, LimitExceededException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a usage report subscription. Usage reports are generated daily.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUsageReportSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link CreateUsageReportSubscriptionRequest#builder()}
     * </p>
     *
     * @param createUsageReportSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link CreateUsageReportSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the CreateUsageReportSubscription operation returned by the service.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUsageReportSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUsageReportSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default CreateUsageReportSubscriptionResponse createUsageReportSubscription(
            Consumer<CreateUsageReportSubscriptionRequest.Builder> createUsageReportSubscriptionRequest)
            throws InvalidRoleException, InvalidAccountStatusException, LimitExceededException, AwsServiceException,
            SdkClientException, AppStreamException {
        return createUsageReportSubscription(CreateUsageReportSubscriptionRequest.builder()
                .applyMutation(createUsageReportSubscriptionRequest).build());
    }

    /**
     * <p>
     * Creates a new user in the user pool.
     * </p>
     *
     * @param createUserRequest
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(CreateUserRequest createUserRequest) throws ResourceAlreadyExistsException,
            InvalidAccountStatusException, InvalidParameterCombinationException, LimitExceededException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new user in the user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateUserRequest.Builder} avoiding the need to
     * create one manually via {@link CreateUserRequest#builder()}
     * </p>
     *
     * @param createUserRequest
     *        A {@link Consumer} that will call methods on {@link CreateUserRequest.Builder} to create a request.
     * @return Result of the CreateUser operation returned by the service.
     * @throws ResourceAlreadyExistsException
     *         The specified resource already exists.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.CreateUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/CreateUser" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateUserResponse createUser(Consumer<CreateUserRequest.Builder> createUserRequest)
            throws ResourceAlreadyExistsException, InvalidAccountStatusException, InvalidParameterCombinationException,
            LimitExceededException, OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        return createUser(CreateUserRequest.builder().applyMutation(createUserRequest).build());
    }

    /**
     * <p>
     * Deletes an app block.
     * </p>
     *
     * @param deleteAppBlockRequest
     * @return Result of the DeleteAppBlock operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteAppBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteAppBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppBlockResponse deleteAppBlock(DeleteAppBlockRequest deleteAppBlockRequest)
            throws ConcurrentModificationException, ResourceInUseException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an app block.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteAppBlockRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteAppBlockRequest#builder()}
     * </p>
     *
     * @param deleteAppBlockRequest
     *        A {@link Consumer} that will call methods on {@link DeleteAppBlockRequest.Builder} to create a request.
     * @return Result of the DeleteAppBlock operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteAppBlock
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteAppBlock" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteAppBlockResponse deleteAppBlock(Consumer<DeleteAppBlockRequest.Builder> deleteAppBlockRequest)
            throws ConcurrentModificationException, ResourceInUseException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        return deleteAppBlock(DeleteAppBlockRequest.builder().applyMutation(deleteAppBlockRequest).build());
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     *
     * @param deleteApplicationRequest
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(DeleteApplicationRequest deleteApplicationRequest)
            throws OperationNotPermittedException, ResourceInUseException, ResourceNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteApplicationRequest#builder()}
     * </p>
     *
     * @param deleteApplicationRequest
     *        A {@link Consumer} that will call methods on {@link DeleteApplicationRequest.Builder} to create a request.
     * @return Result of the DeleteApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteApplicationResponse deleteApplication(Consumer<DeleteApplicationRequest.Builder> deleteApplicationRequest)
            throws OperationNotPermittedException, ResourceInUseException, ResourceNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteApplication(DeleteApplicationRequest.builder().applyMutation(deleteApplicationRequest).build());
    }

    /**
     * <p>
     * Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required
     * to join streaming instances to an Active Directory domain.
     * </p>
     *
     * @param deleteDirectoryConfigRequest
     * @return Result of the DeleteDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectoryConfigResponse deleteDirectoryConfig(DeleteDirectoryConfigRequest deleteDirectoryConfigRequest)
            throws ResourceInUseException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified Directory Config object from AppStream 2.0. This object includes the information required
     * to join streaming instances to an Active Directory domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param deleteDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link DeleteDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteDirectoryConfigResponse deleteDirectoryConfig(
            Consumer<DeleteDirectoryConfigRequest.Builder> deleteDirectoryConfigRequest) throws ResourceInUseException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteDirectoryConfig(DeleteDirectoryConfigRequest.builder().applyMutation(deleteDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Deletes the specified entitlement.
     * </p>
     *
     * @param deleteEntitlementRequest
     * @return Result of the DeleteEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEntitlementResponse deleteEntitlement(DeleteEntitlementRequest deleteEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified entitlement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteEntitlementRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteEntitlementRequest#builder()}
     * </p>
     *
     * @param deleteEntitlementRequest
     *        A {@link Consumer} that will call methods on {@link DeleteEntitlementRequest.Builder} to create a request.
     * @return Result of the DeleteEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteEntitlementResponse deleteEntitlement(Consumer<DeleteEntitlementRequest.Builder> deleteEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteEntitlement(DeleteEntitlementRequest.builder().applyMutation(deleteEntitlementRequest).build());
    }

    /**
     * <p>
     * Deletes the specified fleet.
     * </p>
     *
     * @param deleteFleetRequest
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(DeleteFleetRequest deleteFleetRequest) throws ResourceInUseException,
            ResourceNotFoundException, ConcurrentModificationException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFleetRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFleetRequest#builder()}
     * </p>
     *
     * @param deleteFleetRequest
     *        A {@link Consumer} that will call methods on {@link DeleteFleetRequest.Builder} to create a request.
     * @return Result of the DeleteFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFleetResponse deleteFleet(Consumer<DeleteFleetRequest.Builder> deleteFleetRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        return deleteFleet(DeleteFleetRequest.builder().applyMutation(deleteFleetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot
     * provision new capacity using the image.
     * </p>
     *
     * @param deleteImageRequest
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImageResponse deleteImage(DeleteImageRequest deleteImageRequest) throws ResourceInUseException,
            ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified image. You cannot delete an image when it is in use. After you delete an image, you cannot
     * provision new capacity using the image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteImageRequest#builder()}
     * </p>
     *
     * @param deleteImageRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageRequest.Builder} to create a request.
     * @return Result of the DeleteImage operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImage
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImage" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteImageResponse deleteImage(Consumer<DeleteImageRequest.Builder> deleteImageRequest)
            throws ResourceInUseException, ResourceNotFoundException, OperationNotPermittedException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteImage(DeleteImageRequest.builder().applyMutation(deleteImageRequest).build());
    }

    /**
     * <p>
     * Deletes the specified image builder and releases the capacity.
     * </p>
     *
     * @param deleteImageBuilderRequest
     * @return Result of the DeleteImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteImageBuilderResponse deleteImageBuilder(DeleteImageBuilderRequest deleteImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified image builder and releases the capacity.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImageBuilderRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImageBuilderRequest#builder()}
     * </p>
     *
     * @param deleteImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImageBuilderRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default DeleteImageBuilderResponse deleteImageBuilder(Consumer<DeleteImageBuilderRequest.Builder> deleteImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        return deleteImageBuilder(DeleteImageBuilderRequest.builder().applyMutation(deleteImageBuilderRequest).build());
    }

    /**
     * <p>
     * Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to
     * which you previously granted these permissions can no longer use the image.
     * </p>
     *
     * @param deleteImagePermissionsRequest
     * @return Result of the DeleteImagePermissions operation returned by the service.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteImagePermissionsResponse deleteImagePermissions(DeleteImagePermissionsRequest deleteImagePermissionsRequest)
            throws ResourceNotAvailableException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes permissions for the specified private image. After you delete permissions for an image, AWS accounts to
     * which you previously granted these permissions can no longer use the image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteImagePermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link DeleteImagePermissionsRequest#builder()}
     * </p>
     *
     * @param deleteImagePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DeleteImagePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the DeleteImagePermissions operation returned by the service.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteImagePermissionsResponse deleteImagePermissions(
            Consumer<DeleteImagePermissionsRequest.Builder> deleteImagePermissionsRequest) throws ResourceNotAvailableException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteImagePermissions(DeleteImagePermissionsRequest.builder().applyMutation(deleteImagePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the
     * stack is no longer available to users. Also, any reservations made for application streaming sessions for the
     * stack are released.
     * </p>
     *
     * @param deleteStackRequest
     * @return Result of the DeleteStack operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStackResponse deleteStack(DeleteStackRequest deleteStackRequest) throws ResourceInUseException,
            ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified stack. After the stack is deleted, the application streaming environment provided by the
     * stack is no longer available to users. Also, any reservations made for application streaming sessions for the
     * stack are released.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteStackRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteStackRequest#builder()}
     * </p>
     *
     * @param deleteStackRequest
     *        A {@link Consumer} that will call methods on {@link DeleteStackRequest.Builder} to create a request.
     * @return Result of the DeleteStack operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteStack" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteStackResponse deleteStack(Consumer<DeleteStackRequest.Builder> deleteStackRequest)
            throws ResourceInUseException, ResourceNotFoundException, OperationNotPermittedException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteStack(DeleteStackRequest.builder().applyMutation(deleteStackRequest).build());
    }

    /**
     * <p>
     * Disables usage report generation.
     * </p>
     *
     * @param deleteUsageReportSubscriptionRequest
     * @return Result of the DeleteUsageReportSubscription operation returned by the service.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteUsageReportSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUsageReportSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUsageReportSubscriptionResponse deleteUsageReportSubscription(
            DeleteUsageReportSubscriptionRequest deleteUsageReportSubscriptionRequest) throws InvalidAccountStatusException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables usage report generation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUsageReportSubscriptionRequest.Builder}
     * avoiding the need to create one manually via {@link DeleteUsageReportSubscriptionRequest#builder()}
     * </p>
     *
     * @param deleteUsageReportSubscriptionRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUsageReportSubscriptionRequest.Builder} to
     *        create a request.
     * @return Result of the DeleteUsageReportSubscription operation returned by the service.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteUsageReportSubscription
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUsageReportSubscription"
     *      target="_top">AWS API Documentation</a>
     */
    default DeleteUsageReportSubscriptionResponse deleteUsageReportSubscription(
            Consumer<DeleteUsageReportSubscriptionRequest.Builder> deleteUsageReportSubscriptionRequest)
            throws InvalidAccountStatusException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return deleteUsageReportSubscription(DeleteUsageReportSubscriptionRequest.builder()
                .applyMutation(deleteUsageReportSubscriptionRequest).build());
    }

    /**
     * <p>
     * Deletes a user from the user pool.
     * </p>
     *
     * @param deleteUserRequest
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(DeleteUserRequest deleteUserRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a user from the user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteUserRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteUserRequest#builder()}
     * </p>
     *
     * @param deleteUserRequest
     *        A {@link Consumer} that will call methods on {@link DeleteUserRequest.Builder} to create a request.
     * @return Result of the DeleteUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DeleteUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DeleteUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteUserResponse deleteUser(Consumer<DeleteUserRequest.Builder> deleteUserRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return deleteUser(DeleteUserRequest.builder().applyMutation(deleteUserRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more app blocks.
     * </p>
     *
     * @param describeAppBlocksRequest
     * @return Result of the DescribeAppBlocks operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeAppBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeAppBlocks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAppBlocksResponse describeAppBlocks(DescribeAppBlocksRequest describeAppBlocksRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more app blocks.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeAppBlocksRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeAppBlocksRequest#builder()}
     * </p>
     *
     * @param describeAppBlocksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeAppBlocksRequest.Builder} to create a request.
     * @return Result of the DescribeAppBlocks operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeAppBlocks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeAppBlocks" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeAppBlocksResponse describeAppBlocks(Consumer<DescribeAppBlocksRequest.Builder> describeAppBlocksRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeAppBlocks(DescribeAppBlocksRequest.builder().applyMutation(describeAppBlocksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more application fleet associations. Either ApplicationArn or FleetName
     * must be specified.
     * </p>
     *
     * @param describeApplicationFleetAssociationsRequest
     * @return Result of the DescribeApplicationFleetAssociations operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeApplicationFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeApplicationFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationFleetAssociationsResponse describeApplicationFleetAssociations(
            DescribeApplicationFleetAssociationsRequest describeApplicationFleetAssociationsRequest)
            throws InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more application fleet associations. Either ApplicationArn or FleetName
     * must be specified.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DescribeApplicationFleetAssociationsRequest.Builder} avoiding the need to create one manually via
     * {@link DescribeApplicationFleetAssociationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationFleetAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationFleetAssociationsRequest.Builder}
     *        to create a request.
     * @return Result of the DescribeApplicationFleetAssociations operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeApplicationFleetAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeApplicationFleetAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationFleetAssociationsResponse describeApplicationFleetAssociations(
            Consumer<DescribeApplicationFleetAssociationsRequest.Builder> describeApplicationFleetAssociationsRequest)
            throws InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeApplicationFleetAssociations(DescribeApplicationFleetAssociationsRequest.builder()
                .applyMutation(describeApplicationFleetAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more applications.
     * </p>
     *
     * @param describeApplicationsRequest
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsResponse describeApplications(DescribeApplicationsRequest describeApplicationsRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeApplicationsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeApplicationsRequest#builder()}
     * </p>
     *
     * @param describeApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeApplications operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeApplicationsResponse describeApplications(
            Consumer<DescribeApplicationsRequest.Builder> describeApplicationsRequest) throws OperationNotPermittedException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return describeApplications(DescribeApplicationsRequest.builder().applyMutation(describeApplicationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names
     * for these objects are provided. Otherwise, all Directory Config objects in the account are described. These
     * objects include the configuration information required to join fleets and image builders to Microsoft Active
     * Directory domains.
     * </p>
     * <p>
     * Although the response syntax in this topic includes the account password, this password is not returned in the
     * actual response.
     * </p>
     *
     * @return Result of the DescribeDirectoryConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeDirectoryConfigs
     * @see #describeDirectoryConfigs(DescribeDirectoryConfigsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectoryConfigsResponse describeDirectoryConfigs() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        return describeDirectoryConfigs(DescribeDirectoryConfigsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names
     * for these objects are provided. Otherwise, all Directory Config objects in the account are described. These
     * objects include the configuration information required to join fleets and image builders to Microsoft Active
     * Directory domains.
     * </p>
     * <p>
     * Although the response syntax in this topic includes the account password, this password is not returned in the
     * actual response.
     * </p>
     *
     * @param describeDirectoryConfigsRequest
     * @return Result of the DescribeDirectoryConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeDirectoryConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectoryConfigsResponse describeDirectoryConfigs(
            DescribeDirectoryConfigsRequest describeDirectoryConfigsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified Directory Config objects for AppStream 2.0, if the names
     * for these objects are provided. Otherwise, all Directory Config objects in the account are described. These
     * objects include the configuration information required to join fleets and image builders to Microsoft Active
     * Directory domains.
     * </p>
     * <p>
     * Although the response syntax in this topic includes the account password, this password is not returned in the
     * actual response.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeDirectoryConfigsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeDirectoryConfigsRequest#builder()}
     * </p>
     *
     * @param describeDirectoryConfigsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeDirectoryConfigsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeDirectoryConfigs operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeDirectoryConfigs
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeDirectoryConfigs"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeDirectoryConfigsResponse describeDirectoryConfigs(
            Consumer<DescribeDirectoryConfigsRequest.Builder> describeDirectoryConfigsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return describeDirectoryConfigs(DescribeDirectoryConfigsRequest.builder().applyMutation(describeDirectoryConfigsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes one of more entitlements.
     * </p>
     *
     * @param describeEntitlementsRequest
     * @return Result of the DescribeEntitlements operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntitlementsResponse describeEntitlements(DescribeEntitlementsRequest describeEntitlementsRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one of more entitlements.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeEntitlementsRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeEntitlementsRequest#builder()}
     * </p>
     *
     * @param describeEntitlementsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeEntitlementsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeEntitlements operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeEntitlements
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeEntitlements"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeEntitlementsResponse describeEntitlements(
            Consumer<DescribeEntitlementsRequest.Builder> describeEntitlementsRequest) throws OperationNotPermittedException,
            ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return describeEntitlements(DescribeEntitlementsRequest.builder().applyMutation(describeEntitlementsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all
     * fleets in the account are described.
     * </p>
     *
     * @return Result of the DescribeFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeFleets
     * @see #describeFleets(DescribeFleetsRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFleetsResponse describeFleets() throws ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeFleets(DescribeFleetsRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all
     * fleets in the account are described.
     * </p>
     *
     * @param describeFleetsRequest
     * @return Result of the DescribeFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFleetsResponse describeFleets(DescribeFleetsRequest describeFleetsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified fleets, if the fleet names are provided. Otherwise, all
     * fleets in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeFleetsRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeFleetsRequest#builder()}
     * </p>
     *
     * @param describeFleetsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeFleetsRequest.Builder} to create a request.
     * @return Result of the DescribeFleets operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeFleets" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeFleetsResponse describeFleets(Consumer<DescribeFleetsRequest.Builder> describeFleetsRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return describeFleets(DescribeFleetsRequest.builder().applyMutation(describeFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified image builders, if the image builder names are provided.
     * Otherwise, all image builders in the account are described.
     * </p>
     *
     * @return Result of the DescribeImageBuilders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImageBuilders
     * @see #describeImageBuilders(DescribeImageBuildersRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageBuildersResponse describeImageBuilders() throws ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        return describeImageBuilders(DescribeImageBuildersRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified image builders, if the image builder names are provided.
     * Otherwise, all image builders in the account are described.
     * </p>
     *
     * @param describeImageBuildersRequest
     * @return Result of the DescribeImageBuilders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImageBuilders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageBuildersResponse describeImageBuilders(DescribeImageBuildersRequest describeImageBuildersRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified image builders, if the image builder names are provided.
     * Otherwise, all image builders in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImageBuildersRequest.Builder} avoiding the
     * need to create one manually via {@link DescribeImageBuildersRequest#builder()}
     * </p>
     *
     * @param describeImageBuildersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImageBuildersRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeImageBuilders operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImageBuilders
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImageBuilders"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImageBuildersResponse describeImageBuilders(
            Consumer<DescribeImageBuildersRequest.Builder> describeImageBuildersRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return describeImageBuilders(DescribeImageBuildersRequest.builder().applyMutation(describeImageBuildersRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
     * </p>
     *
     * @param describeImagePermissionsRequest
     * @return Result of the DescribeImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImagePermissionsResponse describeImagePermissions(
            DescribeImagePermissionsRequest describeImagePermissionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagePermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeImagePermissionsRequest#builder()}
     * </p>
     *
     * @param describeImagePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the DescribeImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImagePermissionsResponse describeImagePermissions(
            Consumer<DescribeImagePermissionsRequest.Builder> describeImagePermissionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return describeImagePermissions(DescribeImagePermissionsRequest.builder().applyMutation(describeImagePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImagePermissions(software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client.describeImagePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client
     *             .describeImagePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client.describeImagePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImagePermissions(software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest)}
     * operation.</b>
     * </p>
     *
     * @param describeImagePermissionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImagePermissionsIterable describeImagePermissionsPaginator(
            DescribeImagePermissionsRequest describeImagePermissionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the permissions for shared AWS account IDs on a private image that you own.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImagePermissions(software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client.describeImagePermissionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client
     *             .describeImagePermissionsPaginator(request);
     *     for (software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagePermissionsIterable responses = client.describeImagePermissionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImagePermissions(software.amazon.awssdk.services.appstream.model.DescribeImagePermissionsRequest)}
     * operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagePermissionsRequest.Builder} avoiding
     * the need to create one manually via {@link DescribeImagePermissionsRequest#builder()}
     * </p>
     *
     * @param describeImagePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagePermissionsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeImagePermissionsIterable describeImagePermissionsPaginator(
            Consumer<DescribeImagePermissionsRequest.Builder> describeImagePermissionsRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return describeImagePermissionsPaginator(DescribeImagePermissionsRequest.builder()
                .applyMutation(describeImagePermissionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided.
     * Otherwise, all images in the account are described.
     * </p>
     *
     * @return Result of the DescribeImages operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see #describeImages(DescribeImagesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages() throws InvalidParameterCombinationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return describeImages(DescribeImagesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided.
     * Otherwise, all images in the account are described.
     * </p>
     *
     * @param describeImagesRequest
     * @return Result of the DescribeImages operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages(DescribeImagesRequest describeImagesRequest)
            throws InvalidParameterCombinationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided.
     * Otherwise, all images in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagesRequest.Builder} to create a request.
     * @return Result of the DescribeImages operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesResponse describeImages(Consumer<DescribeImagesRequest.Builder> describeImagesRequest)
            throws InvalidParameterCombinationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeImages(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided.
     * Otherwise, all images in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImages(software.amazon.awssdk.services.appstream.model.DescribeImagesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client
     *             .describeImagesPaginator(request);
     *     for (software.amazon.awssdk.services.appstream.model.DescribeImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.appstream.model.DescribeImagesRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see #describeImagesPaginator(DescribeImagesRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesIterable describeImagesPaginator() throws InvalidParameterCombinationException,
            ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return describeImagesPaginator(DescribeImagesRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided.
     * Otherwise, all images in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImages(software.amazon.awssdk.services.appstream.model.DescribeImagesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client
     *             .describeImagesPaginator(request);
     *     for (software.amazon.awssdk.services.appstream.model.DescribeImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.appstream.model.DescribeImagesRequest)} operation.</b>
     * </p>
     *
     * @param describeImagesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesIterable describeImagesPaginator(DescribeImagesRequest describeImagesRequest)
            throws InvalidParameterCombinationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified images, if the image names or image ARNs are provided.
     * Otherwise, all images in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a variant of
     * {@link #describeImages(software.amazon.awssdk.services.appstream.model.DescribeImagesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client
     *             .describeImagesPaginator(request);
     *     for (software.amazon.awssdk.services.appstream.model.DescribeImagesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appstream.paginators.DescribeImagesIterable responses = client.describeImagesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of MaxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #describeImages(software.amazon.awssdk.services.appstream.model.DescribeImagesRequest)} operation.</b>
     * </p>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeImagesRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeImagesRequest#builder()}
     * </p>
     *
     * @param describeImagesRequest
     *        A {@link Consumer} that will call methods on {@link DescribeImagesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeImages
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeImages" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeImagesIterable describeImagesPaginator(Consumer<DescribeImagesRequest.Builder> describeImagesRequest)
            throws InvalidParameterCombinationException, ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeImagesPaginator(DescribeImagesRequest.builder().applyMutation(describeImagesRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided
     * for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not
     * provided, the default is to authenticate users using a streaming URL.
     * </p>
     *
     * @param describeSessionsRequest
     * @return Result of the DescribeSessions operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSessionsResponse describeSessions(DescribeSessionsRequest describeSessionsRequest)
            throws InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the streaming sessions for a specified stack and fleet. If a UserId is provided
     * for the stack and fleet, only streaming sessions for that user are described. If an authentication type is not
     * provided, the default is to authenticate users using a streaming URL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeSessionsRequest.Builder} avoiding the need
     * to create one manually via {@link DescribeSessionsRequest#builder()}
     * </p>
     *
     * @param describeSessionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeSessionsRequest.Builder} to create a request.
     * @return Result of the DescribeSessions operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeSessions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeSessions" target="_top">AWS
     *      API Documentation</a>
     */
    default DescribeSessionsResponse describeSessions(Consumer<DescribeSessionsRequest.Builder> describeSessionsRequest)
            throws InvalidParameterCombinationException, AwsServiceException, SdkClientException, AppStreamException {
        return describeSessions(DescribeSessionsRequest.builder().applyMutation(describeSessionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all
     * stacks in the account are described.
     * </p>
     *
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeStacks
     * @see #describeStacks(DescribeStacksRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStacksResponse describeStacks() throws ResourceNotFoundException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeStacks(DescribeStacksRequest.builder().build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all
     * stacks in the account are described.
     * </p>
     *
     * @param describeStacksRequest
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStacksResponse describeStacks(DescribeStacksRequest describeStacksRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified stacks, if the stack names are provided. Otherwise, all
     * stacks in the account are described.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeStacksRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeStacksRequest#builder()}
     * </p>
     *
     * @param describeStacksRequest
     *        A {@link Consumer} that will call methods on {@link DescribeStacksRequest.Builder} to create a request.
     * @return Result of the DescribeStacks operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeStacks" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeStacksResponse describeStacks(Consumer<DescribeStacksRequest.Builder> describeStacksRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return describeStacks(DescribeStacksRequest.builder().applyMutation(describeStacksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more usage report subscriptions.
     * </p>
     *
     * @param describeUsageReportSubscriptionsRequest
     * @return Result of the DescribeUsageReportSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUsageReportSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsageReportSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUsageReportSubscriptionsResponse describeUsageReportSubscriptions(
            DescribeUsageReportSubscriptionsRequest describeUsageReportSubscriptionsRequest) throws ResourceNotFoundException,
            InvalidAccountStatusException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more usage report subscriptions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsageReportSubscriptionsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeUsageReportSubscriptionsRequest#builder()}
     * </p>
     *
     * @param describeUsageReportSubscriptionsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsageReportSubscriptionsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeUsageReportSubscriptions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUsageReportSubscriptions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsageReportSubscriptions"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUsageReportSubscriptionsResponse describeUsageReportSubscriptions(
            Consumer<DescribeUsageReportSubscriptionsRequest.Builder> describeUsageReportSubscriptionsRequest)
            throws ResourceNotFoundException, InvalidAccountStatusException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeUsageReportSubscriptions(DescribeUsageReportSubscriptionsRequest.builder()
                .applyMutation(describeUsageReportSubscriptionsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The stack name
     * </p>
     * </li>
     * <li>
     * <p>
     * The user name (email address of the user associated with the stack) and the authentication type for the user
     * </p>
     * </li>
     * </ul>
     *
     * @param describeUserStackAssociationsRequest
     * @return Result of the DescribeUserStackAssociations operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUserStackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUserStackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserStackAssociationsResponse describeUserStackAssociations(
            DescribeUserStackAssociationsRequest describeUserStackAssociationsRequest)
            throws InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes the UserStackAssociation objects. You must specify either or both of the
     * following:
     * </p>
     * <ul>
     * <li>
     * <p>
     * The stack name
     * </p>
     * </li>
     * <li>
     * <p>
     * The user name (email address of the user associated with the stack) and the authentication type for the user
     * </p>
     * </li>
     * </ul>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUserStackAssociationsRequest.Builder}
     * avoiding the need to create one manually via {@link DescribeUserStackAssociationsRequest#builder()}
     * </p>
     *
     * @param describeUserStackAssociationsRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUserStackAssociationsRequest.Builder} to
     *        create a request.
     * @return Result of the DescribeUserStackAssociations operation returned by the service.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUserStackAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUserStackAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default DescribeUserStackAssociationsResponse describeUserStackAssociations(
            Consumer<DescribeUserStackAssociationsRequest.Builder> describeUserStackAssociationsRequest)
            throws InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        return describeUserStackAssociations(DescribeUserStackAssociationsRequest.builder()
                .applyMutation(describeUserStackAssociationsRequest).build());
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified users in the user pool.
     * </p>
     *
     * @param describeUsersRequest
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersResponse describeUsers(DescribeUsersRequest describeUsersRequest) throws ResourceNotFoundException,
            InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list that describes one or more specified users in the user pool.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DescribeUsersRequest.Builder} avoiding the need to
     * create one manually via {@link DescribeUsersRequest#builder()}
     * </p>
     *
     * @param describeUsersRequest
     *        A {@link Consumer} that will call methods on {@link DescribeUsersRequest.Builder} to create a request.
     * @return Result of the DescribeUsers operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DescribeUsers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DescribeUsers" target="_top">AWS API
     *      Documentation</a>
     */
    default DescribeUsersResponse describeUsers(Consumer<DescribeUsersRequest.Builder> describeUsersRequest)
            throws ResourceNotFoundException, InvalidParameterCombinationException, OperationNotPermittedException,
            AwsServiceException, SdkClientException, AppStreamException {
        return describeUsers(DescribeUsersRequest.builder().applyMutation(describeUsersRequest).build());
    }

    /**
     * <p>
     * Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled.
     * This action does not delete the user.
     * </p>
     *
     * @param disableUserRequest
     * @return Result of the DisableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisableUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableUserResponse disableUser(DisableUserRequest disableUserRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disables the specified user in the user pool. Users can't sign in to AppStream 2.0 until they are re-enabled.
     * This action does not delete the user.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisableUserRequest.Builder} avoiding the need to
     * create one manually via {@link DisableUserRequest#builder()}
     * </p>
     *
     * @param disableUserRequest
     *        A {@link Consumer} that will call methods on {@link DisableUserRequest.Builder} to create a request.
     * @return Result of the DisableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisableUser" target="_top">AWS API
     *      Documentation</a>
     */
    default DisableUserResponse disableUser(Consumer<DisableUserRequest.Builder> disableUserRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return disableUser(DisableUserRequest.builder().applyMutation(disableUserRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified application from the fleet.
     * </p>
     *
     * @param disassociateApplicationFleetRequest
     * @return Result of the DisassociateApplicationFleet operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateApplicationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateApplicationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateApplicationFleetResponse disassociateApplicationFleet(
            DisassociateApplicationFleetRequest disassociateApplicationFleetRequest) throws ConcurrentModificationException,
            InvalidParameterCombinationException, OperationNotPermittedException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified application from the fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateApplicationFleetRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateApplicationFleetRequest#builder()}
     * </p>
     *
     * @param disassociateApplicationFleetRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateApplicationFleetRequest.Builder} to create
     *        a request.
     * @return Result of the DisassociateApplicationFleet operation returned by the service.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateApplicationFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateApplicationFleet"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateApplicationFleetResponse disassociateApplicationFleet(
            Consumer<DisassociateApplicationFleetRequest.Builder> disassociateApplicationFleetRequest)
            throws ConcurrentModificationException, InvalidParameterCombinationException, OperationNotPermittedException,
            AwsServiceException, SdkClientException, AppStreamException {
        return disassociateApplicationFleet(DisassociateApplicationFleetRequest.builder()
                .applyMutation(disassociateApplicationFleetRequest).build());
    }

    /**
     * <p>
     * Deletes the specified application from the specified entitlement.
     * </p>
     *
     * @param disassociateApplicationFromEntitlementRequest
     * @return Result of the DisassociateApplicationFromEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateApplicationFromEntitlement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateApplicationFromEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateApplicationFromEntitlementResponse disassociateApplicationFromEntitlement(
            DisassociateApplicationFromEntitlementRequest disassociateApplicationFromEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes the specified application from the specified entitlement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the
     * {@link DisassociateApplicationFromEntitlementRequest.Builder} avoiding the need to create one manually via
     * {@link DisassociateApplicationFromEntitlementRequest#builder()}
     * </p>
     *
     * @param disassociateApplicationFromEntitlementRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateApplicationFromEntitlementRequest.Builder}
     *        to create a request.
     * @return Result of the DisassociateApplicationFromEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateApplicationFromEntitlement
     * @see <a
     *      href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateApplicationFromEntitlement"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateApplicationFromEntitlementResponse disassociateApplicationFromEntitlement(
            Consumer<DisassociateApplicationFromEntitlementRequest.Builder> disassociateApplicationFromEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        return disassociateApplicationFromEntitlement(DisassociateApplicationFromEntitlementRequest.builder()
                .applyMutation(disassociateApplicationFromEntitlementRequest).build());
    }

    /**
     * <p>
     * Disassociates the specified fleet from the specified stack.
     * </p>
     *
     * @param disassociateFleetRequest
     * @return Result of the DisassociateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateFleetResponse disassociateFleet(DisassociateFleetRequest disassociateFleetRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates the specified fleet from the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateFleetRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateFleetRequest#builder()}
     * </p>
     *
     * @param disassociateFleetRequest
     *        A {@link Consumer} that will call methods on {@link DisassociateFleetRequest.Builder} to create a request.
     * @return Result of the DisassociateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.DisassociateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/DisassociateFleet" target="_top">AWS
     *      API Documentation</a>
     */
    default DisassociateFleetResponse disassociateFleet(Consumer<DisassociateFleetRequest.Builder> disassociateFleetRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException,
            OperationNotPermittedException, AwsServiceException, SdkClientException, AppStreamException {
        return disassociateFleet(DisassociateFleetRequest.builder().applyMutation(disassociateFleetRequest).build());
    }

    /**
     * <p>
     * Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications
     * from the stacks to which they are assigned.
     * </p>
     *
     * @param enableUserRequest
     * @return Result of the EnableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.EnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/EnableUser" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableUserResponse enableUser(EnableUserRequest enableUserRequest) throws ResourceNotFoundException,
            InvalidAccountStatusException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Enables a user in the user pool. After being enabled, users can sign in to AppStream 2.0 and open applications
     * from the stacks to which they are assigned.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EnableUserRequest.Builder} avoiding the need to
     * create one manually via {@link EnableUserRequest#builder()}
     * </p>
     *
     * @param enableUserRequest
     *        A {@link Consumer} that will call methods on {@link EnableUserRequest.Builder} to create a request.
     * @return Result of the EnableUser operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.EnableUser
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/EnableUser" target="_top">AWS API
     *      Documentation</a>
     */
    default EnableUserResponse enableUser(Consumer<EnableUserRequest.Builder> enableUserRequest)
            throws ResourceNotFoundException, InvalidAccountStatusException, AwsServiceException, SdkClientException,
            AppStreamException {
        return enableUser(EnableUserRequest.builder().applyMutation(enableUserRequest).build());
    }

    /**
     * <p>
     * Immediately stops the specified streaming session.
     * </p>
     *
     * @param expireSessionRequest
     * @return Result of the ExpireSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ExpireSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession" target="_top">AWS API
     *      Documentation</a>
     */
    default ExpireSessionResponse expireSession(ExpireSessionRequest expireSessionRequest) throws AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Immediately stops the specified streaming session.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ExpireSessionRequest.Builder} avoiding the need to
     * create one manually via {@link ExpireSessionRequest#builder()}
     * </p>
     *
     * @param expireSessionRequest
     *        A {@link Consumer} that will call methods on {@link ExpireSessionRequest.Builder} to create a request.
     * @return Result of the ExpireSession operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ExpireSession
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ExpireSession" target="_top">AWS API
     *      Documentation</a>
     */
    default ExpireSessionResponse expireSession(Consumer<ExpireSessionRequest.Builder> expireSessionRequest)
            throws AwsServiceException, SdkClientException, AppStreamException {
        return expireSession(ExpireSessionRequest.builder().applyMutation(expireSessionRequest).build());
    }

    /**
     * <p>
     * Retrieves the name of the fleet that is associated with the specified stack.
     * </p>
     *
     * @param listAssociatedFleetsRequest
     * @return Result of the ListAssociatedFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedFleetsResponse listAssociatedFleets(ListAssociatedFleetsRequest listAssociatedFleetsRequest)
            throws AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the name of the fleet that is associated with the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedFleetsRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedFleetsRequest#builder()}
     * </p>
     *
     * @param listAssociatedFleetsRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedFleetsRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssociatedFleets operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedFleets
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedFleets"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedFleetsResponse listAssociatedFleets(
            Consumer<ListAssociatedFleetsRequest.Builder> listAssociatedFleetsRequest) throws AwsServiceException,
            SdkClientException, AppStreamException {
        return listAssociatedFleets(ListAssociatedFleetsRequest.builder().applyMutation(listAssociatedFleetsRequest).build());
    }

    /**
     * <p>
     * Retrieves the name of the stack with which the specified fleet is associated.
     * </p>
     *
     * @param listAssociatedStacksRequest
     * @return Result of the ListAssociatedStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedStacksResponse listAssociatedStacks(ListAssociatedStacksRequest listAssociatedStacksRequest)
            throws AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the name of the stack with which the specified fleet is associated.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListAssociatedStacksRequest.Builder} avoiding the
     * need to create one manually via {@link ListAssociatedStacksRequest#builder()}
     * </p>
     *
     * @param listAssociatedStacksRequest
     *        A {@link Consumer} that will call methods on {@link ListAssociatedStacksRequest.Builder} to create a
     *        request.
     * @return Result of the ListAssociatedStacks operation returned by the service.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListAssociatedStacks
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListAssociatedStacks"
     *      target="_top">AWS API Documentation</a>
     */
    default ListAssociatedStacksResponse listAssociatedStacks(
            Consumer<ListAssociatedStacksRequest.Builder> listAssociatedStacksRequest) throws AwsServiceException,
            SdkClientException, AppStreamException {
        return listAssociatedStacks(ListAssociatedStacksRequest.builder().applyMutation(listAssociatedStacksRequest).build());
    }

    /**
     * <p>
     * Retrieves a list of entitled applications.
     * </p>
     *
     * @param listEntitledApplicationsRequest
     * @return Result of the ListEntitledApplications operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListEntitledApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListEntitledApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitledApplicationsResponse listEntitledApplications(
            ListEntitledApplicationsRequest listEntitledApplicationsRequest) throws OperationNotPermittedException,
            ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of entitled applications.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListEntitledApplicationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListEntitledApplicationsRequest#builder()}
     * </p>
     *
     * @param listEntitledApplicationsRequest
     *        A {@link Consumer} that will call methods on {@link ListEntitledApplicationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListEntitledApplications operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListEntitledApplications
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListEntitledApplications"
     *      target="_top">AWS API Documentation</a>
     */
    default ListEntitledApplicationsResponse listEntitledApplications(
            Consumer<ListEntitledApplicationsRequest.Builder> listEntitledApplicationsRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        return listEntitledApplications(ListEntitledApplicationsRequest.builder().applyMutation(listEntitledApplicationsRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders,
     * images, fleets, and stacks.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a list of all tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image builders,
     * images, fleets, and stacks.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on {@link ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Starts the specified fleet.
     * </p>
     *
     * @param startFleetRequest
     * @return Result of the StartFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFleetResponse startFleet(StartFleetRequest startFleetRequest) throws ResourceNotFoundException,
            OperationNotPermittedException, LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException,
            ConcurrentModificationException, ResourceNotAvailableException, InvalidRoleException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartFleetRequest.Builder} avoiding the need to
     * create one manually via {@link StartFleetRequest#builder()}
     * </p>
     *
     * @param startFleetRequest
     *        A {@link Consumer} that will call methods on {@link StartFleetRequest.Builder} to create a request.
     * @return Result of the StartFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default StartFleetResponse startFleet(Consumer<StartFleetRequest.Builder> startFleetRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, LimitExceededException,
            RequestLimitExceededException, InvalidAccountStatusException, ConcurrentModificationException,
            ResourceNotAvailableException, InvalidRoleException, AwsServiceException, SdkClientException, AppStreamException {
        return startFleet(StartFleetRequest.builder().applyMutation(startFleetRequest).build());
    }

    /**
     * <p>
     * Starts the specified image builder.
     * </p>
     *
     * @param startImageBuilderRequest
     * @return Result of the StartImageBuilder operation returned by the service.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default StartImageBuilderResponse startImageBuilder(StartImageBuilderRequest startImageBuilderRequest)
            throws ResourceNotAvailableException, ResourceNotFoundException, ConcurrentModificationException,
            InvalidAccountStatusException, IncompatibleImageException, AwsServiceException, SdkClientException,
            AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Starts the specified image builder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartImageBuilderRequest.Builder} avoiding the need
     * to create one manually via {@link StartImageBuilderRequest#builder()}
     * </p>
     *
     * @param startImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link StartImageBuilderRequest.Builder} to create a request.
     * @return Result of the StartImageBuilder operation returned by the service.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StartImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StartImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default StartImageBuilderResponse startImageBuilder(Consumer<StartImageBuilderRequest.Builder> startImageBuilderRequest)
            throws ResourceNotAvailableException, ResourceNotFoundException, ConcurrentModificationException,
            InvalidAccountStatusException, IncompatibleImageException, AwsServiceException, SdkClientException,
            AppStreamException {
        return startImageBuilder(StartImageBuilderRequest.builder().applyMutation(startImageBuilderRequest).build());
    }

    /**
     * <p>
     * Stops the specified fleet.
     * </p>
     *
     * @param stopFleetRequest
     * @return Result of the StopFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFleetResponse stopFleet(StopFleetRequest stopFleetRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified fleet.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopFleetRequest.Builder} avoiding the need to
     * create one manually via {@link StopFleetRequest#builder()}
     * </p>
     *
     * @param stopFleetRequest
     *        A {@link Consumer} that will call methods on {@link StopFleetRequest.Builder} to create a request.
     * @return Result of the StopFleet operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default StopFleetResponse stopFleet(Consumer<StopFleetRequest.Builder> stopFleetRequest) throws ResourceNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return stopFleet(StopFleetRequest.builder().applyMutation(stopFleetRequest).build());
    }

    /**
     * <p>
     * Stops the specified image builder.
     * </p>
     *
     * @param stopImageBuilderRequest
     * @return Result of the StopImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default StopImageBuilderResponse stopImageBuilder(StopImageBuilderRequest stopImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Stops the specified image builder.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StopImageBuilderRequest.Builder} avoiding the need
     * to create one manually via {@link StopImageBuilderRequest#builder()}
     * </p>
     *
     * @param stopImageBuilderRequest
     *        A {@link Consumer} that will call methods on {@link StopImageBuilderRequest.Builder} to create a request.
     * @return Result of the StopImageBuilder operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.StopImageBuilder
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/StopImageBuilder" target="_top">AWS
     *      API Documentation</a>
     */
    default StopImageBuilderResponse stopImageBuilder(Consumer<StopImageBuilderRequest.Builder> stopImageBuilderRequest)
            throws ResourceNotFoundException, OperationNotPermittedException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppStreamException {
        return stopImageBuilder(StopImageBuilderRequest.builder().applyMutation(stopImageBuilderRequest).build());
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image
     * builders, images, fleets, and stacks.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this
     * operation updates its value.
     * </p>
     * <p>
     * To list the current tags for your resources, use <a>ListTagsForResource</a>. To disassociate tags from your
     * resources, use <a>UntagResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws LimitExceededException,
            InvalidAccountStatusException, ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or overwrites one or more tags for the specified AppStream 2.0 resource. You can tag AppStream 2.0 image
     * builders, images, fleets, and stacks.
     * </p>
     * <p>
     * Each tag consists of a key and an optional value. If a resource already has a tag with the same key, this
     * operation updates its value.
     * </p>
     * <p>
     * To list the current tags for your resources, use <a>ListTagsForResource</a>. To disassociate tags from your
     * resources, use <a>UntagResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on {@link TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest)
            throws LimitExceededException, InvalidAccountStatusException, ResourceNotFoundException, AwsServiceException,
            SdkClientException, AppStreamException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Disassociates one or more specified tags from the specified AppStream 2.0 resource.
     * </p>
     * <p>
     * To list the current tags for your resources, use <a>ListTagsForResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Disassociates one or more specified tags from the specified AppStream 2.0 resource.
     * </p>
     * <p>
     * To list the current tags for your resources, use <a>ListTagsForResource</a>.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on {@link UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws ResourceNotFoundException, AwsServiceException, SdkClientException, AppStreamException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the specified application.
     * </p>
     *
     * @param updateApplicationRequest
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(UpdateApplicationRequest updateApplicationRequest)
            throws OperationNotPermittedException, ConcurrentModificationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified application.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApplicationRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateApplicationRequest#builder()}
     * </p>
     *
     * @param updateApplicationRequest
     *        A {@link Consumer} that will call methods on {@link UpdateApplicationRequest.Builder} to create a request.
     * @return Result of the UpdateApplication operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateApplication
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateApplication" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateApplicationResponse updateApplication(Consumer<UpdateApplicationRequest.Builder> updateApplicationRequest)
            throws OperationNotPermittedException, ConcurrentModificationException, ResourceNotFoundException,
            AwsServiceException, SdkClientException, AppStreamException {
        return updateApplication(UpdateApplicationRequest.builder().applyMutation(updateApplicationRequest).build());
    }

    /**
     * <p>
     * Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration
     * information required to join fleets and image builders to Microsoft Active Directory domains.
     * </p>
     *
     * @param updateDirectoryConfigRequest
     * @return Result of the UpdateDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDirectoryConfigResponse updateDirectoryConfig(UpdateDirectoryConfigRequest updateDirectoryConfigRequest)
            throws ResourceInUseException, ResourceNotFoundException, ConcurrentModificationException,
            OperationNotPermittedException, InvalidRoleException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified Directory Config object in AppStream 2.0. This object includes the configuration
     * information required to join fleets and image builders to Microsoft Active Directory domains.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDirectoryConfigRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateDirectoryConfigRequest#builder()}
     * </p>
     *
     * @param updateDirectoryConfigRequest
     *        A {@link Consumer} that will call methods on {@link UpdateDirectoryConfigRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateDirectoryConfig operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateDirectoryConfig
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateDirectoryConfig"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateDirectoryConfigResponse updateDirectoryConfig(
            Consumer<UpdateDirectoryConfigRequest.Builder> updateDirectoryConfigRequest) throws ResourceInUseException,
            ResourceNotFoundException, ConcurrentModificationException, OperationNotPermittedException, InvalidRoleException,
            AwsServiceException, SdkClientException, AppStreamException {
        return updateDirectoryConfig(UpdateDirectoryConfigRequest.builder().applyMutation(updateDirectoryConfigRequest).build());
    }

    /**
     * <p>
     * Updates the specified entitlement.
     * </p>
     *
     * @param updateEntitlementRequest
     * @return Result of the UpdateEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEntitlementResponse updateEntitlement(UpdateEntitlementRequest updateEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified entitlement.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateEntitlementRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateEntitlementRequest#builder()}
     * </p>
     *
     * @param updateEntitlementRequest
     *        A {@link Consumer} that will call methods on {@link UpdateEntitlementRequest.Builder} to create a request.
     * @return Result of the UpdateEntitlement operation returned by the service.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws EntitlementNotFoundException
     *         The entitlement can't be found.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateEntitlement
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateEntitlement" target="_top">AWS
     *      API Documentation</a>
     */
    default UpdateEntitlementResponse updateEntitlement(Consumer<UpdateEntitlementRequest.Builder> updateEntitlementRequest)
            throws OperationNotPermittedException, ResourceNotFoundException, EntitlementNotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return updateEntitlement(UpdateEntitlementRequest.builder().applyMutation(updateEntitlementRequest).build());
    }

    /**
     * <p>
     * Updates the specified fleet.
     * </p>
     * <p>
     * If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name.
     * </p>
     * <p>
     * If the fleet is in the <code>RUNNING</code> state, you can update the following based on the fleet type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Always-On and On-Demand fleet types
     * </p>
     * <p>
     * You can update the <code>DisplayName</code>, <code>ComputeCapacity</code>, <code>ImageARN</code>,
     * <code>ImageName</code>, <code>IdleDisconnectTimeoutInSeconds</code>, and <code>DisconnectTimeoutInSeconds</code>
     * attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Elastic fleet type
     * </p>
     * <p>
     * You can update the <code>DisplayName</code>, <code>IdleDisconnectTimeoutInSeconds</code>,
     * <code>DisconnectTimeoutInSeconds</code>, <code>MaxConcurrentSessions</code>, <code>SessionScriptS3Location</code>
     * and <code>UsbDeviceFilterStrings</code> attributes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the fleet is in the <code>STARTING</code> or <code>STOPPED</code> state, you can't update it.
     * </p>
     *
     * @param updateFleetRequest
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFleetResponse updateFleet(UpdateFleetRequest updateFleetRequest) throws ResourceInUseException,
            LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException, InvalidRoleException,
            ResourceNotFoundException, ResourceNotAvailableException, InvalidParameterCombinationException,
            ConcurrentModificationException, IncompatibleImageException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified fleet.
     * </p>
     * <p>
     * If the fleet is in the <code>STOPPED</code> state, you can update any attribute except the fleet name.
     * </p>
     * <p>
     * If the fleet is in the <code>RUNNING</code> state, you can update the following based on the fleet type:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Always-On and On-Demand fleet types
     * </p>
     * <p>
     * You can update the <code>DisplayName</code>, <code>ComputeCapacity</code>, <code>ImageARN</code>,
     * <code>ImageName</code>, <code>IdleDisconnectTimeoutInSeconds</code>, and <code>DisconnectTimeoutInSeconds</code>
     * attributes.
     * </p>
     * </li>
     * <li>
     * <p>
     * Elastic fleet type
     * </p>
     * <p>
     * You can update the <code>DisplayName</code>, <code>IdleDisconnectTimeoutInSeconds</code>,
     * <code>DisconnectTimeoutInSeconds</code>, <code>MaxConcurrentSessions</code>, <code>SessionScriptS3Location</code>
     * and <code>UsbDeviceFilterStrings</code> attributes.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the fleet is in the <code>STARTING</code> or <code>STOPPED</code> state, you can't update it.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFleetRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFleetRequest#builder()}
     * </p>
     *
     * @param updateFleetRequest
     *        A {@link Consumer} that will call methods on {@link UpdateFleetRequest.Builder} to create a request.
     * @return Result of the UpdateFleet operation returned by the service.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws RequestLimitExceededException
     *         AppStream 2.0 can’t process the request right now because the Describe calls from your AWS account are
     *         being throttled by Amazon EC2. Try again later.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateFleet
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateFleet" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFleetResponse updateFleet(Consumer<UpdateFleetRequest.Builder> updateFleetRequest)
            throws ResourceInUseException, LimitExceededException, RequestLimitExceededException, InvalidAccountStatusException,
            InvalidRoleException, ResourceNotFoundException, ResourceNotAvailableException, InvalidParameterCombinationException,
            ConcurrentModificationException, IncompatibleImageException, OperationNotPermittedException, AwsServiceException,
            SdkClientException, AppStreamException {
        return updateFleet(UpdateFleetRequest.builder().applyMutation(updateFleetRequest).build());
    }

    /**
     * <p>
     * Adds or updates permissions for the specified private image.
     * </p>
     *
     * @param updateImagePermissionsRequest
     * @return Result of the UpdateImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateImagePermissionsResponse updateImagePermissions(UpdateImagePermissionsRequest updateImagePermissionsRequest)
            throws ResourceNotFoundException, ResourceNotAvailableException, LimitExceededException, AwsServiceException,
            SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds or updates permissions for the specified private image.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateImagePermissionsRequest.Builder} avoiding the
     * need to create one manually via {@link UpdateImagePermissionsRequest#builder()}
     * </p>
     *
     * @param updateImagePermissionsRequest
     *        A {@link Consumer} that will call methods on {@link UpdateImagePermissionsRequest.Builder} to create a
     *        request.
     * @return Result of the UpdateImagePermissions operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceNotAvailableException
     *         The specified resource exists and is not in use, but isn't available.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateImagePermissions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateImagePermissions"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateImagePermissionsResponse updateImagePermissions(
            Consumer<UpdateImagePermissionsRequest.Builder> updateImagePermissionsRequest) throws ResourceNotFoundException,
            ResourceNotAvailableException, LimitExceededException, AwsServiceException, SdkClientException, AppStreamException {
        return updateImagePermissions(UpdateImagePermissionsRequest.builder().applyMutation(updateImagePermissionsRequest)
                .build());
    }

    /**
     * <p>
     * Updates the specified fields for the specified stack.
     * </p>
     *
     * @param updateStackRequest
     * @return Result of the UpdateStack operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStackResponse updateStack(UpdateStackRequest updateStackRequest) throws ResourceNotFoundException,
            ResourceInUseException, InvalidRoleException, InvalidParameterCombinationException, LimitExceededException,
            InvalidAccountStatusException, IncompatibleImageException, OperationNotPermittedException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the specified fields for the specified stack.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateStackRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateStackRequest#builder()}
     * </p>
     *
     * @param updateStackRequest
     *        A {@link Consumer} that will call methods on {@link UpdateStackRequest.Builder} to create a request.
     * @return Result of the UpdateStack operation returned by the service.
     * @throws ResourceNotFoundException
     *         The specified resource was not found.
     * @throws ResourceInUseException
     *         The specified resource is in use.
     * @throws InvalidRoleException
     *         The specified role is invalid.
     * @throws InvalidParameterCombinationException
     *         Indicates an incorrect combination of parameters, or a missing parameter.
     * @throws LimitExceededException
     *         The requested limit exceeds the permitted limit for an account.
     * @throws InvalidAccountStatusException
     *         The resource cannot be created because your AWS account is suspended. For assistance, contact AWS
     *         Support.
     * @throws IncompatibleImageException
     *         The image can't be updated because it's not compatible for updates.
     * @throws OperationNotPermittedException
     *         The attempted operation is not permitted.
     * @throws ConcurrentModificationException
     *         An API error occurred. Wait a few minutes and try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppStreamException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppStreamClient.UpdateStack
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appstream-2016-12-01/UpdateStack" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateStackResponse updateStack(Consumer<UpdateStackRequest.Builder> updateStackRequest)
            throws ResourceNotFoundException, ResourceInUseException, InvalidRoleException, InvalidParameterCombinationException,
            LimitExceededException, InvalidAccountStatusException, IncompatibleImageException, OperationNotPermittedException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppStreamException {
        return updateStack(UpdateStackRequest.builder().applyMutation(updateStackRequest).build());
    }

    /**
     * Create an instance of {@link AppStreamWaiter} using this client.
     * <p>
     * Waiters created via this method are managed by the SDK and resources will be released when the service client is
     * closed.
     *
     * @return an instance of {@link AppStreamWaiter}
     */
    default AppStreamWaiter waiter() {
        throw new UnsupportedOperationException();
    }

    /**
     * Create a {@link AppStreamClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppStreamClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppStreamClient}.
     */
    static AppStreamClientBuilder builder() {
        return new DefaultAppStreamClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    AppStreamServiceClientConfiguration serviceClientConfiguration();
}
