/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appstream.AppStreamAsyncClient;
import software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersRequest;
import software.amazon.awssdk.services.appstream.model.DescribeAppBlockBuildersResponse;

public class DescribeAppBlockBuildersPublisher
implements SdkPublisher<DescribeAppBlockBuildersResponse> {
    private final AppStreamAsyncClient client;
    private final DescribeAppBlockBuildersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeAppBlockBuildersPublisher(AppStreamAsyncClient client, DescribeAppBlockBuildersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeAppBlockBuildersPublisher(AppStreamAsyncClient client, DescribeAppBlockBuildersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeAppBlockBuildersResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeAppBlockBuildersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    private class DescribeAppBlockBuildersResponseFetcher
    implements AsyncPageFetcher<DescribeAppBlockBuildersResponse> {
        private DescribeAppBlockBuildersResponseFetcher() {
        }

        public boolean hasNextPage(DescribeAppBlockBuildersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeAppBlockBuildersResponse> nextPage(DescribeAppBlockBuildersResponse previousPage) {
            if (previousPage == null) {
                return DescribeAppBlockBuildersPublisher.this.client.describeAppBlockBuilders(DescribeAppBlockBuildersPublisher.this.firstRequest);
            }
            return DescribeAppBlockBuildersPublisher.this.client.describeAppBlockBuilders((DescribeAppBlockBuildersRequest)((Object)DescribeAppBlockBuildersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

