/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.FixedDelayBackoffStrategy;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.services.appstream.AppStreamClient;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsRequest;
import software.amazon.awssdk.services.appstream.model.DescribeFleetsResponse;
import software.amazon.awssdk.services.appstream.waiters.AppStreamWaiter;
import software.amazon.awssdk.services.appstream.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultAppStreamWaiter
implements AppStreamWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final AppStreamClient client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeFleetsResponse> fleetStartedWaiter;
    private final Waiter<DescribeFleetsResponse> fleetStoppedWaiter;

    private DefaultAppStreamWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (AppStreamClient)AppStreamClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.fleetStartedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFleetsResponse.class).acceptors(DefaultAppStreamWaiter.fleetStartedWaiterAcceptors())).overrideConfiguration(DefaultAppStreamWaiter.fleetStartedWaiterConfig(builder.overrideConfiguration))).build();
        this.fleetStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeFleetsResponse.class).acceptors(DefaultAppStreamWaiter.fleetStoppedWaiterAcceptors())).overrideConfiguration(DefaultAppStreamWaiter.fleetStoppedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeFleetsResponse> waitUntilFleetStarted(DescribeFleetsRequest describeFleetsRequest) {
        return this.fleetStartedWaiter.run(() -> this.client.describeFleets(this.applyWaitersUserAgent(describeFleetsRequest)));
    }

    @Override
    public WaiterResponse<DescribeFleetsResponse> waitUntilFleetStarted(DescribeFleetsRequest describeFleetsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fleetStartedWaiter.run(() -> this.client.describeFleets(this.applyWaitersUserAgent(describeFleetsRequest)), DefaultAppStreamWaiter.fleetStartedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeFleetsResponse> waitUntilFleetStopped(DescribeFleetsRequest describeFleetsRequest) {
        return this.fleetStoppedWaiter.run(() -> this.client.describeFleets(this.applyWaitersUserAgent(describeFleetsRequest)));
    }

    @Override
    public WaiterResponse<DescribeFleetsResponse> waitUntilFleetStopped(DescribeFleetsRequest describeFleetsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.fleetStoppedWaiter.run(() -> this.client.describeFleets(this.applyWaitersUserAgent(describeFleetsRequest)), DefaultAppStreamWaiter.fleetStoppedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeFleetsResponse>> fleetStartedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFleetsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFleetsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "RUNNING"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "STOPPING"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "STOPPED"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeFleetsResponse>> fleetStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeFleetsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeFleetsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "STOPPED"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "STARTING"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            WaitersRuntime.Value input = new WaitersRuntime.Value(response);
            List<Object> resultValues = input.field("Fleets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "RUNNING"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration fleetStartedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration fleetStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = (BackoffStrategy)optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategy).orElse(FixedDelayBackoffStrategy.create((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategy(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static AppStreamWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends AppStreamRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().version("waiter").name("hll").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((AppStreamRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements AppStreamWaiter.Builder {
        private AppStreamClient client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public AppStreamWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public AppStreamWaiter.Builder client(AppStreamClient client) {
            this.client = client;
            return this;
        }

        @Override
        public AppStreamWaiter build() {
            return new DefaultAppStreamWaiter(this);
        }
    }
}

