/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the configuration information required to join fleets and image builders to Microsoft Active Directory
 * domains.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DirectoryConfig implements SdkPojo, Serializable, ToCopyableBuilder<DirectoryConfig.Builder, DirectoryConfig> {
    private static final SdkField<String> DIRECTORY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DirectoryName").getter(getter(DirectoryConfig::directoryName)).setter(setter(Builder::directoryName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DirectoryName").build()).build();

    private static final SdkField<List<String>> ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("OrganizationalUnitDistinguishedNames")
            .getter(getter(DirectoryConfig::organizationalUnitDistinguishedNames))
            .setter(setter(Builder::organizationalUnitDistinguishedNames))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                    .locationName("OrganizationalUnitDistinguishedNames").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ServiceAccountCredentials> SERVICE_ACCOUNT_CREDENTIALS_FIELD = SdkField
            .<ServiceAccountCredentials> builder(MarshallingType.SDK_POJO).memberName("ServiceAccountCredentials")
            .getter(getter(DirectoryConfig::serviceAccountCredentials)).setter(setter(Builder::serviceAccountCredentials))
            .constructor(ServiceAccountCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ServiceAccountCredentials").build())
            .build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(DirectoryConfig::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<CertificateBasedAuthProperties> CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD = SdkField
            .<CertificateBasedAuthProperties> builder(MarshallingType.SDK_POJO)
            .memberName("CertificateBasedAuthProperties")
            .getter(getter(DirectoryConfig::certificateBasedAuthProperties))
            .setter(setter(Builder::certificateBasedAuthProperties))
            .constructor(CertificateBasedAuthProperties::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CertificateBasedAuthProperties")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DIRECTORY_NAME_FIELD,
            ORGANIZATIONAL_UNIT_DISTINGUISHED_NAMES_FIELD, SERVICE_ACCOUNT_CREDENTIALS_FIELD, CREATED_TIME_FIELD,
            CERTIFICATE_BASED_AUTH_PROPERTIES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String directoryName;

    private final List<String> organizationalUnitDistinguishedNames;

    private final ServiceAccountCredentials serviceAccountCredentials;

    private final Instant createdTime;

    private final CertificateBasedAuthProperties certificateBasedAuthProperties;

    private DirectoryConfig(BuilderImpl builder) {
        this.directoryName = builder.directoryName;
        this.organizationalUnitDistinguishedNames = builder.organizationalUnitDistinguishedNames;
        this.serviceAccountCredentials = builder.serviceAccountCredentials;
        this.createdTime = builder.createdTime;
        this.certificateBasedAuthProperties = builder.certificateBasedAuthProperties;
    }

    /**
     * <p>
     * The fully qualified name of the directory (for example, corp.example.com).
     * </p>
     * 
     * @return The fully qualified name of the directory (for example, corp.example.com).
     */
    public final String directoryName() {
        return directoryName;
    }

    /**
     * For responses, this returns true if the service returned a value for the OrganizationalUnitDistinguishedNames
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasOrganizationalUnitDistinguishedNames() {
        return organizationalUnitDistinguishedNames != null
                && !(organizationalUnitDistinguishedNames instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The distinguished names of the organizational units for computer accounts.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasOrganizationalUnitDistinguishedNames}
     * method.
     * </p>
     * 
     * @return The distinguished names of the organizational units for computer accounts.
     */
    public final List<String> organizationalUnitDistinguishedNames() {
        return organizationalUnitDistinguishedNames;
    }

    /**
     * <p>
     * The credentials for the service account used by the fleet or image builder to connect to the directory.
     * </p>
     * 
     * @return The credentials for the service account used by the fleet or image builder to connect to the directory.
     */
    public final ServiceAccountCredentials serviceAccountCredentials() {
        return serviceAccountCredentials;
    }

    /**
     * <p>
     * The time the directory configuration was created.
     * </p>
     * 
     * @return The time the directory configuration was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user
     * identities to Active Directory domain-joined streaming instances. Fallback is turned on by default when
     * certificate-based authentication is <b>Enabled</b> . Fallback allows users to log in using their AD domain
     * password if certificate-based authentication is unsuccessful, or to unlock a desktop lock screen.
     * <b>Enabled_no_directory_login_fallback</b> enables certificate-based authentication, but does not allow users to
     * log in using their AD domain password. Users will be disconnected to re-authenticate using certificates.
     * </p>
     * 
     * @return The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP)
     *         user identities to Active Directory domain-joined streaming instances. Fallback is turned on by default
     *         when certificate-based authentication is <b>Enabled</b> . Fallback allows users to log in using their AD
     *         domain password if certificate-based authentication is unsuccessful, or to unlock a desktop lock screen.
     *         <b>Enabled_no_directory_login_fallback</b> enables certificate-based authentication, but does not allow
     *         users to log in using their AD domain password. Users will be disconnected to re-authenticate using
     *         certificates.
     */
    public final CertificateBasedAuthProperties certificateBasedAuthProperties() {
        return certificateBasedAuthProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(directoryName());
        hashCode = 31 * hashCode
                + Objects.hashCode(hasOrganizationalUnitDistinguishedNames() ? organizationalUnitDistinguishedNames() : null);
        hashCode = 31 * hashCode + Objects.hashCode(serviceAccountCredentials());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(certificateBasedAuthProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DirectoryConfig)) {
            return false;
        }
        DirectoryConfig other = (DirectoryConfig) obj;
        return Objects.equals(directoryName(), other.directoryName())
                && hasOrganizationalUnitDistinguishedNames() == other.hasOrganizationalUnitDistinguishedNames()
                && Objects.equals(organizationalUnitDistinguishedNames(), other.organizationalUnitDistinguishedNames())
                && Objects.equals(serviceAccountCredentials(), other.serviceAccountCredentials())
                && Objects.equals(createdTime(), other.createdTime())
                && Objects.equals(certificateBasedAuthProperties(), other.certificateBasedAuthProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("DirectoryConfig")
                .add("DirectoryName", directoryName())
                .add("OrganizationalUnitDistinguishedNames",
                        hasOrganizationalUnitDistinguishedNames() ? organizationalUnitDistinguishedNames() : null)
                .add("ServiceAccountCredentials", serviceAccountCredentials()).add("CreatedTime", createdTime())
                .add("CertificateBasedAuthProperties", certificateBasedAuthProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DirectoryName":
            return Optional.ofNullable(clazz.cast(directoryName()));
        case "OrganizationalUnitDistinguishedNames":
            return Optional.ofNullable(clazz.cast(organizationalUnitDistinguishedNames()));
        case "ServiceAccountCredentials":
            return Optional.ofNullable(clazz.cast(serviceAccountCredentials()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "CertificateBasedAuthProperties":
            return Optional.ofNullable(clazz.cast(certificateBasedAuthProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DirectoryConfig, T> g) {
        return obj -> g.apply((DirectoryConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DirectoryConfig> {
        /**
         * <p>
         * The fully qualified name of the directory (for example, corp.example.com).
         * </p>
         * 
         * @param directoryName
         *        The fully qualified name of the directory (for example, corp.example.com).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder directoryName(String directoryName);

        /**
         * <p>
         * The distinguished names of the organizational units for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedNames
         *        The distinguished names of the organizational units for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames);

        /**
         * <p>
         * The distinguished names of the organizational units for computer accounts.
         * </p>
         * 
         * @param organizationalUnitDistinguishedNames
         *        The distinguished names of the organizational units for computer accounts.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationalUnitDistinguishedNames(String... organizationalUnitDistinguishedNames);

        /**
         * <p>
         * The credentials for the service account used by the fleet or image builder to connect to the directory.
         * </p>
         * 
         * @param serviceAccountCredentials
         *        The credentials for the service account used by the fleet or image builder to connect to the
         *        directory.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials);

        /**
         * <p>
         * The credentials for the service account used by the fleet or image builder to connect to the directory.
         * </p>
         * This is a convenience method that creates an instance of the {@link ServiceAccountCredentials.Builder}
         * avoiding the need to create one manually via {@link ServiceAccountCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceAccountCredentials.Builder#build()} is called immediately
         * and its result is passed to {@link #serviceAccountCredentials(ServiceAccountCredentials)}.
         * 
         * @param serviceAccountCredentials
         *        a consumer that will call methods on {@link ServiceAccountCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceAccountCredentials(ServiceAccountCredentials)
         */
        default Builder serviceAccountCredentials(Consumer<ServiceAccountCredentials.Builder> serviceAccountCredentials) {
            return serviceAccountCredentials(ServiceAccountCredentials.builder().applyMutation(serviceAccountCredentials).build());
        }

        /**
         * <p>
         * The time the directory configuration was created.
         * </p>
         * 
         * @param createdTime
         *        The time the directory configuration was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user
         * identities to Active Directory domain-joined streaming instances. Fallback is turned on by default when
         * certificate-based authentication is <b>Enabled</b> . Fallback allows users to log in using their AD domain
         * password if certificate-based authentication is unsuccessful, or to unlock a desktop lock screen.
         * <b>Enabled_no_directory_login_fallback</b> enables certificate-based authentication, but does not allow users
         * to log in using their AD domain password. Users will be disconnected to re-authenticate using certificates.
         * </p>
         * 
         * @param certificateBasedAuthProperties
         *        The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP)
         *        user identities to Active Directory domain-joined streaming instances. Fallback is turned on by
         *        default when certificate-based authentication is <b>Enabled</b> . Fallback allows users to log in
         *        using their AD domain password if certificate-based authentication is unsuccessful, or to unlock a
         *        desktop lock screen. <b>Enabled_no_directory_login_fallback</b> enables certificate-based
         *        authentication, but does not allow users to log in using their AD domain password. Users will be
         *        disconnected to re-authenticate using certificates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties);

        /**
         * <p>
         * The certificate-based authentication properties used to authenticate SAML 2.0 Identity Provider (IdP) user
         * identities to Active Directory domain-joined streaming instances. Fallback is turned on by default when
         * certificate-based authentication is <b>Enabled</b> . Fallback allows users to log in using their AD domain
         * password if certificate-based authentication is unsuccessful, or to unlock a desktop lock screen.
         * <b>Enabled_no_directory_login_fallback</b> enables certificate-based authentication, but does not allow users
         * to log in using their AD domain password. Users will be disconnected to re-authenticate using certificates.
         * </p>
         * This is a convenience method that creates an instance of the {@link CertificateBasedAuthProperties.Builder}
         * avoiding the need to create one manually via {@link CertificateBasedAuthProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CertificateBasedAuthProperties.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #certificateBasedAuthProperties(CertificateBasedAuthProperties)}.
         * 
         * @param certificateBasedAuthProperties
         *        a consumer that will call methods on {@link CertificateBasedAuthProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #certificateBasedAuthProperties(CertificateBasedAuthProperties)
         */
        default Builder certificateBasedAuthProperties(
                Consumer<CertificateBasedAuthProperties.Builder> certificateBasedAuthProperties) {
            return certificateBasedAuthProperties(CertificateBasedAuthProperties.builder()
                    .applyMutation(certificateBasedAuthProperties).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String directoryName;

        private List<String> organizationalUnitDistinguishedNames = DefaultSdkAutoConstructList.getInstance();

        private ServiceAccountCredentials serviceAccountCredentials;

        private Instant createdTime;

        private CertificateBasedAuthProperties certificateBasedAuthProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(DirectoryConfig model) {
            directoryName(model.directoryName);
            organizationalUnitDistinguishedNames(model.organizationalUnitDistinguishedNames);
            serviceAccountCredentials(model.serviceAccountCredentials);
            createdTime(model.createdTime);
            certificateBasedAuthProperties(model.certificateBasedAuthProperties);
        }

        public final String getDirectoryName() {
            return directoryName;
        }

        public final void setDirectoryName(String directoryName) {
            this.directoryName = directoryName;
        }

        @Override
        public final Builder directoryName(String directoryName) {
            this.directoryName = directoryName;
            return this;
        }

        public final Collection<String> getOrganizationalUnitDistinguishedNames() {
            if (organizationalUnitDistinguishedNames instanceof SdkAutoConstructList) {
                return null;
            }
            return organizationalUnitDistinguishedNames;
        }

        public final void setOrganizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier
                    .copy(organizationalUnitDistinguishedNames);
        }

        @Override
        public final Builder organizationalUnitDistinguishedNames(Collection<String> organizationalUnitDistinguishedNames) {
            this.organizationalUnitDistinguishedNames = OrganizationalUnitDistinguishedNamesListCopier
                    .copy(organizationalUnitDistinguishedNames);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder organizationalUnitDistinguishedNames(String... organizationalUnitDistinguishedNames) {
            organizationalUnitDistinguishedNames(Arrays.asList(organizationalUnitDistinguishedNames));
            return this;
        }

        public final ServiceAccountCredentials.Builder getServiceAccountCredentials() {
            return serviceAccountCredentials != null ? serviceAccountCredentials.toBuilder() : null;
        }

        public final void setServiceAccountCredentials(ServiceAccountCredentials.BuilderImpl serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials != null ? serviceAccountCredentials.build() : null;
        }

        @Override
        public final Builder serviceAccountCredentials(ServiceAccountCredentials serviceAccountCredentials) {
            this.serviceAccountCredentials = serviceAccountCredentials;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final CertificateBasedAuthProperties.Builder getCertificateBasedAuthProperties() {
            return certificateBasedAuthProperties != null ? certificateBasedAuthProperties.toBuilder() : null;
        }

        public final void setCertificateBasedAuthProperties(
                CertificateBasedAuthProperties.BuilderImpl certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties != null ? certificateBasedAuthProperties.build()
                    : null;
        }

        @Override
        public final Builder certificateBasedAuthProperties(CertificateBasedAuthProperties certificateBasedAuthProperties) {
            this.certificateBasedAuthProperties = certificateBasedAuthProperties;
            return this;
        }

        @Override
        public DirectoryConfig build() {
            return new DirectoryConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
