/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateThemeForStackRequest extends AppStreamRequest implements
        ToCopyableBuilder<UpdateThemeForStackRequest.Builder, UpdateThemeForStackRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(UpdateThemeForStackRequest::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<List<ThemeFooterLink>> FOOTER_LINKS_FIELD = SdkField
            .<List<ThemeFooterLink>> builder(MarshallingType.LIST)
            .memberName("FooterLinks")
            .getter(getter(UpdateThemeForStackRequest::footerLinks))
            .setter(setter(Builder::footerLinks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FooterLinks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ThemeFooterLink> builder(MarshallingType.SDK_POJO)
                                            .constructor(ThemeFooterLink::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> TITLE_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("TitleText").getter(getter(UpdateThemeForStackRequest::titleText)).setter(setter(Builder::titleText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TitleText").build()).build();

    private static final SdkField<String> THEME_STYLING_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ThemeStyling").getter(getter(UpdateThemeForStackRequest::themeStylingAsString))
            .setter(setter(Builder::themeStyling))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ThemeStyling").build()).build();

    private static final SdkField<S3Location> ORGANIZATION_LOGO_S3_LOCATION_FIELD = SdkField
            .<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("OrganizationLogoS3Location")
            .getter(getter(UpdateThemeForStackRequest::organizationLogoS3Location))
            .setter(setter(Builder::organizationLogoS3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OrganizationLogoS3Location").build())
            .build();

    private static final SdkField<S3Location> FAVICON_S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("FaviconS3Location").getter(getter(UpdateThemeForStackRequest::faviconS3Location))
            .setter(setter(Builder::faviconS3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FaviconS3Location").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(UpdateThemeForStackRequest::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<List<String>> ATTRIBUTES_TO_DELETE_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("AttributesToDelete")
            .getter(getter(UpdateThemeForStackRequest::attributesToDeleteAsStrings))
            .setter(setter(Builder::attributesToDeleteWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AttributesToDelete").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            FOOTER_LINKS_FIELD, TITLE_TEXT_FIELD, THEME_STYLING_FIELD, ORGANIZATION_LOGO_S3_LOCATION_FIELD,
            FAVICON_S3_LOCATION_FIELD, STATE_FIELD, ATTRIBUTES_TO_DELETE_FIELD));

    private final String stackName;

    private final List<ThemeFooterLink> footerLinks;

    private final String titleText;

    private final String themeStyling;

    private final S3Location organizationLogoS3Location;

    private final S3Location faviconS3Location;

    private final String state;

    private final List<String> attributesToDelete;

    private UpdateThemeForStackRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.footerLinks = builder.footerLinks;
        this.titleText = builder.titleText;
        this.themeStyling = builder.themeStyling;
        this.organizationLogoS3Location = builder.organizationLogoS3Location;
        this.faviconS3Location = builder.faviconS3Location;
        this.state = builder.state;
        this.attributesToDelete = builder.attributesToDelete;
    }

    /**
     * <p>
     * The name of the stack for the theme.
     * </p>
     * 
     * @return The name of the stack for the theme.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * For responses, this returns true if the service returned a value for the FooterLinks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFooterLinks() {
        return footerLinks != null && !(footerLinks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The links that are displayed in the footer of the streaming application catalog page. These links are helpful
     * resources for users, such as the organization's IT support and product marketing sites.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFooterLinks} method.
     * </p>
     * 
     * @return The links that are displayed in the footer of the streaming application catalog page. These links are
     *         helpful resources for users, such as the organization's IT support and product marketing sites.
     */
    public final List<ThemeFooterLink> footerLinks() {
        return footerLinks;
    }

    /**
     * <p>
     * The title that is displayed at the top of the browser tab during users' application streaming sessions.
     * </p>
     * 
     * @return The title that is displayed at the top of the browser tab during users' application streaming sessions.
     */
    public final String titleText() {
        return titleText;
    }

    /**
     * <p>
     * The color theme that is applied to website links, text, and buttons. These colors are also applied as accents in
     * the background for the streaming application catalog page.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #themeStyling} will
     * return {@link ThemeStyling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #themeStylingAsString}.
     * </p>
     * 
     * @return The color theme that is applied to website links, text, and buttons. These colors are also applied as
     *         accents in the background for the streaming application catalog page.
     * @see ThemeStyling
     */
    public final ThemeStyling themeStyling() {
        return ThemeStyling.fromValue(themeStyling);
    }

    /**
     * <p>
     * The color theme that is applied to website links, text, and buttons. These colors are also applied as accents in
     * the background for the streaming application catalog page.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #themeStyling} will
     * return {@link ThemeStyling#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #themeStylingAsString}.
     * </p>
     * 
     * @return The color theme that is applied to website links, text, and buttons. These colors are also applied as
     *         accents in the background for the streaming application catalog page.
     * @see ThemeStyling
     */
    public final String themeStylingAsString() {
        return themeStyling;
    }

    /**
     * <p>
     * The organization logo that appears on the streaming application catalog page.
     * </p>
     * 
     * @return The organization logo that appears on the streaming application catalog page.
     */
    public final S3Location organizationLogoS3Location() {
        return organizationLogoS3Location;
    }

    /**
     * <p>
     * The S3 location of the favicon. The favicon enables users to recognize their application streaming site in a
     * browser full of tabs or bookmarks. It is displayed at the top of the browser tab for the application streaming
     * site during users' streaming sessions.
     * </p>
     * 
     * @return The S3 location of the favicon. The favicon enables users to recognize their application streaming site
     *         in a browser full of tabs or bookmarks. It is displayed at the top of the browser tab for the application
     *         streaming site during users' streaming sessions.
     */
    public final S3Location faviconS3Location() {
        return faviconS3Location;
    }

    /**
     * <p>
     * Specifies whether custom branding should be applied to catalog page or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ThemeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether custom branding should be applied to catalog page or not.
     * @see ThemeState
     */
    public final ThemeState state() {
        return ThemeState.fromValue(state);
    }

    /**
     * <p>
     * Specifies whether custom branding should be applied to catalog page or not.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link ThemeState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return Specifies whether custom branding should be applied to catalog page or not.
     * @see ThemeState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The attributes to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToDelete} method.
     * </p>
     * 
     * @return The attributes to delete.
     */
    public final List<ThemeAttribute> attributesToDelete() {
        return ThemeAttributesCopier.copyStringToEnum(attributesToDelete);
    }

    /**
     * For responses, this returns true if the service returned a value for the AttributesToDelete property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAttributesToDelete() {
        return attributesToDelete != null && !(attributesToDelete instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The attributes to delete.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributesToDelete} method.
     * </p>
     * 
     * @return The attributes to delete.
     */
    public final List<String> attributesToDeleteAsStrings() {
        return attributesToDelete;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(hasFooterLinks() ? footerLinks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(titleText());
        hashCode = 31 * hashCode + Objects.hashCode(themeStylingAsString());
        hashCode = 31 * hashCode + Objects.hashCode(organizationLogoS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(faviconS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributesToDelete() ? attributesToDeleteAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateThemeForStackRequest)) {
            return false;
        }
        UpdateThemeForStackRequest other = (UpdateThemeForStackRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && hasFooterLinks() == other.hasFooterLinks()
                && Objects.equals(footerLinks(), other.footerLinks()) && Objects.equals(titleText(), other.titleText())
                && Objects.equals(themeStylingAsString(), other.themeStylingAsString())
                && Objects.equals(organizationLogoS3Location(), other.organizationLogoS3Location())
                && Objects.equals(faviconS3Location(), other.faviconS3Location())
                && Objects.equals(stateAsString(), other.stateAsString())
                && hasAttributesToDelete() == other.hasAttributesToDelete()
                && Objects.equals(attributesToDeleteAsStrings(), other.attributesToDeleteAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateThemeForStackRequest").add("StackName", stackName())
                .add("FooterLinks", hasFooterLinks() ? footerLinks() : null).add("TitleText", titleText())
                .add("ThemeStyling", themeStylingAsString()).add("OrganizationLogoS3Location", organizationLogoS3Location())
                .add("FaviconS3Location", faviconS3Location()).add("State", stateAsString())
                .add("AttributesToDelete", hasAttributesToDelete() ? attributesToDeleteAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "FooterLinks":
            return Optional.ofNullable(clazz.cast(footerLinks()));
        case "TitleText":
            return Optional.ofNullable(clazz.cast(titleText()));
        case "ThemeStyling":
            return Optional.ofNullable(clazz.cast(themeStylingAsString()));
        case "OrganizationLogoS3Location":
            return Optional.ofNullable(clazz.cast(organizationLogoS3Location()));
        case "FaviconS3Location":
            return Optional.ofNullable(clazz.cast(faviconS3Location()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "AttributesToDelete":
            return Optional.ofNullable(clazz.cast(attributesToDeleteAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateThemeForStackRequest, T> g) {
        return obj -> g.apply((UpdateThemeForStackRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateThemeForStackRequest> {
        /**
         * <p>
         * The name of the stack for the theme.
         * </p>
         * 
         * @param stackName
         *        The name of the stack for the theme.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The links that are displayed in the footer of the streaming application catalog page. These links are helpful
         * resources for users, such as the organization's IT support and product marketing sites.
         * </p>
         * 
         * @param footerLinks
         *        The links that are displayed in the footer of the streaming application catalog page. These links are
         *        helpful resources for users, such as the organization's IT support and product marketing sites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder footerLinks(Collection<ThemeFooterLink> footerLinks);

        /**
         * <p>
         * The links that are displayed in the footer of the streaming application catalog page. These links are helpful
         * resources for users, such as the organization's IT support and product marketing sites.
         * </p>
         * 
         * @param footerLinks
         *        The links that are displayed in the footer of the streaming application catalog page. These links are
         *        helpful resources for users, such as the organization's IT support and product marketing sites.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder footerLinks(ThemeFooterLink... footerLinks);

        /**
         * <p>
         * The links that are displayed in the footer of the streaming application catalog page. These links are helpful
         * resources for users, such as the organization's IT support and product marketing sites.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appstream.model.ThemeFooterLink.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.appstream.model.ThemeFooterLink#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appstream.model.ThemeFooterLink.Builder#build()} is called immediately
         * and its result is passed to {@link #footerLinks(List<ThemeFooterLink>)}.
         * 
         * @param footerLinks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appstream.model.ThemeFooterLink.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #footerLinks(java.util.Collection<ThemeFooterLink>)
         */
        Builder footerLinks(Consumer<ThemeFooterLink.Builder>... footerLinks);

        /**
         * <p>
         * The title that is displayed at the top of the browser tab during users' application streaming sessions.
         * </p>
         * 
         * @param titleText
         *        The title that is displayed at the top of the browser tab during users' application streaming
         *        sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder titleText(String titleText);

        /**
         * <p>
         * The color theme that is applied to website links, text, and buttons. These colors are also applied as accents
         * in the background for the streaming application catalog page.
         * </p>
         * 
         * @param themeStyling
         *        The color theme that is applied to website links, text, and buttons. These colors are also applied as
         *        accents in the background for the streaming application catalog page.
         * @see ThemeStyling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeStyling
         */
        Builder themeStyling(String themeStyling);

        /**
         * <p>
         * The color theme that is applied to website links, text, and buttons. These colors are also applied as accents
         * in the background for the streaming application catalog page.
         * </p>
         * 
         * @param themeStyling
         *        The color theme that is applied to website links, text, and buttons. These colors are also applied as
         *        accents in the background for the streaming application catalog page.
         * @see ThemeStyling
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeStyling
         */
        Builder themeStyling(ThemeStyling themeStyling);

        /**
         * <p>
         * The organization logo that appears on the streaming application catalog page.
         * </p>
         * 
         * @param organizationLogoS3Location
         *        The organization logo that appears on the streaming application catalog page.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder organizationLogoS3Location(S3Location organizationLogoS3Location);

        /**
         * <p>
         * The organization logo that appears on the streaming application catalog page.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #organizationLogoS3Location(S3Location)}.
         * 
         * @param organizationLogoS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #organizationLogoS3Location(S3Location)
         */
        default Builder organizationLogoS3Location(Consumer<S3Location.Builder> organizationLogoS3Location) {
            return organizationLogoS3Location(S3Location.builder().applyMutation(organizationLogoS3Location).build());
        }

        /**
         * <p>
         * The S3 location of the favicon. The favicon enables users to recognize their application streaming site in a
         * browser full of tabs or bookmarks. It is displayed at the top of the browser tab for the application
         * streaming site during users' streaming sessions.
         * </p>
         * 
         * @param faviconS3Location
         *        The S3 location of the favicon. The favicon enables users to recognize their application streaming
         *        site in a browser full of tabs or bookmarks. It is displayed at the top of the browser tab for the
         *        application streaming site during users' streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder faviconS3Location(S3Location faviconS3Location);

        /**
         * <p>
         * The S3 location of the favicon. The favicon enables users to recognize their application streaming site in a
         * browser full of tabs or bookmarks. It is displayed at the top of the browser tab for the application
         * streaming site during users' streaming sessions.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #faviconS3Location(S3Location)}.
         * 
         * @param faviconS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #faviconS3Location(S3Location)
         */
        default Builder faviconS3Location(Consumer<S3Location.Builder> faviconS3Location) {
            return faviconS3Location(S3Location.builder().applyMutation(faviconS3Location).build());
        }

        /**
         * <p>
         * Specifies whether custom branding should be applied to catalog page or not.
         * </p>
         * 
         * @param state
         *        Specifies whether custom branding should be applied to catalog page or not.
         * @see ThemeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeState
         */
        Builder state(String state);

        /**
         * <p>
         * Specifies whether custom branding should be applied to catalog page or not.
         * </p>
         * 
         * @param state
         *        Specifies whether custom branding should be applied to catalog page or not.
         * @see ThemeState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ThemeState
         */
        Builder state(ThemeState state);

        /**
         * <p>
         * The attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete);

        /**
         * <p>
         * The attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDeleteWithStrings(String... attributesToDelete);

        /**
         * <p>
         * The attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(Collection<ThemeAttribute> attributesToDelete);

        /**
         * <p>
         * The attributes to delete.
         * </p>
         * 
         * @param attributesToDelete
         *        The attributes to delete.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributesToDelete(ThemeAttribute... attributesToDelete);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String stackName;

        private List<ThemeFooterLink> footerLinks = DefaultSdkAutoConstructList.getInstance();

        private String titleText;

        private String themeStyling;

        private S3Location organizationLogoS3Location;

        private S3Location faviconS3Location;

        private String state;

        private List<String> attributesToDelete = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateThemeForStackRequest model) {
            super(model);
            stackName(model.stackName);
            footerLinks(model.footerLinks);
            titleText(model.titleText);
            themeStyling(model.themeStyling);
            organizationLogoS3Location(model.organizationLogoS3Location);
            faviconS3Location(model.faviconS3Location);
            state(model.state);
            attributesToDeleteWithStrings(model.attributesToDelete);
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final List<ThemeFooterLink.Builder> getFooterLinks() {
            List<ThemeFooterLink.Builder> result = ThemeFooterLinksCopier.copyToBuilder(this.footerLinks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFooterLinks(Collection<ThemeFooterLink.BuilderImpl> footerLinks) {
            this.footerLinks = ThemeFooterLinksCopier.copyFromBuilder(footerLinks);
        }

        @Override
        public final Builder footerLinks(Collection<ThemeFooterLink> footerLinks) {
            this.footerLinks = ThemeFooterLinksCopier.copy(footerLinks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder footerLinks(ThemeFooterLink... footerLinks) {
            footerLinks(Arrays.asList(footerLinks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder footerLinks(Consumer<ThemeFooterLink.Builder>... footerLinks) {
            footerLinks(Stream.of(footerLinks).map(c -> ThemeFooterLink.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getTitleText() {
            return titleText;
        }

        public final void setTitleText(String titleText) {
            this.titleText = titleText;
        }

        @Override
        public final Builder titleText(String titleText) {
            this.titleText = titleText;
            return this;
        }

        public final String getThemeStyling() {
            return themeStyling;
        }

        public final void setThemeStyling(String themeStyling) {
            this.themeStyling = themeStyling;
        }

        @Override
        public final Builder themeStyling(String themeStyling) {
            this.themeStyling = themeStyling;
            return this;
        }

        @Override
        public final Builder themeStyling(ThemeStyling themeStyling) {
            this.themeStyling(themeStyling == null ? null : themeStyling.toString());
            return this;
        }

        public final S3Location.Builder getOrganizationLogoS3Location() {
            return organizationLogoS3Location != null ? organizationLogoS3Location.toBuilder() : null;
        }

        public final void setOrganizationLogoS3Location(S3Location.BuilderImpl organizationLogoS3Location) {
            this.organizationLogoS3Location = organizationLogoS3Location != null ? organizationLogoS3Location.build() : null;
        }

        @Override
        public final Builder organizationLogoS3Location(S3Location organizationLogoS3Location) {
            this.organizationLogoS3Location = organizationLogoS3Location;
            return this;
        }

        public final S3Location.Builder getFaviconS3Location() {
            return faviconS3Location != null ? faviconS3Location.toBuilder() : null;
        }

        public final void setFaviconS3Location(S3Location.BuilderImpl faviconS3Location) {
            this.faviconS3Location = faviconS3Location != null ? faviconS3Location.build() : null;
        }

        @Override
        public final Builder faviconS3Location(S3Location faviconS3Location) {
            this.faviconS3Location = faviconS3Location;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ThemeState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final Collection<String> getAttributesToDelete() {
            if (attributesToDelete instanceof SdkAutoConstructList) {
                return null;
            }
            return attributesToDelete;
        }

        public final void setAttributesToDelete(Collection<String> attributesToDelete) {
            this.attributesToDelete = ThemeAttributesCopier.copy(attributesToDelete);
        }

        @Override
        public final Builder attributesToDeleteWithStrings(Collection<String> attributesToDelete) {
            this.attributesToDelete = ThemeAttributesCopier.copy(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDeleteWithStrings(String... attributesToDelete) {
            attributesToDeleteWithStrings(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public final Builder attributesToDelete(Collection<ThemeAttribute> attributesToDelete) {
            this.attributesToDelete = ThemeAttributesCopier.copyEnumToString(attributesToDelete);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributesToDelete(ThemeAttribute... attributesToDelete) {
            attributesToDelete(Arrays.asList(attributesToDelete));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateThemeForStackRequest build() {
            return new UpdateThemeForStackRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
