/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the parameters for a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Fleet implements SdkPojo, Serializable, ToCopyableBuilder<Fleet.Builder, Fleet> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::fleetTypeAsString)).setter(setter(Builder::fleetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()).build();

    private static final SdkField<ComputeCapacityStatus> COMPUTE_CAPACITY_STATUS_FIELD = SdkField
            .<ComputeCapacityStatus> builder(MarshallingType.SDK_POJO).getter(getter(Fleet::computeCapacityStatus))
            .setter(setter(Builder::computeCapacityStatus)).constructor(ComputeCapacityStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeCapacityStatus").build())
            .build();

    private static final SdkField<Integer> MAX_USER_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).getter(getter(Fleet::maxUserDurationInSeconds))
            .setter(setter(Builder::maxUserDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUserDurationInSeconds").build())
            .build();

    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(Fleet::disconnectTimeoutInSeconds))
            .setter(setter(Builder::disconnectTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimeoutInSeconds").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Fleet::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(Fleet::vpcConfig)).setter(setter(Builder::vpcConfig)).constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Fleet::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<List<FleetError>> FLEET_ERRORS_FIELD = SdkField
            .<List<FleetError>> builder(MarshallingType.LIST)
            .getter(getter(Fleet::fleetErrors))
            .setter(setter(Builder::fleetErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetError> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Fleet::enableDefaultInternetAccess))
            .setter(setter(Builder::enableDefaultInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess")
                    .build()).build();

    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField
            .<DomainJoinInfo> builder(MarshallingType.SDK_POJO).getter(getter(Fleet::domainJoinInfo))
            .setter(setter(Builder::domainJoinInfo)).constructor(DomainJoinInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, IMAGE_NAME_FIELD, IMAGE_ARN_FIELD, INSTANCE_TYPE_FIELD, FLEET_TYPE_FIELD,
            COMPUTE_CAPACITY_STATUS_FIELD, MAX_USER_DURATION_IN_SECONDS_FIELD, DISCONNECT_TIMEOUT_IN_SECONDS_FIELD, STATE_FIELD,
            VPC_CONFIG_FIELD, CREATED_TIME_FIELD, FLEET_ERRORS_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD,
            DOMAIN_JOIN_INFO_FIELD));

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String displayName;

    private final String description;

    private final String imageName;

    private final String imageArn;

    private final String instanceType;

    private final String fleetType;

    private final ComputeCapacityStatus computeCapacityStatus;

    private final Integer maxUserDurationInSeconds;

    private final Integer disconnectTimeoutInSeconds;

    private final String state;

    private final VpcConfig vpcConfig;

    private final Instant createdTime;

    private final List<FleetError> fleetErrors;

    private final Boolean enableDefaultInternetAccess;

    private final DomainJoinInfo domainJoinInfo;

    private Fleet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.instanceType = builder.instanceType;
        this.fleetType = builder.fleetType;
        this.computeCapacityStatus = builder.computeCapacityStatus;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.state = builder.state;
        this.vpcConfig = builder.vpcConfig;
        this.createdTime = builder.createdTime;
        this.fleetErrors = builder.fleetErrors;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
    }

    /**
     * <p>
     * The ARN for the fleet.
     * </p>
     * 
     * @return The ARN for the fleet.
     */
    public String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The fleet name for display.
     * </p>
     * 
     * @return The fleet name for display.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description for display.
     * </p>
     * 
     * @return The description for display.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The name of the image used to create the fleet.
     * </p>
     * 
     * @return The name of the image used to create the fleet.
     */
    public String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The ARN for the public, private, or shared image.
     * </p>
     * 
     * @return The ARN for the public, private, or shared image.
     */
    public String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The instance type to use when launching fleet instances.
     * </p>
     * 
     * @return The instance type to use when launching fleet instances.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The fleet type.
     * </p>
     * <dl>
     * <dt>ALWAYS_ON</dt>
     * <dd>
     * <p>
     * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
     * even if no users are streaming apps.
     * </p>
     * </dd>
     * <dt>ON_DEMAND</dt>
     * <dd>
     * <p>
     * Provide users with access to applications after they connect, which takes one to two minutes. You are charged for
     * instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return The fleet type.</p>
     *         <dl>
     *         <dt>ALWAYS_ON</dt>
     *         <dd>
     *         <p>
     *         Provides users with instant-on access to their apps. You are charged for all running instances in your
     *         fleet, even if no users are streaming apps.
     *         </p>
     *         </dd>
     *         <dt>ON_DEMAND</dt>
     *         <dd>
     *         <p>
     *         Provide users with access to applications after they connect, which takes one to two minutes. You are
     *         charged for instance streaming when users are connected and a small hourly fee for instances that are not
     *         streaming apps.
     *         </p>
     *         </dd>
     * @see FleetType
     */
    public FleetType fleetType() {
        return FleetType.fromValue(fleetType);
    }

    /**
     * <p>
     * The fleet type.
     * </p>
     * <dl>
     * <dt>ALWAYS_ON</dt>
     * <dd>
     * <p>
     * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
     * even if no users are streaming apps.
     * </p>
     * </dd>
     * <dt>ON_DEMAND</dt>
     * <dd>
     * <p>
     * Provide users with access to applications after they connect, which takes one to two minutes. You are charged for
     * instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return The fleet type.</p>
     *         <dl>
     *         <dt>ALWAYS_ON</dt>
     *         <dd>
     *         <p>
     *         Provides users with instant-on access to their apps. You are charged for all running instances in your
     *         fleet, even if no users are streaming apps.
     *         </p>
     *         </dd>
     *         <dt>ON_DEMAND</dt>
     *         <dd>
     *         <p>
     *         Provide users with access to applications after they connect, which takes one to two minutes. You are
     *         charged for instance streaming when users are connected and a small hourly fee for instances that are not
     *         streaming apps.
     *         </p>
     *         </dd>
     * @see FleetType
     */
    public String fleetTypeAsString() {
        return fleetType;
    }

    /**
     * <p>
     * The capacity status for the fleet.
     * </p>
     * 
     * @return The capacity status for the fleet.
     */
    public ComputeCapacityStatus computeCapacityStatus() {
        return computeCapacityStatus;
    }

    /**
     * <p>
     * The maximum time that a streaming session can run, in seconds. Specify a value between 600 and 57600.
     * </p>
     * 
     * @return The maximum time that a streaming session can run, in seconds. Specify a value between 600 and 57600.
     */
    public Integer maxUserDurationInSeconds() {
        return maxUserDurationInSeconds;
    }

    /**
     * <p>
     * The time after disconnection when a session is considered to have ended, in seconds. If a user who was
     * disconnected reconnects within this time interval, the user is connected to their previous session. Specify a
     * value between 60 and 57600.
     * </p>
     * 
     * @return The time after disconnection when a session is considered to have ended, in seconds. If a user who was
     *         disconnected reconnects within this time interval, the user is connected to their previous session.
     *         Specify a value between 60 and 57600.
     */
    public Integer disconnectTimeoutInSeconds() {
        return disconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * The current state for the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FleetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state for the fleet.
     * @see FleetState
     */
    public FleetState state() {
        return FleetState.fromValue(state);
    }

    /**
     * <p>
     * The current state for the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FleetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state for the fleet.
     * @see FleetState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The VPC configuration for the fleet.
     * </p>
     * 
     * @return The VPC configuration for the fleet.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The time the fleet was created.
     * </p>
     * 
     * @return The time the fleet was created.
     */
    public Instant createdTime() {
        return createdTime;
    }

    /**
     * <p>
     * The fleet errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The fleet errors.
     */
    public List<FleetError> fleetErrors() {
        return fleetErrors;
    }

    /**
     * <p>
     * Indicates whether default internet access is enabled for the fleet.
     * </p>
     * 
     * @return Indicates whether default internet access is enabled for the fleet.
     */
    public Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * <p>
     * The information needed to join a Microsoft Active Directory domain.
     * </p>
     * 
     * @return The information needed to join a Microsoft Active Directory domain.
     */
    public DomainJoinInfo domainJoinInfo() {
        return domainJoinInfo;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computeCapacityStatus());
        hashCode = 31 * hashCode + Objects.hashCode(maxUserDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(fleetErrors());
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(domainJoinInfo());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(imageName(), other.imageName()) && Objects.equals(imageArn(), other.imageArn())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(fleetTypeAsString(), other.fleetTypeAsString())
                && Objects.equals(computeCapacityStatus(), other.computeCapacityStatus())
                && Objects.equals(maxUserDurationInSeconds(), other.maxUserDurationInSeconds())
                && Objects.equals(disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(createdTime(), other.createdTime()) && Objects.equals(fleetErrors(), other.fleetErrors())
                && Objects.equals(enableDefaultInternetAccess(), other.enableDefaultInternetAccess())
                && Objects.equals(domainJoinInfo(), other.domainJoinInfo());
    }

    @Override
    public String toString() {
        return ToString.builder("Fleet").add("Arn", arn()).add("Name", name()).add("DisplayName", displayName())
                .add("Description", description()).add("ImageName", imageName()).add("ImageArn", imageArn())
                .add("InstanceType", instanceType()).add("FleetType", fleetTypeAsString())
                .add("ComputeCapacityStatus", computeCapacityStatus())
                .add("MaxUserDurationInSeconds", maxUserDurationInSeconds())
                .add("DisconnectTimeoutInSeconds", disconnectTimeoutInSeconds()).add("State", stateAsString())
                .add("VpcConfig", vpcConfig()).add("CreatedTime", createdTime()).add("FleetErrors", fleetErrors())
                .add("EnableDefaultInternetAccess", enableDefaultInternetAccess()).add("DomainJoinInfo", domainJoinInfo())
                .build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "FleetType":
            return Optional.ofNullable(clazz.cast(fleetTypeAsString()));
        case "ComputeCapacityStatus":
            return Optional.ofNullable(clazz.cast(computeCapacityStatus()));
        case "MaxUserDurationInSeconds":
            return Optional.ofNullable(clazz.cast(maxUserDurationInSeconds()));
        case "DisconnectTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(disconnectTimeoutInSeconds()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "FleetErrors":
            return Optional.ofNullable(clazz.cast(fleetErrors()));
        case "EnableDefaultInternetAccess":
            return Optional.ofNullable(clazz.cast(enableDefaultInternetAccess()));
        case "DomainJoinInfo":
            return Optional.ofNullable(clazz.cast(domainJoinInfo()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Fleet, T> g) {
        return obj -> g.apply((Fleet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Fleet> {
        /**
         * <p>
         * The ARN for the fleet.
         * </p>
         * 
         * @param arn
         *        The ARN for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param name
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The fleet name for display.
         * </p>
         * 
         * @param displayName
         *        The fleet name for display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description for display.
         * </p>
         * 
         * @param description
         *        The description for display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the image used to create the fleet.
         * </p>
         * 
         * @param imageName
         *        The name of the image used to create the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The ARN for the public, private, or shared image.
         * </p>
         * 
         * @param imageArn
         *        The ARN for the public, private, or shared image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The instance type to use when launching fleet instances.
         * </p>
         * 
         * @param instanceType
         *        The instance type to use when launching fleet instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The fleet type.
         * </p>
         * <dl>
         * <dt>ALWAYS_ON</dt>
         * <dd>
         * <p>
         * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
         * even if no users are streaming apps.
         * </p>
         * </dd>
         * <dt>ON_DEMAND</dt>
         * <dd>
         * <p>
         * Provide users with access to applications after they connect, which takes one to two minutes. You are charged
         * for instance streaming when users are connected and a small hourly fee for instances that are not streaming
         * apps.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param fleetType
         *        The fleet type.</p>
         *        <dl>
         *        <dt>ALWAYS_ON</dt>
         *        <dd>
         *        <p>
         *        Provides users with instant-on access to their apps. You are charged for all running instances in your
         *        fleet, even if no users are streaming apps.
         *        </p>
         *        </dd>
         *        <dt>ON_DEMAND</dt>
         *        <dd>
         *        <p>
         *        Provide users with access to applications after they connect, which takes one to two minutes. You are
         *        charged for instance streaming when users are connected and a small hourly fee for instances that are
         *        not streaming apps.
         *        </p>
         *        </dd>
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * The fleet type.
         * </p>
         * <dl>
         * <dt>ALWAYS_ON</dt>
         * <dd>
         * <p>
         * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
         * even if no users are streaming apps.
         * </p>
         * </dd>
         * <dt>ON_DEMAND</dt>
         * <dd>
         * <p>
         * Provide users with access to applications after they connect, which takes one to two minutes. You are charged
         * for instance streaming when users are connected and a small hourly fee for instances that are not streaming
         * apps.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param fleetType
         *        The fleet type.</p>
         *        <dl>
         *        <dt>ALWAYS_ON</dt>
         *        <dd>
         *        <p>
         *        Provides users with instant-on access to their apps. You are charged for all running instances in your
         *        fleet, even if no users are streaming apps.
         *        </p>
         *        </dd>
         *        <dt>ON_DEMAND</dt>
         *        <dd>
         *        <p>
         *        Provide users with access to applications after they connect, which takes one to two minutes. You are
         *        charged for instance streaming when users are connected and a small hourly fee for instances that are
         *        not streaming apps.
         *        </p>
         *        </dd>
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(FleetType fleetType);

        /**
         * <p>
         * The capacity status for the fleet.
         * </p>
         * 
         * @param computeCapacityStatus
         *        The capacity status for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus);

        /**
         * <p>
         * The capacity status for the fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link ComputeCapacityStatus.Builder} avoiding the need
         * to create one manually via {@link ComputeCapacityStatus#builder()}.
         *
         * When the {@link Consumer} completes, {@link ComputeCapacityStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #computeCapacityStatus(ComputeCapacityStatus)}.
         * 
         * @param computeCapacityStatus
         *        a consumer that will call methods on {@link ComputeCapacityStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeCapacityStatus(ComputeCapacityStatus)
         */
        default Builder computeCapacityStatus(Consumer<ComputeCapacityStatus.Builder> computeCapacityStatus) {
            return computeCapacityStatus(ComputeCapacityStatus.builder().applyMutation(computeCapacityStatus).build());
        }

        /**
         * <p>
         * The maximum time that a streaming session can run, in seconds. Specify a value between 600 and 57600.
         * </p>
         * 
         * @param maxUserDurationInSeconds
         *        The maximum time that a streaming session can run, in seconds. Specify a value between 600 and 57600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds);

        /**
         * <p>
         * The time after disconnection when a session is considered to have ended, in seconds. If a user who was
         * disconnected reconnects within this time interval, the user is connected to their previous session. Specify a
         * value between 60 and 57600.
         * </p>
         * 
         * @param disconnectTimeoutInSeconds
         *        The time after disconnection when a session is considered to have ended, in seconds. If a user who was
         *        disconnected reconnects within this time interval, the user is connected to their previous session.
         *        Specify a value between 60 and 57600.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds);

        /**
         * <p>
         * The current state for the fleet.
         * </p>
         * 
         * @param state
         *        The current state for the fleet.
         * @see FleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state for the fleet.
         * </p>
         * 
         * @param state
         *        The current state for the fleet.
         * @see FleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetState
         */
        Builder state(FleetState state);

        /**
         * <p>
         * The VPC configuration for the fleet.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the fleet.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The time the fleet was created.
         * </p>
         * 
         * @param createdTime
         *        The time the fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The fleet errors.
         * </p>
         * 
         * @param fleetErrors
         *        The fleet errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetErrors(Collection<FleetError> fleetErrors);

        /**
         * <p>
         * The fleet errors.
         * </p>
         * 
         * @param fleetErrors
         *        The fleet errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetErrors(FleetError... fleetErrors);

        /**
         * <p>
         * The fleet errors.
         * </p>
         * This is a convenience that creates an instance of the {@link List<FleetError>.Builder} avoiding the need to
         * create one manually via {@link List<FleetError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<FleetError>.Builder#build()} is called immediately and its
         * result is passed to {@link #fleetErrors(List<FleetError>)}.
         * 
         * @param fleetErrors
         *        a consumer that will call methods on {@link List<FleetError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetErrors(List<FleetError>)
         */
        Builder fleetErrors(Consumer<FleetError.Builder>... fleetErrors);

        /**
         * <p>
         * Indicates whether default internet access is enabled for the fleet.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Indicates whether default internet access is enabled for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * <p>
         * The information needed to join a Microsoft Active Directory domain.
         * </p>
         * 
         * @param domainJoinInfo
         *        The information needed to join a Microsoft Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainJoinInfo(DomainJoinInfo domainJoinInfo);

        /**
         * <p>
         * The information needed to join a Microsoft Active Directory domain.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainJoinInfo.Builder} avoiding the need to
         * create one manually via {@link DomainJoinInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainJoinInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #domainJoinInfo(DomainJoinInfo)}.
         * 
         * @param domainJoinInfo
         *        a consumer that will call methods on {@link DomainJoinInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainJoinInfo(DomainJoinInfo)
         */
        default Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return domainJoinInfo(DomainJoinInfo.builder().applyMutation(domainJoinInfo).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String displayName;

        private String description;

        private String imageName;

        private String imageArn;

        private String instanceType;

        private String fleetType;

        private ComputeCapacityStatus computeCapacityStatus;

        private Integer maxUserDurationInSeconds;

        private Integer disconnectTimeoutInSeconds;

        private String state;

        private VpcConfig vpcConfig;

        private Instant createdTime;

        private List<FleetError> fleetErrors = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableDefaultInternetAccess;

        private DomainJoinInfo domainJoinInfo;

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            arn(model.arn);
            name(model.name);
            displayName(model.displayName);
            description(model.description);
            imageName(model.imageName);
            imageArn(model.imageArn);
            instanceType(model.instanceType);
            fleetType(model.fleetType);
            computeCapacityStatus(model.computeCapacityStatus);
            maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            state(model.state);
            vpcConfig(model.vpcConfig);
            createdTime(model.createdTime);
            fleetErrors(model.fleetErrors);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            domainJoinInfo(model.domainJoinInfo);
        }

        public final String getArn() {
            return arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getImageName() {
            return imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageArn() {
            return imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getFleetTypeAsString() {
            return fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType.toString());
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final ComputeCapacityStatus.Builder getComputeCapacityStatus() {
            return computeCapacityStatus != null ? computeCapacityStatus.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus;
            return this;
        }

        public final void setComputeCapacityStatus(ComputeCapacityStatus.BuilderImpl computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus != null ? computeCapacityStatus.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FleetState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        public final Collection<FleetError.Builder> getFleetErrors() {
            return fleetErrors != null ? fleetErrors.stream().map(FleetError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder fleetErrors(Collection<FleetError> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copy(fleetErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(FleetError... fleetErrors) {
            fleetErrors(Arrays.asList(fleetErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(Consumer<FleetError.Builder>... fleetErrors) {
            fleetErrors(Stream.of(fleetErrors).map(c -> FleetError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setFleetErrors(Collection<FleetError.BuilderImpl> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copyFromBuilder(fleetErrors);
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return domainJoinInfo != null ? domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        @Override
        public Fleet build() {
            return new Fleet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
