/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyImageRequest extends AppStreamRequest implements
        ToCopyableBuilder<CopyImageRequest.Builder, CopyImageRequest> {
    private static final SdkField<String> SOURCE_IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyImageRequest::sourceImageName)).setter(setter(Builder::sourceImageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SourceImageName").build()).build();

    private static final SdkField<String> DESTINATION_IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyImageRequest::destinationImageName)).setter(setter(Builder::destinationImageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationImageName").build())
            .build();

    private static final SdkField<String> DESTINATION_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CopyImageRequest::destinationRegion)).setter(setter(Builder::destinationRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationRegion").build()).build();

    private static final SdkField<String> DESTINATION_IMAGE_DESCRIPTION_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .getter(getter(CopyImageRequest::destinationImageDescription))
            .setter(setter(Builder::destinationImageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationImageDescription")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_IMAGE_NAME_FIELD,
            DESTINATION_IMAGE_NAME_FIELD, DESTINATION_REGION_FIELD, DESTINATION_IMAGE_DESCRIPTION_FIELD));

    private final String sourceImageName;

    private final String destinationImageName;

    private final String destinationRegion;

    private final String destinationImageDescription;

    private CopyImageRequest(BuilderImpl builder) {
        super(builder);
        this.sourceImageName = builder.sourceImageName;
        this.destinationImageName = builder.destinationImageName;
        this.destinationRegion = builder.destinationRegion;
        this.destinationImageDescription = builder.destinationImageDescription;
    }

    /**
     * <p>
     * The name of the image to copy.
     * </p>
     * 
     * @return The name of the image to copy.
     */
    public String sourceImageName() {
        return sourceImageName;
    }

    /**
     * <p>
     * The name that the image will have when it is copied to the destination.
     * </p>
     * 
     * @return The name that the image will have when it is copied to the destination.
     */
    public String destinationImageName() {
        return destinationImageName;
    }

    /**
     * <p>
     * The destination region to which the image will be copied. This parameter is required, even if you are copying an
     * image within the same region.
     * </p>
     * 
     * @return The destination region to which the image will be copied. This parameter is required, even if you are
     *         copying an image within the same region.
     */
    public String destinationRegion() {
        return destinationRegion;
    }

    /**
     * <p>
     * The description that the image will have when it is copied to the destination.
     * </p>
     * 
     * @return The description that the image will have when it is copied to the destination.
     */
    public String destinationImageDescription() {
        return destinationImageDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourceImageName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationImageName());
        hashCode = 31 * hashCode + Objects.hashCode(destinationRegion());
        hashCode = 31 * hashCode + Objects.hashCode(destinationImageDescription());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageRequest)) {
            return false;
        }
        CopyImageRequest other = (CopyImageRequest) obj;
        return Objects.equals(sourceImageName(), other.sourceImageName())
                && Objects.equals(destinationImageName(), other.destinationImageName())
                && Objects.equals(destinationRegion(), other.destinationRegion())
                && Objects.equals(destinationImageDescription(), other.destinationImageDescription());
    }

    @Override
    public String toString() {
        return ToString.builder("CopyImageRequest").add("SourceImageName", sourceImageName())
                .add("DestinationImageName", destinationImageName()).add("DestinationRegion", destinationRegion())
                .add("DestinationImageDescription", destinationImageDescription()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "SourceImageName":
            return Optional.ofNullable(clazz.cast(sourceImageName()));
        case "DestinationImageName":
            return Optional.ofNullable(clazz.cast(destinationImageName()));
        case "DestinationRegion":
            return Optional.ofNullable(clazz.cast(destinationRegion()));
        case "DestinationImageDescription":
            return Optional.ofNullable(clazz.cast(destinationImageDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CopyImageRequest, T> g) {
        return obj -> g.apply((CopyImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyImageRequest> {
        /**
         * <p>
         * The name of the image to copy.
         * </p>
         * 
         * @param sourceImageName
         *        The name of the image to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceImageName(String sourceImageName);

        /**
         * <p>
         * The name that the image will have when it is copied to the destination.
         * </p>
         * 
         * @param destinationImageName
         *        The name that the image will have when it is copied to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationImageName(String destinationImageName);

        /**
         * <p>
         * The destination region to which the image will be copied. This parameter is required, even if you are copying
         * an image within the same region.
         * </p>
         * 
         * @param destinationRegion
         *        The destination region to which the image will be copied. This parameter is required, even if you are
         *        copying an image within the same region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationRegion(String destinationRegion);

        /**
         * <p>
         * The description that the image will have when it is copied to the destination.
         * </p>
         * 
         * @param destinationImageDescription
         *        The description that the image will have when it is copied to the destination.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationImageDescription(String destinationImageDescription);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String sourceImageName;

        private String destinationImageName;

        private String destinationRegion;

        private String destinationImageDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageRequest model) {
            super(model);
            sourceImageName(model.sourceImageName);
            destinationImageName(model.destinationImageName);
            destinationRegion(model.destinationRegion);
            destinationImageDescription(model.destinationImageDescription);
        }

        public final String getSourceImageName() {
            return sourceImageName;
        }

        @Override
        public final Builder sourceImageName(String sourceImageName) {
            this.sourceImageName = sourceImageName;
            return this;
        }

        public final void setSourceImageName(String sourceImageName) {
            this.sourceImageName = sourceImageName;
        }

        public final String getDestinationImageName() {
            return destinationImageName;
        }

        @Override
        public final Builder destinationImageName(String destinationImageName) {
            this.destinationImageName = destinationImageName;
            return this;
        }

        public final void setDestinationImageName(String destinationImageName) {
            this.destinationImageName = destinationImageName;
        }

        public final String getDestinationRegion() {
            return destinationRegion;
        }

        @Override
        public final Builder destinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
            return this;
        }

        public final void setDestinationRegion(String destinationRegion) {
            this.destinationRegion = destinationRegion;
        }

        public final String getDestinationImageDescription() {
            return destinationImageDescription;
        }

        @Override
        public final Builder destinationImageDescription(String destinationImageDescription) {
            this.destinationImageDescription = destinationImageDescription;
            return this;
        }

        public final void setDestinationImageDescription(String destinationImageDescription) {
            this.destinationImageDescription = destinationImageDescription;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyImageRequest build() {
            return new CopyImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
