/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateImageBuilderRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateImageBuilderRequest.Builder, CreateImageBuilderRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageBuilderRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageBuilderRequest::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageBuilderRequest::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageBuilderRequest::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageBuilderRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageBuilderRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .getter(getter(CreateImageBuilderRequest::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(CreateImageBuilderRequest::enableDefaultInternetAccess))
            .setter(setter(Builder::enableDefaultInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess")
                    .build()).build();

    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField
            .<DomainJoinInfo> builder(MarshallingType.SDK_POJO).getter(getter(CreateImageBuilderRequest::domainJoinInfo))
            .setter(setter(Builder::domainJoinInfo)).constructor(DomainJoinInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()).build();

    private static final SdkField<String> APPSTREAM_AGENT_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(CreateImageBuilderRequest::appstreamAgentVersion)).setter(setter(Builder::appstreamAgentVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppstreamAgentVersion").build())
            .build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(CreateImageBuilderRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_NAME_FIELD,
            IMAGE_ARN_FIELD, INSTANCE_TYPE_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, VPC_CONFIG_FIELD,
            ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, DOMAIN_JOIN_INFO_FIELD, APPSTREAM_AGENT_VERSION_FIELD, TAGS_FIELD));

    private final String name;

    private final String imageName;

    private final String imageArn;

    private final String instanceType;

    private final String description;

    private final String displayName;

    private final VpcConfig vpcConfig;

    private final Boolean enableDefaultInternetAccess;

    private final DomainJoinInfo domainJoinInfo;

    private final String appstreamAgentVersion;

    private final Map<String, String> tags;

    private CreateImageBuilderRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.instanceType = builder.instanceType;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.vpcConfig = builder.vpcConfig;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.appstreamAgentVersion = builder.appstreamAgentVersion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * A unique name for the image builder.
     * </p>
     * 
     * @return A unique name for the image builder.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The name of the image used to create the image builder.
     * </p>
     * 
     * @return The name of the image used to create the image builder.
     */
    public String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The ARN of the public, private, or shared image to use.
     * </p>
     * 
     * @return The ARN of the public, private, or shared image to use.
     */
    public String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The instance type to use when launching the image builder.
     * </p>
     * 
     * @return The instance type to use when launching the image builder.
     */
    public String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The description to display.
     * </p>
     * 
     * @return The description to display.
     */
    public String description() {
        return description;
    }

    /**
     * <p>
     * The image builder name to display.
     * </p>
     * 
     * @return The image builder name to display.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The VPC configuration for the image builder. You can specify only one subnet.
     * </p>
     * 
     * @return The VPC configuration for the image builder. You can specify only one subnet.
     */
    public VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * Enables or disables default internet access for the image builder.
     * </p>
     * 
     * @return Enables or disables default internet access for the image builder.
     */
    public Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * <p>
     * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active
     * Directory domain.
     * </p>
     * 
     * @return The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft
     *         Active Directory domain.
     */
    public DomainJoinInfo domainJoinInfo() {
        return domainJoinInfo;
    }

    /**
     * <p>
     * The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the AppStream
     * 2.0 agent, specify [LATEST].
     * </p>
     * 
     * @return The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the
     *         AppStream 2.0 agent, specify [LATEST].
     */
    public String appstreamAgentVersion() {
        return appstreamAgentVersion;
    }

    /**
     * <p>
     * The tags to associate with the image builder. A tag is a key-value pair (the value is optional). For example,
     * Environment=Test, or, if you do not specify a value, Environment=.
     * </p>
     * <p>
     * If you do not specify a value, we set the value to an empty string.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="http://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Developer Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The tags to associate with the image builder. A tag is a key-value pair (the value is optional). For
     *         example, Environment=Test, or, if you do not specify a value, Environment=. </p>
     *         <p>
     *         If you do not specify a value, we set the value to an empty string.
     *         </p>
     *         <p>
     *         For more information about tags, see <a
     *         href="http://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
     *         Resources</a> in the <i>Amazon AppStream 2.0 Developer Guide</i>.
     */
    public Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(appstreamAgentVersion());
        hashCode = 31 * hashCode + Objects.hashCode(tags());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateImageBuilderRequest)) {
            return false;
        }
        CreateImageBuilderRequest other = (CreateImageBuilderRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(imageName(), other.imageName())
                && Objects.equals(imageArn(), other.imageArn()) && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(description(), other.description()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(enableDefaultInternetAccess(), other.enableDefaultInternetAccess())
                && Objects.equals(domainJoinInfo(), other.domainJoinInfo())
                && Objects.equals(appstreamAgentVersion(), other.appstreamAgentVersion()) && Objects.equals(tags(), other.tags());
    }

    @Override
    public String toString() {
        return ToString.builder("CreateImageBuilderRequest").add("Name", name()).add("ImageName", imageName())
                .add("ImageArn", imageArn()).add("InstanceType", instanceType()).add("Description", description())
                .add("DisplayName", displayName()).add("VpcConfig", vpcConfig())
                .add("EnableDefaultInternetAccess", enableDefaultInternetAccess()).add("DomainJoinInfo", domainJoinInfo())
                .add("AppstreamAgentVersion", appstreamAgentVersion()).add("Tags", tags()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "EnableDefaultInternetAccess":
            return Optional.ofNullable(clazz.cast(enableDefaultInternetAccess()));
        case "DomainJoinInfo":
            return Optional.ofNullable(clazz.cast(domainJoinInfo()));
        case "AppstreamAgentVersion":
            return Optional.ofNullable(clazz.cast(appstreamAgentVersion()));
        case "Tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateImageBuilderRequest, T> g) {
        return obj -> g.apply((CreateImageBuilderRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateImageBuilderRequest> {
        /**
         * <p>
         * A unique name for the image builder.
         * </p>
         * 
         * @param name
         *        A unique name for the image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the image used to create the image builder.
         * </p>
         * 
         * @param imageName
         *        The name of the image used to create the image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The ARN of the public, private, or shared image to use.
         * </p>
         * 
         * @param imageArn
         *        The ARN of the public, private, or shared image to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The instance type to use when launching the image builder.
         * </p>
         * 
         * @param instanceType
         *        The instance type to use when launching the image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The description to display.
         * </p>
         * 
         * @param description
         *        The description to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The image builder name to display.
         * </p>
         * 
         * @param displayName
         *        The image builder name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The VPC configuration for the image builder. You can specify only one subnet.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the image builder. You can specify only one subnet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the image builder. You can specify only one subnet.
         * </p>
         * This is a convenience that creates an instance of the {@link VpcConfig.Builder} avoiding the need to create
         * one manually via {@link VpcConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * Enables or disables default internet access for the image builder.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Enables or disables default internet access for the image builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * <p>
         * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active
         * Directory domain.
         * </p>
         * 
         * @param domainJoinInfo
         *        The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft
         *        Active Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainJoinInfo(DomainJoinInfo domainJoinInfo);

        /**
         * <p>
         * The name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active
         * Directory domain.
         * </p>
         * This is a convenience that creates an instance of the {@link DomainJoinInfo.Builder} avoiding the need to
         * create one manually via {@link DomainJoinInfo#builder()}.
         *
         * When the {@link Consumer} completes, {@link DomainJoinInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #domainJoinInfo(DomainJoinInfo)}.
         * 
         * @param domainJoinInfo
         *        a consumer that will call methods on {@link DomainJoinInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainJoinInfo(DomainJoinInfo)
         */
        default Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return domainJoinInfo(DomainJoinInfo.builder().applyMutation(domainJoinInfo).build());
        }

        /**
         * <p>
         * The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the
         * AppStream 2.0 agent, specify [LATEST].
         * </p>
         * 
         * @param appstreamAgentVersion
         *        The version of the AppStream 2.0 agent to use for this image builder. To use the latest version of the
         *        AppStream 2.0 agent, specify [LATEST].
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appstreamAgentVersion(String appstreamAgentVersion);

        /**
         * <p>
         * The tags to associate with the image builder. A tag is a key-value pair (the value is optional). For example,
         * Environment=Test, or, if you do not specify a value, Environment=.
         * </p>
         * <p>
         * If you do not specify a value, we set the value to an empty string.
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="http://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         * Resources</a> in the <i>Amazon AppStream 2.0 Developer Guide</i>.
         * </p>
         * 
         * @param tags
         *        The tags to associate with the image builder. A tag is a key-value pair (the value is optional). For
         *        example, Environment=Test, or, if you do not specify a value, Environment=. </p>
         *        <p>
         *        If you do not specify a value, we set the value to an empty string.
         *        </p>
         *        <p>
         *        For more information about tags, see <a
         *        href="http://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         *        Resources</a> in the <i>Amazon AppStream 2.0 Developer Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String name;

        private String imageName;

        private String imageArn;

        private String instanceType;

        private String description;

        private String displayName;

        private VpcConfig vpcConfig;

        private Boolean enableDefaultInternetAccess;

        private DomainJoinInfo domainJoinInfo;

        private String appstreamAgentVersion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateImageBuilderRequest model) {
            super(model);
            name(model.name);
            imageName(model.imageName);
            imageArn(model.imageArn);
            instanceType(model.instanceType);
            description(model.description);
            displayName(model.displayName);
            vpcConfig(model.vpcConfig);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            domainJoinInfo(model.domainJoinInfo);
            appstreamAgentVersion(model.appstreamAgentVersion);
            tags(model.tags);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImageName() {
            return imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageArn() {
            return imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getDescription() {
            return description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return domainJoinInfo != null ? domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final String getAppstreamAgentVersion() {
            return appstreamAgentVersion;
        }

        @Override
        public final Builder appstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
            return this;
        }

        public final void setAppstreamAgentVersion(String appstreamAgentVersion) {
            this.appstreamAgentVersion = appstreamAgentVersion;
        }

        public final Map<String, String> getTags() {
            return tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateImageBuilderRequest build() {
            return new CreateImageBuilderRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
