/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the capacity status for a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeCapacityStatus implements SdkPojo, Serializable,
        ToCopyableBuilder<ComputeCapacityStatus.Builder, ComputeCapacityStatus> {
    private static final SdkField<Integer> DESIRED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Desired").getter(getter(ComputeCapacityStatus::desired)).setter(setter(Builder::desired))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Desired").build()).build();

    private static final SdkField<Integer> RUNNING_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Running").getter(getter(ComputeCapacityStatus::running)).setter(setter(Builder::running))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Running").build()).build();

    private static final SdkField<Integer> IN_USE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("InUse")
            .getter(getter(ComputeCapacityStatus::inUse)).setter(setter(Builder::inUse))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InUse").build()).build();

    private static final SdkField<Integer> AVAILABLE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("Available").getter(getter(ComputeCapacityStatus::available)).setter(setter(Builder::available))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Available").build()).build();

    private static final SdkField<Integer> DESIRED_USER_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("DesiredUserSessions").getter(getter(ComputeCapacityStatus::desiredUserSessions))
            .setter(setter(Builder::desiredUserSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredUserSessions").build())
            .build();

    private static final SdkField<Integer> AVAILABLE_USER_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("AvailableUserSessions").getter(getter(ComputeCapacityStatus::availableUserSessions))
            .setter(setter(Builder::availableUserSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AvailableUserSessions").build())
            .build();

    private static final SdkField<Integer> ACTIVE_USER_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActiveUserSessions").getter(getter(ComputeCapacityStatus::activeUserSessions))
            .setter(setter(Builder::activeUserSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActiveUserSessions").build())
            .build();

    private static final SdkField<Integer> ACTUAL_USER_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("ActualUserSessions").getter(getter(ComputeCapacityStatus::actualUserSessions))
            .setter(setter(Builder::actualUserSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ActualUserSessions").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_FIELD, RUNNING_FIELD,
            IN_USE_FIELD, AVAILABLE_FIELD, DESIRED_USER_SESSIONS_FIELD, AVAILABLE_USER_SESSIONS_FIELD,
            ACTIVE_USER_SESSIONS_FIELD, ACTUAL_USER_SESSIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer desired;

    private final Integer running;

    private final Integer inUse;

    private final Integer available;

    private final Integer desiredUserSessions;

    private final Integer availableUserSessions;

    private final Integer activeUserSessions;

    private final Integer actualUserSessions;

    private ComputeCapacityStatus(BuilderImpl builder) {
        this.desired = builder.desired;
        this.running = builder.running;
        this.inUse = builder.inUse;
        this.available = builder.available;
        this.desiredUserSessions = builder.desiredUserSessions;
        this.availableUserSessions = builder.availableUserSessions;
        this.activeUserSessions = builder.activeUserSessions;
        this.actualUserSessions = builder.actualUserSessions;
    }

    /**
     * <p>
     * The desired number of streaming instances.
     * </p>
     * 
     * @return The desired number of streaming instances.
     */
    public final Integer desired() {
        return desired;
    }

    /**
     * <p>
     * The total number of simultaneous streaming instances that are running.
     * </p>
     * 
     * @return The total number of simultaneous streaming instances that are running.
     */
    public final Integer running() {
        return running;
    }

    /**
     * <p>
     * The number of instances in use for streaming.
     * </p>
     * 
     * @return The number of instances in use for streaming.
     */
    public final Integer inUse() {
        return inUse;
    }

    /**
     * <p>
     * The number of currently available instances that can be used to stream sessions.
     * </p>
     * 
     * @return The number of currently available instances that can be used to stream sessions.
     */
    public final Integer available() {
        return available;
    }

    /**
     * <p>
     * The total number of sessions slots that are either running or pending. This represents the total number of
     * concurrent streaming sessions your fleet can support in a steady state.
     * </p>
     * <p>
     * DesiredUserSessionCapacity = ActualUserSessionCapacity + PendingUserSessionCapacity
     * </p>
     * <p>
     * This only applies to multi-session fleets.
     * </p>
     * 
     * @return The total number of sessions slots that are either running or pending. This represents the total number
     *         of concurrent streaming sessions your fleet can support in a steady state.</p>
     *         <p>
     *         DesiredUserSessionCapacity = ActualUserSessionCapacity + PendingUserSessionCapacity
     *         </p>
     *         <p>
     *         This only applies to multi-session fleets.
     */
    public final Integer desiredUserSessions() {
        return desiredUserSessions;
    }

    /**
     * <p>
     * The number of idle session slots currently available for user sessions.
     * </p>
     * <p>
     * AvailableUserSessionCapacity = ActualUserSessionCapacity - ActiveUserSessions
     * </p>
     * <p>
     * This only applies to multi-session fleets.
     * </p>
     * 
     * @return The number of idle session slots currently available for user sessions.</p>
     *         <p>
     *         AvailableUserSessionCapacity = ActualUserSessionCapacity - ActiveUserSessions
     *         </p>
     *         <p>
     *         This only applies to multi-session fleets.
     */
    public final Integer availableUserSessions() {
        return availableUserSessions;
    }

    /**
     * <p>
     * The number of user sessions currently being used for streaming sessions. This only applies to multi-session
     * fleets.
     * </p>
     * 
     * @return The number of user sessions currently being used for streaming sessions. This only applies to
     *         multi-session fleets.
     */
    public final Integer activeUserSessions() {
        return activeUserSessions;
    }

    /**
     * <p>
     * The total number of session slots that are available for streaming or are currently streaming.
     * </p>
     * <p>
     * ActualUserSessionCapacity = AvailableUserSessionCapacity + ActiveUserSessions
     * </p>
     * <p>
     * This only applies to multi-session fleets.
     * </p>
     * 
     * @return The total number of session slots that are available for streaming or are currently streaming.</p>
     *         <p>
     *         ActualUserSessionCapacity = AvailableUserSessionCapacity + ActiveUserSessions
     *         </p>
     *         <p>
     *         This only applies to multi-session fleets.
     */
    public final Integer actualUserSessions() {
        return actualUserSessions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desired());
        hashCode = 31 * hashCode + Objects.hashCode(running());
        hashCode = 31 * hashCode + Objects.hashCode(inUse());
        hashCode = 31 * hashCode + Objects.hashCode(available());
        hashCode = 31 * hashCode + Objects.hashCode(desiredUserSessions());
        hashCode = 31 * hashCode + Objects.hashCode(availableUserSessions());
        hashCode = 31 * hashCode + Objects.hashCode(activeUserSessions());
        hashCode = 31 * hashCode + Objects.hashCode(actualUserSessions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeCapacityStatus)) {
            return false;
        }
        ComputeCapacityStatus other = (ComputeCapacityStatus) obj;
        return Objects.equals(desired(), other.desired()) && Objects.equals(running(), other.running())
                && Objects.equals(inUse(), other.inUse()) && Objects.equals(available(), other.available())
                && Objects.equals(desiredUserSessions(), other.desiredUserSessions())
                && Objects.equals(availableUserSessions(), other.availableUserSessions())
                && Objects.equals(activeUserSessions(), other.activeUserSessions())
                && Objects.equals(actualUserSessions(), other.actualUserSessions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ComputeCapacityStatus").add("Desired", desired()).add("Running", running())
                .add("InUse", inUse()).add("Available", available()).add("DesiredUserSessions", desiredUserSessions())
                .add("AvailableUserSessions", availableUserSessions()).add("ActiveUserSessions", activeUserSessions())
                .add("ActualUserSessions", actualUserSessions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Desired":
            return Optional.ofNullable(clazz.cast(desired()));
        case "Running":
            return Optional.ofNullable(clazz.cast(running()));
        case "InUse":
            return Optional.ofNullable(clazz.cast(inUse()));
        case "Available":
            return Optional.ofNullable(clazz.cast(available()));
        case "DesiredUserSessions":
            return Optional.ofNullable(clazz.cast(desiredUserSessions()));
        case "AvailableUserSessions":
            return Optional.ofNullable(clazz.cast(availableUserSessions()));
        case "ActiveUserSessions":
            return Optional.ofNullable(clazz.cast(activeUserSessions()));
        case "ActualUserSessions":
            return Optional.ofNullable(clazz.cast(actualUserSessions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Desired", DESIRED_FIELD);
        map.put("Running", RUNNING_FIELD);
        map.put("InUse", IN_USE_FIELD);
        map.put("Available", AVAILABLE_FIELD);
        map.put("DesiredUserSessions", DESIRED_USER_SESSIONS_FIELD);
        map.put("AvailableUserSessions", AVAILABLE_USER_SESSIONS_FIELD);
        map.put("ActiveUserSessions", ACTIVE_USER_SESSIONS_FIELD);
        map.put("ActualUserSessions", ACTUAL_USER_SESSIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ComputeCapacityStatus, T> g) {
        return obj -> g.apply((ComputeCapacityStatus) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeCapacityStatus> {
        /**
         * <p>
         * The desired number of streaming instances.
         * </p>
         * 
         * @param desired
         *        The desired number of streaming instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desired(Integer desired);

        /**
         * <p>
         * The total number of simultaneous streaming instances that are running.
         * </p>
         * 
         * @param running
         *        The total number of simultaneous streaming instances that are running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder running(Integer running);

        /**
         * <p>
         * The number of instances in use for streaming.
         * </p>
         * 
         * @param inUse
         *        The number of instances in use for streaming.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inUse(Integer inUse);

        /**
         * <p>
         * The number of currently available instances that can be used to stream sessions.
         * </p>
         * 
         * @param available
         *        The number of currently available instances that can be used to stream sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder available(Integer available);

        /**
         * <p>
         * The total number of sessions slots that are either running or pending. This represents the total number of
         * concurrent streaming sessions your fleet can support in a steady state.
         * </p>
         * <p>
         * DesiredUserSessionCapacity = ActualUserSessionCapacity + PendingUserSessionCapacity
         * </p>
         * <p>
         * This only applies to multi-session fleets.
         * </p>
         * 
         * @param desiredUserSessions
         *        The total number of sessions slots that are either running or pending. This represents the total
         *        number of concurrent streaming sessions your fleet can support in a steady state.</p>
         *        <p>
         *        DesiredUserSessionCapacity = ActualUserSessionCapacity + PendingUserSessionCapacity
         *        </p>
         *        <p>
         *        This only applies to multi-session fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredUserSessions(Integer desiredUserSessions);

        /**
         * <p>
         * The number of idle session slots currently available for user sessions.
         * </p>
         * <p>
         * AvailableUserSessionCapacity = ActualUserSessionCapacity - ActiveUserSessions
         * </p>
         * <p>
         * This only applies to multi-session fleets.
         * </p>
         * 
         * @param availableUserSessions
         *        The number of idle session slots currently available for user sessions.</p>
         *        <p>
         *        AvailableUserSessionCapacity = ActualUserSessionCapacity - ActiveUserSessions
         *        </p>
         *        <p>
         *        This only applies to multi-session fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder availableUserSessions(Integer availableUserSessions);

        /**
         * <p>
         * The number of user sessions currently being used for streaming sessions. This only applies to multi-session
         * fleets.
         * </p>
         * 
         * @param activeUserSessions
         *        The number of user sessions currently being used for streaming sessions. This only applies to
         *        multi-session fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder activeUserSessions(Integer activeUserSessions);

        /**
         * <p>
         * The total number of session slots that are available for streaming or are currently streaming.
         * </p>
         * <p>
         * ActualUserSessionCapacity = AvailableUserSessionCapacity + ActiveUserSessions
         * </p>
         * <p>
         * This only applies to multi-session fleets.
         * </p>
         * 
         * @param actualUserSessions
         *        The total number of session slots that are available for streaming or are currently streaming.</p>
         *        <p>
         *        ActualUserSessionCapacity = AvailableUserSessionCapacity + ActiveUserSessions
         *        </p>
         *        <p>
         *        This only applies to multi-session fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder actualUserSessions(Integer actualUserSessions);
    }

    static final class BuilderImpl implements Builder {
        private Integer desired;

        private Integer running;

        private Integer inUse;

        private Integer available;

        private Integer desiredUserSessions;

        private Integer availableUserSessions;

        private Integer activeUserSessions;

        private Integer actualUserSessions;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeCapacityStatus model) {
            desired(model.desired);
            running(model.running);
            inUse(model.inUse);
            available(model.available);
            desiredUserSessions(model.desiredUserSessions);
            availableUserSessions(model.availableUserSessions);
            activeUserSessions(model.activeUserSessions);
            actualUserSessions(model.actualUserSessions);
        }

        public final Integer getDesired() {
            return desired;
        }

        public final void setDesired(Integer desired) {
            this.desired = desired;
        }

        @Override
        public final Builder desired(Integer desired) {
            this.desired = desired;
            return this;
        }

        public final Integer getRunning() {
            return running;
        }

        public final void setRunning(Integer running) {
            this.running = running;
        }

        @Override
        public final Builder running(Integer running) {
            this.running = running;
            return this;
        }

        public final Integer getInUse() {
            return inUse;
        }

        public final void setInUse(Integer inUse) {
            this.inUse = inUse;
        }

        @Override
        public final Builder inUse(Integer inUse) {
            this.inUse = inUse;
            return this;
        }

        public final Integer getAvailable() {
            return available;
        }

        public final void setAvailable(Integer available) {
            this.available = available;
        }

        @Override
        public final Builder available(Integer available) {
            this.available = available;
            return this;
        }

        public final Integer getDesiredUserSessions() {
            return desiredUserSessions;
        }

        public final void setDesiredUserSessions(Integer desiredUserSessions) {
            this.desiredUserSessions = desiredUserSessions;
        }

        @Override
        public final Builder desiredUserSessions(Integer desiredUserSessions) {
            this.desiredUserSessions = desiredUserSessions;
            return this;
        }

        public final Integer getAvailableUserSessions() {
            return availableUserSessions;
        }

        public final void setAvailableUserSessions(Integer availableUserSessions) {
            this.availableUserSessions = availableUserSessions;
        }

        @Override
        public final Builder availableUserSessions(Integer availableUserSessions) {
            this.availableUserSessions = availableUserSessions;
            return this;
        }

        public final Integer getActiveUserSessions() {
            return activeUserSessions;
        }

        public final void setActiveUserSessions(Integer activeUserSessions) {
            this.activeUserSessions = activeUserSessions;
        }

        @Override
        public final Builder activeUserSessions(Integer activeUserSessions) {
            this.activeUserSessions = activeUserSessions;
            return this;
        }

        public final Integer getActualUserSessions() {
            return actualUserSessions;
        }

        public final void setActualUserSessions(Integer actualUserSessions) {
            this.actualUserSessions = actualUserSessions;
        }

        @Override
        public final Builder actualUserSessions(Integer actualUserSessions) {
            this.actualUserSessions = actualUserSessions;
            return this;
        }

        @Override
        public ComputeCapacityStatus build() {
            return new ComputeCapacityStatus(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
