/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyImageResponse extends AppStreamResponse implements
        ToCopyableBuilder<CopyImageResponse.Builder, CopyImageResponse> {
    private static final SdkField<String> DESTINATION_IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DestinationImageName").getter(getter(CopyImageResponse::destinationImageName))
            .setter(setter(Builder::destinationImageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DestinationImageName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESTINATION_IMAGE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String destinationImageName;

    private CopyImageResponse(BuilderImpl builder) {
        super(builder);
        this.destinationImageName = builder.destinationImageName;
    }

    /**
     * <p>
     * The name of the destination image.
     * </p>
     * 
     * @return The name of the destination image.
     */
    public final String destinationImageName() {
        return destinationImageName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(destinationImageName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyImageResponse)) {
            return false;
        }
        CopyImageResponse other = (CopyImageResponse) obj;
        return Objects.equals(destinationImageName(), other.destinationImageName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyImageResponse").add("DestinationImageName", destinationImageName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DestinationImageName":
            return Optional.ofNullable(clazz.cast(destinationImageName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DestinationImageName", DESTINATION_IMAGE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyImageResponse, T> g) {
        return obj -> g.apply((CopyImageResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo, CopyableBuilder<Builder, CopyImageResponse> {
        /**
         * <p>
         * The name of the destination image.
         * </p>
         * 
         * @param destinationImageName
         *        The name of the destination image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationImageName(String destinationImageName);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private String destinationImageName;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyImageResponse model) {
            super(model);
            destinationImageName(model.destinationImageName);
        }

        public final String getDestinationImageName() {
            return destinationImageName;
        }

        public final void setDestinationImageName(String destinationImageName) {
            this.destinationImageName = destinationImageName;
        }

        @Override
        public final Builder destinationImageName(String destinationImageName) {
            this.destinationImageName = destinationImageName;
            return this;
        }

        @Override
        public CopyImageResponse build() {
            return new CopyImageResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
