/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateUpdatedImageRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateUpdatedImageRequest.Builder, CreateUpdatedImageRequest> {
    private static final SdkField<String> EXISTING_IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("existingImageName").getter(getter(CreateUpdatedImageRequest::existingImageName))
            .setter(setter(Builder::existingImageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("existingImageName").build()).build();

    private static final SdkField<String> NEW_IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newImageName").getter(getter(CreateUpdatedImageRequest::newImageName))
            .setter(setter(Builder::newImageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImageName").build()).build();

    private static final SdkField<String> NEW_IMAGE_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newImageDescription").getter(getter(CreateUpdatedImageRequest::newImageDescription))
            .setter(setter(Builder::newImageDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImageDescription").build())
            .build();

    private static final SdkField<String> NEW_IMAGE_DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("newImageDisplayName").getter(getter(CreateUpdatedImageRequest::newImageDisplayName))
            .setter(setter(Builder::newImageDisplayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImageDisplayName").build())
            .build();

    private static final SdkField<Map<String, String>> NEW_IMAGE_TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("newImageTags")
            .getter(getter(CreateUpdatedImageRequest::newImageTags))
            .setter(setter(Builder::newImageTags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("newImageTags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Boolean> DRY_RUN_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("dryRun").getter(getter(CreateUpdatedImageRequest::dryRun)).setter(setter(Builder::dryRun))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dryRun").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(EXISTING_IMAGE_NAME_FIELD, NEW_IMAGE_NAME_FIELD, NEW_IMAGE_DESCRIPTION_FIELD,
                    NEW_IMAGE_DISPLAY_NAME_FIELD, NEW_IMAGE_TAGS_FIELD, DRY_RUN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String existingImageName;

    private final String newImageName;

    private final String newImageDescription;

    private final String newImageDisplayName;

    private final Map<String, String> newImageTags;

    private final Boolean dryRun;

    private CreateUpdatedImageRequest(BuilderImpl builder) {
        super(builder);
        this.existingImageName = builder.existingImageName;
        this.newImageName = builder.newImageName;
        this.newImageDescription = builder.newImageDescription;
        this.newImageDisplayName = builder.newImageDisplayName;
        this.newImageTags = builder.newImageTags;
        this.dryRun = builder.dryRun;
    }

    /**
     * <p>
     * The name of the image to update.
     * </p>
     * 
     * @return The name of the image to update.
     */
    public final String existingImageName() {
        return existingImageName;
    }

    /**
     * <p>
     * The name of the new image. The name must be unique within the AWS account and Region.
     * </p>
     * 
     * @return The name of the new image. The name must be unique within the AWS account and Region.
     */
    public final String newImageName() {
        return newImageName;
    }

    /**
     * <p>
     * The description to display for the new image.
     * </p>
     * 
     * @return The description to display for the new image.
     */
    public final String newImageDescription() {
        return newImageDescription;
    }

    /**
     * <p>
     * The name to display for the new image.
     * </p>
     * 
     * @return The name to display for the new image.
     */
    public final String newImageDisplayName() {
        return newImageDisplayName;
    }

    /**
     * For responses, this returns true if the service returned a value for the NewImageTags property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasNewImageTags() {
        return newImageTags != null && !(newImageTags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example,
     * Environment=Test. If you do not specify a value, Environment=.
     * </p>
     * <p>
     * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following special
     * characters:
     * </p>
     * <p>
     * _ . : / = + \ - @
     * </p>
     * <p>
     * If you do not specify a value, the value is set to an empty string.
     * </p>
     * <p>
     * For more information about tags, see <a
     * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your Resources</a>
     * in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNewImageTags} method.
     * </p>
     * 
     * @return The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For
     *         example, Environment=Test. If you do not specify a value, Environment=. </p>
     *         <p>
     *         Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following
     *         special characters:
     *         </p>
     *         <p>
     *         _ . : / = + \ - @
     *         </p>
     *         <p>
     *         If you do not specify a value, the value is set to an empty string.
     *         </p>
     *         <p>
     *         For more information about tags, see <a
     *         href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
     *         Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public final Map<String, String> newImageTags() {
        return newImageTags;
    }

    /**
     * <p>
     * Indicates whether to display the status of image update availability before AppStream 2.0 initiates the process
     * of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays whether image
     * updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the process of
     * creating a new updated image without displaying whether image updates are available.
     * </p>
     * 
     * @return Indicates whether to display the status of image update availability before AppStream 2.0 initiates the
     *         process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0
     *         displays whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0
     *         initiates the process of creating a new updated image without displaying whether image updates are
     *         available.
     */
    public final Boolean dryRun() {
        return dryRun;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(existingImageName());
        hashCode = 31 * hashCode + Objects.hashCode(newImageName());
        hashCode = 31 * hashCode + Objects.hashCode(newImageDescription());
        hashCode = 31 * hashCode + Objects.hashCode(newImageDisplayName());
        hashCode = 31 * hashCode + Objects.hashCode(hasNewImageTags() ? newImageTags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(dryRun());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateUpdatedImageRequest)) {
            return false;
        }
        CreateUpdatedImageRequest other = (CreateUpdatedImageRequest) obj;
        return Objects.equals(existingImageName(), other.existingImageName())
                && Objects.equals(newImageName(), other.newImageName())
                && Objects.equals(newImageDescription(), other.newImageDescription())
                && Objects.equals(newImageDisplayName(), other.newImageDisplayName())
                && hasNewImageTags() == other.hasNewImageTags() && Objects.equals(newImageTags(), other.newImageTags())
                && Objects.equals(dryRun(), other.dryRun());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateUpdatedImageRequest").add("ExistingImageName", existingImageName())
                .add("NewImageName", newImageName()).add("NewImageDescription", newImageDescription())
                .add("NewImageDisplayName", newImageDisplayName()).add("NewImageTags", hasNewImageTags() ? newImageTags() : null)
                .add("DryRun", dryRun()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "existingImageName":
            return Optional.ofNullable(clazz.cast(existingImageName()));
        case "newImageName":
            return Optional.ofNullable(clazz.cast(newImageName()));
        case "newImageDescription":
            return Optional.ofNullable(clazz.cast(newImageDescription()));
        case "newImageDisplayName":
            return Optional.ofNullable(clazz.cast(newImageDisplayName()));
        case "newImageTags":
            return Optional.ofNullable(clazz.cast(newImageTags()));
        case "dryRun":
            return Optional.ofNullable(clazz.cast(dryRun()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("existingImageName", EXISTING_IMAGE_NAME_FIELD);
        map.put("newImageName", NEW_IMAGE_NAME_FIELD);
        map.put("newImageDescription", NEW_IMAGE_DESCRIPTION_FIELD);
        map.put("newImageDisplayName", NEW_IMAGE_DISPLAY_NAME_FIELD);
        map.put("newImageTags", NEW_IMAGE_TAGS_FIELD);
        map.put("dryRun", DRY_RUN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateUpdatedImageRequest, T> g) {
        return obj -> g.apply((CreateUpdatedImageRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateUpdatedImageRequest> {
        /**
         * <p>
         * The name of the image to update.
         * </p>
         * 
         * @param existingImageName
         *        The name of the image to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder existingImageName(String existingImageName);

        /**
         * <p>
         * The name of the new image. The name must be unique within the AWS account and Region.
         * </p>
         * 
         * @param newImageName
         *        The name of the new image. The name must be unique within the AWS account and Region.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newImageName(String newImageName);

        /**
         * <p>
         * The description to display for the new image.
         * </p>
         * 
         * @param newImageDescription
         *        The description to display for the new image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newImageDescription(String newImageDescription);

        /**
         * <p>
         * The name to display for the new image.
         * </p>
         * 
         * @param newImageDisplayName
         *        The name to display for the new image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newImageDisplayName(String newImageDisplayName);

        /**
         * <p>
         * The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For example,
         * Environment=Test. If you do not specify a value, Environment=.
         * </p>
         * <p>
         * Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following
         * special characters:
         * </p>
         * <p>
         * _ . : / = + \ - @
         * </p>
         * <p>
         * If you do not specify a value, the value is set to an empty string.
         * </p>
         * <p>
         * For more information about tags, see <a
         * href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         * Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param newImageTags
         *        The tags to associate with the new image. A tag is a key-value pair, and the value is optional. For
         *        example, Environment=Test. If you do not specify a value, Environment=. </p>
         *        <p>
         *        Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the
         *        following special characters:
         *        </p>
         *        <p>
         *        _ . : / = + \ - @
         *        </p>
         *        <p>
         *        If you do not specify a value, the value is set to an empty string.
         *        </p>
         *        <p>
         *        For more information about tags, see <a
         *        href="https://docs.aws.amazon.com/appstream2/latest/developerguide/tagging-basic.html">Tagging Your
         *        Resources</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder newImageTags(Map<String, String> newImageTags);

        /**
         * <p>
         * Indicates whether to display the status of image update availability before AppStream 2.0 initiates the
         * process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0 displays
         * whether image updates are available. If this value is set to <code>false</code>, AppStream 2.0 initiates the
         * process of creating a new updated image without displaying whether image updates are available.
         * </p>
         * 
         * @param dryRun
         *        Indicates whether to display the status of image update availability before AppStream 2.0 initiates
         *        the process of creating a new updated image. If this value is set to <code>true</code>, AppStream 2.0
         *        displays whether image updates are available. If this value is set to <code>false</code>, AppStream
         *        2.0 initiates the process of creating a new updated image without displaying whether image updates are
         *        available.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dryRun(Boolean dryRun);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String existingImageName;

        private String newImageName;

        private String newImageDescription;

        private String newImageDisplayName;

        private Map<String, String> newImageTags = DefaultSdkAutoConstructMap.getInstance();

        private Boolean dryRun;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateUpdatedImageRequest model) {
            super(model);
            existingImageName(model.existingImageName);
            newImageName(model.newImageName);
            newImageDescription(model.newImageDescription);
            newImageDisplayName(model.newImageDisplayName);
            newImageTags(model.newImageTags);
            dryRun(model.dryRun);
        }

        public final String getExistingImageName() {
            return existingImageName;
        }

        public final void setExistingImageName(String existingImageName) {
            this.existingImageName = existingImageName;
        }

        @Override
        public final Builder existingImageName(String existingImageName) {
            this.existingImageName = existingImageName;
            return this;
        }

        public final String getNewImageName() {
            return newImageName;
        }

        public final void setNewImageName(String newImageName) {
            this.newImageName = newImageName;
        }

        @Override
        public final Builder newImageName(String newImageName) {
            this.newImageName = newImageName;
            return this;
        }

        public final String getNewImageDescription() {
            return newImageDescription;
        }

        public final void setNewImageDescription(String newImageDescription) {
            this.newImageDescription = newImageDescription;
        }

        @Override
        public final Builder newImageDescription(String newImageDescription) {
            this.newImageDescription = newImageDescription;
            return this;
        }

        public final String getNewImageDisplayName() {
            return newImageDisplayName;
        }

        public final void setNewImageDisplayName(String newImageDisplayName) {
            this.newImageDisplayName = newImageDisplayName;
        }

        @Override
        public final Builder newImageDisplayName(String newImageDisplayName) {
            this.newImageDisplayName = newImageDisplayName;
            return this;
        }

        public final Map<String, String> getNewImageTags() {
            if (newImageTags instanceof SdkAutoConstructMap) {
                return null;
            }
            return newImageTags;
        }

        public final void setNewImageTags(Map<String, String> newImageTags) {
            this.newImageTags = TagsCopier.copy(newImageTags);
        }

        @Override
        public final Builder newImageTags(Map<String, String> newImageTags) {
            this.newImageTags = TagsCopier.copy(newImageTags);
            return this;
        }

        public final Boolean getDryRun() {
            return dryRun;
        }

        public final void setDryRun(Boolean dryRun) {
            this.dryRun = dryRun;
        }

        @Override
        public final Builder dryRun(Boolean dryRun) {
            this.dryRun = dryRun;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateUpdatedImageRequest build() {
            return new CreateUpdatedImageRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
