/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateApplicationFromEntitlementRequest extends AppStreamRequest implements
        ToCopyableBuilder<DisassociateApplicationFromEntitlementRequest.Builder, DisassociateApplicationFromEntitlementRequest> {
    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StackName").getter(getter(DisassociateApplicationFromEntitlementRequest::stackName))
            .setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> ENTITLEMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("EntitlementName").getter(getter(DisassociateApplicationFromEntitlementRequest::entitlementName))
            .setter(setter(Builder::entitlementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EntitlementName").build()).build();

    private static final SdkField<String> APPLICATION_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ApplicationIdentifier")
            .getter(getter(DisassociateApplicationFromEntitlementRequest::applicationIdentifier))
            .setter(setter(Builder::applicationIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationIdentifier").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STACK_NAME_FIELD,
            ENTITLEMENT_NAME_FIELD, APPLICATION_IDENTIFIER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String stackName;

    private final String entitlementName;

    private final String applicationIdentifier;

    private DisassociateApplicationFromEntitlementRequest(BuilderImpl builder) {
        super(builder);
        this.stackName = builder.stackName;
        this.entitlementName = builder.entitlementName;
        this.applicationIdentifier = builder.applicationIdentifier;
    }

    /**
     * <p>
     * The name of the stack with which the entitlement is associated.
     * </p>
     * 
     * @return The name of the stack with which the entitlement is associated.
     */
    public final String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name of the entitlement.
     * </p>
     * 
     * @return The name of the entitlement.
     */
    public final String entitlementName() {
        return entitlementName;
    }

    /**
     * <p>
     * The identifier of the application to remove from the entitlement.
     * </p>
     * 
     * @return The identifier of the application to remove from the entitlement.
     */
    public final String applicationIdentifier() {
        return applicationIdentifier;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(entitlementName());
        hashCode = 31 * hashCode + Objects.hashCode(applicationIdentifier());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateApplicationFromEntitlementRequest)) {
            return false;
        }
        DisassociateApplicationFromEntitlementRequest other = (DisassociateApplicationFromEntitlementRequest) obj;
        return Objects.equals(stackName(), other.stackName()) && Objects.equals(entitlementName(), other.entitlementName())
                && Objects.equals(applicationIdentifier(), other.applicationIdentifier());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateApplicationFromEntitlementRequest").add("StackName", stackName())
                .add("EntitlementName", entitlementName()).add("ApplicationIdentifier", applicationIdentifier()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "EntitlementName":
            return Optional.ofNullable(clazz.cast(entitlementName()));
        case "ApplicationIdentifier":
            return Optional.ofNullable(clazz.cast(applicationIdentifier()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("StackName", STACK_NAME_FIELD);
        map.put("EntitlementName", ENTITLEMENT_NAME_FIELD);
        map.put("ApplicationIdentifier", APPLICATION_IDENTIFIER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateApplicationFromEntitlementRequest, T> g) {
        return obj -> g.apply((DisassociateApplicationFromEntitlementRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateApplicationFromEntitlementRequest> {
        /**
         * <p>
         * The name of the stack with which the entitlement is associated.
         * </p>
         * 
         * @param stackName
         *        The name of the stack with which the entitlement is associated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name of the entitlement.
         * </p>
         * 
         * @param entitlementName
         *        The name of the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder entitlementName(String entitlementName);

        /**
         * <p>
         * The identifier of the application to remove from the entitlement.
         * </p>
         * 
         * @param applicationIdentifier
         *        The identifier of the application to remove from the entitlement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder applicationIdentifier(String applicationIdentifier);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String stackName;

        private String entitlementName;

        private String applicationIdentifier;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateApplicationFromEntitlementRequest model) {
            super(model);
            stackName(model.stackName);
            entitlementName(model.entitlementName);
            applicationIdentifier(model.applicationIdentifier);
        }

        public final String getStackName() {
            return stackName;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final String getEntitlementName() {
            return entitlementName;
        }

        public final void setEntitlementName(String entitlementName) {
            this.entitlementName = entitlementName;
        }

        @Override
        public final Builder entitlementName(String entitlementName) {
            this.entitlementName = entitlementName;
            return this;
        }

        public final String getApplicationIdentifier() {
            return applicationIdentifier;
        }

        public final void setApplicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
        }

        @Override
        public final Builder applicationIdentifier(String applicationIdentifier) {
            this.applicationIdentifier = applicationIdentifier;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateApplicationFromEntitlementRequest build() {
            return new DisassociateApplicationFromEntitlementRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
