/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an action and whether the action is enabled or disabled for users during their streaming sessions.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class UserSetting implements SdkPojo, Serializable, ToCopyableBuilder<UserSetting.Builder, UserSetting> {
    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Action")
            .getter(getter(UserSetting::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Action").build()).build();

    private static final SdkField<String> PERMISSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Permission").getter(getter(UserSetting::permissionAsString)).setter(setter(Builder::permission))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Permission").build()).build();

    private static final SdkField<Integer> MAXIMUM_LENGTH_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaximumLength").getter(getter(UserSetting::maximumLength)).setter(setter(Builder::maximumLength))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaximumLength").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_FIELD,
            PERMISSION_FIELD, MAXIMUM_LENGTH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String action;

    private final String permission;

    private final Integer maximumLength;

    private UserSetting(BuilderImpl builder) {
        this.action = builder.action;
        this.permission = builder.permission;
        this.maximumLength = builder.maximumLength;
    }

    /**
     * <p>
     * The action that is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that is enabled or disabled.
     * @see Action
     */
    public final Action action() {
        return Action.fromValue(action);
    }

    /**
     * <p>
     * The action that is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link Action#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action that is enabled or disabled.
     * @see Action
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * Indicates whether the action is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return Indicates whether the action is enabled or disabled.
     * @see Permission
     */
    public final Permission permission() {
        return Permission.fromValue(permission);
    }

    /**
     * <p>
     * Indicates whether the action is enabled or disabled.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #permission} will
     * return {@link Permission#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #permissionAsString}.
     * </p>
     * 
     * @return Indicates whether the action is enabled or disabled.
     * @see Permission
     */
    public final String permissionAsString() {
        return permission;
    }

    /**
     * <p>
     * Specifies the number of characters that can be copied by end users from the local device to the remote session,
     * and to the local device from the remote session.
     * </p>
     * <p>
     * This can be specified only for the <code>CLIPBOARD_COPY_FROM_LOCAL_DEVICE</code> and
     * <code>CLIPBOARD_COPY_TO_LOCAL_DEVICE</code> actions.
     * </p>
     * <p>
     * This defaults to 20,971,520 (20 MB) when unspecified and the permission is <code>ENABLED</code>. This can't be
     * specified when the permission is <code>DISABLED</code>.
     * </p>
     * <p>
     * The value can be between 1 and 20,971,520 (20 MB).
     * </p>
     * 
     * @return Specifies the number of characters that can be copied by end users from the local device to the remote
     *         session, and to the local device from the remote session.</p>
     *         <p>
     *         This can be specified only for the <code>CLIPBOARD_COPY_FROM_LOCAL_DEVICE</code> and
     *         <code>CLIPBOARD_COPY_TO_LOCAL_DEVICE</code> actions.
     *         </p>
     *         <p>
     *         This defaults to 20,971,520 (20 MB) when unspecified and the permission is <code>ENABLED</code>. This
     *         can't be specified when the permission is <code>DISABLED</code>.
     *         </p>
     *         <p>
     *         The value can be between 1 and 20,971,520 (20 MB).
     */
    public final Integer maximumLength() {
        return maximumLength;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(permissionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maximumLength());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UserSetting)) {
            return false;
        }
        UserSetting other = (UserSetting) obj;
        return Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(permissionAsString(), other.permissionAsString())
                && Objects.equals(maximumLength(), other.maximumLength());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UserSetting").add("Action", actionAsString()).add("Permission", permissionAsString())
                .add("MaximumLength", maximumLength()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "Permission":
            return Optional.ofNullable(clazz.cast(permissionAsString()));
        case "MaximumLength":
            return Optional.ofNullable(clazz.cast(maximumLength()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Action", ACTION_FIELD);
        map.put("Permission", PERMISSION_FIELD);
        map.put("MaximumLength", MAXIMUM_LENGTH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UserSetting, T> g) {
        return obj -> g.apply((UserSetting) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, UserSetting> {
        /**
         * <p>
         * The action that is enabled or disabled.
         * </p>
         * 
         * @param action
         *        The action that is enabled or disabled.
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(String action);

        /**
         * <p>
         * The action that is enabled or disabled.
         * </p>
         * 
         * @param action
         *        The action that is enabled or disabled.
         * @see Action
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Action
         */
        Builder action(Action action);

        /**
         * <p>
         * Indicates whether the action is enabled or disabled.
         * </p>
         * 
         * @param permission
         *        Indicates whether the action is enabled or disabled.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(String permission);

        /**
         * <p>
         * Indicates whether the action is enabled or disabled.
         * </p>
         * 
         * @param permission
         *        Indicates whether the action is enabled or disabled.
         * @see Permission
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Permission
         */
        Builder permission(Permission permission);

        /**
         * <p>
         * Specifies the number of characters that can be copied by end users from the local device to the remote
         * session, and to the local device from the remote session.
         * </p>
         * <p>
         * This can be specified only for the <code>CLIPBOARD_COPY_FROM_LOCAL_DEVICE</code> and
         * <code>CLIPBOARD_COPY_TO_LOCAL_DEVICE</code> actions.
         * </p>
         * <p>
         * This defaults to 20,971,520 (20 MB) when unspecified and the permission is <code>ENABLED</code>. This can't
         * be specified when the permission is <code>DISABLED</code>.
         * </p>
         * <p>
         * The value can be between 1 and 20,971,520 (20 MB).
         * </p>
         * 
         * @param maximumLength
         *        Specifies the number of characters that can be copied by end users from the local device to the remote
         *        session, and to the local device from the remote session.</p>
         *        <p>
         *        This can be specified only for the <code>CLIPBOARD_COPY_FROM_LOCAL_DEVICE</code> and
         *        <code>CLIPBOARD_COPY_TO_LOCAL_DEVICE</code> actions.
         *        </p>
         *        <p>
         *        This defaults to 20,971,520 (20 MB) when unspecified and the permission is <code>ENABLED</code>. This
         *        can't be specified when the permission is <code>DISABLED</code>.
         *        </p>
         *        <p>
         *        The value can be between 1 and 20,971,520 (20 MB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maximumLength(Integer maximumLength);
    }

    static final class BuilderImpl implements Builder {
        private String action;

        private String permission;

        private Integer maximumLength;

        private BuilderImpl() {
        }

        private BuilderImpl(UserSetting model) {
            action(model.action);
            permission(model.permission);
            maximumLength(model.maximumLength);
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(Action action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getPermission() {
            return permission;
        }

        public final void setPermission(String permission) {
            this.permission = permission;
        }

        @Override
        public final Builder permission(String permission) {
            this.permission = permission;
            return this;
        }

        @Override
        public final Builder permission(Permission permission) {
            this.permission(permission == null ? null : permission.toString());
            return this;
        }

        public final Integer getMaximumLength() {
            return maximumLength;
        }

        public final void setMaximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
        }

        @Override
        public final Builder maximumLength(Integer maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        @Override
        public UserSetting build() {
            return new UserSetting(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
