/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DescribeUserStackAssociationsResponse extends AppStreamResponse implements
        ToCopyableBuilder<DescribeUserStackAssociationsResponse.Builder, DescribeUserStackAssociationsResponse> {
    private static final SdkField<List<UserStackAssociation>> USER_STACK_ASSOCIATIONS_FIELD = SdkField
            .<List<UserStackAssociation>> builder(MarshallingType.LIST)
            .memberName("UserStackAssociations")
            .getter(getter(DescribeUserStackAssociationsResponse::userStackAssociations))
            .setter(setter(Builder::userStackAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserStackAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserStackAssociation> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserStackAssociation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("NextToken").getter(getter(DescribeUserStackAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(USER_STACK_ASSOCIATIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<UserStackAssociation> userStackAssociations;

    private final String nextToken;

    private DescribeUserStackAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.userStackAssociations = builder.userStackAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the UserStackAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUserStackAssociations() {
        return userStackAssociations != null && !(userStackAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The UserStackAssociation objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUserStackAssociations} method.
     * </p>
     * 
     * @return The UserStackAssociation objects.
     */
    public final List<UserStackAssociation> userStackAssociations() {
        return userStackAssociations;
    }

    /**
     * <p>
     * The pagination token to use to retrieve the next page of results for this operation. If there are no more pages,
     * this value is null.
     * </p>
     * 
     * @return The pagination token to use to retrieve the next page of results for this operation. If there are no more
     *         pages, this value is null.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasUserStackAssociations() ? userStackAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeUserStackAssociationsResponse)) {
            return false;
        }
        DescribeUserStackAssociationsResponse other = (DescribeUserStackAssociationsResponse) obj;
        return hasUserStackAssociations() == other.hasUserStackAssociations()
                && Objects.equals(userStackAssociations(), other.userStackAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DescribeUserStackAssociationsResponse")
                .add("UserStackAssociations", hasUserStackAssociations() ? userStackAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "UserStackAssociations":
            return Optional.ofNullable(clazz.cast(userStackAssociations()));
        case "NextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("UserStackAssociations", USER_STACK_ASSOCIATIONS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeUserStackAssociationsResponse, T> g) {
        return obj -> g.apply((DescribeUserStackAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, DescribeUserStackAssociationsResponse> {
        /**
         * <p>
         * The UserStackAssociation objects.
         * </p>
         * 
         * @param userStackAssociations
         *        The UserStackAssociation objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userStackAssociations(Collection<UserStackAssociation> userStackAssociations);

        /**
         * <p>
         * The UserStackAssociation objects.
         * </p>
         * 
         * @param userStackAssociations
         *        The UserStackAssociation objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userStackAssociations(UserStackAssociation... userStackAssociations);

        /**
         * <p>
         * The UserStackAssociation objects.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appstream.model.UserStackAssociation.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.appstream.model.UserStackAssociation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appstream.model.UserStackAssociation.Builder#build()} is called
         * immediately and its result is passed to {@link #userStackAssociations(List<UserStackAssociation>)}.
         * 
         * @param userStackAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appstream.model.UserStackAssociation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userStackAssociations(java.util.Collection<UserStackAssociation>)
         */
        Builder userStackAssociations(Consumer<UserStackAssociation.Builder>... userStackAssociations);

        /**
         * <p>
         * The pagination token to use to retrieve the next page of results for this operation. If there are no more
         * pages, this value is null.
         * </p>
         * 
         * @param nextToken
         *        The pagination token to use to retrieve the next page of results for this operation. If there are no
         *        more pages, this value is null.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private List<UserStackAssociation> userStackAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeUserStackAssociationsResponse model) {
            super(model);
            userStackAssociations(model.userStackAssociations);
            nextToken(model.nextToken);
        }

        public final List<UserStackAssociation.Builder> getUserStackAssociations() {
            List<UserStackAssociation.Builder> result = UserStackAssociationListCopier.copyToBuilder(this.userStackAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setUserStackAssociations(Collection<UserStackAssociation.BuilderImpl> userStackAssociations) {
            this.userStackAssociations = UserStackAssociationListCopier.copyFromBuilder(userStackAssociations);
        }

        @Override
        public final Builder userStackAssociations(Collection<UserStackAssociation> userStackAssociations) {
            this.userStackAssociations = UserStackAssociationListCopier.copy(userStackAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userStackAssociations(UserStackAssociation... userStackAssociations) {
            userStackAssociations(Arrays.asList(userStackAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userStackAssociations(Consumer<UserStackAssociation.Builder>... userStackAssociations) {
            userStackAssociations(Stream.of(userStackAssociations)
                    .map(c -> UserStackAssociation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeUserStackAssociationsResponse build() {
            return new DescribeUserStackAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
