/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the
 * Windows native client.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StreamingExperienceSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<StreamingExperienceSettings.Builder, StreamingExperienceSettings> {
    private static final SdkField<String> PREFERRED_PROTOCOL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("PreferredProtocol").getter(getter(StreamingExperienceSettings::preferredProtocolAsString))
            .setter(setter(Builder::preferredProtocol))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PreferredProtocol").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PREFERRED_PROTOCOL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String preferredProtocol;

    private StreamingExperienceSettings(BuilderImpl builder) {
        this.preferredProtocol = builder.preferredProtocol;
    }

    /**
     * <p>
     * The preferred protocol that you want to use while streaming your application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preferredProtocol}
     * will return {@link PreferredProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preferredProtocolAsString}.
     * </p>
     * 
     * @return The preferred protocol that you want to use while streaming your application.
     * @see PreferredProtocol
     */
    public final PreferredProtocol preferredProtocol() {
        return PreferredProtocol.fromValue(preferredProtocol);
    }

    /**
     * <p>
     * The preferred protocol that you want to use while streaming your application.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #preferredProtocol}
     * will return {@link PreferredProtocol#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #preferredProtocolAsString}.
     * </p>
     * 
     * @return The preferred protocol that you want to use while streaming your application.
     * @see PreferredProtocol
     */
    public final String preferredProtocolAsString() {
        return preferredProtocol;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(preferredProtocolAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StreamingExperienceSettings)) {
            return false;
        }
        StreamingExperienceSettings other = (StreamingExperienceSettings) obj;
        return Objects.equals(preferredProtocolAsString(), other.preferredProtocolAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StreamingExperienceSettings").add("PreferredProtocol", preferredProtocolAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "PreferredProtocol":
            return Optional.ofNullable(clazz.cast(preferredProtocolAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("PreferredProtocol", PREFERRED_PROTOCOL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StreamingExperienceSettings, T> g) {
        return obj -> g.apply((StreamingExperienceSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StreamingExperienceSettings> {
        /**
         * <p>
         * The preferred protocol that you want to use while streaming your application.
         * </p>
         * 
         * @param preferredProtocol
         *        The preferred protocol that you want to use while streaming your application.
         * @see PreferredProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreferredProtocol
         */
        Builder preferredProtocol(String preferredProtocol);

        /**
         * <p>
         * The preferred protocol that you want to use while streaming your application.
         * </p>
         * 
         * @param preferredProtocol
         *        The preferred protocol that you want to use while streaming your application.
         * @see PreferredProtocol
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PreferredProtocol
         */
        Builder preferredProtocol(PreferredProtocol preferredProtocol);
    }

    static final class BuilderImpl implements Builder {
        private String preferredProtocol;

        private BuilderImpl() {
        }

        private BuilderImpl(StreamingExperienceSettings model) {
            preferredProtocol(model.preferredProtocol);
        }

        public final String getPreferredProtocol() {
            return preferredProtocol;
        }

        public final void setPreferredProtocol(String preferredProtocol) {
            this.preferredProtocol = preferredProtocol;
        }

        @Override
        public final Builder preferredProtocol(String preferredProtocol) {
            this.preferredProtocol = preferredProtocol;
            return this;
        }

        @Override
        public final Builder preferredProtocol(PreferredProtocol preferredProtocol) {
            this.preferredProtocol(preferredProtocol == null ? null : preferredProtocol.toString());
            return this;
        }

        @Override
        public StreamingExperienceSettings build() {
            return new StreamingExperienceSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
