/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The website links that display in the catalog page footer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ThemeFooterLink implements SdkPojo, Serializable, ToCopyableBuilder<ThemeFooterLink.Builder, ThemeFooterLink> {
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(ThemeFooterLink::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> FOOTER_LINK_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FooterLinkURL").getter(getter(ThemeFooterLink::footerLinkURL)).setter(setter(Builder::footerLinkURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FooterLinkURL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DISPLAY_NAME_FIELD,
            FOOTER_LINK_URL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String displayName;

    private final String footerLinkURL;

    private ThemeFooterLink(BuilderImpl builder) {
        this.displayName = builder.displayName;
        this.footerLinkURL = builder.footerLinkURL;
    }

    /**
     * <p>
     * The name of the websites that display in the catalog page footer.
     * </p>
     * 
     * @return The name of the websites that display in the catalog page footer.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The URL of the websites that display in the catalog page footer.
     * </p>
     * 
     * @return The URL of the websites that display in the catalog page footer.
     */
    public final String footerLinkURL() {
        return footerLinkURL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(footerLinkURL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ThemeFooterLink)) {
            return false;
        }
        ThemeFooterLink other = (ThemeFooterLink) obj;
        return Objects.equals(displayName(), other.displayName()) && Objects.equals(footerLinkURL(), other.footerLinkURL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ThemeFooterLink").add("DisplayName", displayName()).add("FooterLinkURL", footerLinkURL())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "FooterLinkURL":
            return Optional.ofNullable(clazz.cast(footerLinkURL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("FooterLinkURL", FOOTER_LINK_URL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ThemeFooterLink, T> g) {
        return obj -> g.apply((ThemeFooterLink) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ThemeFooterLink> {
        /**
         * <p>
         * The name of the websites that display in the catalog page footer.
         * </p>
         * 
         * @param displayName
         *        The name of the websites that display in the catalog page footer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The URL of the websites that display in the catalog page footer.
         * </p>
         * 
         * @param footerLinkURL
         *        The URL of the websites that display in the catalog page footer.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder footerLinkURL(String footerLinkURL);
    }

    static final class BuilderImpl implements Builder {
        private String displayName;

        private String footerLinkURL;

        private BuilderImpl() {
        }

        private BuilderImpl(ThemeFooterLink model) {
            displayName(model.displayName);
            footerLinkURL(model.footerLinkURL);
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getFooterLinkURL() {
            return footerLinkURL;
        }

        public final void setFooterLinkURL(String footerLinkURL) {
            this.footerLinkURL = footerLinkURL;
        }

        @Override
        public final Builder footerLinkURL(String footerLinkURL) {
            this.footerLinkURL = footerLinkURL;
            return this;
        }

        @Override
        public ThemeFooterLink build() {
            return new ThemeFooterLink(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
