/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateAppBlockBuilderStreamingUrlRequest extends AppStreamRequest implements
        ToCopyableBuilder<CreateAppBlockBuilderStreamingUrlRequest.Builder, CreateAppBlockBuilderStreamingUrlRequest> {
    private static final SdkField<String> APP_BLOCK_BUILDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppBlockBuilderName").getter(getter(CreateAppBlockBuilderStreamingUrlRequest::appBlockBuilderName))
            .setter(setter(Builder::appBlockBuilderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockBuilderName").build())
            .build();

    private static final SdkField<Long> VALIDITY_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("Validity")
            .getter(getter(CreateAppBlockBuilderStreamingUrlRequest::validity)).setter(setter(Builder::validity))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Validity").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BLOCK_BUILDER_NAME_FIELD,
            VALIDITY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appBlockBuilderName;

    private final Long validity;

    private CreateAppBlockBuilderStreamingUrlRequest(BuilderImpl builder) {
        super(builder);
        this.appBlockBuilderName = builder.appBlockBuilderName;
        this.validity = builder.validity;
    }

    /**
     * <p>
     * The name of the app block builder.
     * </p>
     * 
     * @return The name of the app block builder.
     */
    public final String appBlockBuilderName() {
        return appBlockBuilderName;
    }

    /**
     * <p>
     * The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The
     * default is 3600 seconds.
     * </p>
     * 
     * @return The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds.
     *         The default is 3600 seconds.
     */
    public final Long validity() {
        return validity;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBlockBuilderName());
        hashCode = 31 * hashCode + Objects.hashCode(validity());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateAppBlockBuilderStreamingUrlRequest)) {
            return false;
        }
        CreateAppBlockBuilderStreamingUrlRequest other = (CreateAppBlockBuilderStreamingUrlRequest) obj;
        return Objects.equals(appBlockBuilderName(), other.appBlockBuilderName()) && Objects.equals(validity(), other.validity());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateAppBlockBuilderStreamingUrlRequest").add("AppBlockBuilderName", appBlockBuilderName())
                .add("Validity", validity()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppBlockBuilderName":
            return Optional.ofNullable(clazz.cast(appBlockBuilderName()));
        case "Validity":
            return Optional.ofNullable(clazz.cast(validity()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppBlockBuilderName", APP_BLOCK_BUILDER_NAME_FIELD);
        map.put("Validity", VALIDITY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateAppBlockBuilderStreamingUrlRequest, T> g) {
        return obj -> g.apply((CreateAppBlockBuilderStreamingUrlRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppStreamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, CreateAppBlockBuilderStreamingUrlRequest> {
        /**
         * <p>
         * The name of the app block builder.
         * </p>
         * 
         * @param appBlockBuilderName
         *        The name of the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBlockBuilderName(String appBlockBuilderName);

        /**
         * <p>
         * The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800 seconds. The
         * default is 3600 seconds.
         * </p>
         * 
         * @param validity
         *        The time that the streaming URL will be valid, in seconds. Specify a value between 1 and 604800
         *        seconds. The default is 3600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder validity(Long validity);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String appBlockBuilderName;

        private Long validity;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateAppBlockBuilderStreamingUrlRequest model) {
            super(model);
            appBlockBuilderName(model.appBlockBuilderName);
            validity(model.validity);
        }

        public final String getAppBlockBuilderName() {
            return appBlockBuilderName;
        }

        public final void setAppBlockBuilderName(String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
        }

        @Override
        public final Builder appBlockBuilderName(String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
            return this;
        }

        public final Long getValidity() {
            return validity;
        }

        public final void setValidity(Long validity) {
            this.validity = validity;
        }

        @Override
        public final Builder validity(Long validity) {
            this.validity = validity;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateAppBlockBuilderStreamingUrlRequest build() {
            return new CreateAppBlockBuilderStreamingUrlRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
