/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DisassociateAppBlockBuilderAppBlockRequest extends AppStreamRequest implements
        ToCopyableBuilder<DisassociateAppBlockBuilderAppBlockRequest.Builder, DisassociateAppBlockBuilderAppBlockRequest> {
    private static final SdkField<String> APP_BLOCK_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppBlockArn").getter(getter(DisassociateAppBlockBuilderAppBlockRequest::appBlockArn))
            .setter(setter(Builder::appBlockArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockArn").build()).build();

    private static final SdkField<String> APP_BLOCK_BUILDER_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("AppBlockBuilderName").getter(getter(DisassociateAppBlockBuilderAppBlockRequest::appBlockBuilderName))
            .setter(setter(Builder::appBlockBuilderName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockBuilderName").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BLOCK_ARN_FIELD,
            APP_BLOCK_BUILDER_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String appBlockArn;

    private final String appBlockBuilderName;

    private DisassociateAppBlockBuilderAppBlockRequest(BuilderImpl builder) {
        super(builder);
        this.appBlockArn = builder.appBlockArn;
        this.appBlockBuilderName = builder.appBlockBuilderName;
    }

    /**
     * <p>
     * The ARN of the app block.
     * </p>
     * 
     * @return The ARN of the app block.
     */
    public final String appBlockArn() {
        return appBlockArn;
    }

    /**
     * <p>
     * The name of the app block builder.
     * </p>
     * 
     * @return The name of the app block builder.
     */
    public final String appBlockBuilderName() {
        return appBlockBuilderName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBlockArn());
        hashCode = 31 * hashCode + Objects.hashCode(appBlockBuilderName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DisassociateAppBlockBuilderAppBlockRequest)) {
            return false;
        }
        DisassociateAppBlockBuilderAppBlockRequest other = (DisassociateAppBlockBuilderAppBlockRequest) obj;
        return Objects.equals(appBlockArn(), other.appBlockArn())
                && Objects.equals(appBlockBuilderName(), other.appBlockBuilderName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DisassociateAppBlockBuilderAppBlockRequest").add("AppBlockArn", appBlockArn())
                .add("AppBlockBuilderName", appBlockBuilderName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppBlockArn":
            return Optional.ofNullable(clazz.cast(appBlockArn()));
        case "AppBlockBuilderName":
            return Optional.ofNullable(clazz.cast(appBlockBuilderName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppBlockArn", APP_BLOCK_ARN_FIELD);
        map.put("AppBlockBuilderName", APP_BLOCK_BUILDER_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DisassociateAppBlockBuilderAppBlockRequest, T> g) {
        return obj -> g.apply((DisassociateAppBlockBuilderAppBlockRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppStreamRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, DisassociateAppBlockBuilderAppBlockRequest> {
        /**
         * <p>
         * The ARN of the app block.
         * </p>
         * 
         * @param appBlockArn
         *        The ARN of the app block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBlockArn(String appBlockArn);

        /**
         * <p>
         * The name of the app block builder.
         * </p>
         * 
         * @param appBlockBuilderName
         *        The name of the app block builder.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBlockBuilderName(String appBlockBuilderName);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppStreamRequest.BuilderImpl implements Builder {
        private String appBlockArn;

        private String appBlockBuilderName;

        private BuilderImpl() {
        }

        private BuilderImpl(DisassociateAppBlockBuilderAppBlockRequest model) {
            super(model);
            appBlockArn(model.appBlockArn);
            appBlockBuilderName(model.appBlockBuilderName);
        }

        public final String getAppBlockArn() {
            return appBlockArn;
        }

        public final void setAppBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
        }

        @Override
        public final Builder appBlockArn(String appBlockArn) {
            this.appBlockArn = appBlockArn;
            return this;
        }

        public final String getAppBlockBuilderName() {
            return appBlockBuilderName;
        }

        public final void setAppBlockBuilderName(String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
        }

        @Override
        public final Builder appBlockBuilderName(String appBlockBuilderName) {
            this.appBlockBuilderName = appBlockBuilderName;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DisassociateAppBlockBuilderAppBlockRequest build() {
            return new DisassociateAppBlockBuilderAppBlockRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
