/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Fleet implements SdkPojo, Serializable, ToCopyableBuilder<Fleet.Builder, Fleet> {
    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Arn")
            .getter(getter(Fleet::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Arn").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("Name")
            .getter(getter(Fleet::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("DisplayName").getter(getter(Fleet::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Description").getter(getter(Fleet::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()).build();

    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageName").getter(getter(Fleet::imageName)).setter(setter(Builder::imageName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()).build();

    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ImageArn").getter(getter(Fleet::imageArn)).setter(setter(Builder::imageArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()).build();

    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("InstanceType").getter(getter(Fleet::instanceType)).setter(setter(Builder::instanceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()).build();

    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("FleetType").getter(getter(Fleet::fleetTypeAsString)).setter(setter(Builder::fleetType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()).build();

    private static final SdkField<ComputeCapacityStatus> COMPUTE_CAPACITY_STATUS_FIELD = SdkField
            .<ComputeCapacityStatus> builder(MarshallingType.SDK_POJO).memberName("ComputeCapacityStatus")
            .getter(getter(Fleet::computeCapacityStatus)).setter(setter(Builder::computeCapacityStatus))
            .constructor(ComputeCapacityStatus::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeCapacityStatus").build())
            .build();

    private static final SdkField<Integer> MAX_USER_DURATION_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER).memberName("MaxUserDurationInSeconds")
            .getter(getter(Fleet::maxUserDurationInSeconds)).setter(setter(Builder::maxUserDurationInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUserDurationInSeconds").build())
            .build();

    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("DisconnectTimeoutInSeconds")
            .getter(getter(Fleet::disconnectTimeoutInSeconds))
            .setter(setter(Builder::disconnectTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimeoutInSeconds").build())
            .build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("State")
            .getter(getter(Fleet::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.<VpcConfig> builder(MarshallingType.SDK_POJO)
            .memberName("VpcConfig").getter(getter(Fleet::vpcConfig)).setter(setter(Builder::vpcConfig))
            .constructor(VpcConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()).build();

    private static final SdkField<Instant> CREATED_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("CreatedTime").getter(getter(Fleet::createdTime)).setter(setter(Builder::createdTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("CreatedTime").build()).build();

    private static final SdkField<List<FleetError>> FLEET_ERRORS_FIELD = SdkField
            .<List<FleetError>> builder(MarshallingType.LIST)
            .memberName("FleetErrors")
            .getter(getter(Fleet::fleetErrors))
            .setter(setter(Builder::fleetErrors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetErrors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetError> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField
            .<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("EnableDefaultInternetAccess")
            .getter(getter(Fleet::enableDefaultInternetAccess))
            .setter(setter(Builder::enableDefaultInternetAccess))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess")
                    .build()).build();

    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField
            .<DomainJoinInfo> builder(MarshallingType.SDK_POJO).memberName("DomainJoinInfo")
            .getter(getter(Fleet::domainJoinInfo)).setter(setter(Builder::domainJoinInfo)).constructor(DomainJoinInfo::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()).build();

    private static final SdkField<Integer> IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("IdleDisconnectTimeoutInSeconds")
            .getter(getter(Fleet::idleDisconnectTimeoutInSeconds))
            .setter(setter(Builder::idleDisconnectTimeoutInSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleDisconnectTimeoutInSeconds")
                    .build()).build();

    private static final SdkField<String> IAM_ROLE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("IamRoleArn").getter(getter(Fleet::iamRoleArn)).setter(setter(Builder::iamRoleArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IamRoleArn").build()).build();

    private static final SdkField<String> STREAM_VIEW_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("StreamView").getter(getter(Fleet::streamViewAsString)).setter(setter(Builder::streamView))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StreamView").build()).build();

    private static final SdkField<String> PLATFORM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("Platform").getter(getter(Fleet::platformAsString)).setter(setter(Builder::platform))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Platform").build()).build();

    private static final SdkField<Integer> MAX_CONCURRENT_SESSIONS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxConcurrentSessions").getter(getter(Fleet::maxConcurrentSessions))
            .setter(setter(Builder::maxConcurrentSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxConcurrentSessions").build())
            .build();

    private static final SdkField<List<String>> USB_DEVICE_FILTER_STRINGS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("UsbDeviceFilterStrings")
            .getter(getter(Fleet::usbDeviceFilterStrings))
            .setter(setter(Builder::usbDeviceFilterStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UsbDeviceFilterStrings").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<S3Location> SESSION_SCRIPT_S3_LOCATION_FIELD = SdkField
            .<S3Location> builder(MarshallingType.SDK_POJO).memberName("SessionScriptS3Location")
            .getter(getter(Fleet::sessionScriptS3Location)).setter(setter(Builder::sessionScriptS3Location))
            .constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionScriptS3Location").build())
            .build();

    private static final SdkField<Integer> MAX_SESSIONS_PER_INSTANCE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("MaxSessionsPerInstance").getter(getter(Fleet::maxSessionsPerInstance))
            .setter(setter(Builder::maxSessionsPerInstance))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxSessionsPerInstance").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ARN_FIELD, NAME_FIELD,
            DISPLAY_NAME_FIELD, DESCRIPTION_FIELD, IMAGE_NAME_FIELD, IMAGE_ARN_FIELD, INSTANCE_TYPE_FIELD, FLEET_TYPE_FIELD,
            COMPUTE_CAPACITY_STATUS_FIELD, MAX_USER_DURATION_IN_SECONDS_FIELD, DISCONNECT_TIMEOUT_IN_SECONDS_FIELD, STATE_FIELD,
            VPC_CONFIG_FIELD, CREATED_TIME_FIELD, FLEET_ERRORS_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD,
            DOMAIN_JOIN_INFO_FIELD, IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD, IAM_ROLE_ARN_FIELD, STREAM_VIEW_FIELD,
            PLATFORM_FIELD, MAX_CONCURRENT_SESSIONS_FIELD, USB_DEVICE_FILTER_STRINGS_FIELD, SESSION_SCRIPT_S3_LOCATION_FIELD,
            MAX_SESSIONS_PER_INSTANCE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String arn;

    private final String name;

    private final String displayName;

    private final String description;

    private final String imageName;

    private final String imageArn;

    private final String instanceType;

    private final String fleetType;

    private final ComputeCapacityStatus computeCapacityStatus;

    private final Integer maxUserDurationInSeconds;

    private final Integer disconnectTimeoutInSeconds;

    private final String state;

    private final VpcConfig vpcConfig;

    private final Instant createdTime;

    private final List<FleetError> fleetErrors;

    private final Boolean enableDefaultInternetAccess;

    private final DomainJoinInfo domainJoinInfo;

    private final Integer idleDisconnectTimeoutInSeconds;

    private final String iamRoleArn;

    private final String streamView;

    private final String platform;

    private final Integer maxConcurrentSessions;

    private final List<String> usbDeviceFilterStrings;

    private final S3Location sessionScriptS3Location;

    private final Integer maxSessionsPerInstance;

    private Fleet(BuilderImpl builder) {
        this.arn = builder.arn;
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.description = builder.description;
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.instanceType = builder.instanceType;
        this.fleetType = builder.fleetType;
        this.computeCapacityStatus = builder.computeCapacityStatus;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.state = builder.state;
        this.vpcConfig = builder.vpcConfig;
        this.createdTime = builder.createdTime;
        this.fleetErrors = builder.fleetErrors;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.idleDisconnectTimeoutInSeconds = builder.idleDisconnectTimeoutInSeconds;
        this.iamRoleArn = builder.iamRoleArn;
        this.streamView = builder.streamView;
        this.platform = builder.platform;
        this.maxConcurrentSessions = builder.maxConcurrentSessions;
        this.usbDeviceFilterStrings = builder.usbDeviceFilterStrings;
        this.sessionScriptS3Location = builder.sessionScriptS3Location;
        this.maxSessionsPerInstance = builder.maxSessionsPerInstance;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for the fleet.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for the fleet.
     */
    public final String arn() {
        return arn;
    }

    /**
     * <p>
     * The name of the fleet.
     * </p>
     * 
     * @return The name of the fleet.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The fleet name to display.
     * </p>
     * 
     * @return The fleet name to display.
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The description to display.
     * </p>
     * 
     * @return The description to display.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The name of the image used to create the fleet.
     * </p>
     * 
     * @return The name of the image used to create the fleet.
     */
    public final String imageName() {
        return imageName;
    }

    /**
     * <p>
     * The ARN for the public, private, or shared image.
     * </p>
     * 
     * @return The ARN for the public, private, or shared image.
     */
    public final String imageArn() {
        return imageArn;
    }

    /**
     * <p>
     * The instance type to use when launching fleet instances. The following instance types are available:
     * </p>
     * <ul>
     * <li>
     * <p>
     * stream.standard.small
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.medium
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.standard.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.compute.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.3xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.6xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.memory.z1d.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.large
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-design.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-desktop.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g4dn.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics-pro.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g5.24xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.2xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.8xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.16xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.12xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.g6.24xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.gr6.4xlarge
     * </p>
     * </li>
     * <li>
     * <p>
     * stream.graphics.gr6.8xlarge
     * </p>
     * </li>
     * </ul>
     * 
     * @return The instance type to use when launching fleet instances. The following instance types are available:</p>
     *         <ul>
     *         <li>
     *         <p>
     *         stream.standard.small
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.medium
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.standard.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.compute.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.3xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.6xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.memory.z1d.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.large
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-design.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-desktop.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g4dn.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics-pro.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g5.24xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.2xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.8xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.16xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.12xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.g6.24xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.gr6.4xlarge
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         stream.graphics.gr6.8xlarge
     *         </p>
     *         </li>
     */
    public final String instanceType() {
        return instanceType;
    }

    /**
     * <p>
     * The fleet type.
     * </p>
     * <dl>
     * <dt>ALWAYS_ON</dt>
     * <dd>
     * <p>
     * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
     * even if no users are streaming apps.
     * </p>
     * </dd>
     * <dt>ON_DEMAND</dt>
     * <dd>
     * <p>
     * Provide users with access to applications after they connect, which takes one to two minutes. You are charged for
     * instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return The fleet type.</p>
     *         <dl>
     *         <dt>ALWAYS_ON</dt>
     *         <dd>
     *         <p>
     *         Provides users with instant-on access to their apps. You are charged for all running instances in your
     *         fleet, even if no users are streaming apps.
     *         </p>
     *         </dd>
     *         <dt>ON_DEMAND</dt>
     *         <dd>
     *         <p>
     *         Provide users with access to applications after they connect, which takes one to two minutes. You are
     *         charged for instance streaming when users are connected and a small hourly fee for instances that are not
     *         streaming apps.
     *         </p>
     *         </dd>
     * @see FleetType
     */
    public final FleetType fleetType() {
        return FleetType.fromValue(fleetType);
    }

    /**
     * <p>
     * The fleet type.
     * </p>
     * <dl>
     * <dt>ALWAYS_ON</dt>
     * <dd>
     * <p>
     * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
     * even if no users are streaming apps.
     * </p>
     * </dd>
     * <dt>ON_DEMAND</dt>
     * <dd>
     * <p>
     * Provide users with access to applications after they connect, which takes one to two minutes. You are charged for
     * instance streaming when users are connected and a small hourly fee for instances that are not streaming apps.
     * </p>
     * </dd>
     * </dl>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fleetType} will
     * return {@link FleetType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #fleetTypeAsString}.
     * </p>
     * 
     * @return The fleet type.</p>
     *         <dl>
     *         <dt>ALWAYS_ON</dt>
     *         <dd>
     *         <p>
     *         Provides users with instant-on access to their apps. You are charged for all running instances in your
     *         fleet, even if no users are streaming apps.
     *         </p>
     *         </dd>
     *         <dt>ON_DEMAND</dt>
     *         <dd>
     *         <p>
     *         Provide users with access to applications after they connect, which takes one to two minutes. You are
     *         charged for instance streaming when users are connected and a small hourly fee for instances that are not
     *         streaming apps.
     *         </p>
     *         </dd>
     * @see FleetType
     */
    public final String fleetTypeAsString() {
        return fleetType;
    }

    /**
     * <p>
     * The capacity status for the fleet.
     * </p>
     * 
     * @return The capacity status for the fleet.
     */
    public final ComputeCapacityStatus computeCapacityStatus() {
        return computeCapacityStatus;
    }

    /**
     * <p>
     * The maximum amount of time that a streaming session can remain active, in seconds. If users are still connected
     * to a streaming instance five minutes before this limit is reached, they are prompted to save any open documents
     * before being disconnected. After this time elapses, the instance is terminated and replaced by a new instance.
     * </p>
     * <p>
     * Specify a value between 600 and 360000.
     * </p>
     * 
     * @return The maximum amount of time that a streaming session can remain active, in seconds. If users are still
     *         connected to a streaming instance five minutes before this limit is reached, they are prompted to save
     *         any open documents before being disconnected. After this time elapses, the instance is terminated and
     *         replaced by a new instance. </p>
     *         <p>
     *         Specify a value between 600 and 360000.
     */
    public final Integer maxUserDurationInSeconds() {
        return maxUserDurationInSeconds;
    }

    /**
     * <p>
     * The amount of time that a streaming session remains active after users disconnect. If they try to reconnect to
     * the streaming session after a disconnection or network interruption within this time interval, they are connected
     * to their previous session. Otherwise, they are connected to a new session with a new streaming instance.
     * </p>
     * <p>
     * Specify a value between 60 and 36000.
     * </p>
     * 
     * @return The amount of time that a streaming session remains active after users disconnect. If they try to
     *         reconnect to the streaming session after a disconnection or network interruption within this time
     *         interval, they are connected to their previous session. Otherwise, they are connected to a new session
     *         with a new streaming instance.</p>
     *         <p>
     *         Specify a value between 60 and 36000.
     */
    public final Integer disconnectTimeoutInSeconds() {
        return disconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * The current state for the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FleetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state for the fleet.
     * @see FleetState
     */
    public final FleetState state() {
        return FleetState.fromValue(state);
    }

    /**
     * <p>
     * The current state for the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link FleetState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state for the fleet.
     * @see FleetState
     */
    public final String stateAsString() {
        return state;
    }

    /**
     * <p>
     * The VPC configuration for the fleet.
     * </p>
     * 
     * @return The VPC configuration for the fleet.
     */
    public final VpcConfig vpcConfig() {
        return vpcConfig;
    }

    /**
     * <p>
     * The time the fleet was created.
     * </p>
     * 
     * @return The time the fleet was created.
     */
    public final Instant createdTime() {
        return createdTime;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetErrors property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasFleetErrors() {
        return fleetErrors != null && !(fleetErrors instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fleet errors.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetErrors} method.
     * </p>
     * 
     * @return The fleet errors.
     */
    public final List<FleetError> fleetErrors() {
        return fleetErrors;
    }

    /**
     * <p>
     * Indicates whether default internet access is enabled for the fleet.
     * </p>
     * 
     * @return Indicates whether default internet access is enabled for the fleet.
     */
    public final Boolean enableDefaultInternetAccess() {
        return enableDefaultInternetAccess;
    }

    /**
     * <p>
     * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active Directory
     * domain.
     * </p>
     * 
     * @return The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active
     *         Directory domain.
     */
    public final DomainJoinInfo domainJoinInfo() {
        return domainJoinInfo;
    }

    /**
     * <p>
     * The amount of time that users can be idle (inactive) before they are disconnected from their streaming session
     * and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they are
     * disconnected due to inactivity. If users try to reconnect to the streaming session before the time interval
     * specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous session. Users
     * are considered idle when they stop providing keyboard or mouse input during their streaming session. File uploads
     * and downloads, audio in, audio out, and pixels changing do not qualify as user activity. If users continue to be
     * idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.
     * </p>
     * <p>
     * To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value
     * between 60 and 36000. The default value is 0.
     * </p>
     * <note>
     * <p>
     * If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number of
     * minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute. For
     * example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you specify a
     * value that is at the midpoint between two different minutes, the value is rounded up. For example, if you specify
     * a value of 90, users are disconnected after 2 minutes of inactivity.
     * </p>
     * </note>
     * 
     * @return The amount of time that users can be idle (inactive) before they are disconnected from their streaming
     *         session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before
     *         they are disconnected due to inactivity. If users try to reconnect to the streaming session before the
     *         time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their
     *         previous session. Users are considered idle when they stop providing keyboard or mouse input during their
     *         streaming session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as
     *         user activity. If users continue to be idle after the time interval in
     *         <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
     *         <p>
     *         To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a
     *         value between 60 and 36000. The default value is 0.
     *         </p>
     *         <note>
     *         <p>
     *         If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole
     *         number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the
     *         nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of
     *         inactivity. If you specify a value that is at the midpoint between two different minutes, the value is
     *         rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of
     *         inactivity.
     *         </p>
     */
    public final Integer idleDisconnectTimeoutInSeconds() {
        return idleDisconnectTimeoutInSeconds;
    }

    /**
     * <p>
     * The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the AWS Security
     * Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The operation
     * creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials and creates
     * the <b>appstream_machine_role</b> credential profile on the instance.
     * </p>
     * <p>
     * For more information, see <a href=
     * "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
     * >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
     * Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     * </p>
     * 
     * @return The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the AWS
     *         Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use.
     *         The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary
     *         credentials and creates the <b>appstream_machine_role</b> credential profile on the instance.</p>
     *         <p>
     *         For more information, see <a href=
     *         "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
     *         >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
     *         Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
     */
    public final String iamRoleArn() {
        return iamRoleArn;
    }

    /**
     * <p>
     * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is
     * specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the
     * standard desktop that is provided by the operating system displays.
     * </p>
     * <p>
     * The default value is <code>APP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamView} will
     * return {@link StreamView#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamViewAsString}.
     * </p>
     * 
     * @return The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When
     *         <code>APP</code> is specified, only the windows of applications opened by users display. When
     *         <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system
     *         displays.</p>
     *         <p>
     *         The default value is <code>APP</code>.
     * @see StreamView
     */
    public final StreamView streamView() {
        return StreamView.fromValue(streamView);
    }

    /**
     * <p>
     * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code> is
     * specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is specified, the
     * standard desktop that is provided by the operating system displays.
     * </p>
     * <p>
     * The default value is <code>APP</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #streamView} will
     * return {@link StreamView#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #streamViewAsString}.
     * </p>
     * 
     * @return The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When
     *         <code>APP</code> is specified, only the windows of applications opened by users display. When
     *         <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system
     *         displays.</p>
     *         <p>
     *         The default value is <code>APP</code>.
     * @see StreamView
     */
    public final String streamViewAsString() {
        return streamView;
    }

    /**
     * <p>
     * The platform of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the fleet.
     * @see PlatformType
     */
    public final PlatformType platform() {
        return PlatformType.fromValue(platform);
    }

    /**
     * <p>
     * The platform of the fleet.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #platform} will
     * return {@link PlatformType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #platformAsString}.
     * </p>
     * 
     * @return The platform of the fleet.
     * @see PlatformType
     */
    public final String platformAsString() {
        return platform;
    }

    /**
     * <p>
     * The maximum number of concurrent sessions for the fleet.
     * </p>
     * 
     * @return The maximum number of concurrent sessions for the fleet.
     */
    public final Integer maxConcurrentSessions() {
        return maxConcurrentSessions;
    }

    /**
     * For responses, this returns true if the service returned a value for the UsbDeviceFilterStrings property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasUsbDeviceFilterStrings() {
        return usbDeviceFilterStrings != null && !(usbDeviceFilterStrings instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The USB device filter strings associated with the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUsbDeviceFilterStrings} method.
     * </p>
     * 
     * @return The USB device filter strings associated with the fleet.
     */
    public final List<String> usbDeviceFilterStrings() {
        return usbDeviceFilterStrings;
    }

    /**
     * <p>
     * The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
     * </p>
     * 
     * @return The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
     */
    public final S3Location sessionScriptS3Location() {
        return sessionScriptS3Location;
    }

    /**
     * <p>
     * The maximum number of user sessions on an instance. This only applies to multi-session fleets.
     * </p>
     * 
     * @return The maximum number of user sessions on an instance. This only applies to multi-session fleets.
     */
    public final Integer maxSessionsPerInstance() {
        return maxSessionsPerInstance;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(imageName());
        hashCode = 31 * hashCode + Objects.hashCode(imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(computeCapacityStatus());
        hashCode = 31 * hashCode + Objects.hashCode(maxUserDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(createdTime());
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetErrors() ? fleetErrors() : null);
        hashCode = 31 * hashCode + Objects.hashCode(enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(idleDisconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(iamRoleArn());
        hashCode = 31 * hashCode + Objects.hashCode(streamViewAsString());
        hashCode = 31 * hashCode + Objects.hashCode(platformAsString());
        hashCode = 31 * hashCode + Objects.hashCode(maxConcurrentSessions());
        hashCode = 31 * hashCode + Objects.hashCode(hasUsbDeviceFilterStrings() ? usbDeviceFilterStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(sessionScriptS3Location());
        hashCode = 31 * hashCode + Objects.hashCode(maxSessionsPerInstance());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Fleet)) {
            return false;
        }
        Fleet other = (Fleet) obj;
        return Objects.equals(arn(), other.arn()) && Objects.equals(name(), other.name())
                && Objects.equals(displayName(), other.displayName()) && Objects.equals(description(), other.description())
                && Objects.equals(imageName(), other.imageName()) && Objects.equals(imageArn(), other.imageArn())
                && Objects.equals(instanceType(), other.instanceType())
                && Objects.equals(fleetTypeAsString(), other.fleetTypeAsString())
                && Objects.equals(computeCapacityStatus(), other.computeCapacityStatus())
                && Objects.equals(maxUserDurationInSeconds(), other.maxUserDurationInSeconds())
                && Objects.equals(disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds())
                && Objects.equals(stateAsString(), other.stateAsString()) && Objects.equals(vpcConfig(), other.vpcConfig())
                && Objects.equals(createdTime(), other.createdTime()) && hasFleetErrors() == other.hasFleetErrors()
                && Objects.equals(fleetErrors(), other.fleetErrors())
                && Objects.equals(enableDefaultInternetAccess(), other.enableDefaultInternetAccess())
                && Objects.equals(domainJoinInfo(), other.domainJoinInfo())
                && Objects.equals(idleDisconnectTimeoutInSeconds(), other.idleDisconnectTimeoutInSeconds())
                && Objects.equals(iamRoleArn(), other.iamRoleArn())
                && Objects.equals(streamViewAsString(), other.streamViewAsString())
                && Objects.equals(platformAsString(), other.platformAsString())
                && Objects.equals(maxConcurrentSessions(), other.maxConcurrentSessions())
                && hasUsbDeviceFilterStrings() == other.hasUsbDeviceFilterStrings()
                && Objects.equals(usbDeviceFilterStrings(), other.usbDeviceFilterStrings())
                && Objects.equals(sessionScriptS3Location(), other.sessionScriptS3Location())
                && Objects.equals(maxSessionsPerInstance(), other.maxSessionsPerInstance());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Fleet").add("Arn", arn()).add("Name", name()).add("DisplayName", displayName())
                .add("Description", description()).add("ImageName", imageName()).add("ImageArn", imageArn())
                .add("InstanceType", instanceType()).add("FleetType", fleetTypeAsString())
                .add("ComputeCapacityStatus", computeCapacityStatus())
                .add("MaxUserDurationInSeconds", maxUserDurationInSeconds())
                .add("DisconnectTimeoutInSeconds", disconnectTimeoutInSeconds()).add("State", stateAsString())
                .add("VpcConfig", vpcConfig()).add("CreatedTime", createdTime())
                .add("FleetErrors", hasFleetErrors() ? fleetErrors() : null)
                .add("EnableDefaultInternetAccess", enableDefaultInternetAccess()).add("DomainJoinInfo", domainJoinInfo())
                .add("IdleDisconnectTimeoutInSeconds", idleDisconnectTimeoutInSeconds()).add("IamRoleArn", iamRoleArn())
                .add("StreamView", streamViewAsString()).add("Platform", platformAsString())
                .add("MaxConcurrentSessions", maxConcurrentSessions())
                .add("UsbDeviceFilterStrings", hasUsbDeviceFilterStrings() ? usbDeviceFilterStrings() : null)
                .add("SessionScriptS3Location", sessionScriptS3Location())
                .add("MaxSessionsPerInstance", maxSessionsPerInstance()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "Description":
            return Optional.ofNullable(clazz.cast(description()));
        case "ImageName":
            return Optional.ofNullable(clazz.cast(imageName()));
        case "ImageArn":
            return Optional.ofNullable(clazz.cast(imageArn()));
        case "InstanceType":
            return Optional.ofNullable(clazz.cast(instanceType()));
        case "FleetType":
            return Optional.ofNullable(clazz.cast(fleetTypeAsString()));
        case "ComputeCapacityStatus":
            return Optional.ofNullable(clazz.cast(computeCapacityStatus()));
        case "MaxUserDurationInSeconds":
            return Optional.ofNullable(clazz.cast(maxUserDurationInSeconds()));
        case "DisconnectTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(disconnectTimeoutInSeconds()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "VpcConfig":
            return Optional.ofNullable(clazz.cast(vpcConfig()));
        case "CreatedTime":
            return Optional.ofNullable(clazz.cast(createdTime()));
        case "FleetErrors":
            return Optional.ofNullable(clazz.cast(fleetErrors()));
        case "EnableDefaultInternetAccess":
            return Optional.ofNullable(clazz.cast(enableDefaultInternetAccess()));
        case "DomainJoinInfo":
            return Optional.ofNullable(clazz.cast(domainJoinInfo()));
        case "IdleDisconnectTimeoutInSeconds":
            return Optional.ofNullable(clazz.cast(idleDisconnectTimeoutInSeconds()));
        case "IamRoleArn":
            return Optional.ofNullable(clazz.cast(iamRoleArn()));
        case "StreamView":
            return Optional.ofNullable(clazz.cast(streamViewAsString()));
        case "Platform":
            return Optional.ofNullable(clazz.cast(platformAsString()));
        case "MaxConcurrentSessions":
            return Optional.ofNullable(clazz.cast(maxConcurrentSessions()));
        case "UsbDeviceFilterStrings":
            return Optional.ofNullable(clazz.cast(usbDeviceFilterStrings()));
        case "SessionScriptS3Location":
            return Optional.ofNullable(clazz.cast(sessionScriptS3Location()));
        case "MaxSessionsPerInstance":
            return Optional.ofNullable(clazz.cast(maxSessionsPerInstance()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("Arn", ARN_FIELD);
        map.put("Name", NAME_FIELD);
        map.put("DisplayName", DISPLAY_NAME_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("ImageName", IMAGE_NAME_FIELD);
        map.put("ImageArn", IMAGE_ARN_FIELD);
        map.put("InstanceType", INSTANCE_TYPE_FIELD);
        map.put("FleetType", FLEET_TYPE_FIELD);
        map.put("ComputeCapacityStatus", COMPUTE_CAPACITY_STATUS_FIELD);
        map.put("MaxUserDurationInSeconds", MAX_USER_DURATION_IN_SECONDS_FIELD);
        map.put("DisconnectTimeoutInSeconds", DISCONNECT_TIMEOUT_IN_SECONDS_FIELD);
        map.put("State", STATE_FIELD);
        map.put("VpcConfig", VPC_CONFIG_FIELD);
        map.put("CreatedTime", CREATED_TIME_FIELD);
        map.put("FleetErrors", FLEET_ERRORS_FIELD);
        map.put("EnableDefaultInternetAccess", ENABLE_DEFAULT_INTERNET_ACCESS_FIELD);
        map.put("DomainJoinInfo", DOMAIN_JOIN_INFO_FIELD);
        map.put("IdleDisconnectTimeoutInSeconds", IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD);
        map.put("IamRoleArn", IAM_ROLE_ARN_FIELD);
        map.put("StreamView", STREAM_VIEW_FIELD);
        map.put("Platform", PLATFORM_FIELD);
        map.put("MaxConcurrentSessions", MAX_CONCURRENT_SESSIONS_FIELD);
        map.put("UsbDeviceFilterStrings", USB_DEVICE_FILTER_STRINGS_FIELD);
        map.put("SessionScriptS3Location", SESSION_SCRIPT_S3_LOCATION_FIELD);
        map.put("MaxSessionsPerInstance", MAX_SESSIONS_PER_INSTANCE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Fleet, T> g) {
        return obj -> g.apply((Fleet) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Fleet> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) for the fleet.
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN) for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The name of the fleet.
         * </p>
         * 
         * @param name
         *        The name of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The fleet name to display.
         * </p>
         * 
         * @param displayName
         *        The fleet name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The description to display.
         * </p>
         * 
         * @param description
         *        The description to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The name of the image used to create the fleet.
         * </p>
         * 
         * @param imageName
         *        The name of the image used to create the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageName(String imageName);

        /**
         * <p>
         * The ARN for the public, private, or shared image.
         * </p>
         * 
         * @param imageArn
         *        The ARN for the public, private, or shared image.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder imageArn(String imageArn);

        /**
         * <p>
         * The instance type to use when launching fleet instances. The following instance types are available:
         * </p>
         * <ul>
         * <li>
         * <p>
         * stream.standard.small
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.medium
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.standard.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.compute.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.3xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.6xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.memory.z1d.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.large
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-design.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-desktop.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g4dn.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics-pro.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g5.24xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.2xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.8xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.16xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.12xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.g6.24xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.gr6.4xlarge
         * </p>
         * </li>
         * <li>
         * <p>
         * stream.graphics.gr6.8xlarge
         * </p>
         * </li>
         * </ul>
         * 
         * @param instanceType
         *        The instance type to use when launching fleet instances. The following instance types are
         *        available:</p>
         *        <ul>
         *        <li>
         *        <p>
         *        stream.standard.small
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.medium
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.standard.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.compute.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.3xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.6xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.memory.z1d.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.large
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-design.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-desktop.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g4dn.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics-pro.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g5.24xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.2xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.8xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.16xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.12xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.g6.24xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.gr6.4xlarge
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        stream.graphics.gr6.8xlarge
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceType(String instanceType);

        /**
         * <p>
         * The fleet type.
         * </p>
         * <dl>
         * <dt>ALWAYS_ON</dt>
         * <dd>
         * <p>
         * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
         * even if no users are streaming apps.
         * </p>
         * </dd>
         * <dt>ON_DEMAND</dt>
         * <dd>
         * <p>
         * Provide users with access to applications after they connect, which takes one to two minutes. You are charged
         * for instance streaming when users are connected and a small hourly fee for instances that are not streaming
         * apps.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param fleetType
         *        The fleet type.</p>
         *        <dl>
         *        <dt>ALWAYS_ON</dt>
         *        <dd>
         *        <p>
         *        Provides users with instant-on access to their apps. You are charged for all running instances in your
         *        fleet, even if no users are streaming apps.
         *        </p>
         *        </dd>
         *        <dt>ON_DEMAND</dt>
         *        <dd>
         *        <p>
         *        Provide users with access to applications after they connect, which takes one to two minutes. You are
         *        charged for instance streaming when users are connected and a small hourly fee for instances that are
         *        not streaming apps.
         *        </p>
         *        </dd>
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(String fleetType);

        /**
         * <p>
         * The fleet type.
         * </p>
         * <dl>
         * <dt>ALWAYS_ON</dt>
         * <dd>
         * <p>
         * Provides users with instant-on access to their apps. You are charged for all running instances in your fleet,
         * even if no users are streaming apps.
         * </p>
         * </dd>
         * <dt>ON_DEMAND</dt>
         * <dd>
         * <p>
         * Provide users with access to applications after they connect, which takes one to two minutes. You are charged
         * for instance streaming when users are connected and a small hourly fee for instances that are not streaming
         * apps.
         * </p>
         * </dd>
         * </dl>
         * 
         * @param fleetType
         *        The fleet type.</p>
         *        <dl>
         *        <dt>ALWAYS_ON</dt>
         *        <dd>
         *        <p>
         *        Provides users with instant-on access to their apps. You are charged for all running instances in your
         *        fleet, even if no users are streaming apps.
         *        </p>
         *        </dd>
         *        <dt>ON_DEMAND</dt>
         *        <dd>
         *        <p>
         *        Provide users with access to applications after they connect, which takes one to two minutes. You are
         *        charged for instance streaming when users are connected and a small hourly fee for instances that are
         *        not streaming apps.
         *        </p>
         *        </dd>
         * @see FleetType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetType
         */
        Builder fleetType(FleetType fleetType);

        /**
         * <p>
         * The capacity status for the fleet.
         * </p>
         * 
         * @param computeCapacityStatus
         *        The capacity status for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus);

        /**
         * <p>
         * The capacity status for the fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link ComputeCapacityStatus.Builder} avoiding
         * the need to create one manually via {@link ComputeCapacityStatus#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ComputeCapacityStatus.Builder#build()} is called immediately and
         * its result is passed to {@link #computeCapacityStatus(ComputeCapacityStatus)}.
         * 
         * @param computeCapacityStatus
         *        a consumer that will call methods on {@link ComputeCapacityStatus.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #computeCapacityStatus(ComputeCapacityStatus)
         */
        default Builder computeCapacityStatus(Consumer<ComputeCapacityStatus.Builder> computeCapacityStatus) {
            return computeCapacityStatus(ComputeCapacityStatus.builder().applyMutation(computeCapacityStatus).build());
        }

        /**
         * <p>
         * The maximum amount of time that a streaming session can remain active, in seconds. If users are still
         * connected to a streaming instance five minutes before this limit is reached, they are prompted to save any
         * open documents before being disconnected. After this time elapses, the instance is terminated and replaced by
         * a new instance.
         * </p>
         * <p>
         * Specify a value between 600 and 360000.
         * </p>
         * 
         * @param maxUserDurationInSeconds
         *        The maximum amount of time that a streaming session can remain active, in seconds. If users are still
         *        connected to a streaming instance five minutes before this limit is reached, they are prompted to save
         *        any open documents before being disconnected. After this time elapses, the instance is terminated and
         *        replaced by a new instance. </p>
         *        <p>
         *        Specify a value between 600 and 360000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds);

        /**
         * <p>
         * The amount of time that a streaming session remains active after users disconnect. If they try to reconnect
         * to the streaming session after a disconnection or network interruption within this time interval, they are
         * connected to their previous session. Otherwise, they are connected to a new session with a new streaming
         * instance.
         * </p>
         * <p>
         * Specify a value between 60 and 36000.
         * </p>
         * 
         * @param disconnectTimeoutInSeconds
         *        The amount of time that a streaming session remains active after users disconnect. If they try to
         *        reconnect to the streaming session after a disconnection or network interruption within this time
         *        interval, they are connected to their previous session. Otherwise, they are connected to a new session
         *        with a new streaming instance.</p>
         *        <p>
         *        Specify a value between 60 and 36000.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds);

        /**
         * <p>
         * The current state for the fleet.
         * </p>
         * 
         * @param state
         *        The current state for the fleet.
         * @see FleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state for the fleet.
         * </p>
         * 
         * @param state
         *        The current state for the fleet.
         * @see FleetState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FleetState
         */
        Builder state(FleetState state);

        /**
         * <p>
         * The VPC configuration for the fleet.
         * </p>
         * 
         * @param vpcConfig
         *        The VPC configuration for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfig(VpcConfig vpcConfig);

        /**
         * <p>
         * The VPC configuration for the fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfig.Builder} avoiding the need to
         * create one manually via {@link VpcConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #vpcConfig(VpcConfig)}.
         * 
         * @param vpcConfig
         *        a consumer that will call methods on {@link VpcConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfig(VpcConfig)
         */
        default Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return vpcConfig(VpcConfig.builder().applyMutation(vpcConfig).build());
        }

        /**
         * <p>
         * The time the fleet was created.
         * </p>
         * 
         * @param createdTime
         *        The time the fleet was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdTime(Instant createdTime);

        /**
         * <p>
         * The fleet errors.
         * </p>
         * 
         * @param fleetErrors
         *        The fleet errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetErrors(Collection<FleetError> fleetErrors);

        /**
         * <p>
         * The fleet errors.
         * </p>
         * 
         * @param fleetErrors
         *        The fleet errors.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetErrors(FleetError... fleetErrors);

        /**
         * <p>
         * The fleet errors.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.appstream.model.FleetError.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.appstream.model.FleetError#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.appstream.model.FleetError.Builder#build()} is called immediately and
         * its result is passed to {@link #fleetErrors(List<FleetError>)}.
         * 
         * @param fleetErrors
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.appstream.model.FleetError.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleetErrors(java.util.Collection<FleetError>)
         */
        Builder fleetErrors(Consumer<FleetError.Builder>... fleetErrors);

        /**
         * <p>
         * Indicates whether default internet access is enabled for the fleet.
         * </p>
         * 
         * @param enableDefaultInternetAccess
         *        Indicates whether default internet access is enabled for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess);

        /**
         * <p>
         * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active
         * Directory domain.
         * </p>
         * 
         * @param domainJoinInfo
         *        The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active
         *        Directory domain.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainJoinInfo(DomainJoinInfo domainJoinInfo);

        /**
         * <p>
         * The name of the directory and organizational unit (OU) to use to join the fleet to a Microsoft Active
         * Directory domain.
         * </p>
         * This is a convenience method that creates an instance of the {@link DomainJoinInfo.Builder} avoiding the need
         * to create one manually via {@link DomainJoinInfo#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DomainJoinInfo.Builder#build()} is called immediately and its
         * result is passed to {@link #domainJoinInfo(DomainJoinInfo)}.
         * 
         * @param domainJoinInfo
         *        a consumer that will call methods on {@link DomainJoinInfo.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #domainJoinInfo(DomainJoinInfo)
         */
        default Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return domainJoinInfo(DomainJoinInfo.builder().applyMutation(domainJoinInfo).build());
        }

        /**
         * <p>
         * The amount of time that users can be idle (inactive) before they are disconnected from their streaming
         * session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified before they
         * are disconnected due to inactivity. If users try to reconnect to the streaming session before the time
         * interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are connected to their previous
         * session. Users are considered idle when they stop providing keyboard or mouse input during their streaming
         * session. File uploads and downloads, audio in, audio out, and pixels changing do not qualify as user
         * activity. If users continue to be idle after the time interval in <code>IdleDisconnectTimeoutInSeconds</code>
         * elapses, they are disconnected.
         * </p>
         * <p>
         * To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a value
         * between 60 and 36000. The default value is 0.
         * </p>
         * <note>
         * <p>
         * If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole number
         * of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the nearest minute.
         * For example, if you specify a value of 70, users are disconnected after 1 minute of inactivity. If you
         * specify a value that is at the midpoint between two different minutes, the value is rounded up. For example,
         * if you specify a value of 90, users are disconnected after 2 minutes of inactivity.
         * </p>
         * </note>
         * 
         * @param idleDisconnectTimeoutInSeconds
         *        The amount of time that users can be idle (inactive) before they are disconnected from their streaming
         *        session and the <code>DisconnectTimeoutInSeconds</code> time interval begins. Users are notified
         *        before they are disconnected due to inactivity. If users try to reconnect to the streaming session
         *        before the time interval specified in <code>DisconnectTimeoutInSeconds</code> elapses, they are
         *        connected to their previous session. Users are considered idle when they stop providing keyboard or
         *        mouse input during their streaming session. File uploads and downloads, audio in, audio out, and
         *        pixels changing do not qualify as user activity. If users continue to be idle after the time interval
         *        in <code>IdleDisconnectTimeoutInSeconds</code> elapses, they are disconnected.</p>
         *        <p>
         *        To prevent users from being disconnected due to inactivity, specify a value of 0. Otherwise, specify a
         *        value between 60 and 36000. The default value is 0.
         *        </p>
         *        <note>
         *        <p>
         *        If you enable this feature, we recommend that you specify a value that corresponds exactly to a whole
         *        number of minutes (for example, 60, 120, and 180). If you don't do this, the value is rounded to the
         *        nearest minute. For example, if you specify a value of 70, users are disconnected after 1 minute of
         *        inactivity. If you specify a value that is at the midpoint between two different minutes, the value is
         *        rounded up. For example, if you specify a value of 90, users are disconnected after 2 minutes of
         *        inactivity.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder idleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds);

        /**
         * <p>
         * The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the AWS
         * Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role to use. The
         * operation creates a new session with temporary credentials. AppStream 2.0 retrieves the temporary credentials
         * and creates the <b>appstream_machine_role</b> credential profile on the instance.
         * </p>
         * <p>
         * For more information, see <a href=
         * "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
         * >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
         * Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * </p>
         * 
         * @param iamRoleArn
         *        The ARN of the IAM role that is applied to the fleet. To assume a role, the fleet instance calls the
         *        AWS Security Token Service (STS) <code>AssumeRole</code> API operation and passes the ARN of the role
         *        to use. The operation creates a new session with temporary credentials. AppStream 2.0 retrieves the
         *        temporary credentials and creates the <b>appstream_machine_role</b> credential profile on the
         *        instance.</p>
         *        <p>
         *        For more information, see <a href=
         *        "https://docs.aws.amazon.com/appstream2/latest/developerguide/using-iam-roles-to-grant-permissions-to-applications-scripts-streaming-instances.html"
         *        >Using an IAM Role to Grant Permissions to Applications and Scripts Running on AppStream 2.0 Streaming
         *        Instances</a> in the <i>Amazon AppStream 2.0 Administration Guide</i>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iamRoleArn(String iamRoleArn);

        /**
         * <p>
         * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code>
         * is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is
         * specified, the standard desktop that is provided by the operating system displays.
         * </p>
         * <p>
         * The default value is <code>APP</code>.
         * </p>
         * 
         * @param streamView
         *        The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When
         *        <code>APP</code> is specified, only the windows of applications opened by users display. When
         *        <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system
         *        displays.</p>
         *        <p>
         *        The default value is <code>APP</code>.
         * @see StreamView
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamView
         */
        Builder streamView(String streamView);

        /**
         * <p>
         * The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When <code>APP</code>
         * is specified, only the windows of applications opened by users display. When <code>DESKTOP</code> is
         * specified, the standard desktop that is provided by the operating system displays.
         * </p>
         * <p>
         * The default value is <code>APP</code>.
         * </p>
         * 
         * @param streamView
         *        The AppStream 2.0 view that is displayed to your users when they stream from the fleet. When
         *        <code>APP</code> is specified, only the windows of applications opened by users display. When
         *        <code>DESKTOP</code> is specified, the standard desktop that is provided by the operating system
         *        displays.</p>
         *        <p>
         *        The default value is <code>APP</code>.
         * @see StreamView
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StreamView
         */
        Builder streamView(StreamView streamView);

        /**
         * <p>
         * The platform of the fleet.
         * </p>
         * 
         * @param platform
         *        The platform of the fleet.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(String platform);

        /**
         * <p>
         * The platform of the fleet.
         * </p>
         * 
         * @param platform
         *        The platform of the fleet.
         * @see PlatformType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PlatformType
         */
        Builder platform(PlatformType platform);

        /**
         * <p>
         * The maximum number of concurrent sessions for the fleet.
         * </p>
         * 
         * @param maxConcurrentSessions
         *        The maximum number of concurrent sessions for the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxConcurrentSessions(Integer maxConcurrentSessions);

        /**
         * <p>
         * The USB device filter strings associated with the fleet.
         * </p>
         * 
         * @param usbDeviceFilterStrings
         *        The USB device filter strings associated with the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usbDeviceFilterStrings(Collection<String> usbDeviceFilterStrings);

        /**
         * <p>
         * The USB device filter strings associated with the fleet.
         * </p>
         * 
         * @param usbDeviceFilterStrings
         *        The USB device filter strings associated with the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder usbDeviceFilterStrings(String... usbDeviceFilterStrings);

        /**
         * <p>
         * The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
         * </p>
         * 
         * @param sessionScriptS3Location
         *        The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionScriptS3Location(S3Location sessionScriptS3Location);

        /**
         * <p>
         * The S3 location of the session scripts configuration zip file. This only applies to Elastic fleets.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #sessionScriptS3Location(S3Location)}.
         * 
         * @param sessionScriptS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionScriptS3Location(S3Location)
         */
        default Builder sessionScriptS3Location(Consumer<S3Location.Builder> sessionScriptS3Location) {
            return sessionScriptS3Location(S3Location.builder().applyMutation(sessionScriptS3Location).build());
        }

        /**
         * <p>
         * The maximum number of user sessions on an instance. This only applies to multi-session fleets.
         * </p>
         * 
         * @param maxSessionsPerInstance
         *        The maximum number of user sessions on an instance. This only applies to multi-session fleets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxSessionsPerInstance(Integer maxSessionsPerInstance);
    }

    static final class BuilderImpl implements Builder {
        private String arn;

        private String name;

        private String displayName;

        private String description;

        private String imageName;

        private String imageArn;

        private String instanceType;

        private String fleetType;

        private ComputeCapacityStatus computeCapacityStatus;

        private Integer maxUserDurationInSeconds;

        private Integer disconnectTimeoutInSeconds;

        private String state;

        private VpcConfig vpcConfig;

        private Instant createdTime;

        private List<FleetError> fleetErrors = DefaultSdkAutoConstructList.getInstance();

        private Boolean enableDefaultInternetAccess;

        private DomainJoinInfo domainJoinInfo;

        private Integer idleDisconnectTimeoutInSeconds;

        private String iamRoleArn;

        private String streamView;

        private String platform;

        private Integer maxConcurrentSessions;

        private List<String> usbDeviceFilterStrings = DefaultSdkAutoConstructList.getInstance();

        private S3Location sessionScriptS3Location;

        private Integer maxSessionsPerInstance;

        private BuilderImpl() {
        }

        private BuilderImpl(Fleet model) {
            arn(model.arn);
            name(model.name);
            displayName(model.displayName);
            description(model.description);
            imageName(model.imageName);
            imageArn(model.imageArn);
            instanceType(model.instanceType);
            fleetType(model.fleetType);
            computeCapacityStatus(model.computeCapacityStatus);
            maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            state(model.state);
            vpcConfig(model.vpcConfig);
            createdTime(model.createdTime);
            fleetErrors(model.fleetErrors);
            enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            domainJoinInfo(model.domainJoinInfo);
            idleDisconnectTimeoutInSeconds(model.idleDisconnectTimeoutInSeconds);
            iamRoleArn(model.iamRoleArn);
            streamView(model.streamView);
            platform(model.platform);
            maxConcurrentSessions(model.maxConcurrentSessions);
            usbDeviceFilterStrings(model.usbDeviceFilterStrings);
            sessionScriptS3Location(model.sessionScriptS3Location);
            maxSessionsPerInstance(model.maxSessionsPerInstance);
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getImageName() {
            return imageName;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final String getImageArn() {
            return imageArn;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final String getInstanceType() {
            return instanceType;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final String getFleetType() {
            return fleetType;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final ComputeCapacityStatus.Builder getComputeCapacityStatus() {
            return computeCapacityStatus != null ? computeCapacityStatus.toBuilder() : null;
        }

        public final void setComputeCapacityStatus(ComputeCapacityStatus.BuilderImpl computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus != null ? computeCapacityStatus.build() : null;
        }

        @Override
        public final Builder computeCapacityStatus(ComputeCapacityStatus computeCapacityStatus) {
            this.computeCapacityStatus = computeCapacityStatus;
            return this;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return maxUserDurationInSeconds;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return disconnectTimeoutInSeconds;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final String getState() {
            return state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(FleetState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return vpcConfig != null ? vpcConfig.toBuilder() : null;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final Instant getCreatedTime() {
            return createdTime;
        }

        public final void setCreatedTime(Instant createdTime) {
            this.createdTime = createdTime;
        }

        @Override
        public final Builder createdTime(Instant createdTime) {
            this.createdTime = createdTime;
            return this;
        }

        public final List<FleetError.Builder> getFleetErrors() {
            List<FleetError.Builder> result = FleetErrorsCopier.copyToBuilder(this.fleetErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleetErrors(Collection<FleetError.BuilderImpl> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copyFromBuilder(fleetErrors);
        }

        @Override
        public final Builder fleetErrors(Collection<FleetError> fleetErrors) {
            this.fleetErrors = FleetErrorsCopier.copy(fleetErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(FleetError... fleetErrors) {
            fleetErrors(Arrays.asList(fleetErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetErrors(Consumer<FleetError.Builder>... fleetErrors) {
            fleetErrors(Stream.of(fleetErrors).map(c -> FleetError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return enableDefaultInternetAccess;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return domainJoinInfo != null ? domainJoinInfo.toBuilder() : null;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final Integer getIdleDisconnectTimeoutInSeconds() {
            return idleDisconnectTimeoutInSeconds;
        }

        public final void setIdleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
        }

        @Override
        public final Builder idleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
            return this;
        }

        public final String getIamRoleArn() {
            return iamRoleArn;
        }

        public final void setIamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
        }

        @Override
        public final Builder iamRoleArn(String iamRoleArn) {
            this.iamRoleArn = iamRoleArn;
            return this;
        }

        public final String getStreamView() {
            return streamView;
        }

        public final void setStreamView(String streamView) {
            this.streamView = streamView;
        }

        @Override
        public final Builder streamView(String streamView) {
            this.streamView = streamView;
            return this;
        }

        @Override
        public final Builder streamView(StreamView streamView) {
            this.streamView(streamView == null ? null : streamView.toString());
            return this;
        }

        public final String getPlatform() {
            return platform;
        }

        public final void setPlatform(String platform) {
            this.platform = platform;
        }

        @Override
        public final Builder platform(String platform) {
            this.platform = platform;
            return this;
        }

        @Override
        public final Builder platform(PlatformType platform) {
            this.platform(platform == null ? null : platform.toString());
            return this;
        }

        public final Integer getMaxConcurrentSessions() {
            return maxConcurrentSessions;
        }

        public final void setMaxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
        }

        @Override
        public final Builder maxConcurrentSessions(Integer maxConcurrentSessions) {
            this.maxConcurrentSessions = maxConcurrentSessions;
            return this;
        }

        public final Collection<String> getUsbDeviceFilterStrings() {
            if (usbDeviceFilterStrings instanceof SdkAutoConstructList) {
                return null;
            }
            return usbDeviceFilterStrings;
        }

        public final void setUsbDeviceFilterStrings(Collection<String> usbDeviceFilterStrings) {
            this.usbDeviceFilterStrings = UsbDeviceFilterStringsCopier.copy(usbDeviceFilterStrings);
        }

        @Override
        public final Builder usbDeviceFilterStrings(Collection<String> usbDeviceFilterStrings) {
            this.usbDeviceFilterStrings = UsbDeviceFilterStringsCopier.copy(usbDeviceFilterStrings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder usbDeviceFilterStrings(String... usbDeviceFilterStrings) {
            usbDeviceFilterStrings(Arrays.asList(usbDeviceFilterStrings));
            return this;
        }

        public final S3Location.Builder getSessionScriptS3Location() {
            return sessionScriptS3Location != null ? sessionScriptS3Location.toBuilder() : null;
        }

        public final void setSessionScriptS3Location(S3Location.BuilderImpl sessionScriptS3Location) {
            this.sessionScriptS3Location = sessionScriptS3Location != null ? sessionScriptS3Location.build() : null;
        }

        @Override
        public final Builder sessionScriptS3Location(S3Location sessionScriptS3Location) {
            this.sessionScriptS3Location = sessionScriptS3Location;
            return this;
        }

        public final Integer getMaxSessionsPerInstance() {
            return maxSessionsPerInstance;
        }

        public final void setMaxSessionsPerInstance(Integer maxSessionsPerInstance) {
            this.maxSessionsPerInstance = maxSessionsPerInstance;
        }

        @Override
        public final Builder maxSessionsPerInstance(Integer maxSessionsPerInstance) {
            this.maxSessionsPerInstance = maxSessionsPerInstance;
            return this;
        }

        @Override
        public Fleet build() {
            return new Fleet(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
