/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateAppBlockBuilderResponse extends AppStreamResponse implements
        ToCopyableBuilder<UpdateAppBlockBuilderResponse.Builder, UpdateAppBlockBuilderResponse> {
    private static final SdkField<AppBlockBuilder> APP_BLOCK_BUILDER_FIELD = SdkField
            .<AppBlockBuilder> builder(MarshallingType.SDK_POJO).memberName("AppBlockBuilder")
            .getter(getter(UpdateAppBlockBuilderResponse::appBlockBuilder)).setter(setter(Builder::appBlockBuilder))
            .constructor(AppBlockBuilder::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AppBlockBuilder").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(APP_BLOCK_BUILDER_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AppBlockBuilder appBlockBuilder;

    private UpdateAppBlockBuilderResponse(BuilderImpl builder) {
        super(builder);
        this.appBlockBuilder = builder.appBlockBuilder;
    }

    /**
     * Returns the value of the AppBlockBuilder property for this object.
     * 
     * @return The value of the AppBlockBuilder property for this object.
     */
    public final AppBlockBuilder appBlockBuilder() {
        return appBlockBuilder;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(appBlockBuilder());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateAppBlockBuilderResponse)) {
            return false;
        }
        UpdateAppBlockBuilderResponse other = (UpdateAppBlockBuilderResponse) obj;
        return Objects.equals(appBlockBuilder(), other.appBlockBuilder());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateAppBlockBuilderResponse").add("AppBlockBuilder", appBlockBuilder()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AppBlockBuilder":
            return Optional.ofNullable(clazz.cast(appBlockBuilder()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("AppBlockBuilder", APP_BLOCK_BUILDER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateAppBlockBuilderResponse, T> g) {
        return obj -> g.apply((UpdateAppBlockBuilderResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends AppStreamResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateAppBlockBuilderResponse> {
        /**
         * Sets the value of the AppBlockBuilder property for this object.
         *
         * @param appBlockBuilder
         *        The new value for the AppBlockBuilder property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appBlockBuilder(AppBlockBuilder appBlockBuilder);

        /**
         * Sets the value of the AppBlockBuilder property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AppBlockBuilder.Builder} avoiding the
         * need to create one manually via {@link AppBlockBuilder#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppBlockBuilder.Builder#build()} is called immediately and its
         * result is passed to {@link #appBlockBuilder(AppBlockBuilder)}.
         * 
         * @param appBlockBuilder
         *        a consumer that will call methods on {@link AppBlockBuilder.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #appBlockBuilder(AppBlockBuilder)
         */
        default Builder appBlockBuilder(Consumer<AppBlockBuilder.Builder> appBlockBuilder) {
            return appBlockBuilder(AppBlockBuilder.builder().applyMutation(appBlockBuilder).build());
        }
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private AppBlockBuilder appBlockBuilder;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateAppBlockBuilderResponse model) {
            super(model);
            appBlockBuilder(model.appBlockBuilder);
        }

        public final AppBlockBuilder.Builder getAppBlockBuilder() {
            return appBlockBuilder != null ? appBlockBuilder.toBuilder() : null;
        }

        public final void setAppBlockBuilder(AppBlockBuilder.BuilderImpl appBlockBuilder) {
            this.appBlockBuilder = appBlockBuilder != null ? appBlockBuilder.build() : null;
        }

        @Override
        public final Builder appBlockBuilder(AppBlockBuilder appBlockBuilder) {
            this.appBlockBuilder = appBlockBuilder;
            return this;
        }

        @Override
        public UpdateAppBlockBuilderResponse build() {
            return new UpdateAppBlockBuilderResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
