/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the capacity for a fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ComputeCapacity implements SdkPojo, Serializable, ToCopyableBuilder<ComputeCapacity.Builder, ComputeCapacity> {
    private static final SdkField<Integer> DESIRED_INSTANCES_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .getter(getter(ComputeCapacity::desiredInstances)).setter(setter(Builder::desiredInstances))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DesiredInstances").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESIRED_INSTANCES_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer desiredInstances;

    private ComputeCapacity(BuilderImpl builder) {
        this.desiredInstances = builder.desiredInstances;
    }

    /**
     * <p>
     * The desired number of streaming instances.
     * </p>
     * 
     * @return The desired number of streaming instances.
     */
    public Integer desiredInstances() {
        return desiredInstances;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(desiredInstances());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ComputeCapacity)) {
            return false;
        }
        ComputeCapacity other = (ComputeCapacity) obj;
        return Objects.equals(desiredInstances(), other.desiredInstances());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ComputeCapacity").add("DesiredInstances", desiredInstances()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "DesiredInstances":
            return Optional.ofNullable(clazz.cast(desiredInstances()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ComputeCapacity, T> g) {
        return obj -> g.apply((ComputeCapacity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ComputeCapacity> {
        /**
         * <p>
         * The desired number of streaming instances.
         * </p>
         * 
         * @param desiredInstances
         *        The desired number of streaming instances.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder desiredInstances(Integer desiredInstances);
    }

    static final class BuilderImpl implements Builder {
        private Integer desiredInstances;

        private BuilderImpl() {
        }

        private BuilderImpl(ComputeCapacity model) {
            desiredInstances(model.desiredInstances);
        }

        public final Integer getDesiredInstances() {
            return desiredInstances;
        }

        @Override
        public final Builder desiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
            return this;
        }

        public final void setDesiredInstances(Integer desiredInstances) {
            this.desiredInstances = desiredInstances;
        }

        @Override
        public ComputeCapacity build() {
            return new ComputeCapacity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
