/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an application in the application catalog.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Application implements SdkPojo, Serializable, ToCopyableBuilder<Application.Builder, Application> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Application::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Application::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()).build();

    private static final SdkField<String> ICON_URL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Application::iconURL)).setter(setter(Builder::iconURL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IconURL").build()).build();

    private static final SdkField<String> LAUNCH_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Application::launchPath)).setter(setter(Builder::launchPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchPath").build()).build();

    private static final SdkField<String> LAUNCH_PARAMETERS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Application::launchParameters)).setter(setter(Builder::launchParameters))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("LaunchParameters").build()).build();

    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(Application::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<Map<String, String>> METADATA_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .getter(getter(Application::metadata))
            .setter(setter(Builder::metadata))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Metadata").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            DISPLAY_NAME_FIELD, ICON_URL_FIELD, LAUNCH_PATH_FIELD, LAUNCH_PARAMETERS_FIELD, ENABLED_FIELD, METADATA_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String displayName;

    private final String iconURL;

    private final String launchPath;

    private final String launchParameters;

    private final Boolean enabled;

    private final Map<String, String> metadata;

    private Application(BuilderImpl builder) {
        this.name = builder.name;
        this.displayName = builder.displayName;
        this.iconURL = builder.iconURL;
        this.launchPath = builder.launchPath;
        this.launchParameters = builder.launchParameters;
        this.enabled = builder.enabled;
        this.metadata = builder.metadata;
    }

    /**
     * <p>
     * The name of the application.
     * </p>
     * 
     * @return The name of the application.
     */
    public String name() {
        return name;
    }

    /**
     * <p>
     * The application name to display.
     * </p>
     * 
     * @return The application name to display.
     */
    public String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The URL for the application icon. This URL might be time-limited.
     * </p>
     * 
     * @return The URL for the application icon. This URL might be time-limited.
     */
    public String iconURL() {
        return iconURL;
    }

    /**
     * <p>
     * The path to the application executable in the instance.
     * </p>
     * 
     * @return The path to the application executable in the instance.
     */
    public String launchPath() {
        return launchPath;
    }

    /**
     * <p>
     * The arguments that are passed to the application at launch.
     * </p>
     * 
     * @return The arguments that are passed to the application at launch.
     */
    public String launchParameters() {
        return launchParameters;
    }

    /**
     * <p>
     * If there is a problem, the application can be disabled after image creation.
     * </p>
     * 
     * @return If there is a problem, the application can be disabled after image creation.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * Additional attributes that describe the application.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return Additional attributes that describe the application.
     */
    public Map<String, String> metadata() {
        return metadata;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(iconURL());
        hashCode = 31 * hashCode + Objects.hashCode(launchPath());
        hashCode = 31 * hashCode + Objects.hashCode(launchParameters());
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(metadata());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Application)) {
            return false;
        }
        Application other = (Application) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(iconURL(), other.iconURL()) && Objects.equals(launchPath(), other.launchPath())
                && Objects.equals(launchParameters(), other.launchParameters()) && Objects.equals(enabled(), other.enabled())
                && Objects.equals(metadata(), other.metadata());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Application").add("Name", name()).add("DisplayName", displayName()).add("IconURL", iconURL())
                .add("LaunchPath", launchPath()).add("LaunchParameters", launchParameters()).add("Enabled", enabled())
                .add("Metadata", metadata()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Name":
            return Optional.ofNullable(clazz.cast(name()));
        case "DisplayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "IconURL":
            return Optional.ofNullable(clazz.cast(iconURL()));
        case "LaunchPath":
            return Optional.ofNullable(clazz.cast(launchPath()));
        case "LaunchParameters":
            return Optional.ofNullable(clazz.cast(launchParameters()));
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "Metadata":
            return Optional.ofNullable(clazz.cast(metadata()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Application, T> g) {
        return obj -> g.apply((Application) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Application> {
        /**
         * <p>
         * The name of the application.
         * </p>
         * 
         * @param name
         *        The name of the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The application name to display.
         * </p>
         * 
         * @param displayName
         *        The application name to display.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The URL for the application icon. This URL might be time-limited.
         * </p>
         * 
         * @param iconURL
         *        The URL for the application icon. This URL might be time-limited.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iconURL(String iconURL);

        /**
         * <p>
         * The path to the application executable in the instance.
         * </p>
         * 
         * @param launchPath
         *        The path to the application executable in the instance.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchPath(String launchPath);

        /**
         * <p>
         * The arguments that are passed to the application at launch.
         * </p>
         * 
         * @param launchParameters
         *        The arguments that are passed to the application at launch.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder launchParameters(String launchParameters);

        /**
         * <p>
         * If there is a problem, the application can be disabled after image creation.
         * </p>
         * 
         * @param enabled
         *        If there is a problem, the application can be disabled after image creation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * Additional attributes that describe the application.
         * </p>
         * 
         * @param metadata
         *        Additional attributes that describe the application.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder metadata(Map<String, String> metadata);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String displayName;

        private String iconURL;

        private String launchPath;

        private String launchParameters;

        private Boolean enabled;

        private Map<String, String> metadata = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(Application model) {
            name(model.name);
            displayName(model.displayName);
            iconURL(model.iconURL);
            launchPath(model.launchPath);
            launchParameters(model.launchParameters);
            enabled(model.enabled);
            metadata(model.metadata);
        }

        public final String getName() {
            return name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDisplayName() {
            return displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final String getIconURL() {
            return iconURL;
        }

        @Override
        public final Builder iconURL(String iconURL) {
            this.iconURL = iconURL;
            return this;
        }

        public final void setIconURL(String iconURL) {
            this.iconURL = iconURL;
        }

        public final String getLaunchPath() {
            return launchPath;
        }

        @Override
        public final Builder launchPath(String launchPath) {
            this.launchPath = launchPath;
            return this;
        }

        public final void setLaunchPath(String launchPath) {
            this.launchPath = launchPath;
        }

        public final String getLaunchParameters() {
            return launchParameters;
        }

        @Override
        public final Builder launchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
            return this;
        }

        public final void setLaunchParameters(String launchParameters) {
            this.launchParameters = launchParameters;
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final Map<String, String> getMetadata() {
            return metadata;
        }

        @Override
        public final Builder metadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
            return this;
        }

        public final void setMetadata(Map<String, String> metadata) {
            this.metadata = MetadataCopier.copy(metadata);
        }

        @Override
        public Application build() {
            return new Application(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
