/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class BatchAssociateUserStackResponse extends AppStreamResponse implements
        ToCopyableBuilder<BatchAssociateUserStackResponse.Builder, BatchAssociateUserStackResponse> {
    private static final SdkField<List<UserStackAssociationError>> ERRORS_FIELD = SdkField
            .<List<UserStackAssociationError>> builder(MarshallingType.LIST)
            .getter(getter(BatchAssociateUserStackResponse::errors))
            .setter(setter(Builder::errors))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("errors").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<UserStackAssociationError> builder(MarshallingType.SDK_POJO)
                                            .constructor(UserStackAssociationError::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERRORS_FIELD));

    private final List<UserStackAssociationError> errors;

    private BatchAssociateUserStackResponse(BuilderImpl builder) {
        super(builder);
        this.errors = builder.errors;
    }

    /**
     * <p>
     * The list of UserStackAssociationError objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * 
     * @return The list of UserStackAssociationError objects.
     */
    public List<UserStackAssociationError> errors() {
        return errors;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errors());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof BatchAssociateUserStackResponse)) {
            return false;
        }
        BatchAssociateUserStackResponse other = (BatchAssociateUserStackResponse) obj;
        return Objects.equals(errors(), other.errors());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("BatchAssociateUserStackResponse").add("Errors", errors()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "errors":
            return Optional.ofNullable(clazz.cast(errors()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<BatchAssociateUserStackResponse, T> g) {
        return obj -> g.apply((BatchAssociateUserStackResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppStreamResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, BatchAssociateUserStackResponse> {
        /**
         * <p>
         * The list of UserStackAssociationError objects.
         * </p>
         * 
         * @param errors
         *        The list of UserStackAssociationError objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(Collection<UserStackAssociationError> errors);

        /**
         * <p>
         * The list of UserStackAssociationError objects.
         * </p>
         * 
         * @param errors
         *        The list of UserStackAssociationError objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder errors(UserStackAssociationError... errors);

        /**
         * <p>
         * The list of UserStackAssociationError objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<UserStackAssociationError>.Builder}
         * avoiding the need to create one manually via {@link List<UserStackAssociationError>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<UserStackAssociationError>.Builder#build()} is called
         * immediately and its result is passed to {@link #errors(List<UserStackAssociationError>)}.
         * 
         * @param errors
         *        a consumer that will call methods on {@link List<UserStackAssociationError>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #errors(List<UserStackAssociationError>)
         */
        Builder errors(Consumer<UserStackAssociationError.Builder>... errors);
    }

    static final class BuilderImpl extends AppStreamResponse.BuilderImpl implements Builder {
        private List<UserStackAssociationError> errors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(BatchAssociateUserStackResponse model) {
            super(model);
            errors(model.errors);
        }

        public final Collection<UserStackAssociationError.Builder> getErrors() {
            return errors != null ? errors.stream().map(UserStackAssociationError::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder errors(Collection<UserStackAssociationError> errors) {
            this.errors = UserStackAssociationErrorListCopier.copy(errors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(UserStackAssociationError... errors) {
            errors(Arrays.asList(errors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder errors(Consumer<UserStackAssociationError.Builder>... errors) {
            errors(Stream.of(errors).map(c -> UserStackAssociationError.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final void setErrors(Collection<UserStackAssociationError.BuilderImpl> errors) {
            this.errors = UserStackAssociationErrorListCopier.copyFromBuilder(errors);
        }

        @Override
        public BatchAssociateUserStackResponse build() {
            return new BatchAssociateUserStackResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
