/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes the credentials for the service account used by the streaming instance to connect to the directory.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceAccountCredentials implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceAccountCredentials.Builder, ServiceAccountCredentials> {
    private static final SdkField<String> ACCOUNT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceAccountCredentials::accountName)).setter(setter(Builder::accountName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountName").build()).build();

    private static final SdkField<String> ACCOUNT_PASSWORD_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ServiceAccountCredentials::accountPassword)).setter(setter(Builder::accountPassword))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccountPassword").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACCOUNT_NAME_FIELD,
            ACCOUNT_PASSWORD_FIELD));

    private static final long serialVersionUID = 1L;

    private final String accountName;

    private final String accountPassword;

    private ServiceAccountCredentials(BuilderImpl builder) {
        this.accountName = builder.accountName;
        this.accountPassword = builder.accountPassword;
    }

    /**
     * <p>
     * The user name of the account. This account must have the following privileges: create computer objects, join
     * computers to the domain, and change/reset the password on descendant computer objects for the organizational
     * units specified.
     * </p>
     * 
     * @return The user name of the account. This account must have the following privileges: create computer objects,
     *         join computers to the domain, and change/reset the password on descendant computer objects for the
     *         organizational units specified.
     */
    public String accountName() {
        return accountName;
    }

    /**
     * <p>
     * The password for the account.
     * </p>
     * 
     * @return The password for the account.
     */
    public String accountPassword() {
        return accountPassword;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(accountName());
        hashCode = 31 * hashCode + Objects.hashCode(accountPassword());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceAccountCredentials)) {
            return false;
        }
        ServiceAccountCredentials other = (ServiceAccountCredentials) obj;
        return Objects.equals(accountName(), other.accountName()) && Objects.equals(accountPassword(), other.accountPassword());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ServiceAccountCredentials")
                .add("AccountName", accountName() == null ? null : "*** Sensitive Data Redacted ***")
                .add("AccountPassword", accountPassword() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "AccountName":
            return Optional.ofNullable(clazz.cast(accountName()));
        case "AccountPassword":
            return Optional.ofNullable(clazz.cast(accountPassword()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ServiceAccountCredentials, T> g) {
        return obj -> g.apply((ServiceAccountCredentials) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceAccountCredentials> {
        /**
         * <p>
         * The user name of the account. This account must have the following privileges: create computer objects, join
         * computers to the domain, and change/reset the password on descendant computer objects for the organizational
         * units specified.
         * </p>
         * 
         * @param accountName
         *        The user name of the account. This account must have the following privileges: create computer
         *        objects, join computers to the domain, and change/reset the password on descendant computer objects
         *        for the organizational units specified.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountName(String accountName);

        /**
         * <p>
         * The password for the account.
         * </p>
         * 
         * @param accountPassword
         *        The password for the account.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder accountPassword(String accountPassword);
    }

    static final class BuilderImpl implements Builder {
        private String accountName;

        private String accountPassword;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceAccountCredentials model) {
            accountName(model.accountName);
            accountPassword(model.accountPassword);
        }

        public final String getAccountName() {
            return accountName;
        }

        @Override
        public final Builder accountName(String accountName) {
            this.accountName = accountName;
            return this;
        }

        public final void setAccountName(String accountName) {
            this.accountName = accountName;
        }

        public final String getAccountPassword() {
            return accountPassword;
        }

        @Override
        public final Builder accountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
            return this;
        }

        public final void setAccountPassword(String accountPassword) {
            this.accountPassword = accountPassword;
        }

        @Override
        public ServiceAccountCredentials build() {
            return new ServiceAccountCredentials(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
