/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The persistent application settings for users of a stack.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApplicationSettings implements SdkPojo, Serializable,
        ToCopyableBuilder<ApplicationSettings.Builder, ApplicationSettings> {
    private static final SdkField<Boolean> ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .getter(getter(ApplicationSettings::enabled)).setter(setter(Builder::enabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Enabled").build()).build();

    private static final SdkField<String> SETTINGS_GROUP_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(ApplicationSettings::settingsGroup)).setter(setter(Builder::settingsGroup))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SettingsGroup").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ENABLED_FIELD,
            SETTINGS_GROUP_FIELD));

    private static final long serialVersionUID = 1L;

    private final Boolean enabled;

    private final String settingsGroup;

    private ApplicationSettings(BuilderImpl builder) {
        this.enabled = builder.enabled;
        this.settingsGroup = builder.settingsGroup;
    }

    /**
     * <p>
     * Enables or disables persistent application settings for users during their streaming sessions.
     * </p>
     * 
     * @return Enables or disables persistent application settings for users during their streaming sessions.
     */
    public Boolean enabled() {
        return enabled;
    }

    /**
     * <p>
     * The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the same
     * persistent application settings to be used across multiple stacks by specifying the same settings group for each
     * stack.
     * </p>
     * 
     * @return The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow
     *         the same persistent application settings to be used across multiple stacks by specifying the same
     *         settings group for each stack.
     */
    public String settingsGroup() {
        return settingsGroup;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(enabled());
        hashCode = 31 * hashCode + Objects.hashCode(settingsGroup());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApplicationSettings)) {
            return false;
        }
        ApplicationSettings other = (ApplicationSettings) obj;
        return Objects.equals(enabled(), other.enabled()) && Objects.equals(settingsGroup(), other.settingsGroup());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("ApplicationSettings").add("Enabled", enabled()).add("SettingsGroup", settingsGroup()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Enabled":
            return Optional.ofNullable(clazz.cast(enabled()));
        case "SettingsGroup":
            return Optional.ofNullable(clazz.cast(settingsGroup()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApplicationSettings, T> g) {
        return obj -> g.apply((ApplicationSettings) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApplicationSettings> {
        /**
         * <p>
         * Enables or disables persistent application settings for users during their streaming sessions.
         * </p>
         * 
         * @param enabled
         *        Enables or disables persistent application settings for users during their streaming sessions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enabled(Boolean enabled);

        /**
         * <p>
         * The path prefix for the S3 bucket where users’ persistent application settings are stored. You can allow the
         * same persistent application settings to be used across multiple stacks by specifying the same settings group
         * for each stack.
         * </p>
         * 
         * @param settingsGroup
         *        The path prefix for the S3 bucket where users’ persistent application settings are stored. You can
         *        allow the same persistent application settings to be used across multiple stacks by specifying the
         *        same settings group for each stack.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder settingsGroup(String settingsGroup);
    }

    static final class BuilderImpl implements Builder {
        private Boolean enabled;

        private String settingsGroup;

        private BuilderImpl() {
        }

        private BuilderImpl(ApplicationSettings model) {
            enabled(model.enabled);
            settingsGroup(model.settingsGroup);
        }

        public final Boolean getEnabled() {
            return enabled;
        }

        @Override
        public final Builder enabled(Boolean enabled) {
            this.enabled = enabled;
            return this;
        }

        public final void setEnabled(Boolean enabled) {
            this.enabled = enabled;
        }

        public final String getSettingsGroup() {
            return settingsGroup;
        }

        @Override
        public final Builder settingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
            return this;
        }

        public final void setSettingsGroup(String settingsGroup) {
            this.settingsGroup = settingsGroup;
        }

        @Override
        public ApplicationSettings build() {
            return new ApplicationSettings(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
