/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ComputeCapacity;
import software.amazon.awssdk.services.appstream.model.DomainJoinInfo;
import software.amazon.awssdk.services.appstream.model.FleetType;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.services.appstream.model.VpcConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateFleetRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateFleetRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFleetRequest.getter(CreateFleetRequest::name)).setter(CreateFleetRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> IMAGE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFleetRequest.getter(CreateFleetRequest::imageName)).setter(CreateFleetRequest.setter(Builder::imageName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageName").build()}).build();
    private static final SdkField<String> IMAGE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFleetRequest.getter(CreateFleetRequest::imageArn)).setter(CreateFleetRequest.setter(Builder::imageArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ImageArn").build()}).build();
    private static final SdkField<String> INSTANCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFleetRequest.getter(CreateFleetRequest::instanceType)).setter(CreateFleetRequest.setter(Builder::instanceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("InstanceType").build()}).build();
    private static final SdkField<String> FLEET_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFleetRequest.getter(CreateFleetRequest::fleetTypeAsString)).setter(CreateFleetRequest.setter(Builder::fleetType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetType").build()}).build();
    private static final SdkField<ComputeCapacity> COMPUTE_CAPACITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateFleetRequest.getter(CreateFleetRequest::computeCapacity)).setter(CreateFleetRequest.setter(Builder::computeCapacity)).constructor(ComputeCapacity::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ComputeCapacity").build()}).build();
    private static final SdkField<VpcConfig> VPC_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateFleetRequest.getter(CreateFleetRequest::vpcConfig)).setter(CreateFleetRequest.setter(Builder::vpcConfig)).constructor(VpcConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VpcConfig").build()}).build();
    private static final SdkField<Integer> MAX_USER_DURATION_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateFleetRequest.getter(CreateFleetRequest::maxUserDurationInSeconds)).setter(CreateFleetRequest.setter(Builder::maxUserDurationInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxUserDurationInSeconds").build()}).build();
    private static final SdkField<Integer> DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateFleetRequest.getter(CreateFleetRequest::disconnectTimeoutInSeconds)).setter(CreateFleetRequest.setter(Builder::disconnectTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisconnectTimeoutInSeconds").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFleetRequest.getter(CreateFleetRequest::description)).setter(CreateFleetRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateFleetRequest.getter(CreateFleetRequest::displayName)).setter(CreateFleetRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<Boolean> ENABLE_DEFAULT_INTERNET_ACCESS_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).getter(CreateFleetRequest.getter(CreateFleetRequest::enableDefaultInternetAccess)).setter(CreateFleetRequest.setter(Builder::enableDefaultInternetAccess)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("EnableDefaultInternetAccess").build()}).build();
    private static final SdkField<DomainJoinInfo> DOMAIN_JOIN_INFO_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateFleetRequest.getter(CreateFleetRequest::domainJoinInfo)).setter(CreateFleetRequest.setter(Builder::domainJoinInfo)).constructor(DomainJoinInfo::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DomainJoinInfo").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateFleetRequest.getter(CreateFleetRequest::tags)).setter(CreateFleetRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<Integer> IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).getter(CreateFleetRequest.getter(CreateFleetRequest::idleDisconnectTimeoutInSeconds)).setter(CreateFleetRequest.setter(Builder::idleDisconnectTimeoutInSeconds)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("IdleDisconnectTimeoutInSeconds").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, IMAGE_NAME_FIELD, IMAGE_ARN_FIELD, INSTANCE_TYPE_FIELD, FLEET_TYPE_FIELD, COMPUTE_CAPACITY_FIELD, VPC_CONFIG_FIELD, MAX_USER_DURATION_IN_SECONDS_FIELD, DISCONNECT_TIMEOUT_IN_SECONDS_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, ENABLE_DEFAULT_INTERNET_ACCESS_FIELD, DOMAIN_JOIN_INFO_FIELD, TAGS_FIELD, IDLE_DISCONNECT_TIMEOUT_IN_SECONDS_FIELD));
    private final String name;
    private final String imageName;
    private final String imageArn;
    private final String instanceType;
    private final String fleetType;
    private final ComputeCapacity computeCapacity;
    private final VpcConfig vpcConfig;
    private final Integer maxUserDurationInSeconds;
    private final Integer disconnectTimeoutInSeconds;
    private final String description;
    private final String displayName;
    private final Boolean enableDefaultInternetAccess;
    private final DomainJoinInfo domainJoinInfo;
    private final Map<String, String> tags;
    private final Integer idleDisconnectTimeoutInSeconds;

    private CreateFleetRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.imageName = builder.imageName;
        this.imageArn = builder.imageArn;
        this.instanceType = builder.instanceType;
        this.fleetType = builder.fleetType;
        this.computeCapacity = builder.computeCapacity;
        this.vpcConfig = builder.vpcConfig;
        this.maxUserDurationInSeconds = builder.maxUserDurationInSeconds;
        this.disconnectTimeoutInSeconds = builder.disconnectTimeoutInSeconds;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.enableDefaultInternetAccess = builder.enableDefaultInternetAccess;
        this.domainJoinInfo = builder.domainJoinInfo;
        this.tags = builder.tags;
        this.idleDisconnectTimeoutInSeconds = builder.idleDisconnectTimeoutInSeconds;
    }

    public String name() {
        return this.name;
    }

    public String imageName() {
        return this.imageName;
    }

    public String imageArn() {
        return this.imageArn;
    }

    public String instanceType() {
        return this.instanceType;
    }

    public FleetType fleetType() {
        return FleetType.fromValue(this.fleetType);
    }

    public String fleetTypeAsString() {
        return this.fleetType;
    }

    public ComputeCapacity computeCapacity() {
        return this.computeCapacity;
    }

    public VpcConfig vpcConfig() {
        return this.vpcConfig;
    }

    public Integer maxUserDurationInSeconds() {
        return this.maxUserDurationInSeconds;
    }

    public Integer disconnectTimeoutInSeconds() {
        return this.disconnectTimeoutInSeconds;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public Boolean enableDefaultInternetAccess() {
        return this.enableDefaultInternetAccess;
    }

    public DomainJoinInfo domainJoinInfo() {
        return this.domainJoinInfo;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public Integer idleDisconnectTimeoutInSeconds() {
        return this.idleDisconnectTimeoutInSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageName());
        hashCode = 31 * hashCode + Objects.hashCode(this.imageArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceType());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.computeCapacity());
        hashCode = 31 * hashCode + Objects.hashCode(this.vpcConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxUserDurationInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.disconnectTimeoutInSeconds());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.enableDefaultInternetAccess());
        hashCode = 31 * hashCode + Objects.hashCode(this.domainJoinInfo());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.idleDisconnectTimeoutInSeconds());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFleetRequest)) {
            return false;
        }
        CreateFleetRequest other = (CreateFleetRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.imageName(), other.imageName()) && Objects.equals(this.imageArn(), other.imageArn()) && Objects.equals(this.instanceType(), other.instanceType()) && Objects.equals(this.fleetTypeAsString(), other.fleetTypeAsString()) && Objects.equals(this.computeCapacity(), other.computeCapacity()) && Objects.equals(this.vpcConfig(), other.vpcConfig()) && Objects.equals(this.maxUserDurationInSeconds(), other.maxUserDurationInSeconds()) && Objects.equals(this.disconnectTimeoutInSeconds(), other.disconnectTimeoutInSeconds()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.enableDefaultInternetAccess(), other.enableDefaultInternetAccess()) && Objects.equals(this.domainJoinInfo(), other.domainJoinInfo()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.idleDisconnectTimeoutInSeconds(), other.idleDisconnectTimeoutInSeconds());
    }

    public String toString() {
        return ToString.builder((String)"CreateFleetRequest").add("Name", (Object)this.name()).add("ImageName", (Object)this.imageName()).add("ImageArn", (Object)this.imageArn()).add("InstanceType", (Object)this.instanceType()).add("FleetType", (Object)this.fleetTypeAsString()).add("ComputeCapacity", (Object)this.computeCapacity()).add("VpcConfig", (Object)this.vpcConfig()).add("MaxUserDurationInSeconds", (Object)this.maxUserDurationInSeconds()).add("DisconnectTimeoutInSeconds", (Object)this.disconnectTimeoutInSeconds()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("EnableDefaultInternetAccess", (Object)this.enableDefaultInternetAccess()).add("DomainJoinInfo", (Object)this.domainJoinInfo()).add("Tags", this.tags()).add("IdleDisconnectTimeoutInSeconds", (Object)this.idleDisconnectTimeoutInSeconds()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "ImageName": {
                return Optional.ofNullable(clazz.cast(this.imageName()));
            }
            case "ImageArn": {
                return Optional.ofNullable(clazz.cast(this.imageArn()));
            }
            case "InstanceType": {
                return Optional.ofNullable(clazz.cast(this.instanceType()));
            }
            case "FleetType": {
                return Optional.ofNullable(clazz.cast(this.fleetTypeAsString()));
            }
            case "ComputeCapacity": {
                return Optional.ofNullable(clazz.cast(this.computeCapacity()));
            }
            case "VpcConfig": {
                return Optional.ofNullable(clazz.cast(this.vpcConfig()));
            }
            case "MaxUserDurationInSeconds": {
                return Optional.ofNullable(clazz.cast(this.maxUserDurationInSeconds()));
            }
            case "DisconnectTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.disconnectTimeoutInSeconds()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "EnableDefaultInternetAccess": {
                return Optional.ofNullable(clazz.cast(this.enableDefaultInternetAccess()));
            }
            case "DomainJoinInfo": {
                return Optional.ofNullable(clazz.cast(this.domainJoinInfo()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "IdleDisconnectTimeoutInSeconds": {
                return Optional.ofNullable(clazz.cast(this.idleDisconnectTimeoutInSeconds()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFleetRequest, T> g) {
        return obj -> g.apply((CreateFleetRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String imageName;
        private String imageArn;
        private String instanceType;
        private String fleetType;
        private ComputeCapacity computeCapacity;
        private VpcConfig vpcConfig;
        private Integer maxUserDurationInSeconds;
        private Integer disconnectTimeoutInSeconds;
        private String description;
        private String displayName;
        private Boolean enableDefaultInternetAccess;
        private DomainJoinInfo domainJoinInfo;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private Integer idleDisconnectTimeoutInSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFleetRequest model) {
            super(model);
            this.name(model.name);
            this.imageName(model.imageName);
            this.imageArn(model.imageArn);
            this.instanceType(model.instanceType);
            this.fleetType(model.fleetType);
            this.computeCapacity(model.computeCapacity);
            this.vpcConfig(model.vpcConfig);
            this.maxUserDurationInSeconds(model.maxUserDurationInSeconds);
            this.disconnectTimeoutInSeconds(model.disconnectTimeoutInSeconds);
            this.description(model.description);
            this.displayName(model.displayName);
            this.enableDefaultInternetAccess(model.enableDefaultInternetAccess);
            this.domainJoinInfo(model.domainJoinInfo);
            this.tags(model.tags);
            this.idleDisconnectTimeoutInSeconds(model.idleDisconnectTimeoutInSeconds);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getImageName() {
            return this.imageName;
        }

        @Override
        public final Builder imageName(String imageName) {
            this.imageName = imageName;
            return this;
        }

        public final void setImageName(String imageName) {
            this.imageName = imageName;
        }

        public final String getImageArn() {
            return this.imageArn;
        }

        @Override
        public final Builder imageArn(String imageArn) {
            this.imageArn = imageArn;
            return this;
        }

        public final void setImageArn(String imageArn) {
            this.imageArn = imageArn;
        }

        public final String getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final Builder instanceType(String instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        public final void setInstanceType(String instanceType) {
            this.instanceType = instanceType;
        }

        public final String getFleetTypeAsString() {
            return this.fleetType;
        }

        @Override
        public final Builder fleetType(String fleetType) {
            this.fleetType = fleetType;
            return this;
        }

        @Override
        public final Builder fleetType(FleetType fleetType) {
            this.fleetType(fleetType == null ? null : fleetType.toString());
            return this;
        }

        public final void setFleetType(String fleetType) {
            this.fleetType = fleetType;
        }

        public final ComputeCapacity.Builder getComputeCapacity() {
            return this.computeCapacity != null ? this.computeCapacity.toBuilder() : null;
        }

        @Override
        public final Builder computeCapacity(ComputeCapacity computeCapacity) {
            this.computeCapacity = computeCapacity;
            return this;
        }

        public final void setComputeCapacity(ComputeCapacity.BuilderImpl computeCapacity) {
            this.computeCapacity = computeCapacity != null ? computeCapacity.build() : null;
        }

        public final VpcConfig.Builder getVpcConfig() {
            return this.vpcConfig != null ? this.vpcConfig.toBuilder() : null;
        }

        @Override
        public final Builder vpcConfig(VpcConfig vpcConfig) {
            this.vpcConfig = vpcConfig;
            return this;
        }

        public final void setVpcConfig(VpcConfig.BuilderImpl vpcConfig) {
            this.vpcConfig = vpcConfig != null ? vpcConfig.build() : null;
        }

        public final Integer getMaxUserDurationInSeconds() {
            return this.maxUserDurationInSeconds;
        }

        @Override
        public final Builder maxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
            return this;
        }

        public final void setMaxUserDurationInSeconds(Integer maxUserDurationInSeconds) {
            this.maxUserDurationInSeconds = maxUserDurationInSeconds;
        }

        public final Integer getDisconnectTimeoutInSeconds() {
            return this.disconnectTimeoutInSeconds;
        }

        @Override
        public final Builder disconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
            return this;
        }

        public final void setDisconnectTimeoutInSeconds(Integer disconnectTimeoutInSeconds) {
            this.disconnectTimeoutInSeconds = disconnectTimeoutInSeconds;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Boolean getEnableDefaultInternetAccess() {
            return this.enableDefaultInternetAccess;
        }

        @Override
        public final Builder enableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
            return this;
        }

        public final void setEnableDefaultInternetAccess(Boolean enableDefaultInternetAccess) {
            this.enableDefaultInternetAccess = enableDefaultInternetAccess;
        }

        public final DomainJoinInfo.Builder getDomainJoinInfo() {
            return this.domainJoinInfo != null ? this.domainJoinInfo.toBuilder() : null;
        }

        @Override
        public final Builder domainJoinInfo(DomainJoinInfo domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo;
            return this;
        }

        public final void setDomainJoinInfo(DomainJoinInfo.BuilderImpl domainJoinInfo) {
            this.domainJoinInfo = domainJoinInfo != null ? domainJoinInfo.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Integer getIdleDisconnectTimeoutInSeconds() {
            return this.idleDisconnectTimeoutInSeconds;
        }

        @Override
        public final Builder idleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
            return this;
        }

        public final void setIdleDisconnectTimeoutInSeconds(Integer idleDisconnectTimeoutInSeconds) {
            this.idleDisconnectTimeoutInSeconds = idleDisconnectTimeoutInSeconds;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFleetRequest build() {
            return new CreateFleetRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateFleetRequest> {
        public Builder name(String var1);

        public Builder imageName(String var1);

        public Builder imageArn(String var1);

        public Builder instanceType(String var1);

        public Builder fleetType(String var1);

        public Builder fleetType(FleetType var1);

        public Builder computeCapacity(ComputeCapacity var1);

        default public Builder computeCapacity(Consumer<ComputeCapacity.Builder> computeCapacity) {
            return this.computeCapacity((ComputeCapacity)((ComputeCapacity.Builder)ComputeCapacity.builder().applyMutation(computeCapacity)).build());
        }

        public Builder vpcConfig(VpcConfig var1);

        default public Builder vpcConfig(Consumer<VpcConfig.Builder> vpcConfig) {
            return this.vpcConfig((VpcConfig)((VpcConfig.Builder)VpcConfig.builder().applyMutation(vpcConfig)).build());
        }

        public Builder maxUserDurationInSeconds(Integer var1);

        public Builder disconnectTimeoutInSeconds(Integer var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder enableDefaultInternetAccess(Boolean var1);

        public Builder domainJoinInfo(DomainJoinInfo var1);

        default public Builder domainJoinInfo(Consumer<DomainJoinInfo.Builder> domainJoinInfo) {
            return this.domainJoinInfo((DomainJoinInfo)((DomainJoinInfo.Builder)DomainJoinInfo.builder().applyMutation(domainJoinInfo)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder idleDisconnectTimeoutInSeconds(Integer var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

