/*
 * Copyright 2014-2019 Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appstream.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a streaming session.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Session implements SdkPojo, Serializable, ToCopyableBuilder<Session.Builder, Session> {
    private static final SdkField<String> ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::id)).setter(setter(Builder::id))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Id").build()).build();

    private static final SdkField<String> USER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::userId)).setter(setter(Builder::userId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserId").build()).build();

    private static final SdkField<String> STACK_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::stackName)).setter(setter(Builder::stackName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StackName").build()).build();

    private static final SdkField<String> FLEET_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::fleetName)).setter(setter(Builder::fleetName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FleetName").build()).build();

    private static final SdkField<String> STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::stateAsString)).setter(setter(Builder::state))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("State").build()).build();

    private static final SdkField<String> CONNECTION_STATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::connectionStateAsString)).setter(setter(Builder::connectionState))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ConnectionState").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Session::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StartTime").build()).build();

    private static final SdkField<Instant> MAX_EXPIRATION_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .getter(getter(Session::maxExpirationTime)).setter(setter(Builder::maxExpirationTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("MaxExpirationTime").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .getter(getter(Session::authenticationTypeAsString)).setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AuthenticationType").build())
            .build();

    private static final SdkField<NetworkAccessConfiguration> NETWORK_ACCESS_CONFIGURATION_FIELD = SdkField
            .<NetworkAccessConfiguration> builder(MarshallingType.SDK_POJO)
            .getter(getter(Session::networkAccessConfiguration))
            .setter(setter(Builder::networkAccessConfiguration))
            .constructor(NetworkAccessConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkAccessConfiguration").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ID_FIELD, USER_ID_FIELD,
            STACK_NAME_FIELD, FLEET_NAME_FIELD, STATE_FIELD, CONNECTION_STATE_FIELD, START_TIME_FIELD, MAX_EXPIRATION_TIME_FIELD,
            AUTHENTICATION_TYPE_FIELD, NETWORK_ACCESS_CONFIGURATION_FIELD));

    private static final long serialVersionUID = 1L;

    private final String id;

    private final String userId;

    private final String stackName;

    private final String fleetName;

    private final String state;

    private final String connectionState;

    private final Instant startTime;

    private final Instant maxExpirationTime;

    private final String authenticationType;

    private final NetworkAccessConfiguration networkAccessConfiguration;

    private Session(BuilderImpl builder) {
        this.id = builder.id;
        this.userId = builder.userId;
        this.stackName = builder.stackName;
        this.fleetName = builder.fleetName;
        this.state = builder.state;
        this.connectionState = builder.connectionState;
        this.startTime = builder.startTime;
        this.maxExpirationTime = builder.maxExpirationTime;
        this.authenticationType = builder.authenticationType;
        this.networkAccessConfiguration = builder.networkAccessConfiguration;
    }

    /**
     * <p>
     * The identifier of the streaming session.
     * </p>
     * 
     * @return The identifier of the streaming session.
     */
    public String id() {
        return id;
    }

    /**
     * <p>
     * The identifier of the user for whom the session was created.
     * </p>
     * 
     * @return The identifier of the user for whom the session was created.
     */
    public String userId() {
        return userId;
    }

    /**
     * <p>
     * The name of the stack for the streaming session.
     * </p>
     * 
     * @return The name of the stack for the streaming session.
     */
    public String stackName() {
        return stackName;
    }

    /**
     * <p>
     * The name of the fleet for the streaming session.
     * </p>
     * 
     * @return The name of the fleet for the streaming session.
     */
    public String fleetName() {
        return fleetName;
    }

    /**
     * <p>
     * The current state of the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the streaming session.
     * @see SessionState
     */
    public SessionState state() {
        return SessionState.fromValue(state);
    }

    /**
     * <p>
     * The current state of the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #state} will return
     * {@link SessionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stateAsString}.
     * </p>
     * 
     * @return The current state of the streaming session.
     * @see SessionState
     */
    public String stateAsString() {
        return state;
    }

    /**
     * <p>
     * Specifies whether a user is connected to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link SessionConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return Specifies whether a user is connected to the streaming session.
     * @see SessionConnectionState
     */
    public SessionConnectionState connectionState() {
        return SessionConnectionState.fromValue(connectionState);
    }

    /**
     * <p>
     * Specifies whether a user is connected to the streaming session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #connectionState}
     * will return {@link SessionConnectionState#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #connectionStateAsString}.
     * </p>
     * 
     * @return Specifies whether a user is connected to the streaming session.
     * @see SessionConnectionState
     */
    public String connectionStateAsString() {
        return connectionState;
    }

    /**
     * <p>
     * The time when a streaming instance is dedicated for the user.
     * </p>
     * 
     * @return The time when a streaming instance is dedicated for the user.
     */
    public Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The time when the streaming session is set to expire. This time is based on the
     * <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a streaming session
     * can run. A streaming session might end earlier than the time specified in <code>SessionMaxExpirationTime</code>,
     * when the <code>DisconnectTimeOutInSeconds</code> elapses or the user chooses to end his or her session. If the
     * <code>DisconnectTimeOutInSeconds</code> elapses, or the user chooses to end his or her session, the streaming
     * instance is terminated and the streaming session ends.
     * </p>
     * 
     * @return The time when the streaming session is set to expire. This time is based on the
     *         <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a streaming
     *         session can run. A streaming session might end earlier than the time specified in
     *         <code>SessionMaxExpirationTime</code>, when the <code>DisconnectTimeOutInSeconds</code> elapses or the
     *         user chooses to end his or her session. If the <code>DisconnectTimeOutInSeconds</code> elapses, or the
     *         user chooses to end his or her session, the streaming instance is terminated and the streaming session
     *         ends.
     */
    public Instant maxExpirationTime() {
        return maxExpirationTime;
    }

    /**
     * <p>
     * The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML 2.0
     * federation (<code>SAML</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML 2.0
     *         federation (<code>SAML</code>).
     * @see AuthenticationType
     */
    public AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML 2.0
     * federation (<code>SAML</code>).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML 2.0
     *         federation (<code>SAML</code>).
     * @see AuthenticationType
     */
    public String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The network details for the streaming session.
     * </p>
     * 
     * @return The network details for the streaming session.
     */
    public NetworkAccessConfiguration networkAccessConfiguration() {
        return networkAccessConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(id());
        hashCode = 31 * hashCode + Objects.hashCode(userId());
        hashCode = 31 * hashCode + Objects.hashCode(stackName());
        hashCode = 31 * hashCode + Objects.hashCode(fleetName());
        hashCode = 31 * hashCode + Objects.hashCode(stateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(connectionStateAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(maxExpirationTime());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(networkAccessConfiguration());
        return hashCode;
    }

    @Override
    public boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Session)) {
            return false;
        }
        Session other = (Session) obj;
        return Objects.equals(id(), other.id()) && Objects.equals(userId(), other.userId())
                && Objects.equals(stackName(), other.stackName()) && Objects.equals(fleetName(), other.fleetName())
                && Objects.equals(stateAsString(), other.stateAsString())
                && Objects.equals(connectionStateAsString(), other.connectionStateAsString())
                && Objects.equals(startTime(), other.startTime())
                && Objects.equals(maxExpirationTime(), other.maxExpirationTime())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(networkAccessConfiguration(), other.networkAccessConfiguration());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public String toString() {
        return ToString.builder("Session").add("Id", id()).add("UserId", userId()).add("StackName", stackName())
                .add("FleetName", fleetName()).add("State", stateAsString()).add("ConnectionState", connectionStateAsString())
                .add("StartTime", startTime()).add("MaxExpirationTime", maxExpirationTime())
                .add("AuthenticationType", authenticationTypeAsString())
                .add("NetworkAccessConfiguration", networkAccessConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "Id":
            return Optional.ofNullable(clazz.cast(id()));
        case "UserId":
            return Optional.ofNullable(clazz.cast(userId()));
        case "StackName":
            return Optional.ofNullable(clazz.cast(stackName()));
        case "FleetName":
            return Optional.ofNullable(clazz.cast(fleetName()));
        case "State":
            return Optional.ofNullable(clazz.cast(stateAsString()));
        case "ConnectionState":
            return Optional.ofNullable(clazz.cast(connectionStateAsString()));
        case "StartTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "MaxExpirationTime":
            return Optional.ofNullable(clazz.cast(maxExpirationTime()));
        case "AuthenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "NetworkAccessConfiguration":
            return Optional.ofNullable(clazz.cast(networkAccessConfiguration()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Session, T> g) {
        return obj -> g.apply((Session) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Session> {
        /**
         * <p>
         * The identifier of the streaming session.
         * </p>
         * 
         * @param id
         *        The identifier of the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder id(String id);

        /**
         * <p>
         * The identifier of the user for whom the session was created.
         * </p>
         * 
         * @param userId
         *        The identifier of the user for whom the session was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userId(String userId);

        /**
         * <p>
         * The name of the stack for the streaming session.
         * </p>
         * 
         * @param stackName
         *        The name of the stack for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stackName(String stackName);

        /**
         * <p>
         * The name of the fleet for the streaming session.
         * </p>
         * 
         * @param fleetName
         *        The name of the fleet for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetName(String fleetName);

        /**
         * <p>
         * The current state of the streaming session.
         * </p>
         * 
         * @param state
         *        The current state of the streaming session.
         * @see SessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionState
         */
        Builder state(String state);

        /**
         * <p>
         * The current state of the streaming session.
         * </p>
         * 
         * @param state
         *        The current state of the streaming session.
         * @see SessionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionState
         */
        Builder state(SessionState state);

        /**
         * <p>
         * Specifies whether a user is connected to the streaming session.
         * </p>
         * 
         * @param connectionState
         *        Specifies whether a user is connected to the streaming session.
         * @see SessionConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionConnectionState
         */
        Builder connectionState(String connectionState);

        /**
         * <p>
         * Specifies whether a user is connected to the streaming session.
         * </p>
         * 
         * @param connectionState
         *        Specifies whether a user is connected to the streaming session.
         * @see SessionConnectionState
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionConnectionState
         */
        Builder connectionState(SessionConnectionState connectionState);

        /**
         * <p>
         * The time when a streaming instance is dedicated for the user.
         * </p>
         * 
         * @param startTime
         *        The time when a streaming instance is dedicated for the user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The time when the streaming session is set to expire. This time is based on the
         * <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a streaming
         * session can run. A streaming session might end earlier than the time specified in
         * <code>SessionMaxExpirationTime</code>, when the <code>DisconnectTimeOutInSeconds</code> elapses or the user
         * chooses to end his or her session. If the <code>DisconnectTimeOutInSeconds</code> elapses, or the user
         * chooses to end his or her session, the streaming instance is terminated and the streaming session ends.
         * </p>
         * 
         * @param maxExpirationTime
         *        The time when the streaming session is set to expire. This time is based on the
         *        <code>MaxUserDurationinSeconds</code> value, which determines the maximum length of time that a
         *        streaming session can run. A streaming session might end earlier than the time specified in
         *        <code>SessionMaxExpirationTime</code>, when the <code>DisconnectTimeOutInSeconds</code> elapses or the
         *        user chooses to end his or her session. If the <code>DisconnectTimeOutInSeconds</code> elapses, or the
         *        user chooses to end his or her session, the streaming instance is terminated and the streaming session
         *        ends.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxExpirationTime(Instant maxExpirationTime);

        /**
         * <p>
         * The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML 2.0
         * federation (<code>SAML</code>).
         * </p>
         * 
         * @param authenticationType
         *        The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML
         *        2.0 federation (<code>SAML</code>).
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML 2.0
         * federation (<code>SAML</code>).
         * </p>
         * 
         * @param authenticationType
         *        The authentication method. The user is authenticated using a streaming URL (<code>API</code>) or SAML
         *        2.0 federation (<code>SAML</code>).
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The network details for the streaming session.
         * </p>
         * 
         * @param networkAccessConfiguration
         *        The network details for the streaming session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder networkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration);

        /**
         * <p>
         * The network details for the streaming session.
         * </p>
         * This is a convenience that creates an instance of the {@link NetworkAccessConfiguration.Builder} avoiding the
         * need to create one manually via {@link NetworkAccessConfiguration#builder()}.
         *
         * When the {@link Consumer} completes, {@link NetworkAccessConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #networkAccessConfiguration(NetworkAccessConfiguration)}.
         * 
         * @param networkAccessConfiguration
         *        a consumer that will call methods on {@link NetworkAccessConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #networkAccessConfiguration(NetworkAccessConfiguration)
         */
        default Builder networkAccessConfiguration(Consumer<NetworkAccessConfiguration.Builder> networkAccessConfiguration) {
            return networkAccessConfiguration(NetworkAccessConfiguration.builder().applyMutation(networkAccessConfiguration)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String id;

        private String userId;

        private String stackName;

        private String fleetName;

        private String state;

        private String connectionState;

        private Instant startTime;

        private Instant maxExpirationTime;

        private String authenticationType;

        private NetworkAccessConfiguration networkAccessConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(Session model) {
            id(model.id);
            userId(model.userId);
            stackName(model.stackName);
            fleetName(model.fleetName);
            state(model.state);
            connectionState(model.connectionState);
            startTime(model.startTime);
            maxExpirationTime(model.maxExpirationTime);
            authenticationType(model.authenticationType);
            networkAccessConfiguration(model.networkAccessConfiguration);
        }

        public final String getId() {
            return id;
        }

        @Override
        public final Builder id(String id) {
            this.id = id;
            return this;
        }

        public final void setId(String id) {
            this.id = id;
        }

        public final String getUserId() {
            return userId;
        }

        @Override
        public final Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public final void setUserId(String userId) {
            this.userId = userId;
        }

        public final String getStackName() {
            return stackName;
        }

        @Override
        public final Builder stackName(String stackName) {
            this.stackName = stackName;
            return this;
        }

        public final void setStackName(String stackName) {
            this.stackName = stackName;
        }

        public final String getFleetName() {
            return fleetName;
        }

        @Override
        public final Builder fleetName(String fleetName) {
            this.fleetName = fleetName;
            return this;
        }

        public final void setFleetName(String fleetName) {
            this.fleetName = fleetName;
        }

        public final String getStateAsString() {
            return state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(SessionState state) {
            this.state(state.toString());
            return this;
        }

        public final void setState(String state) {
            this.state = state;
        }

        public final String getConnectionStateAsString() {
            return connectionState;
        }

        @Override
        public final Builder connectionState(String connectionState) {
            this.connectionState = connectionState;
            return this;
        }

        @Override
        public final Builder connectionState(SessionConnectionState connectionState) {
            this.connectionState(connectionState.toString());
            return this;
        }

        public final void setConnectionState(String connectionState) {
            this.connectionState = connectionState;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        public final Instant getMaxExpirationTime() {
            return maxExpirationTime;
        }

        @Override
        public final Builder maxExpirationTime(Instant maxExpirationTime) {
            this.maxExpirationTime = maxExpirationTime;
            return this;
        }

        public final void setMaxExpirationTime(Instant maxExpirationTime) {
            this.maxExpirationTime = maxExpirationTime;
        }

        public final String getAuthenticationTypeAsString() {
            return authenticationType;
        }

        @Override
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType.toString());
            return this;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        public final NetworkAccessConfiguration.Builder getNetworkAccessConfiguration() {
            return networkAccessConfiguration != null ? networkAccessConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder networkAccessConfiguration(NetworkAccessConfiguration networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration;
            return this;
        }

        public final void setNetworkAccessConfiguration(NetworkAccessConfiguration.BuilderImpl networkAccessConfiguration) {
            this.networkAccessConfiguration = networkAccessConfiguration != null ? networkAccessConfiguration.build() : null;
        }

        @Override
        public Session build() {
            return new Session(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
