/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appstream.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.services.appstream.model.AccessEndpoint;
import software.amazon.awssdk.services.appstream.model.AccessEndpointListCopier;
import software.amazon.awssdk.services.appstream.model.AppStreamRequest;
import software.amazon.awssdk.services.appstream.model.ApplicationSettings;
import software.amazon.awssdk.services.appstream.model.StorageConnector;
import software.amazon.awssdk.services.appstream.model.StorageConnectorListCopier;
import software.amazon.awssdk.services.appstream.model.TagsCopier;
import software.amazon.awssdk.services.appstream.model.UserSetting;
import software.amazon.awssdk.services.appstream.model.UserSettingListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateStackRequest
extends AppStreamRequest
implements ToCopyableBuilder<Builder, CreateStackRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStackRequest.getter(CreateStackRequest::name)).setter(CreateStackRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStackRequest.getter(CreateStackRequest::description)).setter(CreateStackRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").build()}).build();
    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStackRequest.getter(CreateStackRequest::displayName)).setter(CreateStackRequest.setter(Builder::displayName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("DisplayName").build()}).build();
    private static final SdkField<List<StorageConnector>> STORAGE_CONNECTORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateStackRequest.getter(CreateStackRequest::storageConnectors)).setter(CreateStackRequest.setter(Builder::storageConnectors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("StorageConnectors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(StorageConnector::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> REDIRECT_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStackRequest.getter(CreateStackRequest::redirectURL)).setter(CreateStackRequest.setter(Builder::redirectURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("RedirectURL").build()}).build();
    private static final SdkField<String> FEEDBACK_URL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(CreateStackRequest.getter(CreateStackRequest::feedbackURL)).setter(CreateStackRequest.setter(Builder::feedbackURL)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("FeedbackURL").build()}).build();
    private static final SdkField<List<UserSetting>> USER_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateStackRequest.getter(CreateStackRequest::userSettings)).setter(CreateStackRequest.setter(Builder::userSettings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("UserSettings").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(UserSetting::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ApplicationSettings> APPLICATION_SETTINGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).getter(CreateStackRequest.getter(CreateStackRequest::applicationSettings)).setter(CreateStackRequest.setter(Builder::applicationSettings)).constructor(ApplicationSettings::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ApplicationSettings").build()}).build();
    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).getter(CreateStackRequest.getter(CreateStackRequest::tags)).setter(CreateStackRequest.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Tags").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<AccessEndpoint>> ACCESS_ENDPOINTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).getter(CreateStackRequest.getter(CreateStackRequest::accessEndpoints)).setter(CreateStackRequest.setter(Builder::accessEndpoints)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("AccessEndpoints").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(AccessEndpoint::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, DISPLAY_NAME_FIELD, STORAGE_CONNECTORS_FIELD, REDIRECT_URL_FIELD, FEEDBACK_URL_FIELD, USER_SETTINGS_FIELD, APPLICATION_SETTINGS_FIELD, TAGS_FIELD, ACCESS_ENDPOINTS_FIELD));
    private final String name;
    private final String description;
    private final String displayName;
    private final List<StorageConnector> storageConnectors;
    private final String redirectURL;
    private final String feedbackURL;
    private final List<UserSetting> userSettings;
    private final ApplicationSettings applicationSettings;
    private final Map<String, String> tags;
    private final List<AccessEndpoint> accessEndpoints;

    private CreateStackRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.displayName = builder.displayName;
        this.storageConnectors = builder.storageConnectors;
        this.redirectURL = builder.redirectURL;
        this.feedbackURL = builder.feedbackURL;
        this.userSettings = builder.userSettings;
        this.applicationSettings = builder.applicationSettings;
        this.tags = builder.tags;
        this.accessEndpoints = builder.accessEndpoints;
    }

    public String name() {
        return this.name;
    }

    public String description() {
        return this.description;
    }

    public String displayName() {
        return this.displayName;
    }

    public List<StorageConnector> storageConnectors() {
        return this.storageConnectors;
    }

    public String redirectURL() {
        return this.redirectURL;
    }

    public String feedbackURL() {
        return this.feedbackURL;
    }

    public List<UserSetting> userSettings() {
        return this.userSettings;
    }

    public ApplicationSettings applicationSettings() {
        return this.applicationSettings;
    }

    public Map<String, String> tags() {
        return this.tags;
    }

    public List<AccessEndpoint> accessEndpoints() {
        return this.accessEndpoints;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.displayName());
        hashCode = 31 * hashCode + Objects.hashCode(this.storageConnectors());
        hashCode = 31 * hashCode + Objects.hashCode(this.redirectURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.feedbackURL());
        hashCode = 31 * hashCode + Objects.hashCode(this.userSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.applicationSettings());
        hashCode = 31 * hashCode + Objects.hashCode(this.tags());
        hashCode = 31 * hashCode + Objects.hashCode(this.accessEndpoints());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateStackRequest)) {
            return false;
        }
        CreateStackRequest other = (CreateStackRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.displayName(), other.displayName()) && Objects.equals(this.storageConnectors(), other.storageConnectors()) && Objects.equals(this.redirectURL(), other.redirectURL()) && Objects.equals(this.feedbackURL(), other.feedbackURL()) && Objects.equals(this.userSettings(), other.userSettings()) && Objects.equals(this.applicationSettings(), other.applicationSettings()) && Objects.equals(this.tags(), other.tags()) && Objects.equals(this.accessEndpoints(), other.accessEndpoints());
    }

    public String toString() {
        return ToString.builder((String)"CreateStackRequest").add("Name", (Object)this.name()).add("Description", (Object)this.description()).add("DisplayName", (Object)this.displayName()).add("StorageConnectors", this.storageConnectors()).add("RedirectURL", (Object)this.redirectURL()).add("FeedbackURL", (Object)this.feedbackURL()).add("UserSettings", this.userSettings()).add("ApplicationSettings", (Object)this.applicationSettings()).add("Tags", this.tags()).add("AccessEndpoints", this.accessEndpoints()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "Name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "DisplayName": {
                return Optional.ofNullable(clazz.cast(this.displayName()));
            }
            case "StorageConnectors": {
                return Optional.ofNullable(clazz.cast(this.storageConnectors()));
            }
            case "RedirectURL": {
                return Optional.ofNullable(clazz.cast(this.redirectURL()));
            }
            case "FeedbackURL": {
                return Optional.ofNullable(clazz.cast(this.feedbackURL()));
            }
            case "UserSettings": {
                return Optional.ofNullable(clazz.cast(this.userSettings()));
            }
            case "ApplicationSettings": {
                return Optional.ofNullable(clazz.cast(this.applicationSettings()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
            case "AccessEndpoints": {
                return Optional.ofNullable(clazz.cast(this.accessEndpoints()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateStackRequest, T> g) {
        return obj -> g.apply((CreateStackRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppStreamRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private String displayName;
        private List<StorageConnector> storageConnectors = DefaultSdkAutoConstructList.getInstance();
        private String redirectURL;
        private String feedbackURL;
        private List<UserSetting> userSettings = DefaultSdkAutoConstructList.getInstance();
        private ApplicationSettings applicationSettings;
        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();
        private List<AccessEndpoint> accessEndpoints = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateStackRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.displayName(model.displayName);
            this.storageConnectors(model.storageConnectors);
            this.redirectURL(model.redirectURL);
            this.feedbackURL(model.feedbackURL);
            this.userSettings(model.userSettings);
            this.applicationSettings(model.applicationSettings);
            this.tags(model.tags);
            this.accessEndpoints(model.accessEndpoints);
        }

        public final String getName() {
            return this.name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final void setName(String name) {
            this.name = name;
        }

        public final String getDescription() {
            return this.description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        public final String getDisplayName() {
            return this.displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        public final Collection<StorageConnector.Builder> getStorageConnectors() {
            return this.storageConnectors != null ? (Collection)this.storageConnectors.stream().map(StorageConnector::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder storageConnectors(Collection<StorageConnector> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copy(storageConnectors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(StorageConnector ... storageConnectors) {
            this.storageConnectors(Arrays.asList(storageConnectors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder storageConnectors(Consumer<StorageConnector.Builder> ... storageConnectors) {
            this.storageConnectors(Stream.of(storageConnectors).map(c -> (StorageConnector)((StorageConnector.Builder)StorageConnector.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setStorageConnectors(Collection<StorageConnector.BuilderImpl> storageConnectors) {
            this.storageConnectors = StorageConnectorListCopier.copyFromBuilder(storageConnectors);
        }

        public final String getRedirectURL() {
            return this.redirectURL;
        }

        @Override
        public final Builder redirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
            return this;
        }

        public final void setRedirectURL(String redirectURL) {
            this.redirectURL = redirectURL;
        }

        public final String getFeedbackURL() {
            return this.feedbackURL;
        }

        @Override
        public final Builder feedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
            return this;
        }

        public final void setFeedbackURL(String feedbackURL) {
            this.feedbackURL = feedbackURL;
        }

        public final Collection<UserSetting.Builder> getUserSettings() {
            return this.userSettings != null ? (Collection)this.userSettings.stream().map(UserSetting::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder userSettings(Collection<UserSetting> userSettings) {
            this.userSettings = UserSettingListCopier.copy(userSettings);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(UserSetting ... userSettings) {
            this.userSettings(Arrays.asList(userSettings));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder userSettings(Consumer<UserSetting.Builder> ... userSettings) {
            this.userSettings(Stream.of(userSettings).map(c -> (UserSetting)((UserSetting.Builder)UserSetting.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setUserSettings(Collection<UserSetting.BuilderImpl> userSettings) {
            this.userSettings = UserSettingListCopier.copyFromBuilder(userSettings);
        }

        public final ApplicationSettings.Builder getApplicationSettings() {
            return this.applicationSettings != null ? this.applicationSettings.toBuilder() : null;
        }

        @Override
        public final Builder applicationSettings(ApplicationSettings applicationSettings) {
            this.applicationSettings = applicationSettings;
            return this;
        }

        public final void setApplicationSettings(ApplicationSettings.BuilderImpl applicationSettings) {
            this.applicationSettings = applicationSettings != null ? applicationSettings.build() : null;
        }

        public final Map<String, String> getTags() {
            return this.tags;
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        public final Collection<AccessEndpoint.Builder> getAccessEndpoints() {
            return this.accessEndpoints != null ? (Collection)this.accessEndpoints.stream().map(AccessEndpoint::toBuilder).collect(Collectors.toList()) : null;
        }

        @Override
        public final Builder accessEndpoints(Collection<AccessEndpoint> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copy(accessEndpoints);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(AccessEndpoint ... accessEndpoints) {
            this.accessEndpoints(Arrays.asList(accessEndpoints));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... accessEndpoints) {
            this.accessEndpoints(Stream.of(accessEndpoints).map(c -> (AccessEndpoint)((AccessEndpoint.Builder)AccessEndpoint.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final void setAccessEndpoints(Collection<AccessEndpoint.BuilderImpl> accessEndpoints) {
            this.accessEndpoints = AccessEndpointListCopier.copyFromBuilder(accessEndpoints);
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateStackRequest build() {
            return new CreateStackRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppStreamRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateStackRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder displayName(String var1);

        public Builder storageConnectors(Collection<StorageConnector> var1);

        public Builder storageConnectors(StorageConnector ... var1);

        public Builder storageConnectors(Consumer<StorageConnector.Builder> ... var1);

        public Builder redirectURL(String var1);

        public Builder feedbackURL(String var1);

        public Builder userSettings(Collection<UserSetting> var1);

        public Builder userSettings(UserSetting ... var1);

        public Builder userSettings(Consumer<UserSetting.Builder> ... var1);

        public Builder applicationSettings(ApplicationSettings var1);

        default public Builder applicationSettings(Consumer<ApplicationSettings.Builder> applicationSettings) {
            return this.applicationSettings((ApplicationSettings)((ApplicationSettings.Builder)ApplicationSettings.builder().applyMutation(applicationSettings)).build());
        }

        public Builder tags(Map<String, String> var1);

        public Builder accessEndpoints(Collection<AccessEndpoint> var1);

        public Builder accessEndpoints(AccessEndpoint ... var1);

        public Builder accessEndpoints(Consumer<AccessEndpoint.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

