/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.appsync.model.AccessDeniedException;
import software.amazon.awssdk.services.appsync.model.ApiKeyLimitExceededException;
import software.amazon.awssdk.services.appsync.model.ApiKeyValidityOutOfBoundsException;
import software.amazon.awssdk.services.appsync.model.ApiLimitExceededException;
import software.amazon.awssdk.services.appsync.model.AppSyncException;
import software.amazon.awssdk.services.appsync.model.BadRequestException;
import software.amazon.awssdk.services.appsync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.CreateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.CreateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateResolverRequest;
import software.amazon.awssdk.services.appsync.model.CreateResolverResponse;
import software.amazon.awssdk.services.appsync.model.CreateTypeRequest;
import software.amazon.awssdk.services.appsync.model.CreateTypeResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteResolverRequest;
import software.amazon.awssdk.services.appsync.model.DeleteResolverResponse;
import software.amazon.awssdk.services.appsync.model.DeleteTypeRequest;
import software.amazon.awssdk.services.appsync.model.DeleteTypeResponse;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.GetApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.GetFunctionRequest;
import software.amazon.awssdk.services.appsync.model.GetFunctionResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse;
import software.amazon.awssdk.services.appsync.model.GetResolverRequest;
import software.amazon.awssdk.services.appsync.model.GetResolverResponse;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.services.appsync.model.GetTypeResponse;
import software.amazon.awssdk.services.appsync.model.GraphQlSchemaException;
import software.amazon.awssdk.services.appsync.model.InternalFailureException;
import software.amazon.awssdk.services.appsync.model.LimitExceededException;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.NotFoundException;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse;
import software.amazon.awssdk.services.appsync.model.TagResourceRequest;
import software.amazon.awssdk.services.appsync.model.TagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UnauthorizedException;
import software.amazon.awssdk.services.appsync.model.UntagResourceRequest;
import software.amazon.awssdk.services.appsync.model.UntagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateResolverRequest;
import software.amazon.awssdk.services.appsync.model.UpdateResolverResponse;
import software.amazon.awssdk.services.appsync.model.UpdateTypeRequest;
import software.amazon.awssdk.services.appsync.model.UpdateTypeResponse;
import software.amazon.awssdk.services.appsync.transform.CreateApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.FlushApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetIntrospectionSchemaRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSchemaCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListApiKeysRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListGraphqlApisRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversByFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaCreationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateTypeRequestMarshaller;

/**
 * Internal implementation of {@link AppSyncClient}.
 *
 * @see AppSyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAppSyncClient implements AppSyncClient {
    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppSyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration;
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    /**
     * <p>
     * Creates a cache for the GraphQL API.
     * </p>
     *
     * @param createApiCacheRequest
     *        Represents the input of a <code>CreateApiCache</code> operation.
     * @return Result of the CreateApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateApiCacheResponse createApiCache(CreateApiCacheRequest createApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiCache");

            return clientHandler.execute(new ClientExecutionParams<CreateApiCacheRequest, CreateApiCacheResponse>()
                    .withOperationName("CreateApiCache").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiCacheRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a unique key that you can distribute to clients who are executing your API.
     * </p>
     *
     * @param createApiKeyRequest
     * @return Result of the CreateApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws ApiKeyLimitExceededException
     *         The API key exceeded a limit. Try your request again.
     * @throws ApiKeyValidityOutOfBoundsException
     *         The API key expiration must be set to a value between 1 and 365 days from creation (for
     *         <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException,
            ApiKeyLimitExceededException, ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiKey");

            return clientHandler.execute(new ClientExecutionParams<CreateApiKeyRequest, CreateApiKeyResponse>()
                    .withOperationName("CreateApiKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");

            return clientHandler.execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                    .withOperationName("CreateDataSource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>Function</code> object.
     * </p>
     * <p>
     * A function is a reusable entity. Multiple functions can be used to compose the resolver logic.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFunction");

            return clientHandler.execute(new ClientExecutionParams<CreateFunctionRequest, CreateFunctionResponse>()
                    .withOperationName("CreateFunction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFunctionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFunctionRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param createGraphqlApiRequest
     * @return Result of the CreateGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws ApiLimitExceededException
     *         The GraphQL API exceeded a limit. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGraphqlApiResponse createGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest) throws BadRequestException,
            LimitExceededException, ConcurrentModificationException, UnauthorizedException, InternalFailureException,
            ApiLimitExceededException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGraphqlApi");

            return clientHandler.execute(new ClientExecutionParams<CreateGraphqlApiRequest, CreateGraphqlApiResponse>()
                    .withOperationName("CreateGraphqlApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createGraphqlApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGraphqlApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>Resolver</code> object.
     * </p>
     * <p>
     * A resolver converts incoming requests into a format that a data source can understand and converts the data
     * source's responses into GraphQL.
     * </p>
     *
     * @param createResolverRequest
     * @return Result of the CreateResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateResolverResponse createResolver(CreateResolverRequest createResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateResolverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResolver");

            return clientHandler.execute(new ClientExecutionParams<CreateResolverRequest, CreateResolverResponse>()
                    .withOperationName("CreateResolver").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(createResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateResolverRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResolverRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>Type</code> object.
     * </p>
     *
     * @param createTypeRequest
     * @return Result of the CreateType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTypeResponse createType(CreateTypeRequest createTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateType");

            return clientHandler
                    .execute(new ClientExecutionParams<CreateTypeRequest, CreateTypeResponse>().withOperationName("CreateType")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(createTypeRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new CreateTypeRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTypeRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an <code>ApiCache</code> object.
     * </p>
     *
     * @param deleteApiCacheRequest
     *        Represents the input of a <code>DeleteApiCache</code> operation.
     * @return Result of the DeleteApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteApiCacheResponse deleteApiCache(DeleteApiCacheRequest deleteApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiCache");

            return clientHandler.execute(new ClientExecutionParams<DeleteApiCacheRequest, DeleteApiCacheResponse>()
                    .withOperationName("DeleteApiCache").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiCacheRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an API key.
     * </p>
     *
     * @param deleteApiKeyRequest
     * @return Result of the DeleteApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiKey");

            return clientHandler.execute(new ClientExecutionParams<DeleteApiKeyRequest, DeleteApiKeyResponse>()
                    .withOperationName("DeleteApiKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>DataSource</code> object.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                    .withOperationName("DeleteDataSource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>Function</code>.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunction");

            return clientHandler.execute(new ClientExecutionParams<DeleteFunctionRequest, DeleteFunctionResponse>()
                    .withOperationName("DeleteFunction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFunctionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFunctionRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param deleteGraphqlApiRequest
     * @return Result of the DeleteGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You do not have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGraphqlApiResponse deleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGraphqlApi");

            return clientHandler.execute(new ClientExecutionParams<DeleteGraphqlApiRequest, DeleteGraphqlApiResponse>()
                    .withOperationName("DeleteGraphqlApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteGraphqlApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGraphqlApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>Resolver</code> object.
     * </p>
     *
     * @param deleteResolverRequest
     * @return Result of the DeleteResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteResolver" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteResolverResponse deleteResolver(DeleteResolverRequest deleteResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteResolverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResolver");

            return clientHandler.execute(new ClientExecutionParams<DeleteResolverRequest, DeleteResolverResponse>()
                    .withOperationName("DeleteResolver").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(deleteResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResolverRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResolverRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>Type</code> object.
     * </p>
     *
     * @param deleteTypeRequest
     * @return Result of the DeleteType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTypeResponse deleteType(DeleteTypeRequest deleteTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteType");

            return clientHandler
                    .execute(new ClientExecutionParams<DeleteTypeRequest, DeleteTypeResponse>().withOperationName("DeleteType")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(deleteTypeRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DeleteTypeRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTypeRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Flushes an <code>ApiCache</code> object.
     * </p>
     *
     * @param flushApiCacheRequest
     *        Represents the input of a <code>FlushApiCache</code> operation.
     * @return Result of the FlushApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.FlushApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/FlushApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public FlushApiCacheResponse flushApiCache(FlushApiCacheRequest flushApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<FlushApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                FlushApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FlushApiCache");

            return clientHandler.execute(new ClientExecutionParams<FlushApiCacheRequest, FlushApiCacheResponse>()
                    .withOperationName("FlushApiCache").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(flushApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FlushApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, flushApiCacheRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an <code>ApiCache</code> object.
     * </p>
     *
     * @param getApiCacheRequest
     *        Represents the input of a <code>GetApiCache</code> operation.
     * @return Result of the GetApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetApiCacheResponse getApiCache(GetApiCacheRequest getApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiCache");

            return clientHandler.execute(new ClientExecutionParams<GetApiCacheRequest, GetApiCacheResponse>()
                    .withOperationName("GetApiCache").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiCacheRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>DataSource</code> object.
     * </p>
     *
     * @param getDataSourceRequest
     * @return Result of the GetDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataSource");

            return clientHandler.execute(new ClientExecutionParams<GetDataSourceRequest, GetDataSourceResponse>()
                    .withOperationName("GetDataSource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataSourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a <code>Function</code>.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ConcurrentModificationException,
            NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunction");

            return clientHandler.execute(new ClientExecutionParams<GetFunctionRequest, GetFunctionResponse>()
                    .withOperationName("GetFunction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFunctionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param getGraphqlApiRequest
     * @return Result of the GetGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You do not have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGraphqlApiResponse getGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGraphqlApi");

            return clientHandler.execute(new ClientExecutionParams<GetGraphqlApiRequest, GetGraphqlApiResponse>()
                    .withOperationName("GetGraphqlApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getGraphqlApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGraphqlApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the introspection schema for a GraphQL API.
     * </p>
     *
     * @param getIntrospectionSchemaRequest
     * @return Result of the GetIntrospectionSchema operation returned by the service.
     * @throws GraphQlSchemaException
     *         The GraphQL schema is not valid.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetIntrospectionSchema
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public GetIntrospectionSchemaResponse getIntrospectionSchema(GetIntrospectionSchemaRequest getIntrospectionSchemaRequest)
            throws GraphQlSchemaException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<GetIntrospectionSchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIntrospectionSchemaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntrospectionSchema");

            return clientHandler
                    .execute(new ClientExecutionParams<GetIntrospectionSchemaRequest, GetIntrospectionSchemaResponse>()
                            .withOperationName("GetIntrospectionSchema").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getIntrospectionSchemaRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetIntrospectionSchemaRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntrospectionSchemaRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>Resolver</code> object.
     * </p>
     *
     * @param getResolverRequest
     * @return Result of the GetResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetResolver" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetResolverResponse getResolver(GetResolverRequest getResolverRequest) throws ConcurrentModificationException,
            NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetResolverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolver");

            return clientHandler.execute(new ClientExecutionParams<GetResolverRequest, GetResolverResponse>()
                    .withOperationName("GetResolver").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResolverRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current status of a schema creation operation.
     * </p>
     *
     * @param getSchemaCreationStatusRequest
     * @return Result of the GetSchemaCreationStatus operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetSchemaCreationStatus
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSchemaCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSchemaCreationStatusResponse getSchemaCreationStatus(GetSchemaCreationStatusRequest getSchemaCreationStatusRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSchemaCreationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSchemaCreationStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSchemaCreationStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetSchemaCreationStatusRequest, GetSchemaCreationStatusResponse>()
                            .withOperationName("GetSchemaCreationStatus").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(getSchemaCreationStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSchemaCreationStatusRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSchemaCreationStatusRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>Type</code> object.
     * </p>
     *
     * @param getTypeRequest
     * @return Result of the GetType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTypeResponse getType(GetTypeRequest getTypeRequest) throws BadRequestException, ConcurrentModificationException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetType");

            return clientHandler.execute(new ClientExecutionParams<GetTypeRequest, GetTypeResponse>()
                    .withOperationName("GetType").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(getTypeRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new GetTypeRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTypeRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the API keys for a given API.
     * </p>
     * <note>
     * <p>
     * API keys are deleted automatically sometime after they expire. However, they may still be included in the
     * response until they have actually been deleted. You can safely call <code>DeleteApiKey</code> to manually delete
     * a key before it's automatically deleted.
     * </p>
     * </note>
     *
     * @param listApiKeysRequest
     * @return Result of the ListApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListApiKeys
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListApiKeysResponse listApiKeys(ListApiKeysRequest listApiKeysRequest) throws BadRequestException, NotFoundException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListApiKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApiKeys");

            return clientHandler.execute(new ClientExecutionParams<ListApiKeysRequest, ListApiKeysResponse>()
                    .withOperationName("ListApiKeys").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listApiKeysRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListApiKeysRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApiKeysRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the data sources for a given API.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDataSources
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDataSourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSources");

            return clientHandler.execute(new ClientExecutionParams<ListDataSourcesRequest, ListDataSourcesResponse>()
                    .withOperationName("ListDataSources").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listDataSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDataSourcesRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourcesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List multiple functions.
     * </p>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListFunctions
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFunctionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctions");

            return clientHandler.execute(new ClientExecutionParams<ListFunctionsRequest, ListFunctionsResponse>()
                    .withOperationName("ListFunctions").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listFunctionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFunctionsRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFunctionsRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your GraphQL APIs.
     * </p>
     *
     * @param listGraphqlApisRequest
     * @return Result of the ListGraphqlApis operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListGraphqlApis
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGraphqlApisResponse listGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGraphqlApisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGraphqlApisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGraphqlApis");

            return clientHandler.execute(new ClientExecutionParams<ListGraphqlApisRequest, ListGraphqlApisResponse>()
                    .withOperationName("ListGraphqlApis").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listGraphqlApisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGraphqlApisRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGraphqlApisRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resolvers for a given API and type.
     * </p>
     *
     * @param listResolversRequest
     * @return Result of the ListResolvers operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolvers
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListResolversResponse listResolvers(ListResolversRequest listResolversRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResolversResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListResolversResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolvers");

            return clientHandler.execute(new ClientExecutionParams<ListResolversRequest, ListResolversResponse>()
                    .withOperationName("ListResolvers").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listResolversRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListResolversRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolversRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the resolvers that are associated with a specific function.
     * </p>
     *
     * @param listResolversByFunctionRequest
     * @return Result of the ListResolversByFunction operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolversByFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResolversByFunctionResponse listResolversByFunction(ListResolversByFunctionRequest listResolversByFunctionRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResolversByFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResolversByFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolversByFunction");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResolversByFunctionRequest, ListResolversByFunctionResponse>()
                            .withOperationName("ListResolversByFunction").withResponseHandler(responseHandler)
                            .withErrorResponseHandler(errorResponseHandler).withInput(listResolversByFunctionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResolversByFunctionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolversByFunctionRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You do not have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTagsForResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the types for a given API.
     * </p>
     *
     * @param listTypesRequest
     * @return Result of the ListTypes operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypes
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypes");

            return clientHandler.execute(new ClientExecutionParams<ListTypesRequest, ListTypesResponse>()
                    .withOperationName("ListTypes").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(listTypesRequest)
                    .withMetricCollector(apiCallMetricCollector).withMarshaller(new ListTypesRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypesRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a new schema to your GraphQL API.
     * </p>
     * <p>
     * This operation is asynchronous. Use to determine when it has completed.
     * </p>
     *
     * @param startSchemaCreationRequest
     * @return Result of the StartSchemaCreation operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartSchemaCreation
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaCreation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartSchemaCreationResponse startSchemaCreation(StartSchemaCreationRequest startSchemaCreationRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSchemaCreationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartSchemaCreationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSchemaCreation");

            return clientHandler.execute(new ClientExecutionParams<StartSchemaCreationRequest, StartSchemaCreationResponse>()
                    .withOperationName("StartSchemaCreation").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(startSchemaCreationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartSchemaCreationRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSchemaCreationRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tags a resource with user-supplied tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You do not have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.TagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, NotFoundException,
            LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(tagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You do not have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UntagResource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the cache for the GraphQL API.
     * </p>
     *
     * @param updateApiCacheRequest
     *        Represents the input of a <code>UpdateApiCache</code> operation.
     * @return Result of the UpdateApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateApiCache
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateApiCacheResponse updateApiCache(UpdateApiCacheRequest updateApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiCache");

            return clientHandler.execute(new ClientExecutionParams<UpdateApiCacheRequest, UpdateApiCacheResponse>()
                    .withOperationName("UpdateApiCache").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiCacheRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an API key.
     * </p>
     *
     * @param updateApiKeyRequest
     * @return Result of the UpdateApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws ApiKeyValidityOutOfBoundsException
     *         The API key expiration must be set to a value between 1 and 365 days from creation (for
     *         <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateApiKey
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateApiKeyResponse updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, LimitExceededException, InternalFailureException,
            ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiKey");

            return clientHandler.execute(new ClientExecutionParams<UpdateApiKeyRequest, UpdateApiKeyResponse>()
                    .withOperationName("UpdateApiKey").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiKeyRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>DataSource</code> object.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateDataSource
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSource");

            return clientHandler.execute(new ClientExecutionParams<UpdateDataSourceRequest, UpdateDataSourceResponse>()
                    .withOperationName("UpdateDataSource").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourceRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>Function</code> object.
     * </p>
     *
     * @param updateFunctionRequest
     * @return Result of the UpdateFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateFunction
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFunctionResponse updateFunction(UpdateFunctionRequest updateFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunction");

            return clientHandler.execute(new ClientExecutionParams<UpdateFunctionRequest, UpdateFunctionResponse>()
                    .withOperationName("UpdateFunction").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFunctionRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFunctionRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param updateGraphqlApiRequest
     * @return Result of the UpdateGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You do not have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateGraphqlApi
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateGraphqlApiResponse updateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGraphqlApi");

            return clientHandler.execute(new ClientExecutionParams<UpdateGraphqlApiRequest, UpdateGraphqlApiResponse>()
                    .withOperationName("UpdateGraphqlApi").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateGraphqlApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGraphqlApiRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>Resolver</code> object.
     * </p>
     *
     * @param updateResolverRequest
     * @return Result of the UpdateResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateResolver
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateResolverResponse updateResolver(UpdateResolverRequest updateResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateResolverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResolver");

            return clientHandler.execute(new ClientExecutionParams<UpdateResolverRequest, UpdateResolverResponse>()
                    .withOperationName("UpdateResolver").withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withInput(updateResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateResolverRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResolverRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>Type</code> object.
     * </p>
     *
     * @param updateTypeRequest
     * @return Result of the UpdateType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You are not authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AWS AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateType
     * @see <a href="http://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateTypeResponse updateType(UpdateTypeRequest updateTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        MetricCollector apiCallMetricCollector = MetricCollector.create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateType");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateTypeRequest, UpdateTypeResponse>().withOperationName("UpdateType")
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withInput(updateTypeRequest).withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateTypeRequestMarshaller(protocolFactory)));
        } finally {
            List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTypeRequest
                    .overrideConfiguration().orElse(null));
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AppSyncException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GraphQLSchemaException")
                                .exceptionBuilderSupplier(GraphQlSchemaException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException")
                                .exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException")
                                .exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApiLimitExceededException")
                                .exceptionBuilderSupplier(ApiLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
