/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an <code>ApiAssociation</code> object.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ApiAssociation implements SdkPojo, Serializable, ToCopyableBuilder<ApiAssociation.Builder, ApiAssociation> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(ApiAssociation::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(ApiAssociation::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()).build();

    private static final SdkField<String> ASSOCIATION_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associationStatus").getter(getter(ApiAssociation::associationStatusAsString))
            .setter(setter(Builder::associationStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associationStatus").build()).build();

    private static final SdkField<String> DEPLOYMENT_DETAIL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deploymentDetail").getter(getter(ApiAssociation::deploymentDetail))
            .setter(setter(Builder::deploymentDetail))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deploymentDetail").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            API_ID_FIELD, ASSOCIATION_STATUS_FIELD, DEPLOYMENT_DETAIL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String apiId;

    private final String associationStatus;

    private final String deploymentDetail;

    private ApiAssociation(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.apiId = builder.apiId;
        this.associationStatus = builder.associationStatus;
        this.deploymentDetail = builder.deploymentDetail;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @return The API ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * Identifies the status of an association.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during
     * processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCESS</b>: The API association was successful. You can modify associations after success.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b>: The API association has failed. You can modify associations after failure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link AssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return Identifies the status of an association.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during
     *         processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCESS</b>: The API association was successful. You can modify associations after success.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b>: The API association has failed. You can modify associations after failure.
     *         </p>
     *         </li>
     * @see AssociationStatus
     */
    public final AssociationStatus associationStatus() {
        return AssociationStatus.fromValue(associationStatus);
    }

    /**
     * <p>
     * Identifies the status of an association.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during
     * processing.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>SUCCESS</b>: The API association was successful. You can modify associations after success.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>FAILED</b>: The API association has failed. You can modify associations after failure.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #associationStatus}
     * will return {@link AssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #associationStatusAsString}.
     * </p>
     * 
     * @return Identifies the status of an association.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during
     *         processing.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>SUCCESS</b>: The API association was successful. You can modify associations after success.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>FAILED</b>: The API association has failed. You can modify associations after failure.
     *         </p>
     *         </li>
     * @see AssociationStatus
     */
    public final String associationStatusAsString() {
        return associationStatus;
    }

    /**
     * <p>
     * Details about the last deployment status.
     * </p>
     * 
     * @return Details about the last deployment status.
     */
    public final String deploymentDetail() {
        return deploymentDetail;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(associationStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(deploymentDetail());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApiAssociation)) {
            return false;
        }
        ApiAssociation other = (ApiAssociation) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(associationStatusAsString(), other.associationStatusAsString())
                && Objects.equals(deploymentDetail(), other.deploymentDetail());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ApiAssociation").add("DomainName", domainName()).add("ApiId", apiId())
                .add("AssociationStatus", associationStatusAsString()).add("DeploymentDetail", deploymentDetail()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "associationStatus":
            return Optional.ofNullable(clazz.cast(associationStatusAsString()));
        case "deploymentDetail":
            return Optional.ofNullable(clazz.cast(deploymentDetail()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ApiAssociation, T> g) {
        return obj -> g.apply((ApiAssociation) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ApiAssociation> {
        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * The API ID.
         * </p>
         * 
         * @param apiId
         *        The API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * Identifies the status of an association.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during
         * processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCESS</b>: The API association was successful. You can modify associations after success.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b>: The API association has failed. You can modify associations after failure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationStatus
         *        Identifies the status of an association.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during
         *        processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCESS</b>: The API association was successful. You can modify associations after success.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b>: The API association has failed. You can modify associations after failure.
         *        </p>
         *        </li>
         * @see AssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatus
         */
        Builder associationStatus(String associationStatus);

        /**
         * <p>
         * Identifies the status of an association.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during
         * processing.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>SUCCESS</b>: The API association was successful. You can modify associations after success.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>FAILED</b>: The API association has failed. You can modify associations after failure.
         * </p>
         * </li>
         * </ul>
         * 
         * @param associationStatus
         *        Identifies the status of an association.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>PROCESSING</b>: The API association is being created. You cannot modify association requests during
         *        processing.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>SUCCESS</b>: The API association was successful. You can modify associations after success.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>FAILED</b>: The API association has failed. You can modify associations after failure.
         *        </p>
         *        </li>
         * @see AssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AssociationStatus
         */
        Builder associationStatus(AssociationStatus associationStatus);

        /**
         * <p>
         * Details about the last deployment status.
         * </p>
         * 
         * @param deploymentDetail
         *        Details about the last deployment status.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deploymentDetail(String deploymentDetail);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String apiId;

        private String associationStatus;

        private String deploymentDetail;

        private BuilderImpl() {
        }

        private BuilderImpl(ApiAssociation model) {
            domainName(model.domainName);
            apiId(model.apiId);
            associationStatus(model.associationStatus);
            deploymentDetail(model.deploymentDetail);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        @Transient
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getAssociationStatus() {
            return associationStatus;
        }

        public final void setAssociationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
        }

        @Override
        @Transient
        public final Builder associationStatus(String associationStatus) {
            this.associationStatus = associationStatus;
            return this;
        }

        @Override
        @Transient
        public final Builder associationStatus(AssociationStatus associationStatus) {
            this.associationStatus(associationStatus == null ? null : associationStatus.toString());
            return this;
        }

        public final String getDeploymentDetail() {
            return deploymentDetail;
        }

        public final void setDeploymentDetail(String deploymentDetail) {
            this.deploymentDetail = deploymentDetail;
        }

        @Override
        @Transient
        public final Builder deploymentDetail(String deploymentDetail) {
            this.deploymentDetail = deploymentDetail;
            return this;
        }

        @Override
        public ApiAssociation build() {
            return new ApiAssociation(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
