/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The authorization configuration in case the HTTP endpoint requires authorization.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AuthorizationConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<AuthorizationConfig.Builder, AuthorizationConfig> {
    private static final SdkField<String> AUTHORIZATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authorizationType").getter(getter(AuthorizationConfig::authorizationTypeAsString))
            .setter(setter(Builder::authorizationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizationType").build()).build();

    private static final SdkField<AwsIamConfig> AWS_IAM_CONFIG_FIELD = SdkField.<AwsIamConfig> builder(MarshallingType.SDK_POJO)
            .memberName("awsIamConfig").getter(getter(AuthorizationConfig::awsIamConfig)).setter(setter(Builder::awsIamConfig))
            .constructor(AwsIamConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsIamConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AUTHORIZATION_TYPE_FIELD,
            AWS_IAM_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String authorizationType;

    private final AwsIamConfig awsIamConfig;

    private AuthorizationConfig(BuilderImpl builder) {
        this.authorizationType = builder.authorizationType;
        this.awsIamConfig = builder.awsIamConfig;
    }

    /**
     * <p>
     * The authorization type that the HTTP endpoint requires.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link AuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The authorization type that the HTTP endpoint requires.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).
     *         </p>
     *         </li>
     * @see AuthorizationType
     */
    public final AuthorizationType authorizationType() {
        return AuthorizationType.fromValue(authorizationType);
    }

    /**
     * <p>
     * The authorization type that the HTTP endpoint requires.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #authorizationType}
     * will return {@link AuthorizationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #authorizationTypeAsString}.
     * </p>
     * 
     * @return The authorization type that the HTTP endpoint requires.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).
     *         </p>
     *         </li>
     * @see AuthorizationType
     */
    public final String authorizationTypeAsString() {
        return authorizationType;
    }

    /**
     * <p>
     * The Identity and Access Management (IAM) settings.
     * </p>
     * 
     * @return The Identity and Access Management (IAM) settings.
     */
    public final AwsIamConfig awsIamConfig() {
        return awsIamConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(authorizationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(awsIamConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AuthorizationConfig)) {
            return false;
        }
        AuthorizationConfig other = (AuthorizationConfig) obj;
        return Objects.equals(authorizationTypeAsString(), other.authorizationTypeAsString())
                && Objects.equals(awsIamConfig(), other.awsIamConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AuthorizationConfig").add("AuthorizationType", authorizationTypeAsString())
                .add("AwsIamConfig", awsIamConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "authorizationType":
            return Optional.ofNullable(clazz.cast(authorizationTypeAsString()));
        case "awsIamConfig":
            return Optional.ofNullable(clazz.cast(awsIamConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<AuthorizationConfig, T> g) {
        return obj -> g.apply((AuthorizationConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AuthorizationConfig> {
        /**
         * <p>
         * The authorization type that the HTTP endpoint requires.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).
         * </p>
         * </li>
         * </ul>
         * 
         * @param authorizationType
         *        The authorization type that the HTTP endpoint requires.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).
         *        </p>
         *        </li>
         * @see AuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationType
         */
        Builder authorizationType(String authorizationType);

        /**
         * <p>
         * The authorization type that the HTTP endpoint requires.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).
         * </p>
         * </li>
         * </ul>
         * 
         * @param authorizationType
         *        The authorization type that the HTTP endpoint requires.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>AWS_IAM</b>: The authorization type is Signature Version 4 (SigV4).
         *        </p>
         *        </li>
         * @see AuthorizationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthorizationType
         */
        Builder authorizationType(AuthorizationType authorizationType);

        /**
         * <p>
         * The Identity and Access Management (IAM) settings.
         * </p>
         * 
         * @param awsIamConfig
         *        The Identity and Access Management (IAM) settings.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder awsIamConfig(AwsIamConfig awsIamConfig);

        /**
         * <p>
         * The Identity and Access Management (IAM) settings.
         * </p>
         * This is a convenience that creates an instance of the {@link AwsIamConfig.Builder} avoiding the need to
         * create one manually via {@link AwsIamConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link AwsIamConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #awsIamConfig(AwsIamConfig)}.
         * 
         * @param awsIamConfig
         *        a consumer that will call methods on {@link AwsIamConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #awsIamConfig(AwsIamConfig)
         */
        default Builder awsIamConfig(Consumer<AwsIamConfig.Builder> awsIamConfig) {
            return awsIamConfig(AwsIamConfig.builder().applyMutation(awsIamConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String authorizationType;

        private AwsIamConfig awsIamConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AuthorizationConfig model) {
            authorizationType(model.authorizationType);
            awsIamConfig(model.awsIamConfig);
        }

        public final String getAuthorizationType() {
            return authorizationType;
        }

        public final void setAuthorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
        }

        @Override
        @Transient
        public final Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        @Override
        @Transient
        public final Builder authorizationType(AuthorizationType authorizationType) {
            this.authorizationType(authorizationType == null ? null : authorizationType.toString());
            return this;
        }

        public final AwsIamConfig.Builder getAwsIamConfig() {
            return awsIamConfig != null ? awsIamConfig.toBuilder() : null;
        }

        public final void setAwsIamConfig(AwsIamConfig.BuilderImpl awsIamConfig) {
            this.awsIamConfig = awsIamConfig != null ? awsIamConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder awsIamConfig(AwsIamConfig awsIamConfig) {
            this.awsIamConfig = awsIamConfig;
            return this;
        }

        @Override
        public AuthorizationConfig build() {
            return new AuthorizationConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
