/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a Delta Sync configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeltaSyncConfig implements SdkPojo, Serializable, ToCopyableBuilder<DeltaSyncConfig.Builder, DeltaSyncConfig> {
    private static final SdkField<Long> BASE_TABLE_TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("baseTableTTL").getter(getter(DeltaSyncConfig::baseTableTTL)).setter(setter(Builder::baseTableTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("baseTableTTL").build()).build();

    private static final SdkField<String> DELTA_SYNC_TABLE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("deltaSyncTableName").getter(getter(DeltaSyncConfig::deltaSyncTableName))
            .setter(setter(Builder::deltaSyncTableName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deltaSyncTableName").build())
            .build();

    private static final SdkField<Long> DELTA_SYNC_TABLE_TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG)
            .memberName("deltaSyncTableTTL").getter(getter(DeltaSyncConfig::deltaSyncTableTTL))
            .setter(setter(Builder::deltaSyncTableTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("deltaSyncTableTTL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BASE_TABLE_TTL_FIELD,
            DELTA_SYNC_TABLE_NAME_FIELD, DELTA_SYNC_TABLE_TTL_FIELD));

    private static final long serialVersionUID = 1L;

    private final Long baseTableTTL;

    private final String deltaSyncTableName;

    private final Long deltaSyncTableTTL;

    private DeltaSyncConfig(BuilderImpl builder) {
        this.baseTableTTL = builder.baseTableTTL;
        this.deltaSyncTableName = builder.deltaSyncTableName;
        this.deltaSyncTableTTL = builder.deltaSyncTableTTL;
    }

    /**
     * <p>
     * The number of minutes that an Item is stored in the data source.
     * </p>
     * 
     * @return The number of minutes that an Item is stored in the data source.
     */
    public final Long baseTableTTL() {
        return baseTableTTL;
    }

    /**
     * <p>
     * The Delta Sync table name.
     * </p>
     * 
     * @return The Delta Sync table name.
     */
    public final String deltaSyncTableName() {
        return deltaSyncTableName;
    }

    /**
     * <p>
     * The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
     * </p>
     * 
     * @return The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
     */
    public final Long deltaSyncTableTTL() {
        return deltaSyncTableTTL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(baseTableTTL());
        hashCode = 31 * hashCode + Objects.hashCode(deltaSyncTableName());
        hashCode = 31 * hashCode + Objects.hashCode(deltaSyncTableTTL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeltaSyncConfig)) {
            return false;
        }
        DeltaSyncConfig other = (DeltaSyncConfig) obj;
        return Objects.equals(baseTableTTL(), other.baseTableTTL())
                && Objects.equals(deltaSyncTableName(), other.deltaSyncTableName())
                && Objects.equals(deltaSyncTableTTL(), other.deltaSyncTableTTL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeltaSyncConfig").add("BaseTableTTL", baseTableTTL())
                .add("DeltaSyncTableName", deltaSyncTableName()).add("DeltaSyncTableTTL", deltaSyncTableTTL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "baseTableTTL":
            return Optional.ofNullable(clazz.cast(baseTableTTL()));
        case "deltaSyncTableName":
            return Optional.ofNullable(clazz.cast(deltaSyncTableName()));
        case "deltaSyncTableTTL":
            return Optional.ofNullable(clazz.cast(deltaSyncTableTTL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DeltaSyncConfig, T> g) {
        return obj -> g.apply((DeltaSyncConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DeltaSyncConfig> {
        /**
         * <p>
         * The number of minutes that an Item is stored in the data source.
         * </p>
         * 
         * @param baseTableTTL
         *        The number of minutes that an Item is stored in the data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder baseTableTTL(Long baseTableTTL);

        /**
         * <p>
         * The Delta Sync table name.
         * </p>
         * 
         * @param deltaSyncTableName
         *        The Delta Sync table name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deltaSyncTableName(String deltaSyncTableName);

        /**
         * <p>
         * The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
         * </p>
         * 
         * @param deltaSyncTableTTL
         *        The number of minutes that a Delta Sync log entry is stored in the Delta Sync table.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder deltaSyncTableTTL(Long deltaSyncTableTTL);
    }

    static final class BuilderImpl implements Builder {
        private Long baseTableTTL;

        private String deltaSyncTableName;

        private Long deltaSyncTableTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(DeltaSyncConfig model) {
            baseTableTTL(model.baseTableTTL);
            deltaSyncTableName(model.deltaSyncTableName);
            deltaSyncTableTTL(model.deltaSyncTableTTL);
        }

        public final Long getBaseTableTTL() {
            return baseTableTTL;
        }

        public final void setBaseTableTTL(Long baseTableTTL) {
            this.baseTableTTL = baseTableTTL;
        }

        @Override
        @Transient
        public final Builder baseTableTTL(Long baseTableTTL) {
            this.baseTableTTL = baseTableTTL;
            return this;
        }

        public final String getDeltaSyncTableName() {
            return deltaSyncTableName;
        }

        public final void setDeltaSyncTableName(String deltaSyncTableName) {
            this.deltaSyncTableName = deltaSyncTableName;
        }

        @Override
        @Transient
        public final Builder deltaSyncTableName(String deltaSyncTableName) {
            this.deltaSyncTableName = deltaSyncTableName;
            return this;
        }

        public final Long getDeltaSyncTableTTL() {
            return deltaSyncTableTTL;
        }

        public final void setDeltaSyncTableTTL(Long deltaSyncTableTTL) {
            this.deltaSyncTableTTL = deltaSyncTableTTL;
        }

        @Override
        @Transient
        public final Builder deltaSyncTableTTL(Long deltaSyncTableTTL) {
            this.deltaSyncTableTTL = deltaSyncTableTTL;
            return this;
        }

        @Override
        public DeltaSyncConfig build() {
            return new DeltaSyncConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
