/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a configuration for a custom domain.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DomainNameConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<DomainNameConfig.Builder, DomainNameConfig> {
    private static final SdkField<String> DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("domainName").getter(getter(DomainNameConfig::domainName)).setter(setter(Builder::domainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("domainName").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(DomainNameConfig::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> CERTIFICATE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("certificateArn").getter(getter(DomainNameConfig::certificateArn))
            .setter(setter(Builder::certificateArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("certificateArn").build()).build();

    private static final SdkField<String> APPSYNC_DOMAIN_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("appsyncDomainName").getter(getter(DomainNameConfig::appsyncDomainName))
            .setter(setter(Builder::appsyncDomainName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("appsyncDomainName").build()).build();

    private static final SdkField<String> HOSTED_ZONE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("hostedZoneId").getter(getter(DomainNameConfig::hostedZoneId)).setter(setter(Builder::hostedZoneId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostedZoneId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DOMAIN_NAME_FIELD,
            DESCRIPTION_FIELD, CERTIFICATE_ARN_FIELD, APPSYNC_DOMAIN_NAME_FIELD, HOSTED_ZONE_ID_FIELD));

    private static final long serialVersionUID = 1L;

    private final String domainName;

    private final String description;

    private final String certificateArn;

    private final String appsyncDomainName;

    private final String hostedZoneId;

    private DomainNameConfig(BuilderImpl builder) {
        this.domainName = builder.domainName;
        this.description = builder.description;
        this.certificateArn = builder.certificateArn;
        this.appsyncDomainName = builder.appsyncDomainName;
        this.hostedZoneId = builder.hostedZoneId;
    }

    /**
     * <p>
     * The domain name.
     * </p>
     * 
     * @return The domain name.
     */
    public final String domainName() {
        return domainName;
    }

    /**
     * <p>
     * A description of the <code>DomainName</code> configuration.
     * </p>
     * 
     * @return A description of the <code>DomainName</code> configuration.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an
     * Identity and Access Management (IAM) server certificate.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate
     *         or an Identity and Access Management (IAM) server certificate.
     */
    public final String certificateArn() {
        return certificateArn;
    }

    /**
     * <p>
     * The domain name that AppSync provides.
     * </p>
     * 
     * @return The domain name that AppSync provides.
     */
    public final String appsyncDomainName() {
        return appsyncDomainName;
    }

    /**
     * <p>
     * The ID of your Amazon Route 53 hosted zone.
     * </p>
     * 
     * @return The ID of your Amazon Route 53 hosted zone.
     */
    public final String hostedZoneId() {
        return hostedZoneId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(domainName());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(certificateArn());
        hashCode = 31 * hashCode + Objects.hashCode(appsyncDomainName());
        hashCode = 31 * hashCode + Objects.hashCode(hostedZoneId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DomainNameConfig)) {
            return false;
        }
        DomainNameConfig other = (DomainNameConfig) obj;
        return Objects.equals(domainName(), other.domainName()) && Objects.equals(description(), other.description())
                && Objects.equals(certificateArn(), other.certificateArn())
                && Objects.equals(appsyncDomainName(), other.appsyncDomainName())
                && Objects.equals(hostedZoneId(), other.hostedZoneId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DomainNameConfig").add("DomainName", domainName()).add("Description", description())
                .add("CertificateArn", certificateArn()).add("AppsyncDomainName", appsyncDomainName())
                .add("HostedZoneId", hostedZoneId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "domainName":
            return Optional.ofNullable(clazz.cast(domainName()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "certificateArn":
            return Optional.ofNullable(clazz.cast(certificateArn()));
        case "appsyncDomainName":
            return Optional.ofNullable(clazz.cast(appsyncDomainName()));
        case "hostedZoneId":
            return Optional.ofNullable(clazz.cast(hostedZoneId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DomainNameConfig, T> g) {
        return obj -> g.apply((DomainNameConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DomainNameConfig> {
        /**
         * <p>
         * The domain name.
         * </p>
         * 
         * @param domainName
         *        The domain name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder domainName(String domainName);

        /**
         * <p>
         * A description of the <code>DomainName</code> configuration.
         * </p>
         * 
         * @param description
         *        A description of the <code>DomainName</code> configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM) certificate or an
         * Identity and Access Management (IAM) server certificate.
         * </p>
         * 
         * @param certificateArn
         *        The Amazon Resource Name (ARN) of the certificate. This can be an Certificate Manager (ACM)
         *        certificate or an Identity and Access Management (IAM) server certificate.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder certificateArn(String certificateArn);

        /**
         * <p>
         * The domain name that AppSync provides.
         * </p>
         * 
         * @param appsyncDomainName
         *        The domain name that AppSync provides.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder appsyncDomainName(String appsyncDomainName);

        /**
         * <p>
         * The ID of your Amazon Route 53 hosted zone.
         * </p>
         * 
         * @param hostedZoneId
         *        The ID of your Amazon Route 53 hosted zone.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostedZoneId(String hostedZoneId);
    }

    static final class BuilderImpl implements Builder {
        private String domainName;

        private String description;

        private String certificateArn;

        private String appsyncDomainName;

        private String hostedZoneId;

        private BuilderImpl() {
        }

        private BuilderImpl(DomainNameConfig model) {
            domainName(model.domainName);
            description(model.description);
            certificateArn(model.certificateArn);
            appsyncDomainName(model.appsyncDomainName);
            hostedZoneId(model.hostedZoneId);
        }

        public final String getDomainName() {
            return domainName;
        }

        public final void setDomainName(String domainName) {
            this.domainName = domainName;
        }

        @Override
        @Transient
        public final Builder domainName(String domainName) {
            this.domainName = domainName;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getCertificateArn() {
            return certificateArn;
        }

        public final void setCertificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
        }

        @Override
        @Transient
        public final Builder certificateArn(String certificateArn) {
            this.certificateArn = certificateArn;
            return this;
        }

        public final String getAppsyncDomainName() {
            return appsyncDomainName;
        }

        public final void setAppsyncDomainName(String appsyncDomainName) {
            this.appsyncDomainName = appsyncDomainName;
        }

        @Override
        @Transient
        public final Builder appsyncDomainName(String appsyncDomainName) {
            this.appsyncDomainName = appsyncDomainName;
            return this;
        }

        public final String getHostedZoneId() {
            return hostedZoneId;
        }

        public final void setHostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
        }

        @Override
        @Transient
        public final Builder hostedZoneId(String hostedZoneId) {
            this.hostedZoneId = hostedZoneId;
            return this;
        }

        @Override
        public DomainNameConfig build() {
            return new DomainNameConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
