/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a GraphQL API.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GraphqlApi implements SdkPojo, Serializable, ToCopyableBuilder<GraphqlApi.Builder, GraphqlApi> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(GraphqlApi::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(GraphqlApi::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiId").build()).build();

    private static final SdkField<String> AUTHENTICATION_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("authenticationType").getter(getter(GraphqlApi::authenticationTypeAsString))
            .setter(setter(Builder::authenticationType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authenticationType").build())
            .build();

    private static final SdkField<LogConfig> LOG_CONFIG_FIELD = SdkField.<LogConfig> builder(MarshallingType.SDK_POJO)
            .memberName("logConfig").getter(getter(GraphqlApi::logConfig)).setter(setter(Builder::logConfig))
            .constructor(LogConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logConfig").build()).build();

    private static final SdkField<UserPoolConfig> USER_POOL_CONFIG_FIELD = SdkField
            .<UserPoolConfig> builder(MarshallingType.SDK_POJO).memberName("userPoolConfig")
            .getter(getter(GraphqlApi::userPoolConfig)).setter(setter(Builder::userPoolConfig))
            .constructor(UserPoolConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("userPoolConfig").build()).build();

    private static final SdkField<OpenIDConnectConfig> OPEN_ID_CONNECT_CONFIG_FIELD = SdkField
            .<OpenIDConnectConfig> builder(MarshallingType.SDK_POJO).memberName("openIDConnectConfig")
            .getter(getter(GraphqlApi::openIDConnectConfig)).setter(setter(Builder::openIDConnectConfig))
            .constructor(OpenIDConnectConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("openIDConnectConfig").build())
            .build();

    private static final SdkField<String> ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("arn")
            .getter(getter(GraphqlApi::arn)).setter(setter(Builder::arn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arn").build()).build();

    private static final SdkField<Map<String, String>> URIS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("uris")
            .getter(getter(GraphqlApi::uris))
            .setter(setter(Builder::uris))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("uris").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(GraphqlApi::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<AdditionalAuthenticationProvider>> ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD = SdkField
            .<List<AdditionalAuthenticationProvider>> builder(MarshallingType.LIST)
            .memberName("additionalAuthenticationProviders")
            .getter(getter(GraphqlApi::additionalAuthenticationProviders))
            .setter(setter(Builder::additionalAuthenticationProviders))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("additionalAuthenticationProviders")
                    .build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<AdditionalAuthenticationProvider> builder(MarshallingType.SDK_POJO)
                                            .constructor(AdditionalAuthenticationProvider::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Boolean> XRAY_ENABLED_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("xrayEnabled").getter(getter(GraphqlApi::xrayEnabled)).setter(setter(Builder::xrayEnabled))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("xrayEnabled").build()).build();

    private static final SdkField<String> WAF_WEB_ACL_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("wafWebAclArn").getter(getter(GraphqlApi::wafWebAclArn)).setter(setter(Builder::wafWebAclArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("wafWebAclArn").build()).build();

    private static final SdkField<LambdaAuthorizerConfig> LAMBDA_AUTHORIZER_CONFIG_FIELD = SdkField
            .<LambdaAuthorizerConfig> builder(MarshallingType.SDK_POJO).memberName("lambdaAuthorizerConfig")
            .getter(getter(GraphqlApi::lambdaAuthorizerConfig)).setter(setter(Builder::lambdaAuthorizerConfig))
            .constructor(LambdaAuthorizerConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lambdaAuthorizerConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, API_ID_FIELD,
            AUTHENTICATION_TYPE_FIELD, LOG_CONFIG_FIELD, USER_POOL_CONFIG_FIELD, OPEN_ID_CONNECT_CONFIG_FIELD, ARN_FIELD,
            URIS_FIELD, TAGS_FIELD, ADDITIONAL_AUTHENTICATION_PROVIDERS_FIELD, XRAY_ENABLED_FIELD, WAF_WEB_ACL_ARN_FIELD,
            LAMBDA_AUTHORIZER_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String apiId;

    private final String authenticationType;

    private final LogConfig logConfig;

    private final UserPoolConfig userPoolConfig;

    private final OpenIDConnectConfig openIDConnectConfig;

    private final String arn;

    private final Map<String, String> uris;

    private final Map<String, String> tags;

    private final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders;

    private final Boolean xrayEnabled;

    private final String wafWebAclArn;

    private final LambdaAuthorizerConfig lambdaAuthorizerConfig;

    private GraphqlApi(BuilderImpl builder) {
        this.name = builder.name;
        this.apiId = builder.apiId;
        this.authenticationType = builder.authenticationType;
        this.logConfig = builder.logConfig;
        this.userPoolConfig = builder.userPoolConfig;
        this.openIDConnectConfig = builder.openIDConnectConfig;
        this.arn = builder.arn;
        this.uris = builder.uris;
        this.tags = builder.tags;
        this.additionalAuthenticationProviders = builder.additionalAuthenticationProviders;
        this.xrayEnabled = builder.xrayEnabled;
        this.wafWebAclArn = builder.wafWebAclArn;
        this.lambdaAuthorizerConfig = builder.lambdaAuthorizerConfig;
    }

    /**
     * <p>
     * The API name.
     * </p>
     * 
     * @return The API name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The API ID.
     * </p>
     * 
     * @return The API ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The authentication type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type.
     * @see AuthenticationType
     */
    public final AuthenticationType authenticationType() {
        return AuthenticationType.fromValue(authenticationType);
    }

    /**
     * <p>
     * The authentication type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #authenticationType} will return {@link AuthenticationType#UNKNOWN_TO_SDK_VERSION}. The raw value returned
     * by the service is available from {@link #authenticationTypeAsString}.
     * </p>
     * 
     * @return The authentication type.
     * @see AuthenticationType
     */
    public final String authenticationTypeAsString() {
        return authenticationType;
    }

    /**
     * <p>
     * The Amazon CloudWatch Logs configuration.
     * </p>
     * 
     * @return The Amazon CloudWatch Logs configuration.
     */
    public final LogConfig logConfig() {
        return logConfig;
    }

    /**
     * <p>
     * The Amazon Cognito user pool configuration.
     * </p>
     * 
     * @return The Amazon Cognito user pool configuration.
     */
    public final UserPoolConfig userPoolConfig() {
        return userPoolConfig;
    }

    /**
     * <p>
     * The OpenID Connect configuration.
     * </p>
     * 
     * @return The OpenID Connect configuration.
     */
    public final OpenIDConnectConfig openIDConnectConfig() {
        return openIDConnectConfig;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The Amazon Resource Name (ARN).
     */
    public final String arn() {
        return arn;
    }

    /**
     * For responses, this returns true if the service returned a value for the Uris property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasUris() {
        return uris != null && !(uris instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The URIs.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasUris} method.
     * </p>
     * 
     * @return The URIs.
     */
    public final Map<String, String> uris() {
        return uris;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * For responses, this returns true if the service returned a value for the AdditionalAuthenticationProviders
     * property. This DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()}
     * method on the property). This is useful because the SDK will never return a null collection or map, but you may
     * need to differentiate between the service returning nothing (or null) and the service returning an empty
     * collection or map. For requests, this returns true if a value for the property was specified in the request
     * builder, and false if a value was not specified.
     */
    public final boolean hasAdditionalAuthenticationProviders() {
        return additionalAuthenticationProviders != null && !(additionalAuthenticationProviders instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of additional authentication providers for the <code>GraphqlApi</code> API.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAdditionalAuthenticationProviders}
     * method.
     * </p>
     * 
     * @return A list of additional authentication providers for the <code>GraphqlApi</code> API.
     */
    public final List<AdditionalAuthenticationProvider> additionalAuthenticationProviders() {
        return additionalAuthenticationProviders;
    }

    /**
     * <p>
     * A flag indicating whether to use X-Ray tracing for this <code>GraphqlApi</code>.
     * </p>
     * 
     * @return A flag indicating whether to use X-Ray tracing for this <code>GraphqlApi</code>.
     */
    public final Boolean xrayEnabled() {
        return xrayEnabled;
    }

    /**
     * <p>
     * The ARN of the WAF access control list (ACL) associated with this <code>GraphqlApi</code>, if one exists.
     * </p>
     * 
     * @return The ARN of the WAF access control list (ACL) associated with this <code>GraphqlApi</code>, if one exists.
     */
    public final String wafWebAclArn() {
        return wafWebAclArn;
    }

    /**
     * <p>
     * Configuration for Lambda function authorization.
     * </p>
     * 
     * @return Configuration for Lambda function authorization.
     */
    public final LambdaAuthorizerConfig lambdaAuthorizerConfig() {
        return lambdaAuthorizerConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(authenticationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(logConfig());
        hashCode = 31 * hashCode + Objects.hashCode(userPoolConfig());
        hashCode = 31 * hashCode + Objects.hashCode(openIDConnectConfig());
        hashCode = 31 * hashCode + Objects.hashCode(arn());
        hashCode = 31 * hashCode + Objects.hashCode(hasUris() ? uris() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode
                + Objects.hashCode(hasAdditionalAuthenticationProviders() ? additionalAuthenticationProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(xrayEnabled());
        hashCode = 31 * hashCode + Objects.hashCode(wafWebAclArn());
        hashCode = 31 * hashCode + Objects.hashCode(lambdaAuthorizerConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GraphqlApi)) {
            return false;
        }
        GraphqlApi other = (GraphqlApi) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(apiId(), other.apiId())
                && Objects.equals(authenticationTypeAsString(), other.authenticationTypeAsString())
                && Objects.equals(logConfig(), other.logConfig()) && Objects.equals(userPoolConfig(), other.userPoolConfig())
                && Objects.equals(openIDConnectConfig(), other.openIDConnectConfig()) && Objects.equals(arn(), other.arn())
                && hasUris() == other.hasUris() && Objects.equals(uris(), other.uris()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags())
                && hasAdditionalAuthenticationProviders() == other.hasAdditionalAuthenticationProviders()
                && Objects.equals(additionalAuthenticationProviders(), other.additionalAuthenticationProviders())
                && Objects.equals(xrayEnabled(), other.xrayEnabled()) && Objects.equals(wafWebAclArn(), other.wafWebAclArn())
                && Objects.equals(lambdaAuthorizerConfig(), other.lambdaAuthorizerConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString
                .builder("GraphqlApi")
                .add("Name", name())
                .add("ApiId", apiId())
                .add("AuthenticationType", authenticationTypeAsString())
                .add("LogConfig", logConfig())
                .add("UserPoolConfig", userPoolConfig())
                .add("OpenIDConnectConfig", openIDConnectConfig())
                .add("Arn", arn())
                .add("Uris", hasUris() ? uris() : null)
                .add("Tags", hasTags() ? tags() : null)
                .add("AdditionalAuthenticationProviders",
                        hasAdditionalAuthenticationProviders() ? additionalAuthenticationProviders() : null)
                .add("XrayEnabled", xrayEnabled()).add("WafWebAclArn", wafWebAclArn())
                .add("LambdaAuthorizerConfig", lambdaAuthorizerConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "authenticationType":
            return Optional.ofNullable(clazz.cast(authenticationTypeAsString()));
        case "logConfig":
            return Optional.ofNullable(clazz.cast(logConfig()));
        case "userPoolConfig":
            return Optional.ofNullable(clazz.cast(userPoolConfig()));
        case "openIDConnectConfig":
            return Optional.ofNullable(clazz.cast(openIDConnectConfig()));
        case "arn":
            return Optional.ofNullable(clazz.cast(arn()));
        case "uris":
            return Optional.ofNullable(clazz.cast(uris()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "additionalAuthenticationProviders":
            return Optional.ofNullable(clazz.cast(additionalAuthenticationProviders()));
        case "xrayEnabled":
            return Optional.ofNullable(clazz.cast(xrayEnabled()));
        case "wafWebAclArn":
            return Optional.ofNullable(clazz.cast(wafWebAclArn()));
        case "lambdaAuthorizerConfig":
            return Optional.ofNullable(clazz.cast(lambdaAuthorizerConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<GraphqlApi, T> g) {
        return obj -> g.apply((GraphqlApi) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GraphqlApi> {
        /**
         * <p>
         * The API name.
         * </p>
         * 
         * @param name
         *        The API name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The API ID.
         * </p>
         * 
         * @param apiId
         *        The API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The authentication type.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(String authenticationType);

        /**
         * <p>
         * The authentication type.
         * </p>
         * 
         * @param authenticationType
         *        The authentication type.
         * @see AuthenticationType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AuthenticationType
         */
        Builder authenticationType(AuthenticationType authenticationType);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration.
         * </p>
         * 
         * @param logConfig
         *        The Amazon CloudWatch Logs configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logConfig(LogConfig logConfig);

        /**
         * <p>
         * The Amazon CloudWatch Logs configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link LogConfig.Builder} avoiding the need to create
         * one manually via {@link LogConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LogConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #logConfig(LogConfig)}.
         * 
         * @param logConfig
         *        a consumer that will call methods on {@link LogConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logConfig(LogConfig)
         */
        default Builder logConfig(Consumer<LogConfig.Builder> logConfig) {
            return logConfig(LogConfig.builder().applyMutation(logConfig).build());
        }

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * 
         * @param userPoolConfig
         *        The Amazon Cognito user pool configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder userPoolConfig(UserPoolConfig userPoolConfig);

        /**
         * <p>
         * The Amazon Cognito user pool configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link UserPoolConfig.Builder} avoiding the need to
         * create one manually via {@link UserPoolConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link UserPoolConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #userPoolConfig(UserPoolConfig)}.
         * 
         * @param userPoolConfig
         *        a consumer that will call methods on {@link UserPoolConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #userPoolConfig(UserPoolConfig)
         */
        default Builder userPoolConfig(Consumer<UserPoolConfig.Builder> userPoolConfig) {
            return userPoolConfig(UserPoolConfig.builder().applyMutation(userPoolConfig).build());
        }

        /**
         * <p>
         * The OpenID Connect configuration.
         * </p>
         * 
         * @param openIDConnectConfig
         *        The OpenID Connect configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig);

        /**
         * <p>
         * The OpenID Connect configuration.
         * </p>
         * This is a convenience that creates an instance of the {@link OpenIDConnectConfig.Builder} avoiding the need
         * to create one manually via {@link OpenIDConnectConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link OpenIDConnectConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #openIDConnectConfig(OpenIDConnectConfig)}.
         * 
         * @param openIDConnectConfig
         *        a consumer that will call methods on {@link OpenIDConnectConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #openIDConnectConfig(OpenIDConnectConfig)
         */
        default Builder openIDConnectConfig(Consumer<OpenIDConnectConfig.Builder> openIDConnectConfig) {
            return openIDConnectConfig(OpenIDConnectConfig.builder().applyMutation(openIDConnectConfig).build());
        }

        /**
         * <p>
         * The Amazon Resource Name (ARN).
         * </p>
         * 
         * @param arn
         *        The Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arn(String arn);

        /**
         * <p>
         * The URIs.
         * </p>
         * 
         * @param uris
         *        The URIs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder uris(Map<String, String> uris);

        /**
         * <p>
         * The tags.
         * </p>
         * 
         * @param tags
         *        The tags.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * 
         * @param additionalAuthenticationProviders
         *        A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder additionalAuthenticationProviders(AdditionalAuthenticationProvider... additionalAuthenticationProviders);

        /**
         * <p>
         * A list of additional authentication providers for the <code>GraphqlApi</code> API.
         * </p>
         * This is a convenience that creates an instance of the {@link List<AdditionalAuthenticationProvider>.Builder}
         * avoiding the need to create one manually via {@link List<AdditionalAuthenticationProvider>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<AdditionalAuthenticationProvider>.Builder#build()} is called
         * immediately and its result is passed to {@link
         * #additionalAuthenticationProviders(List<AdditionalAuthenticationProvider>)}.
         * 
         * @param additionalAuthenticationProviders
         *        a consumer that will call methods on {@link List<AdditionalAuthenticationProvider>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #additionalAuthenticationProviders(List<AdditionalAuthenticationProvider>)
         */
        Builder additionalAuthenticationProviders(
                Consumer<AdditionalAuthenticationProvider.Builder>... additionalAuthenticationProviders);

        /**
         * <p>
         * A flag indicating whether to use X-Ray tracing for this <code>GraphqlApi</code>.
         * </p>
         * 
         * @param xrayEnabled
         *        A flag indicating whether to use X-Ray tracing for this <code>GraphqlApi</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder xrayEnabled(Boolean xrayEnabled);

        /**
         * <p>
         * The ARN of the WAF access control list (ACL) associated with this <code>GraphqlApi</code>, if one exists.
         * </p>
         * 
         * @param wafWebAclArn
         *        The ARN of the WAF access control list (ACL) associated with this <code>GraphqlApi</code>, if one
         *        exists.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder wafWebAclArn(String wafWebAclArn);

        /**
         * <p>
         * Configuration for Lambda function authorization.
         * </p>
         * 
         * @param lambdaAuthorizerConfig
         *        Configuration for Lambda function authorization.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig);

        /**
         * <p>
         * Configuration for Lambda function authorization.
         * </p>
         * This is a convenience that creates an instance of the {@link LambdaAuthorizerConfig.Builder} avoiding the
         * need to create one manually via {@link LambdaAuthorizerConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link LambdaAuthorizerConfig.Builder#build()} is called immediately and
         * its result is passed to {@link #lambdaAuthorizerConfig(LambdaAuthorizerConfig)}.
         * 
         * @param lambdaAuthorizerConfig
         *        a consumer that will call methods on {@link LambdaAuthorizerConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #lambdaAuthorizerConfig(LambdaAuthorizerConfig)
         */
        default Builder lambdaAuthorizerConfig(Consumer<LambdaAuthorizerConfig.Builder> lambdaAuthorizerConfig) {
            return lambdaAuthorizerConfig(LambdaAuthorizerConfig.builder().applyMutation(lambdaAuthorizerConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String apiId;

        private String authenticationType;

        private LogConfig logConfig;

        private UserPoolConfig userPoolConfig;

        private OpenIDConnectConfig openIDConnectConfig;

        private String arn;

        private Map<String, String> uris = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private List<AdditionalAuthenticationProvider> additionalAuthenticationProviders = DefaultSdkAutoConstructList
                .getInstance();

        private Boolean xrayEnabled;

        private String wafWebAclArn;

        private LambdaAuthorizerConfig lambdaAuthorizerConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(GraphqlApi model) {
            name(model.name);
            apiId(model.apiId);
            authenticationType(model.authenticationType);
            logConfig(model.logConfig);
            userPoolConfig(model.userPoolConfig);
            openIDConnectConfig(model.openIDConnectConfig);
            arn(model.arn);
            uris(model.uris);
            tags(model.tags);
            additionalAuthenticationProviders(model.additionalAuthenticationProviders);
            xrayEnabled(model.xrayEnabled);
            wafWebAclArn(model.wafWebAclArn);
            lambdaAuthorizerConfig(model.lambdaAuthorizerConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        @Transient
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getAuthenticationType() {
            return authenticationType;
        }

        public final void setAuthenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
        }

        @Override
        @Transient
        public final Builder authenticationType(String authenticationType) {
            this.authenticationType = authenticationType;
            return this;
        }

        @Override
        @Transient
        public final Builder authenticationType(AuthenticationType authenticationType) {
            this.authenticationType(authenticationType == null ? null : authenticationType.toString());
            return this;
        }

        public final LogConfig.Builder getLogConfig() {
            return logConfig != null ? logConfig.toBuilder() : null;
        }

        public final void setLogConfig(LogConfig.BuilderImpl logConfig) {
            this.logConfig = logConfig != null ? logConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder logConfig(LogConfig logConfig) {
            this.logConfig = logConfig;
            return this;
        }

        public final UserPoolConfig.Builder getUserPoolConfig() {
            return userPoolConfig != null ? userPoolConfig.toBuilder() : null;
        }

        public final void setUserPoolConfig(UserPoolConfig.BuilderImpl userPoolConfig) {
            this.userPoolConfig = userPoolConfig != null ? userPoolConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder userPoolConfig(UserPoolConfig userPoolConfig) {
            this.userPoolConfig = userPoolConfig;
            return this;
        }

        public final OpenIDConnectConfig.Builder getOpenIDConnectConfig() {
            return openIDConnectConfig != null ? openIDConnectConfig.toBuilder() : null;
        }

        public final void setOpenIDConnectConfig(OpenIDConnectConfig.BuilderImpl openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig != null ? openIDConnectConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder openIDConnectConfig(OpenIDConnectConfig openIDConnectConfig) {
            this.openIDConnectConfig = openIDConnectConfig;
            return this;
        }

        public final String getArn() {
            return arn;
        }

        public final void setArn(String arn) {
            this.arn = arn;
        }

        @Override
        @Transient
        public final Builder arn(String arn) {
            this.arn = arn;
            return this;
        }

        public final Map<String, String> getUris() {
            if (uris instanceof SdkAutoConstructMap) {
                return null;
            }
            return uris;
        }

        public final void setUris(Map<String, String> uris) {
            this.uris = MapOfStringToStringCopier.copy(uris);
        }

        @Override
        @Transient
        public final Builder uris(Map<String, String> uris) {
            this.uris = MapOfStringToStringCopier.copy(uris);
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        @Transient
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final List<AdditionalAuthenticationProvider.Builder> getAdditionalAuthenticationProviders() {
            List<AdditionalAuthenticationProvider.Builder> result = AdditionalAuthenticationProvidersCopier
                    .copyToBuilder(this.additionalAuthenticationProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAdditionalAuthenticationProviders(
                Collection<AdditionalAuthenticationProvider.BuilderImpl> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier
                    .copyFromBuilder(additionalAuthenticationProviders);
        }

        @Override
        @Transient
        public final Builder additionalAuthenticationProviders(
                Collection<AdditionalAuthenticationProvider> additionalAuthenticationProviders) {
            this.additionalAuthenticationProviders = AdditionalAuthenticationProvidersCopier
                    .copy(additionalAuthenticationProviders);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                AdditionalAuthenticationProvider... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Arrays.asList(additionalAuthenticationProviders));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder additionalAuthenticationProviders(
                Consumer<AdditionalAuthenticationProvider.Builder>... additionalAuthenticationProviders) {
            additionalAuthenticationProviders(Stream.of(additionalAuthenticationProviders)
                    .map(c -> AdditionalAuthenticationProvider.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final Boolean getXrayEnabled() {
            return xrayEnabled;
        }

        public final void setXrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
        }

        @Override
        @Transient
        public final Builder xrayEnabled(Boolean xrayEnabled) {
            this.xrayEnabled = xrayEnabled;
            return this;
        }

        public final String getWafWebAclArn() {
            return wafWebAclArn;
        }

        public final void setWafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
        }

        @Override
        @Transient
        public final Builder wafWebAclArn(String wafWebAclArn) {
            this.wafWebAclArn = wafWebAclArn;
            return this;
        }

        public final LambdaAuthorizerConfig.Builder getLambdaAuthorizerConfig() {
            return lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.toBuilder() : null;
        }

        public final void setLambdaAuthorizerConfig(LambdaAuthorizerConfig.BuilderImpl lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig != null ? lambdaAuthorizerConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder lambdaAuthorizerConfig(LambdaAuthorizerConfig lambdaAuthorizerConfig) {
            this.lambdaAuthorizerConfig = lambdaAuthorizerConfig;
            return this;
        }

        @Override
        public GraphqlApi build() {
            return new GraphqlApi(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
