/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListTypesResponse extends AppSyncResponse implements
        ToCopyableBuilder<ListTypesResponse.Builder, ListTypesResponse> {
    private static final SdkField<List<Type>> TYPES_FIELD = SdkField
            .<List<Type>> builder(MarshallingType.LIST)
            .memberName("types")
            .getter(getter(ListTypesResponse::types))
            .setter(setter(Builder::types))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("types").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Type> builder(MarshallingType.SDK_POJO)
                                            .constructor(Type::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListTypesResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TYPES_FIELD, NEXT_TOKEN_FIELD));

    private final List<Type> types;

    private final String nextToken;

    private ListTypesResponse(BuilderImpl builder) {
        super(builder);
        this.types = builder.types;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Types property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTypes() {
        return types != null && !(types instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>Type</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTypes} method.
     * </p>
     * 
     * @return The <code>Type</code> objects.
     */
    public final List<Type> types() {
        return types;
    }

    /**
     * <p>
     * An identifier to pass in the next request to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier to pass in the next request to this operation to return the next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasTypes() ? types() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListTypesResponse)) {
            return false;
        }
        ListTypesResponse other = (ListTypesResponse) obj;
        return hasTypes() == other.hasTypes() && Objects.equals(types(), other.types())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListTypesResponse").add("Types", hasTypes() ? types() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "types":
            return Optional.ofNullable(clazz.cast(types()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListTypesResponse, T> g) {
        return obj -> g.apply((ListTypesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListTypesResponse> {
        /**
         * <p>
         * The <code>Type</code> objects.
         * </p>
         * 
         * @param types
         *        The <code>Type</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Collection<Type> types);

        /**
         * <p>
         * The <code>Type</code> objects.
         * </p>
         * 
         * @param types
         *        The <code>Type</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder types(Type... types);

        /**
         * <p>
         * The <code>Type</code> objects.
         * </p>
         * This is a convenience that creates an instance of the {@link List<Type>.Builder} avoiding the need to create
         * one manually via {@link List<Type>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<Type>.Builder#build()} is called immediately and its result
         * is passed to {@link #types(List<Type>)}.
         * 
         * @param types
         *        a consumer that will call methods on {@link List<Type>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #types(List<Type>)
         */
        Builder types(Consumer<Type.Builder>... types);

        /**
         * <p>
         * An identifier to pass in the next request to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier to pass in the next request to this operation to return the next set of items in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private List<Type> types = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListTypesResponse model) {
            super(model);
            types(model.types);
            nextToken(model.nextToken);
        }

        public final List<Type.Builder> getTypes() {
            List<Type.Builder> result = TypeListCopier.copyToBuilder(this.types);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTypes(Collection<Type.BuilderImpl> types) {
            this.types = TypeListCopier.copyFromBuilder(types);
        }

        @Override
        @Transient
        public final Builder types(Collection<Type> types) {
            this.types = TypeListCopier.copy(types);
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder types(Type... types) {
            types(Arrays.asList(types));
            return this;
        }

        @Override
        @Transient
        @SafeVarargs
        public final Builder types(Consumer<Type.Builder>... types) {
            types(Stream.of(types).map(c -> Type.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        @Transient
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListTypesResponse build() {
            return new ListTypesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
