/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes an OpenID Connect (OIDC) configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class OpenIDConnectConfig implements SdkPojo, Serializable,
        ToCopyableBuilder<OpenIDConnectConfig.Builder, OpenIDConnectConfig> {
    private static final SdkField<String> ISSUER_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("issuer")
            .getter(getter(OpenIDConnectConfig::issuer)).setter(setter(Builder::issuer))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("issuer").build()).build();

    private static final SdkField<String> CLIENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clientId").getter(getter(OpenIDConnectConfig::clientId)).setter(setter(Builder::clientId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientId").build()).build();

    private static final SdkField<Long> IAT_TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("iatTTL")
            .getter(getter(OpenIDConnectConfig::iatTTL)).setter(setter(Builder::iatTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("iatTTL").build()).build();

    private static final SdkField<Long> AUTH_TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("authTTL")
            .getter(getter(OpenIDConnectConfig::authTTL)).setter(setter(Builder::authTTL))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authTTL").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ISSUER_FIELD, CLIENT_ID_FIELD,
            IAT_TTL_FIELD, AUTH_TTL_FIELD));

    private static final long serialVersionUID = 1L;

    private final String issuer;

    private final String clientId;

    private final Long iatTTL;

    private final Long authTTL;

    private OpenIDConnectConfig(BuilderImpl builder) {
        this.issuer = builder.issuer;
        this.clientId = builder.clientId;
        this.iatTTL = builder.iatTTL;
        this.authTTL = builder.authTTL;
    }

    /**
     * <p>
     * The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of
     * <code>iss</code> in the ID token.
     * </p>
     * 
     * @return The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of
     *         <code>iss</code> in the ID token.
     */
    public final String issuer() {
        return issuer;
    }

    /**
     * <p>
     * The client identifier of the relying party at the OpenID identity provider. This identifier is typically obtained
     * when the relying party is registered with the OpenID identity provider. You can specify a regular expression so
     * that AppSync can validate against multiple client identifiers at a time.
     * </p>
     * 
     * @return The client identifier of the relying party at the OpenID identity provider. This identifier is typically
     *         obtained when the relying party is registered with the OpenID identity provider. You can specify a
     *         regular expression so that AppSync can validate against multiple client identifiers at a time.
     */
    public final String clientId() {
        return clientId;
    }

    /**
     * <p>
     * The number of milliseconds that a token is valid after it's issued to a user.
     * </p>
     * 
     * @return The number of milliseconds that a token is valid after it's issued to a user.
     */
    public final Long iatTTL() {
        return iatTTL;
    }

    /**
     * <p>
     * The number of milliseconds that a token is valid after being authenticated.
     * </p>
     * 
     * @return The number of milliseconds that a token is valid after being authenticated.
     */
    public final Long authTTL() {
        return authTTL;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(issuer());
        hashCode = 31 * hashCode + Objects.hashCode(clientId());
        hashCode = 31 * hashCode + Objects.hashCode(iatTTL());
        hashCode = 31 * hashCode + Objects.hashCode(authTTL());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof OpenIDConnectConfig)) {
            return false;
        }
        OpenIDConnectConfig other = (OpenIDConnectConfig) obj;
        return Objects.equals(issuer(), other.issuer()) && Objects.equals(clientId(), other.clientId())
                && Objects.equals(iatTTL(), other.iatTTL()) && Objects.equals(authTTL(), other.authTTL());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("OpenIDConnectConfig").add("Issuer", issuer()).add("ClientId", clientId())
                .add("IatTTL", iatTTL()).add("AuthTTL", authTTL()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "issuer":
            return Optional.ofNullable(clazz.cast(issuer()));
        case "clientId":
            return Optional.ofNullable(clazz.cast(clientId()));
        case "iatTTL":
            return Optional.ofNullable(clazz.cast(iatTTL()));
        case "authTTL":
            return Optional.ofNullable(clazz.cast(authTTL()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<OpenIDConnectConfig, T> g) {
        return obj -> g.apply((OpenIDConnectConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, OpenIDConnectConfig> {
        /**
         * <p>
         * The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value of
         * <code>iss</code> in the ID token.
         * </p>
         * 
         * @param issuer
         *        The issuer for the OIDC configuration. The issuer returned by discovery must exactly match the value
         *        of <code>iss</code> in the ID token.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder issuer(String issuer);

        /**
         * <p>
         * The client identifier of the relying party at the OpenID identity provider. This identifier is typically
         * obtained when the relying party is registered with the OpenID identity provider. You can specify a regular
         * expression so that AppSync can validate against multiple client identifiers at a time.
         * </p>
         * 
         * @param clientId
         *        The client identifier of the relying party at the OpenID identity provider. This identifier is
         *        typically obtained when the relying party is registered with the OpenID identity provider. You can
         *        specify a regular expression so that AppSync can validate against multiple client identifiers at a
         *        time.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientId(String clientId);

        /**
         * <p>
         * The number of milliseconds that a token is valid after it's issued to a user.
         * </p>
         * 
         * @param iatTTL
         *        The number of milliseconds that a token is valid after it's issued to a user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder iatTTL(Long iatTTL);

        /**
         * <p>
         * The number of milliseconds that a token is valid after being authenticated.
         * </p>
         * 
         * @param authTTL
         *        The number of milliseconds that a token is valid after being authenticated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder authTTL(Long authTTL);
    }

    static final class BuilderImpl implements Builder {
        private String issuer;

        private String clientId;

        private Long iatTTL;

        private Long authTTL;

        private BuilderImpl() {
        }

        private BuilderImpl(OpenIDConnectConfig model) {
            issuer(model.issuer);
            clientId(model.clientId);
            iatTTL(model.iatTTL);
            authTTL(model.authTTL);
        }

        public final String getIssuer() {
            return issuer;
        }

        public final void setIssuer(String issuer) {
            this.issuer = issuer;
        }

        @Override
        @Transient
        public final Builder issuer(String issuer) {
            this.issuer = issuer;
            return this;
        }

        public final String getClientId() {
            return clientId;
        }

        public final void setClientId(String clientId) {
            this.clientId = clientId;
        }

        @Override
        @Transient
        public final Builder clientId(String clientId) {
            this.clientId = clientId;
            return this;
        }

        public final Long getIatTTL() {
            return iatTTL;
        }

        public final void setIatTTL(Long iatTTL) {
            this.iatTTL = iatTTL;
        }

        @Override
        @Transient
        public final Builder iatTTL(Long iatTTL) {
            this.iatTTL = iatTTL;
            return this;
        }

        public final Long getAuthTTL() {
            return authTTL;
        }

        public final void setAuthTTL(Long authTTL) {
            this.authTTL = authTTL;
        }

        @Override
        @Transient
        public final Builder authTTL(Long authTTL) {
            this.authTTL = authTTL;
            return this;
        }

        @Override
        public OpenIDConnectConfig build() {
            return new OpenIDConnectConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
