/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Describes a resolver.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Resolver implements SdkPojo, Serializable, ToCopyableBuilder<Resolver.Builder, Resolver> {
    private static final SdkField<String> TYPE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("typeName").getter(getter(Resolver::typeName)).setter(setter(Builder::typeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("typeName").build()).build();

    private static final SdkField<String> FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fieldName").getter(getter(Resolver::fieldName)).setter(setter(Builder::fieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fieldName").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceName").getter(getter(Resolver::dataSourceName)).setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()).build();

    private static final SdkField<String> RESOLVER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resolverArn").getter(getter(Resolver::resolverArn)).setter(setter(Builder::resolverArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolverArn").build()).build();

    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestMappingTemplate").getter(getter(Resolver::requestMappingTemplate))
            .setter(setter(Builder::requestMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build())
            .build();

    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseMappingTemplate").getter(getter(Resolver::responseMappingTemplate))
            .setter(setter(Builder::responseMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build())
            .build();

    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kind")
            .getter(getter(Resolver::kindAsString)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<PipelineConfig> PIPELINE_CONFIG_FIELD = SdkField
            .<PipelineConfig> builder(MarshallingType.SDK_POJO).memberName("pipelineConfig")
            .getter(getter(Resolver::pipelineConfig)).setter(setter(Builder::pipelineConfig))
            .constructor(PipelineConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pipelineConfig").build()).build();

    private static final SdkField<SyncConfig> SYNC_CONFIG_FIELD = SdkField.<SyncConfig> builder(MarshallingType.SDK_POJO)
            .memberName("syncConfig").getter(getter(Resolver::syncConfig)).setter(setter(Builder::syncConfig))
            .constructor(SyncConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncConfig").build()).build();

    private static final SdkField<CachingConfig> CACHING_CONFIG_FIELD = SdkField
            .<CachingConfig> builder(MarshallingType.SDK_POJO).memberName("cachingConfig")
            .getter(getter(Resolver::cachingConfig)).setter(setter(Builder::cachingConfig)).constructor(CachingConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachingConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_NAME_FIELD,
            FIELD_NAME_FIELD, DATA_SOURCE_NAME_FIELD, RESOLVER_ARN_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD,
            RESPONSE_MAPPING_TEMPLATE_FIELD, KIND_FIELD, PIPELINE_CONFIG_FIELD, SYNC_CONFIG_FIELD, CACHING_CONFIG_FIELD));

    private static final long serialVersionUID = 1L;

    private final String typeName;

    private final String fieldName;

    private final String dataSourceName;

    private final String resolverArn;

    private final String requestMappingTemplate;

    private final String responseMappingTemplate;

    private final String kind;

    private final PipelineConfig pipelineConfig;

    private final SyncConfig syncConfig;

    private final CachingConfig cachingConfig;

    private Resolver(BuilderImpl builder) {
        this.typeName = builder.typeName;
        this.fieldName = builder.fieldName;
        this.dataSourceName = builder.dataSourceName;
        this.resolverArn = builder.resolverArn;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
        this.kind = builder.kind;
        this.pipelineConfig = builder.pipelineConfig;
        this.syncConfig = builder.syncConfig;
        this.cachingConfig = builder.cachingConfig;
    }

    /**
     * <p>
     * The resolver type name.
     * </p>
     * 
     * @return The resolver type name.
     */
    public final String typeName() {
        return typeName;
    }

    /**
     * <p>
     * The resolver field name.
     * </p>
     * 
     * @return The resolver field name.
     */
    public final String fieldName() {
        return fieldName;
    }

    /**
     * <p>
     * The resolver data source name.
     * </p>
     * 
     * @return The resolver data source name.
     */
    public final String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The resolver Amazon Resource Name (ARN).
     * </p>
     * 
     * @return The resolver Amazon Resource Name (ARN).
     */
    public final String resolverArn() {
        return resolverArn;
    }

    /**
     * <p>
     * The request mapping template.
     * </p>
     * 
     * @return The request mapping template.
     */
    public final String requestMappingTemplate() {
        return requestMappingTemplate;
    }

    /**
     * <p>
     * The response mapping template.
     * </p>
     * 
     * @return The response mapping template.
     */
    public final String responseMappingTemplate() {
        return responseMappingTemplate;
    }

    /**
     * <p>
     * The resolver type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to
     * run a GraphQL query against a single data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
     * <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against
     * multiple data sources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link ResolverKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The resolver type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT
     *         resolver to run a GraphQL query against a single data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
     *         <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query
     *         against multiple data sources.
     *         </p>
     *         </li>
     * @see ResolverKind
     */
    public final ResolverKind kind() {
        return ResolverKind.fromValue(kind);
    }

    /**
     * <p>
     * The resolver type.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver to
     * run a GraphQL query against a single data source.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
     * <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query against
     * multiple data sources.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #kind} will return
     * {@link ResolverKind#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #kindAsString}.
     * </p>
     * 
     * @return The resolver type.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT
     *         resolver to run a GraphQL query against a single data source.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
     *         <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query
     *         against multiple data sources.
     *         </p>
     *         </li>
     * @see ResolverKind
     */
    public final String kindAsString() {
        return kind;
    }

    /**
     * <p>
     * The <code>PipelineConfig</code>.
     * </p>
     * 
     * @return The <code>PipelineConfig</code>.
     */
    public final PipelineConfig pipelineConfig() {
        return pipelineConfig;
    }

    /**
     * <p>
     * The <code>SyncConfig</code> for a resolver attached to a versioned data source.
     * </p>
     * 
     * @return The <code>SyncConfig</code> for a resolver attached to a versioned data source.
     */
    public final SyncConfig syncConfig() {
        return syncConfig;
    }

    /**
     * <p>
     * The caching configuration for the resolver.
     * </p>
     * 
     * @return The caching configuration for the resolver.
     */
    public final CachingConfig cachingConfig() {
        return cachingConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(typeName());
        hashCode = 31 * hashCode + Objects.hashCode(fieldName());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(resolverArn());
        hashCode = 31 * hashCode + Objects.hashCode(requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(responseMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(kindAsString());
        hashCode = 31 * hashCode + Objects.hashCode(pipelineConfig());
        hashCode = 31 * hashCode + Objects.hashCode(syncConfig());
        hashCode = 31 * hashCode + Objects.hashCode(cachingConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Resolver)) {
            return false;
        }
        Resolver other = (Resolver) obj;
        return Objects.equals(typeName(), other.typeName()) && Objects.equals(fieldName(), other.fieldName())
                && Objects.equals(dataSourceName(), other.dataSourceName()) && Objects.equals(resolverArn(), other.resolverArn())
                && Objects.equals(requestMappingTemplate(), other.requestMappingTemplate())
                && Objects.equals(responseMappingTemplate(), other.responseMappingTemplate())
                && Objects.equals(kindAsString(), other.kindAsString())
                && Objects.equals(pipelineConfig(), other.pipelineConfig()) && Objects.equals(syncConfig(), other.syncConfig())
                && Objects.equals(cachingConfig(), other.cachingConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Resolver").add("TypeName", typeName()).add("FieldName", fieldName())
                .add("DataSourceName", dataSourceName()).add("ResolverArn", resolverArn())
                .add("RequestMappingTemplate", requestMappingTemplate())
                .add("ResponseMappingTemplate", responseMappingTemplate()).add("Kind", kindAsString())
                .add("PipelineConfig", pipelineConfig()).add("SyncConfig", syncConfig()).add("CachingConfig", cachingConfig())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "typeName":
            return Optional.ofNullable(clazz.cast(typeName()));
        case "fieldName":
            return Optional.ofNullable(clazz.cast(fieldName()));
        case "dataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "resolverArn":
            return Optional.ofNullable(clazz.cast(resolverArn()));
        case "requestMappingTemplate":
            return Optional.ofNullable(clazz.cast(requestMappingTemplate()));
        case "responseMappingTemplate":
            return Optional.ofNullable(clazz.cast(responseMappingTemplate()));
        case "kind":
            return Optional.ofNullable(clazz.cast(kindAsString()));
        case "pipelineConfig":
            return Optional.ofNullable(clazz.cast(pipelineConfig()));
        case "syncConfig":
            return Optional.ofNullable(clazz.cast(syncConfig()));
        case "cachingConfig":
            return Optional.ofNullable(clazz.cast(cachingConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Resolver, T> g) {
        return obj -> g.apply((Resolver) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Resolver> {
        /**
         * <p>
         * The resolver type name.
         * </p>
         * 
         * @param typeName
         *        The resolver type name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder typeName(String typeName);

        /**
         * <p>
         * The resolver field name.
         * </p>
         * 
         * @param fieldName
         *        The resolver field name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fieldName(String fieldName);

        /**
         * <p>
         * The resolver data source name.
         * </p>
         * 
         * @param dataSourceName
         *        The resolver data source name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The resolver Amazon Resource Name (ARN).
         * </p>
         * 
         * @param resolverArn
         *        The resolver Amazon Resource Name (ARN).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolverArn(String resolverArn);

        /**
         * <p>
         * The request mapping template.
         * </p>
         * 
         * @param requestMappingTemplate
         *        The request mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMappingTemplate(String requestMappingTemplate);

        /**
         * <p>
         * The response mapping template.
         * </p>
         * 
         * @param responseMappingTemplate
         *        The response mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseMappingTemplate(String responseMappingTemplate);

        /**
         * <p>
         * The resolver type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver
         * to run a GraphQL query against a single data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
         * <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query
         * against multiple data sources.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The resolver type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT
         *        resolver to run a GraphQL query against a single data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
         *        <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL
         *        query against multiple data sources.
         *        </p>
         *        </li>
         * @see ResolverKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverKind
         */
        Builder kind(String kind);

        /**
         * <p>
         * The resolver type.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT resolver
         * to run a GraphQL query against a single data source.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
         * <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL query
         * against multiple data sources.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        The resolver type.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>UNIT</b>: A UNIT resolver type. A UNIT resolver is the default resolver type. You can use a UNIT
         *        resolver to run a GraphQL query against a single data source.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>PIPELINE</b>: A PIPELINE resolver type. You can use a PIPELINE resolver to invoke a series of
         *        <code>Function</code> objects in a serial manner. You can use a pipeline resolver to run a GraphQL
         *        query against multiple data sources.
         *        </p>
         *        </li>
         * @see ResolverKind
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ResolverKind
         */
        Builder kind(ResolverKind kind);

        /**
         * <p>
         * The <code>PipelineConfig</code>.
         * </p>
         * 
         * @param pipelineConfig
         *        The <code>PipelineConfig</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pipelineConfig(PipelineConfig pipelineConfig);

        /**
         * <p>
         * The <code>PipelineConfig</code>.
         * </p>
         * This is a convenience that creates an instance of the {@link PipelineConfig.Builder} avoiding the need to
         * create one manually via {@link PipelineConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link PipelineConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #pipelineConfig(PipelineConfig)}.
         * 
         * @param pipelineConfig
         *        a consumer that will call methods on {@link PipelineConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #pipelineConfig(PipelineConfig)
         */
        default Builder pipelineConfig(Consumer<PipelineConfig.Builder> pipelineConfig) {
            return pipelineConfig(PipelineConfig.builder().applyMutation(pipelineConfig).build());
        }

        /**
         * <p>
         * The <code>SyncConfig</code> for a resolver attached to a versioned data source.
         * </p>
         * 
         * @param syncConfig
         *        The <code>SyncConfig</code> for a resolver attached to a versioned data source.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncConfig(SyncConfig syncConfig);

        /**
         * <p>
         * The <code>SyncConfig</code> for a resolver attached to a versioned data source.
         * </p>
         * This is a convenience that creates an instance of the {@link SyncConfig.Builder} avoiding the need to create
         * one manually via {@link SyncConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SyncConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #syncConfig(SyncConfig)}.
         * 
         * @param syncConfig
         *        a consumer that will call methods on {@link SyncConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncConfig(SyncConfig)
         */
        default Builder syncConfig(Consumer<SyncConfig.Builder> syncConfig) {
            return syncConfig(SyncConfig.builder().applyMutation(syncConfig).build());
        }

        /**
         * <p>
         * The caching configuration for the resolver.
         * </p>
         * 
         * @param cachingConfig
         *        The caching configuration for the resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingConfig(CachingConfig cachingConfig);

        /**
         * <p>
         * The caching configuration for the resolver.
         * </p>
         * This is a convenience that creates an instance of the {@link CachingConfig.Builder} avoiding the need to
         * create one manually via {@link CachingConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link CachingConfig.Builder#build()} is called immediately and its
         * result is passed to {@link #cachingConfig(CachingConfig)}.
         * 
         * @param cachingConfig
         *        a consumer that will call methods on {@link CachingConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #cachingConfig(CachingConfig)
         */
        default Builder cachingConfig(Consumer<CachingConfig.Builder> cachingConfig) {
            return cachingConfig(CachingConfig.builder().applyMutation(cachingConfig).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String typeName;

        private String fieldName;

        private String dataSourceName;

        private String resolverArn;

        private String requestMappingTemplate;

        private String responseMappingTemplate;

        private String kind;

        private PipelineConfig pipelineConfig;

        private SyncConfig syncConfig;

        private CachingConfig cachingConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(Resolver model) {
            typeName(model.typeName);
            fieldName(model.fieldName);
            dataSourceName(model.dataSourceName);
            resolverArn(model.resolverArn);
            requestMappingTemplate(model.requestMappingTemplate);
            responseMappingTemplate(model.responseMappingTemplate);
            kind(model.kind);
            pipelineConfig(model.pipelineConfig);
            syncConfig(model.syncConfig);
            cachingConfig(model.cachingConfig);
        }

        public final String getTypeName() {
            return typeName;
        }

        public final void setTypeName(String typeName) {
            this.typeName = typeName;
        }

        @Override
        @Transient
        public final Builder typeName(String typeName) {
            this.typeName = typeName;
            return this;
        }

        public final String getFieldName() {
            return fieldName;
        }

        public final void setFieldName(String fieldName) {
            this.fieldName = fieldName;
        }

        @Override
        @Transient
        public final Builder fieldName(String fieldName) {
            this.fieldName = fieldName;
            return this;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        @Transient
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final String getResolverArn() {
            return resolverArn;
        }

        public final void setResolverArn(String resolverArn) {
            this.resolverArn = resolverArn;
        }

        @Override
        @Transient
        public final Builder resolverArn(String resolverArn) {
            this.resolverArn = resolverArn;
            return this;
        }

        public final String getRequestMappingTemplate() {
            return requestMappingTemplate;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        @Override
        @Transient
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final String getResponseMappingTemplate() {
            return responseMappingTemplate;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        @Override
        @Transient
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        @Transient
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        @Override
        @Transient
        public final Builder kind(ResolverKind kind) {
            this.kind(kind == null ? null : kind.toString());
            return this;
        }

        public final PipelineConfig.Builder getPipelineConfig() {
            return pipelineConfig != null ? pipelineConfig.toBuilder() : null;
        }

        public final void setPipelineConfig(PipelineConfig.BuilderImpl pipelineConfig) {
            this.pipelineConfig = pipelineConfig != null ? pipelineConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder pipelineConfig(PipelineConfig pipelineConfig) {
            this.pipelineConfig = pipelineConfig;
            return this;
        }

        public final SyncConfig.Builder getSyncConfig() {
            return syncConfig != null ? syncConfig.toBuilder() : null;
        }

        public final void setSyncConfig(SyncConfig.BuilderImpl syncConfig) {
            this.syncConfig = syncConfig != null ? syncConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder syncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public final CachingConfig.Builder getCachingConfig() {
            return cachingConfig != null ? cachingConfig.toBuilder() : null;
        }

        public final void setCachingConfig(CachingConfig.BuilderImpl cachingConfig) {
            this.cachingConfig = cachingConfig != null ? cachingConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder cachingConfig(CachingConfig cachingConfig) {
            this.cachingConfig = cachingConfig;
            return this;
        }

        @Override
        public Resolver build() {
            return new Resolver(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
