/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateFunctionRequest extends AppSyncRequest implements
        ToCopyableBuilder<UpdateFunctionRequest.Builder, UpdateFunctionRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(UpdateFunctionRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(UpdateFunctionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(UpdateFunctionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> FUNCTION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionId").getter(getter(UpdateFunctionRequest::functionId)).setter(setter(Builder::functionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("functionId").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceName").getter(getter(UpdateFunctionRequest::dataSourceName))
            .setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()).build();

    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestMappingTemplate").getter(getter(UpdateFunctionRequest::requestMappingTemplate))
            .setter(setter(Builder::requestMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build())
            .build();

    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseMappingTemplate").getter(getter(UpdateFunctionRequest::responseMappingTemplate))
            .setter(setter(Builder::responseMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build())
            .build();

    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionVersion").getter(getter(UpdateFunctionRequest::functionVersion))
            .setter(setter(Builder::functionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionVersion").build()).build();

    private static final SdkField<SyncConfig> SYNC_CONFIG_FIELD = SdkField.<SyncConfig> builder(MarshallingType.SDK_POJO)
            .memberName("syncConfig").getter(getter(UpdateFunctionRequest::syncConfig)).setter(setter(Builder::syncConfig))
            .constructor(SyncConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, FUNCTION_ID_FIELD, DATA_SOURCE_NAME_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD,
            RESPONSE_MAPPING_TEMPLATE_FIELD, FUNCTION_VERSION_FIELD, SYNC_CONFIG_FIELD));

    private final String apiId;

    private final String name;

    private final String description;

    private final String functionId;

    private final String dataSourceName;

    private final String requestMappingTemplate;

    private final String responseMappingTemplate;

    private final String functionVersion;

    private final SyncConfig syncConfig;

    private UpdateFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.description = builder.description;
        this.functionId = builder.functionId;
        this.dataSourceName = builder.dataSourceName;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
        this.functionVersion = builder.functionVersion;
        this.syncConfig = builder.syncConfig;
    }

    /**
     * <p>
     * The GraphQL API ID.
     * </p>
     * 
     * @return The GraphQL API ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The <code>Function</code> name.
     * </p>
     * 
     * @return The <code>Function</code> name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The <code>Function</code> description.
     * </p>
     * 
     * @return The <code>Function</code> description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The function ID.
     * </p>
     * 
     * @return The function ID.
     */
    public final String functionId() {
        return functionId;
    }

    /**
     * <p>
     * The <code>Function</code> <code>DataSource</code> name.
     * </p>
     * 
     * @return The <code>Function</code> <code>DataSource</code> name.
     */
    public final String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request
     * mapping template.
     * </p>
     * 
     * @return The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the
     *         request mapping template.
     */
    public final String requestMappingTemplate() {
        return requestMappingTemplate;
    }

    /**
     * <p>
     * The <code>Function</code> request mapping template.
     * </p>
     * 
     * @return The <code>Function</code> request mapping template.
     */
    public final String responseMappingTemplate() {
        return responseMappingTemplate;
    }

    /**
     * <p>
     * The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.
     * </p>
     * 
     * @return The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.
     */
    public final String functionVersion() {
        return functionVersion;
    }

    /**
     * Returns the value of the SyncConfig property for this object.
     * 
     * @return The value of the SyncConfig property for this object.
     */
    public final SyncConfig syncConfig() {
        return syncConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(functionId());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(responseMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(syncConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateFunctionRequest)) {
            return false;
        }
        UpdateFunctionRequest other = (UpdateFunctionRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(functionId(), other.functionId())
                && Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(requestMappingTemplate(), other.requestMappingTemplate())
                && Objects.equals(responseMappingTemplate(), other.responseMappingTemplate())
                && Objects.equals(functionVersion(), other.functionVersion()) && Objects.equals(syncConfig(), other.syncConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateFunctionRequest").add("ApiId", apiId()).add("Name", name())
                .add("Description", description()).add("FunctionId", functionId()).add("DataSourceName", dataSourceName())
                .add("RequestMappingTemplate", requestMappingTemplate())
                .add("ResponseMappingTemplate", responseMappingTemplate()).add("FunctionVersion", functionVersion())
                .add("SyncConfig", syncConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "functionId":
            return Optional.ofNullable(clazz.cast(functionId()));
        case "dataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "requestMappingTemplate":
            return Optional.ofNullable(clazz.cast(requestMappingTemplate()));
        case "responseMappingTemplate":
            return Optional.ofNullable(clazz.cast(responseMappingTemplate()));
        case "functionVersion":
            return Optional.ofNullable(clazz.cast(functionVersion()));
        case "syncConfig":
            return Optional.ofNullable(clazz.cast(syncConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateFunctionRequest, T> g) {
        return obj -> g.apply((UpdateFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateFunctionRequest> {
        /**
         * <p>
         * The GraphQL API ID.
         * </p>
         * 
         * @param apiId
         *        The GraphQL API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The <code>Function</code> name.
         * </p>
         * 
         * @param name
         *        The <code>Function</code> name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>Function</code> description.
         * </p>
         * 
         * @param description
         *        The <code>Function</code> description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The function ID.
         * </p>
         * 
         * @param functionId
         *        The function ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionId(String functionId);

        /**
         * <p>
         * The <code>Function</code> <code>DataSource</code> name.
         * </p>
         * 
         * @param dataSourceName
         *        The <code>Function</code> <code>DataSource</code> name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the
         * request mapping template.
         * </p>
         * 
         * @param requestMappingTemplate
         *        The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of
         *        the request mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMappingTemplate(String requestMappingTemplate);

        /**
         * <p>
         * The <code>Function</code> request mapping template.
         * </p>
         * 
         * @param responseMappingTemplate
         *        The <code>Function</code> request mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseMappingTemplate(String responseMappingTemplate);

        /**
         * <p>
         * The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.
         * </p>
         * 
         * @param functionVersion
         *        The <code>version</code> of the request mapping template. Currently, the supported value is
         *        2018-05-29.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersion(String functionVersion);

        /**
         * Sets the value of the SyncConfig property for this object.
         *
         * @param syncConfig
         *        The new value for the SyncConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncConfig(SyncConfig syncConfig);

        /**
         * Sets the value of the SyncConfig property for this object.
         *
         * This is a convenience that creates an instance of the {@link SyncConfig.Builder} avoiding the need to create
         * one manually via {@link SyncConfig#builder()}.
         *
         * When the {@link Consumer} completes, {@link SyncConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #syncConfig(SyncConfig)}.
         * 
         * @param syncConfig
         *        a consumer that will call methods on {@link SyncConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncConfig(SyncConfig)
         */
        default Builder syncConfig(Consumer<SyncConfig.Builder> syncConfig) {
            return syncConfig(SyncConfig.builder().applyMutation(syncConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String name;

        private String description;

        private String functionId;

        private String dataSourceName;

        private String requestMappingTemplate;

        private String responseMappingTemplate;

        private String functionVersion;

        private SyncConfig syncConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateFunctionRequest model) {
            super(model);
            apiId(model.apiId);
            name(model.name);
            description(model.description);
            functionId(model.functionId);
            dataSourceName(model.dataSourceName);
            requestMappingTemplate(model.requestMappingTemplate);
            responseMappingTemplate(model.responseMappingTemplate);
            functionVersion(model.functionVersion);
            syncConfig(model.syncConfig);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        @Transient
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        @Transient
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        @Transient
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getFunctionId() {
            return functionId;
        }

        public final void setFunctionId(String functionId) {
            this.functionId = functionId;
        }

        @Override
        @Transient
        public final Builder functionId(String functionId) {
            this.functionId = functionId;
            return this;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        @Transient
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final String getRequestMappingTemplate() {
            return requestMappingTemplate;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        @Override
        @Transient
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final String getResponseMappingTemplate() {
            return responseMappingTemplate;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        @Override
        @Transient
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final String getFunctionVersion() {
            return functionVersion;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        @Override
        @Transient
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final SyncConfig.Builder getSyncConfig() {
            return syncConfig != null ? syncConfig.toBuilder() : null;
        }

        public final void setSyncConfig(SyncConfig.BuilderImpl syncConfig) {
            this.syncConfig = syncConfig != null ? syncConfig.build() : null;
        }

        @Override
        @Transient
        public final Builder syncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateFunctionRequest build() {
            return new UpdateFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
