/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.beans.Transient;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateResolverResponse extends AppSyncResponse implements
        ToCopyableBuilder<UpdateResolverResponse.Builder, UpdateResolverResponse> {
    private static final SdkField<Resolver> RESOLVER_FIELD = SdkField.<Resolver> builder(MarshallingType.SDK_POJO)
            .memberName("resolver").getter(getter(UpdateResolverResponse::resolver)).setter(setter(Builder::resolver))
            .constructor(Resolver::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resolver").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOLVER_FIELD));

    private final Resolver resolver;

    private UpdateResolverResponse(BuilderImpl builder) {
        super(builder);
        this.resolver = builder.resolver;
    }

    /**
     * <p>
     * The updated <code>Resolver</code> object.
     * </p>
     * 
     * @return The updated <code>Resolver</code> object.
     */
    public final Resolver resolver() {
        return resolver;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(resolver());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateResolverResponse)) {
            return false;
        }
        UpdateResolverResponse other = (UpdateResolverResponse) obj;
        return Objects.equals(resolver(), other.resolver());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateResolverResponse").add("Resolver", resolver()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resolver":
            return Optional.ofNullable(clazz.cast(resolver()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateResolverResponse, T> g) {
        return obj -> g.apply((UpdateResolverResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateResolverResponse> {
        /**
         * <p>
         * The updated <code>Resolver</code> object.
         * </p>
         * 
         * @param resolver
         *        The updated <code>Resolver</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resolver(Resolver resolver);

        /**
         * <p>
         * The updated <code>Resolver</code> object.
         * </p>
         * This is a convenience that creates an instance of the {@link Resolver.Builder} avoiding the need to create
         * one manually via {@link Resolver#builder()}.
         *
         * When the {@link Consumer} completes, {@link Resolver.Builder#build()} is called immediately and its result is
         * passed to {@link #resolver(Resolver)}.
         * 
         * @param resolver
         *        a consumer that will call methods on {@link Resolver.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resolver(Resolver)
         */
        default Builder resolver(Consumer<Resolver.Builder> resolver) {
            return resolver(Resolver.builder().applyMutation(resolver).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private Resolver resolver;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateResolverResponse model) {
            super(model);
            resolver(model.resolver);
        }

        public final Resolver.Builder getResolver() {
            return resolver != null ? resolver.toBuilder() : null;
        }

        public final void setResolver(Resolver.BuilderImpl resolver) {
            this.resolver = resolver != null ? resolver.build() : null;
        }

        @Override
        @Transient
        public final Builder resolver(Resolver resolver) {
            this.resolver = resolver;
            return this;
        }

        @Override
        public UpdateResolverResponse build() {
            return new UpdateResolverResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
