/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListApiKeysResponse extends AppSyncResponse implements
        ToCopyableBuilder<ListApiKeysResponse.Builder, ListApiKeysResponse> {
    private static final SdkField<List<ApiKey>> API_KEYS_FIELD = SdkField
            .<List<ApiKey>> builder(MarshallingType.LIST)
            .memberName("apiKeys")
            .getter(getter(ListApiKeysResponse::apiKeys))
            .setter(setter(Builder::apiKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("apiKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ApiKey> builder(MarshallingType.SDK_POJO)
                                            .constructor(ApiKey::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListApiKeysResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_KEYS_FIELD,
            NEXT_TOKEN_FIELD));

    private final List<ApiKey> apiKeys;

    private final String nextToken;

    private ListApiKeysResponse(BuilderImpl builder) {
        super(builder);
        this.apiKeys = builder.apiKeys;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the ApiKeys property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasApiKeys() {
        return apiKeys != null && !(apiKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The <code>ApiKey</code> objects.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasApiKeys} method.
     * </p>
     * 
     * @return The <code>ApiKey</code> objects.
     */
    public final List<ApiKey> apiKeys() {
        return apiKeys;
    }

    /**
     * <p>
     * An identifier to pass in the next request to this operation to return the next set of items in the list.
     * </p>
     * 
     * @return An identifier to pass in the next request to this operation to return the next set of items in the list.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasApiKeys() ? apiKeys() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApiKeysResponse)) {
            return false;
        }
        ListApiKeysResponse other = (ListApiKeysResponse) obj;
        return hasApiKeys() == other.hasApiKeys() && Objects.equals(apiKeys(), other.apiKeys())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListApiKeysResponse").add("ApiKeys", hasApiKeys() ? apiKeys() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiKeys":
            return Optional.ofNullable(clazz.cast(apiKeys()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListApiKeysResponse, T> g) {
        return obj -> g.apply((ListApiKeysResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListApiKeysResponse> {
        /**
         * <p>
         * The <code>ApiKey</code> objects.
         * </p>
         * 
         * @param apiKeys
         *        The <code>ApiKey</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeys(Collection<ApiKey> apiKeys);

        /**
         * <p>
         * The <code>ApiKey</code> objects.
         * </p>
         * 
         * @param apiKeys
         *        The <code>ApiKey</code> objects.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiKeys(ApiKey... apiKeys);

        /**
         * <p>
         * The <code>ApiKey</code> objects.
         * </p>
         * This is a convenience method that creates an instance of the {@link List<ApiKey>.Builder} avoiding the need
         * to create one manually via {@link List<ApiKey>#builder()}.
         *
         * When the {@link Consumer} completes, {@link List<ApiKey>.Builder#build()} is called immediately and its
         * result is passed to {@link #apiKeys(List<ApiKey>)}.
         * 
         * @param apiKeys
         *        a consumer that will call methods on {@link List<ApiKey>.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #apiKeys(List<ApiKey>)
         */
        Builder apiKeys(Consumer<ApiKey.Builder>... apiKeys);

        /**
         * <p>
         * An identifier to pass in the next request to this operation to return the next set of items in the list.
         * </p>
         * 
         * @param nextToken
         *        An identifier to pass in the next request to this operation to return the next set of items in the
         *        list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private List<ApiKey> apiKeys = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApiKeysResponse model) {
            super(model);
            apiKeys(model.apiKeys);
            nextToken(model.nextToken);
        }

        public final List<ApiKey.Builder> getApiKeys() {
            List<ApiKey.Builder> result = ApiKeysCopier.copyToBuilder(this.apiKeys);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setApiKeys(Collection<ApiKey.BuilderImpl> apiKeys) {
            this.apiKeys = ApiKeysCopier.copyFromBuilder(apiKeys);
        }

        @Override
        public final Builder apiKeys(Collection<ApiKey> apiKeys) {
            this.apiKeys = ApiKeysCopier.copy(apiKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeys(ApiKey... apiKeys) {
            apiKeys(Arrays.asList(apiKeys));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder apiKeys(Consumer<ApiKey.Builder>... apiKeys) {
            apiKeys(Stream.of(apiKeys).map(c -> ApiKey.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApiKeysResponse build() {
            return new ListApiKeysResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
