/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class EvaluateMappingTemplateResponse extends AppSyncResponse implements
        ToCopyableBuilder<EvaluateMappingTemplateResponse.Builder, EvaluateMappingTemplateResponse> {
    private static final SdkField<String> EVALUATION_RESULT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("evaluationResult").getter(getter(EvaluateMappingTemplateResponse::evaluationResult))
            .setter(setter(Builder::evaluationResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluationResult").build()).build();

    private static final SdkField<ErrorDetail> ERROR_FIELD = SdkField.<ErrorDetail> builder(MarshallingType.SDK_POJO)
            .memberName("error").getter(getter(EvaluateMappingTemplateResponse::error)).setter(setter(Builder::error))
            .constructor(ErrorDetail::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATION_RESULT_FIELD,
            ERROR_FIELD));

    private final String evaluationResult;

    private final ErrorDetail error;

    private EvaluateMappingTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.evaluationResult = builder.evaluationResult;
        this.error = builder.error;
    }

    /**
     * <p>
     * The mapping template; this can be a request or response template.
     * </p>
     * 
     * @return The mapping template; this can be a request or response template.
     */
    public final String evaluationResult() {
        return evaluationResult;
    }

    /**
     * <p>
     * The <code>ErrorDetail</code> object.
     * </p>
     * 
     * @return The <code>ErrorDetail</code> object.
     */
    public final ErrorDetail error() {
        return error;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(evaluationResult());
        hashCode = 31 * hashCode + Objects.hashCode(error());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateMappingTemplateResponse)) {
            return false;
        }
        EvaluateMappingTemplateResponse other = (EvaluateMappingTemplateResponse) obj;
        return Objects.equals(evaluationResult(), other.evaluationResult()) && Objects.equals(error(), other.error());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("EvaluateMappingTemplateResponse").add("EvaluationResult", evaluationResult())
                .add("Error", error()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "evaluationResult":
            return Optional.ofNullable(clazz.cast(evaluationResult()));
        case "error":
            return Optional.ofNullable(clazz.cast(error()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateMappingTemplateResponse, T> g) {
        return obj -> g.apply((EvaluateMappingTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, EvaluateMappingTemplateResponse> {
        /**
         * <p>
         * The mapping template; this can be a request or response template.
         * </p>
         * 
         * @param evaluationResult
         *        The mapping template; this can be a request or response template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder evaluationResult(String evaluationResult);

        /**
         * <p>
         * The <code>ErrorDetail</code> object.
         * </p>
         * 
         * @param error
         *        The <code>ErrorDetail</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder error(ErrorDetail error);

        /**
         * <p>
         * The <code>ErrorDetail</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link ErrorDetail.Builder} avoiding the need to
         * create one manually via {@link ErrorDetail#builder()}.
         *
         * When the {@link Consumer} completes, {@link ErrorDetail.Builder#build()} is called immediately and its result
         * is passed to {@link #error(ErrorDetail)}.
         * 
         * @param error
         *        a consumer that will call methods on {@link ErrorDetail.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #error(ErrorDetail)
         */
        default Builder error(Consumer<ErrorDetail.Builder> error) {
            return error(ErrorDetail.builder().applyMutation(error).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private String evaluationResult;

        private ErrorDetail error;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateMappingTemplateResponse model) {
            super(model);
            evaluationResult(model.evaluationResult);
            error(model.error);
        }

        public final String getEvaluationResult() {
            return evaluationResult;
        }

        public final void setEvaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
        }

        @Override
        public final Builder evaluationResult(String evaluationResult) {
            this.evaluationResult = evaluationResult;
            return this;
        }

        public final ErrorDetail.Builder getError() {
            return error != null ? error.toBuilder() : null;
        }

        public final void setError(ErrorDetail.BuilderImpl error) {
            this.error = error != null ? error.build() : null;
        }

        @Override
        public final Builder error(ErrorDetail error) {
            this.error = error;
            return this;
        }

        @Override
        public EvaluateMappingTemplateResponse build() {
            return new EvaluateMappingTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
