/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateGraphqlApiResponse extends AppSyncResponse implements
        ToCopyableBuilder<UpdateGraphqlApiResponse.Builder, UpdateGraphqlApiResponse> {
    private static final SdkField<GraphqlApi> GRAPHQL_API_FIELD = SdkField.<GraphqlApi> builder(MarshallingType.SDK_POJO)
            .memberName("graphqlApi").getter(getter(UpdateGraphqlApiResponse::graphqlApi)).setter(setter(Builder::graphqlApi))
            .constructor(GraphqlApi::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("graphqlApi").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GRAPHQL_API_FIELD));

    private final GraphqlApi graphqlApi;

    private UpdateGraphqlApiResponse(BuilderImpl builder) {
        super(builder);
        this.graphqlApi = builder.graphqlApi;
    }

    /**
     * <p>
     * The updated <code>GraphqlApi</code> object.
     * </p>
     * 
     * @return The updated <code>GraphqlApi</code> object.
     */
    public final GraphqlApi graphqlApi() {
        return graphqlApi;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(graphqlApi());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateGraphqlApiResponse)) {
            return false;
        }
        UpdateGraphqlApiResponse other = (UpdateGraphqlApiResponse) obj;
        return Objects.equals(graphqlApi(), other.graphqlApi());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateGraphqlApiResponse").add("GraphqlApi", graphqlApi()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "graphqlApi":
            return Optional.ofNullable(clazz.cast(graphqlApi()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateGraphqlApiResponse, T> g) {
        return obj -> g.apply((UpdateGraphqlApiResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateGraphqlApiResponse> {
        /**
         * <p>
         * The updated <code>GraphqlApi</code> object.
         * </p>
         * 
         * @param graphqlApi
         *        The updated <code>GraphqlApi</code> object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder graphqlApi(GraphqlApi graphqlApi);

        /**
         * <p>
         * The updated <code>GraphqlApi</code> object.
         * </p>
         * This is a convenience method that creates an instance of the {@link GraphqlApi.Builder} avoiding the need to
         * create one manually via {@link GraphqlApi#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GraphqlApi.Builder#build()} is called immediately and its result
         * is passed to {@link #graphqlApi(GraphqlApi)}.
         * 
         * @param graphqlApi
         *        a consumer that will call methods on {@link GraphqlApi.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #graphqlApi(GraphqlApi)
         */
        default Builder graphqlApi(Consumer<GraphqlApi.Builder> graphqlApi) {
            return graphqlApi(GraphqlApi.builder().applyMutation(graphqlApi).build());
        }
    }

    static final class BuilderImpl extends AppSyncResponse.BuilderImpl implements Builder {
        private GraphqlApi graphqlApi;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateGraphqlApiResponse model) {
            super(model);
            graphqlApi(model.graphqlApi);
        }

        public final GraphqlApi.Builder getGraphqlApi() {
            return graphqlApi != null ? graphqlApi.toBuilder() : null;
        }

        public final void setGraphqlApi(GraphqlApi.BuilderImpl graphqlApi) {
            this.graphqlApi = graphqlApi != null ? graphqlApi.build() : null;
        }

        @Override
        public final Builder graphqlApi(GraphqlApi graphqlApi) {
            this.graphqlApi = graphqlApi;
            return this;
        }

        @Override
        public UpdateGraphqlApiResponse build() {
            return new UpdateGraphqlApiResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
