/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync;

import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.client.handler.AwsSyncClientHandler;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.awscore.internal.AwsProtocolMetadata;
import software.amazon.awssdk.awscore.internal.AwsServiceProtocol;
import software.amazon.awssdk.core.RequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkPlugin;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.client.config.SdkClientConfiguration;
import software.amazon.awssdk.core.client.config.SdkClientOption;
import software.amazon.awssdk.core.client.handler.ClientExecutionParams;
import software.amazon.awssdk.core.client.handler.SyncClientHandler;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpResponseHandler;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.metrics.MetricCollector;
import software.amazon.awssdk.metrics.MetricPublisher;
import software.amazon.awssdk.metrics.NoOpMetricCollector;
import software.amazon.awssdk.protocols.core.ExceptionMetadata;
import software.amazon.awssdk.protocols.json.AwsJsonProtocol;
import software.amazon.awssdk.protocols.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.BaseAwsJsonProtocolFactory;
import software.amazon.awssdk.protocols.json.JsonOperationMetadata;
import software.amazon.awssdk.services.appsync.internal.AppSyncServiceClientConfigurationBuilder;
import software.amazon.awssdk.services.appsync.model.AccessDeniedException;
import software.amazon.awssdk.services.appsync.model.ApiKeyLimitExceededException;
import software.amazon.awssdk.services.appsync.model.ApiKeyValidityOutOfBoundsException;
import software.amazon.awssdk.services.appsync.model.ApiLimitExceededException;
import software.amazon.awssdk.services.appsync.model.AppSyncException;
import software.amazon.awssdk.services.appsync.model.AssociateApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateApiResponse;
import software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.BadRequestException;
import software.amazon.awssdk.services.appsync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.CreateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.CreateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateResolverRequest;
import software.amazon.awssdk.services.appsync.model.CreateResolverResponse;
import software.amazon.awssdk.services.appsync.model.CreateTypeRequest;
import software.amazon.awssdk.services.appsync.model.CreateTypeResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteResolverRequest;
import software.amazon.awssdk.services.appsync.model.DeleteResolverResponse;
import software.amazon.awssdk.services.appsync.model.DeleteTypeRequest;
import software.amazon.awssdk.services.appsync.model.DeleteTypeResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateApiResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest;
import software.amazon.awssdk.services.appsync.model.EvaluateCodeResponse;
import software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest;
import software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateResponse;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.GetApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.GetApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.GetApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceIntrospectionRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceIntrospectionResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.GetDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.GetDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.GetFunctionRequest;
import software.amazon.awssdk.services.appsync.model.GetFunctionResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiEnvironmentVariablesRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiEnvironmentVariablesResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse;
import software.amazon.awssdk.services.appsync.model.GetResolverRequest;
import software.amazon.awssdk.services.appsync.model.GetResolverResponse;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse;
import software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.services.appsync.model.GetTypeResponse;
import software.amazon.awssdk.services.appsync.model.GraphQlSchemaException;
import software.amazon.awssdk.services.appsync.model.InternalFailureException;
import software.amazon.awssdk.services.appsync.model.LimitExceededException;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.NotFoundException;
import software.amazon.awssdk.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest;
import software.amazon.awssdk.services.appsync.model.PutGraphqlApiEnvironmentVariablesResponse;
import software.amazon.awssdk.services.appsync.model.StartDataSourceIntrospectionRequest;
import software.amazon.awssdk.services.appsync.model.StartDataSourceIntrospectionResponse;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse;
import software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaMergeResponse;
import software.amazon.awssdk.services.appsync.model.TagResourceRequest;
import software.amazon.awssdk.services.appsync.model.TagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UnauthorizedException;
import software.amazon.awssdk.services.appsync.model.UntagResourceRequest;
import software.amazon.awssdk.services.appsync.model.UntagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateResolverRequest;
import software.amazon.awssdk.services.appsync.model.UpdateResolverResponse;
import software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.UpdateTypeRequest;
import software.amazon.awssdk.services.appsync.model.UpdateTypeResponse;
import software.amazon.awssdk.services.appsync.transform.AssociateApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.AssociateMergedGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.AssociateSourceGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.CreateTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteDomainNameRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DeleteTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DisassociateApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DisassociateMergedGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.DisassociateSourceGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.EvaluateCodeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.EvaluateMappingTemplateRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.FlushApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetApiAssociationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceIntrospectionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetDomainNameRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiEnvironmentVariablesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetIntrospectionSchemaRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSchemaCreationStatusRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetSourceApiAssociationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.GetTypeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListApiKeysRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDataSourcesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListDomainNamesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListFunctionsRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListGraphqlApisRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversByFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListResolversRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListSourceApiAssociationsRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTagsForResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesByAssociationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.ListTypesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.PutGraphqlApiEnvironmentVariablesRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartDataSourceIntrospectionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaCreationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.StartSchemaMergeRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.TagResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UntagResourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiCacheRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateApiKeyRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDataSourceRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateDomainNameRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateFunctionRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateGraphqlApiRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateResolverRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateSourceApiAssociationRequestMarshaller;
import software.amazon.awssdk.services.appsync.transform.UpdateTypeRequestMarshaller;
import software.amazon.awssdk.utils.Logger;

/**
 * Internal implementation of {@link AppSyncClient}.
 *
 * @see AppSyncClient#builder()
 */
@Generated("software.amazon.awssdk:codegen")
@SdkInternalApi
final class DefaultAppSyncClient implements AppSyncClient {
    private static final Logger log = Logger.loggerFor(DefaultAppSyncClient.class);

    private static final AwsProtocolMetadata protocolMetadata = AwsProtocolMetadata.builder()
            .serviceProtocol(AwsServiceProtocol.REST_JSON).build();

    private final SyncClientHandler clientHandler;

    private final AwsJsonProtocolFactory protocolFactory;

    private final SdkClientConfiguration clientConfiguration;

    protected DefaultAppSyncClient(SdkClientConfiguration clientConfiguration) {
        this.clientHandler = new AwsSyncClientHandler(clientConfiguration);
        this.clientConfiguration = clientConfiguration.toBuilder().option(SdkClientOption.SDK_CLIENT, this).build();
        this.protocolFactory = init(AwsJsonProtocolFactory.builder()).build();
    }

    /**
     * <p>
     * Maps an endpoint to your custom domain.
     * </p>
     *
     * @param associateApiRequest
     * @return Result of the AssociateApi operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public AssociateApiResponse associateApi(AssociateApiRequest associateApiRequest) throws AccessDeniedException,
            BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                AssociateApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateApi");

            return clientHandler.execute(new ClientExecutionParams<AssociateApiRequest, AssociateApiResponse>()
                    .withOperationName("AssociateApi").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(associateApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new AssociateApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an association between a Merged API and source API using the source API's identifier.
     * </p>
     *
     * @param associateMergedGraphqlApiRequest
     * @return Result of the AssociateMergedGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateMergedGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateMergedGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateMergedGraphqlApiResponse associateMergedGraphqlApi(
            AssociateMergedGraphqlApiRequest associateMergedGraphqlApiRequest) throws UnauthorizedException, BadRequestException,
            InternalFailureException, NotFoundException, LimitExceededException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateMergedGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateMergedGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateMergedGraphqlApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateMergedGraphqlApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateMergedGraphqlApi");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateMergedGraphqlApiRequest, AssociateMergedGraphqlApiResponse>()
                            .withOperationName("AssociateMergedGraphqlApi").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateMergedGraphqlApiRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateMergedGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates an association between a Merged API and source API using the Merged API's identifier.
     * </p>
     *
     * @param associateSourceGraphqlApiRequest
     * @return Result of the AssociateSourceGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateSourceGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateSourceGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public AssociateSourceGraphqlApiResponse associateSourceGraphqlApi(
            AssociateSourceGraphqlApiRequest associateSourceGraphqlApiRequest) throws UnauthorizedException, BadRequestException,
            InternalFailureException, NotFoundException, LimitExceededException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<AssociateSourceGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, AssociateSourceGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(associateSourceGraphqlApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, associateSourceGraphqlApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "AssociateSourceGraphqlApi");

            return clientHandler
                    .execute(new ClientExecutionParams<AssociateSourceGraphqlApiRequest, AssociateSourceGraphqlApiResponse>()
                            .withOperationName("AssociateSourceGraphqlApi").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(associateSourceGraphqlApiRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new AssociateSourceGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a cache for the GraphQL API.
     * </p>
     *
     * @param createApiCacheRequest
     *        Represents the input of a <code>CreateApiCache</code> operation.
     * @return Result of the CreateApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateApiCacheResponse createApiCache(CreateApiCacheRequest createApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiCache");

            return clientHandler.execute(new ClientExecutionParams<CreateApiCacheRequest, CreateApiCacheResponse>()
                    .withOperationName("CreateApiCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a unique key that you can distribute to clients who invoke your API.
     * </p>
     *
     * @param createApiKeyRequest
     * @return Result of the CreateApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiKeyLimitExceededException
     *         The API key exceeded a limit. Try your request again.
     * @throws ApiKeyValidityOutOfBoundsException
     *         The API key expiration must be set to a value between 1 and 365 days from creation (for
     *         <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException,
            ApiKeyLimitExceededException, ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateApiKey");

            return clientHandler.execute(new ClientExecutionParams<CreateApiKeyRequest, CreateApiKeyResponse>()
                    .withOperationName("CreateApiKey").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDataSource");

            return clientHandler.execute(new ClientExecutionParams<CreateDataSourceRequest, CreateDataSourceResponse>()
                    .withOperationName("CreateDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a custom <code>DomainName</code> object.
     * </p>
     *
     * @param createDomainNameRequest
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateDomainNameResponse createDomainName(CreateDomainNameRequest createDomainNameRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createDomainNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateDomainName");

            return clientHandler.execute(new ClientExecutionParams<CreateDomainNameRequest, CreateDomainNameResponse>()
                    .withOperationName("CreateDomainName").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>Function</code> object.
     * </p>
     * <p>
     * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateFunction");

            return clientHandler.execute(new ClientExecutionParams<CreateFunctionRequest, CreateFunctionResponse>()
                    .withOperationName("CreateFunction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param createGraphqlApiRequest
     * @return Result of the CreateGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiLimitExceededException
     *         The GraphQL API exceeded a limit. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateGraphqlApiResponse createGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest) throws BadRequestException,
            LimitExceededException, ConcurrentModificationException, UnauthorizedException, InternalFailureException,
            ApiLimitExceededException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createGraphqlApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createGraphqlApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateGraphqlApi");

            return clientHandler.execute(new ClientExecutionParams<CreateGraphqlApiRequest, CreateGraphqlApiResponse>()
                    .withOperationName("CreateGraphqlApi").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createGraphqlApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>Resolver</code> object.
     * </p>
     * <p>
     * A resolver converts incoming requests into a format that a data source can understand, and converts the data
     * source's responses into GraphQL.
     * </p>
     *
     * @param createResolverRequest
     * @return Result of the CreateResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateResolverResponse createResolver(CreateResolverRequest createResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateResolverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createResolverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateResolver");

            return clientHandler.execute(new ClientExecutionParams<CreateResolverRequest, CreateResolverResponse>()
                    .withOperationName("CreateResolver").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(createResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateResolverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a <code>Type</code> object.
     * </p>
     *
     * @param createTypeRequest
     * @return Result of the CreateType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public CreateTypeResponse createType(CreateTypeRequest createTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<CreateTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                CreateTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(createTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, createTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "CreateType");

            return clientHandler.execute(new ClientExecutionParams<CreateTypeRequest, CreateTypeResponse>()
                    .withOperationName("CreateType").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(createTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new CreateTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an <code>ApiCache</code> object.
     * </p>
     *
     * @param deleteApiCacheRequest
     *        Represents the input of a <code>DeleteApiCache</code> operation.
     * @return Result of the DeleteApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteApiCacheResponse deleteApiCache(DeleteApiCacheRequest deleteApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiCache");

            return clientHandler.execute(new ClientExecutionParams<DeleteApiCacheRequest, DeleteApiCacheResponse>()
                    .withOperationName("DeleteApiCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an API key.
     * </p>
     *
     * @param deleteApiKeyRequest
     * @return Result of the DeleteApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteApiKey");

            return clientHandler.execute(new ClientExecutionParams<DeleteApiKeyRequest, DeleteApiKeyResponse>()
                    .withOperationName("DeleteApiKey").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>DataSource</code> object.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDataSource");

            return clientHandler.execute(new ClientExecutionParams<DeleteDataSourceRequest, DeleteDataSourceResponse>()
                    .withOperationName("DeleteDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a custom <code>DomainName</code> object.
     * </p>
     *
     * @param deleteDomainNameRequest
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteDomainNameResponse deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest)
            throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException,
            NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteDomainNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteDomainName");

            return clientHandler.execute(new ClientExecutionParams<DeleteDomainNameRequest, DeleteDomainNameResponse>()
                    .withOperationName("DeleteDomainName").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>Function</code>.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteFunction");

            return clientHandler.execute(new ClientExecutionParams<DeleteFunctionRequest, DeleteFunctionResponse>()
                    .withOperationName("DeleteFunction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param deleteGraphqlApiRequest
     * @return Result of the DeleteGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteGraphqlApiResponse deleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteGraphqlApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteGraphqlApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteGraphqlApi");

            return clientHandler.execute(new ClientExecutionParams<DeleteGraphqlApiRequest, DeleteGraphqlApiResponse>()
                    .withOperationName("DeleteGraphqlApi").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteGraphqlApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>Resolver</code> object.
     * </p>
     *
     * @param deleteResolverRequest
     * @return Result of the DeleteResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteResolver" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteResolverResponse deleteResolver(DeleteResolverRequest deleteResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteResolverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteResolverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteResolver");

            return clientHandler.execute(new ClientExecutionParams<DeleteResolverRequest, DeleteResolverResponse>()
                    .withOperationName("DeleteResolver").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(deleteResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteResolverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes a <code>Type</code> object.
     * </p>
     *
     * @param deleteTypeRequest
     * @return Result of the DeleteType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DeleteTypeResponse deleteType(DeleteTypeRequest deleteTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DeleteTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DeleteTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(deleteTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, deleteTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DeleteType");

            return clientHandler.execute(new ClientExecutionParams<DeleteTypeRequest, DeleteTypeResponse>()
                    .withOperationName("DeleteType").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(deleteTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DeleteTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Removes an <code>ApiAssociation</code> object from a custom domain.
     * </p>
     *
     * @param disassociateApiRequest
     * @return Result of the DisassociateApi operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public DisassociateApiResponse disassociateApi(DisassociateApiRequest disassociateApiRequest) throws AccessDeniedException,
            BadRequestException, ConcurrentModificationException, InternalFailureException, NotFoundException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                DisassociateApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateApi");

            return clientHandler.execute(new ClientExecutionParams<DisassociateApiRequest, DisassociateApiResponse>()
                    .withOperationName("DisassociateApi").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(disassociateApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new DisassociateApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an association between a Merged API and source API using the source API's identifier and the association
     * ID.
     * </p>
     *
     * @param disassociateMergedGraphqlApiRequest
     * @return Result of the DisassociateMergedGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateMergedGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateMergedGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateMergedGraphqlApiResponse disassociateMergedGraphqlApi(
            DisassociateMergedGraphqlApiRequest disassociateMergedGraphqlApiRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateMergedGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateMergedGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateMergedGraphqlApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateMergedGraphqlApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateMergedGraphqlApi");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateMergedGraphqlApiRequest, DisassociateMergedGraphqlApiResponse>()
                            .withOperationName("DisassociateMergedGraphqlApi").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateMergedGraphqlApiRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateMergedGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Deletes an association between a Merged API and source API using the Merged API's identifier and the association
     * ID.
     * </p>
     *
     * @param disassociateSourceGraphqlApiRequest
     * @return Result of the DisassociateSourceGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateSourceGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateSourceGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public DisassociateSourceGraphqlApiResponse disassociateSourceGraphqlApi(
            DisassociateSourceGraphqlApiRequest disassociateSourceGraphqlApiRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<DisassociateSourceGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, DisassociateSourceGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(disassociateSourceGraphqlApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, disassociateSourceGraphqlApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "DisassociateSourceGraphqlApi");

            return clientHandler
                    .execute(new ClientExecutionParams<DisassociateSourceGraphqlApiRequest, DisassociateSourceGraphqlApiResponse>()
                            .withOperationName("DisassociateSourceGraphqlApi").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(disassociateSourceGraphqlApiRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new DisassociateSourceGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Evaluates the given code and returns the response. The code definition requirements depend on the specified
     * runtime. For <code>APPSYNC_JS</code> runtimes, the code defines the request and response functions. The request
     * function takes the incoming request after a GraphQL operation is parsed and converts it into a request
     * configuration for the selected data source operation. The response function interprets responses from the data
     * source and maps it to the shape of the GraphQL field output type.
     * </p>
     *
     * @param evaluateCodeRequest
     * @return Result of the EvaluateCode operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.EvaluateCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/EvaluateCode" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public EvaluateCodeResponse evaluateCode(EvaluateCodeRequest evaluateCodeRequest) throws AccessDeniedException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EvaluateCodeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                EvaluateCodeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(evaluateCodeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, evaluateCodeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EvaluateCode");

            return clientHandler.execute(new ClientExecutionParams<EvaluateCodeRequest, EvaluateCodeResponse>()
                    .withOperationName("EvaluateCode").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(evaluateCodeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new EvaluateCodeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Evaluates a given template and returns the response. The mapping template can be a request or response template.
     * </p>
     * <p>
     * Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request
     * configuration for the selected data source operation. Response templates interpret responses from the data source
     * and map it to the shape of the GraphQL field output type.
     * </p>
     * <p>
     * Mapping templates are written in the Apache Velocity Template Language (VTL).
     * </p>
     *
     * @param evaluateMappingTemplateRequest
     * @return Result of the EvaluateMappingTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.EvaluateMappingTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/EvaluateMappingTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public EvaluateMappingTemplateResponse evaluateMappingTemplate(EvaluateMappingTemplateRequest evaluateMappingTemplateRequest)
            throws AccessDeniedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<EvaluateMappingTemplateResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, EvaluateMappingTemplateResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(evaluateMappingTemplateRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, evaluateMappingTemplateRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "EvaluateMappingTemplate");

            return clientHandler
                    .execute(new ClientExecutionParams<EvaluateMappingTemplateRequest, EvaluateMappingTemplateResponse>()
                            .withOperationName("EvaluateMappingTemplate").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(evaluateMappingTemplateRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new EvaluateMappingTemplateRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Flushes an <code>ApiCache</code> object.
     * </p>
     *
     * @param flushApiCacheRequest
     *        Represents the input of a <code>FlushApiCache</code> operation.
     * @return Result of the FlushApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.FlushApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/FlushApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public FlushApiCacheResponse flushApiCache(FlushApiCacheRequest flushApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<FlushApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                FlushApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(flushApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, flushApiCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "FlushApiCache");

            return clientHandler.execute(new ClientExecutionParams<FlushApiCacheRequest, FlushApiCacheResponse>()
                    .withOperationName("FlushApiCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(flushApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new FlushApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an <code>ApiAssociation</code> object.
     * </p>
     *
     * @param getApiAssociationRequest
     * @return Result of the GetApiAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetApiAssociationResponse getApiAssociation(GetApiAssociationRequest getApiAssociationRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiAssociationResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApiAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApiAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiAssociation");

            return clientHandler.execute(new ClientExecutionParams<GetApiAssociationRequest, GetApiAssociationResponse>()
                    .withOperationName("GetApiAssociation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getApiAssociationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApiAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves an <code>ApiCache</code> object.
     * </p>
     *
     * @param getApiCacheRequest
     *        Represents the input of a <code>GetApiCache</code> operation.
     * @return Result of the GetApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetApiCacheResponse getApiCache(GetApiCacheRequest getApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getApiCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetApiCache");

            return clientHandler.execute(new ClientExecutionParams<GetApiCacheRequest, GetApiCacheResponse>()
                    .withOperationName("GetApiCache").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getApiCacheRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>DataSource</code> object.
     * </p>
     *
     * @param getDataSourceRequest
     * @return Result of the GetDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataSourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataSource");

            return clientHandler.execute(new ClientExecutionParams<GetDataSourceRequest, GetDataSourceResponse>()
                    .withOperationName("GetDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the record of an existing introspection. If the retrieval is successful, the result of the
     * instrospection will also be returned. If the retrieval fails the operation, an error message will be returned
     * instead.
     * </p>
     *
     * @param getDataSourceIntrospectionRequest
     * @return Result of the GetDataSourceIntrospection operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDataSourceIntrospection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSourceIntrospection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetDataSourceIntrospectionResponse getDataSourceIntrospection(
            GetDataSourceIntrospectionRequest getDataSourceIntrospectionRequest) throws BadRequestException, NotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDataSourceIntrospectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetDataSourceIntrospectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDataSourceIntrospectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDataSourceIntrospectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDataSourceIntrospection");

            return clientHandler
                    .execute(new ClientExecutionParams<GetDataSourceIntrospectionRequest, GetDataSourceIntrospectionResponse>()
                            .withOperationName("GetDataSourceIntrospection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getDataSourceIntrospectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetDataSourceIntrospectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a custom <code>DomainName</code> object.
     * </p>
     *
     * @param getDomainNameRequest
     * @return Result of the GetDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetDomainNameResponse getDomainName(GetDomainNameRequest getDomainNameRequest) throws AccessDeniedException,
            BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getDomainNameRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetDomainName");

            return clientHandler.execute(new ClientExecutionParams<GetDomainNameRequest, GetDomainNameResponse>()
                    .withOperationName("GetDomainName").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Get a <code>Function</code>.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ConcurrentModificationException,
            NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetFunction");

            return clientHandler.execute(new ClientExecutionParams<GetFunctionRequest, GetFunctionResponse>()
                    .withOperationName("GetFunction").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getFunctionRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param getGraphqlApiRequest
     * @return Result of the GetGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetGraphqlApiResponse getGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGraphqlApiRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getGraphqlApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGraphqlApi");

            return clientHandler.execute(new ClientExecutionParams<GetGraphqlApiRequest, GetGraphqlApiResponse>()
                    .withOperationName("GetGraphqlApi").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(getGraphqlApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the list of environmental variable key-value pairs associated with an API by its ID value.
     * </p>
     *
     * @param getGraphqlApiEnvironmentVariablesRequest
     * @return Result of the GetGraphqlApiEnvironmentVariables operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetGraphqlApiEnvironmentVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApiEnvironmentVariables"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetGraphqlApiEnvironmentVariablesResponse getGraphqlApiEnvironmentVariables(
            GetGraphqlApiEnvironmentVariablesRequest getGraphqlApiEnvironmentVariablesRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetGraphqlApiEnvironmentVariablesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetGraphqlApiEnvironmentVariablesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getGraphqlApiEnvironmentVariablesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                getGraphqlApiEnvironmentVariablesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetGraphqlApiEnvironmentVariables");

            return clientHandler
                    .execute(new ClientExecutionParams<GetGraphqlApiEnvironmentVariablesRequest, GetGraphqlApiEnvironmentVariablesResponse>()
                            .withOperationName("GetGraphqlApiEnvironmentVariables").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getGraphqlApiEnvironmentVariablesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetGraphqlApiEnvironmentVariablesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the introspection schema for a GraphQL API.
     * </p>
     *
     * @param getIntrospectionSchemaRequest
     * @return Result of the GetIntrospectionSchema operation returned by the service.
     * @throws GraphQlSchemaException
     *         The GraphQL schema is not valid.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetIntrospectionSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetIntrospectionSchemaResponse getIntrospectionSchema(GetIntrospectionSchemaRequest getIntrospectionSchemaRequest)
            throws GraphQlSchemaException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(false).build();

        HttpResponseHandler<GetIntrospectionSchemaResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetIntrospectionSchemaResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getIntrospectionSchemaRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getIntrospectionSchemaRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetIntrospectionSchema");

            return clientHandler
                    .execute(new ClientExecutionParams<GetIntrospectionSchemaRequest, GetIntrospectionSchemaResponse>()
                            .withOperationName("GetIntrospectionSchema").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getIntrospectionSchemaRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetIntrospectionSchemaRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>Resolver</code> object.
     * </p>
     *
     * @param getResolverRequest
     * @return Result of the GetResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetResolver" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetResolverResponse getResolver(GetResolverRequest getResolverRequest) throws ConcurrentModificationException,
            NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetResolverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getResolverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetResolver");

            return clientHandler.execute(new ClientExecutionParams<GetResolverRequest, GetResolverResponse>()
                    .withOperationName("GetResolver").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getResolverRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetResolverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves the current status of a schema creation operation.
     * </p>
     *
     * @param getSchemaCreationStatusRequest
     * @return Result of the GetSchemaCreationStatus operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetSchemaCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSchemaCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSchemaCreationStatusResponse getSchemaCreationStatus(GetSchemaCreationStatusRequest getSchemaCreationStatusRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSchemaCreationStatusResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSchemaCreationStatusResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSchemaCreationStatusRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSchemaCreationStatusRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSchemaCreationStatus");

            return clientHandler
                    .execute(new ClientExecutionParams<GetSchemaCreationStatusRequest, GetSchemaCreationStatusResponse>()
                            .withOperationName("GetSchemaCreationStatus").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getSchemaCreationStatusRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSchemaCreationStatusRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>SourceApiAssociation</code> object.
     * </p>
     *
     * @param getSourceApiAssociationRequest
     * @return Result of the GetSourceApiAssociation operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetSourceApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSourceApiAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public GetSourceApiAssociationResponse getSourceApiAssociation(GetSourceApiAssociationRequest getSourceApiAssociationRequest)
            throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetSourceApiAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, GetSourceApiAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getSourceApiAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getSourceApiAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetSourceApiAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<GetSourceApiAssociationRequest, GetSourceApiAssociationResponse>()
                            .withOperationName("GetSourceApiAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(getSourceApiAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new GetSourceApiAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Retrieves a <code>Type</code> object.
     * </p>
     *
     * @param getTypeRequest
     * @return Result of the GetType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public GetTypeResponse getType(GetTypeRequest getTypeRequest) throws BadRequestException, ConcurrentModificationException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<GetTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                GetTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(getTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, getTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "GetType");

            return clientHandler.execute(new ClientExecutionParams<GetTypeRequest, GetTypeResponse>()
                    .withOperationName("GetType").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(getTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new GetTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the API keys for a given API.
     * </p>
     * <note>
     * <p>
     * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response
     * until they have actually been deleted. You can safely call <code>DeleteApiKey</code> to manually delete a key
     * before it's automatically deleted.
     * </p>
     * </note>
     *
     * @param listApiKeysRequest
     * @return Result of the ListApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListApiKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListApiKeysResponse listApiKeys(ListApiKeysRequest listApiKeysRequest) throws BadRequestException, NotFoundException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListApiKeysResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListApiKeysResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listApiKeysRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listApiKeysRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListApiKeys");

            return clientHandler.execute(new ClientExecutionParams<ListApiKeysRequest, ListApiKeysResponse>()
                    .withOperationName("ListApiKeys").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listApiKeysRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListApiKeysRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the data sources for a given API.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDataSourcesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDataSourcesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDataSourcesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDataSourcesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDataSources");

            return clientHandler.execute(new ClientExecutionParams<ListDataSourcesRequest, ListDataSourcesResponse>()
                    .withOperationName("ListDataSources").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDataSourcesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDataSourcesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists multiple custom domain names.
     * </p>
     *
     * @param listDomainNamesRequest
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDomainNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDomainNames" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws AccessDeniedException,
            BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListDomainNamesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListDomainNamesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listDomainNamesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listDomainNamesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListDomainNames");

            return clientHandler.execute(new ClientExecutionParams<ListDomainNamesRequest, ListDomainNamesResponse>()
                    .withOperationName("ListDomainNames").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listDomainNamesRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListDomainNamesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List multiple functions.
     * </p>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListFunctionsResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListFunctionsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listFunctionsRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listFunctionsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListFunctions");

            return clientHandler.execute(new ClientExecutionParams<ListFunctionsRequest, ListFunctionsResponse>()
                    .withOperationName("ListFunctions").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listFunctionsRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListFunctionsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists your GraphQL APIs.
     * </p>
     *
     * @param listGraphqlApisRequest
     * @return Result of the ListGraphqlApis operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListGraphqlApis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListGraphqlApisResponse listGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListGraphqlApisResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListGraphqlApisResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listGraphqlApisRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listGraphqlApisRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListGraphqlApis");

            return clientHandler.execute(new ClientExecutionParams<ListGraphqlApisRequest, ListGraphqlApisResponse>()
                    .withOperationName("ListGraphqlApis").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listGraphqlApisRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListGraphqlApisRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the resolvers for a given API and type.
     * </p>
     *
     * @param listResolversRequest
     * @return Result of the ListResolvers operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListResolversResponse listResolvers(ListResolversRequest listResolversRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResolversResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListResolversResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolversRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolversRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolvers");

            return clientHandler.execute(new ClientExecutionParams<ListResolversRequest, ListResolversResponse>()
                    .withOperationName("ListResolvers").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listResolversRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListResolversRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * List the resolvers that are associated with a specific function.
     * </p>
     *
     * @param listResolversByFunctionRequest
     * @return Result of the ListResolversByFunction operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolversByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListResolversByFunctionResponse listResolversByFunction(ListResolversByFunctionRequest listResolversByFunctionRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListResolversByFunctionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListResolversByFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listResolversByFunctionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listResolversByFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListResolversByFunction");

            return clientHandler
                    .execute(new ClientExecutionParams<ListResolversByFunctionRequest, ListResolversByFunctionResponse>()
                            .withOperationName("ListResolversByFunction").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listResolversByFunctionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListResolversByFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the <code>SourceApiAssociationSummary</code> data.
     * </p>
     *
     * @param listSourceApiAssociationsRequest
     * @return Result of the ListSourceApiAssociations operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListSourceApiAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListSourceApiAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListSourceApiAssociationsResponse listSourceApiAssociations(
            ListSourceApiAssociationsRequest listSourceApiAssociationsRequest) throws UnauthorizedException, BadRequestException,
            InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListSourceApiAssociationsResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListSourceApiAssociationsResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listSourceApiAssociationsRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listSourceApiAssociationsRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListSourceApiAssociations");

            return clientHandler
                    .execute(new ClientExecutionParams<ListSourceApiAssociationsRequest, ListSourceApiAssociationsResponse>()
                            .withOperationName("ListSourceApiAssociations").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listSourceApiAssociationsRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListSourceApiAssociationsRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTagsForResourceResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTagsForResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTagsForResourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTagsForResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTagsForResource");

            return clientHandler.execute(new ClientExecutionParams<ListTagsForResourceRequest, ListTagsForResourceResponse>()
                    .withOperationName("ListTagsForResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(listTagsForResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTagsForResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists the types for a given API.
     * </p>
     *
     * @param listTypesRequest
     * @return Result of the ListTypes operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTypesResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                ListTypesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTypesRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypesRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypes");

            return clientHandler.execute(new ClientExecutionParams<ListTypesRequest, ListTypesResponse>()
                    .withOperationName("ListTypes").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(listTypesRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new ListTypesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Lists <code>Type</code> objects by the source API association ID.
     * </p>
     *
     * @param listTypesByAssociationRequest
     * @return Result of the ListTypesByAssociation operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypesByAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypesByAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public ListTypesByAssociationResponse listTypesByAssociation(ListTypesByAssociationRequest listTypesByAssociationRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<ListTypesByAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, ListTypesByAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(listTypesByAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, listTypesByAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "ListTypesByAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<ListTypesByAssociationRequest, ListTypesByAssociationResponse>()
                            .withOperationName("ListTypesByAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(listTypesByAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new ListTypesByAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a list of environmental variables in an API by its ID value.
     * </p>
     * <p>
     * When creating an environmental variable, it must follow the constraints below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Both JavaScript and VTL templates support environmental variables.
     * </p>
     * </li>
     * <li>
     * <p>
     * Environmental variables are not evaluated before function invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Environmental variables only support string values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any defined value in an environmental variable is considered a string literal and not expanded.
     * </p>
     * </li>
     * <li>
     * <p>
     * Variable evaluations should ideally be performed in the function code.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When creating an environmental variable key-value pair, it must follow the additional constraints below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Keys must begin with a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys must be at least two characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys can only contain letters, numbers, and the underscore character (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Values can be up to 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure up to 50 key-value pairs in a GraphQL API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can create a list of environmental variables by adding it to the <code>environmentVariables</code> payload as
     * a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call of the
     * <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the existing
     * environmental variable list of that API. This means the existing environmental variables will be lost. To avoid
     * this, you must include all existing and new environmental variables in the list each time you call this action.
     * </p>
     *
     * @param putGraphqlApiEnvironmentVariablesRequest
     * @return Result of the PutGraphqlApiEnvironmentVariables operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.PutGraphqlApiEnvironmentVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/PutGraphqlApiEnvironmentVariables"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public PutGraphqlApiEnvironmentVariablesResponse putGraphqlApiEnvironmentVariables(
            PutGraphqlApiEnvironmentVariablesRequest putGraphqlApiEnvironmentVariablesRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<PutGraphqlApiEnvironmentVariablesResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, PutGraphqlApiEnvironmentVariablesResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(putGraphqlApiEnvironmentVariablesRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration,
                putGraphqlApiEnvironmentVariablesRequest.overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "PutGraphqlApiEnvironmentVariables");

            return clientHandler
                    .execute(new ClientExecutionParams<PutGraphqlApiEnvironmentVariablesRequest, PutGraphqlApiEnvironmentVariablesResponse>()
                            .withOperationName("PutGraphqlApiEnvironmentVariables").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(putGraphqlApiEnvironmentVariablesRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new PutGraphqlApiEnvironmentVariablesRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Creates a new introspection. Returns the <code>introspectionId</code> of the new introspection after its
     * creation.
     * </p>
     *
     * @param startDataSourceIntrospectionRequest
     * @return Result of the StartDataSourceIntrospection operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartDataSourceIntrospection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartDataSourceIntrospection"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public StartDataSourceIntrospectionResponse startDataSourceIntrospection(
            StartDataSourceIntrospectionRequest startDataSourceIntrospectionRequest) throws NotFoundException,
            UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartDataSourceIntrospectionResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartDataSourceIntrospectionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startDataSourceIntrospectionRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startDataSourceIntrospectionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartDataSourceIntrospection");

            return clientHandler
                    .execute(new ClientExecutionParams<StartDataSourceIntrospectionRequest, StartDataSourceIntrospectionResponse>()
                            .withOperationName("StartDataSourceIntrospection").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(startDataSourceIntrospectionRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new StartDataSourceIntrospectionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Adds a new schema to your GraphQL API.
     * </p>
     * <p>
     * This operation is asynchronous. Use to determine when it has completed.
     * </p>
     *
     * @param startSchemaCreationRequest
     * @return Result of the StartSchemaCreation operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartSchemaCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaCreation" target="_top">AWS
     *      API Documentation</a>
     */
    @Override
    public StartSchemaCreationResponse startSchemaCreation(StartSchemaCreationRequest startSchemaCreationRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSchemaCreationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, StartSchemaCreationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSchemaCreationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSchemaCreationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSchemaCreation");

            return clientHandler.execute(new ClientExecutionParams<StartSchemaCreationRequest, StartSchemaCreationResponse>()
                    .withOperationName("StartSchemaCreation").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startSchemaCreationRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartSchemaCreationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Initiates a merge operation. Returns a status that shows the result of the merge operation.
     * </p>
     *
     * @param startSchemaMergeRequest
     * @return Result of the StartSchemaMerge operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartSchemaMerge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaMerge" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public StartSchemaMergeResponse startSchemaMerge(StartSchemaMergeRequest startSchemaMergeRequest)
            throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<StartSchemaMergeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                StartSchemaMergeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(startSchemaMergeRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, startSchemaMergeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "StartSchemaMerge");

            return clientHandler.execute(new ClientExecutionParams<StartSchemaMergeRequest, StartSchemaMergeResponse>()
                    .withOperationName("StartSchemaMerge").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(startSchemaMergeRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new StartSchemaMergeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Tags a resource with user-supplied tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, NotFoundException,
            LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<TagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                TagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(tagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, tagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "TagResource");

            return clientHandler.execute(new ClientExecutionParams<TagResourceRequest, TagResourceResponse>()
                    .withOperationName("TagResource").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(tagResourceRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new TagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UntagResourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UntagResourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(untagResourceRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, untagResourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UntagResource");

            return clientHandler.execute(new ClientExecutionParams<UntagResourceRequest, UntagResourceResponse>()
                    .withOperationName("UntagResource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(untagResourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UntagResourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates the cache for the GraphQL API.
     * </p>
     *
     * @param updateApiCacheRequest
     *        Represents the input of a <code>UpdateApiCache</code> operation.
     * @return Result of the UpdateApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateApiCacheResponse updateApiCache(UpdateApiCacheRequest updateApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApiCacheResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApiCacheResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApiCacheRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiCacheRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiCache");

            return clientHandler.execute(new ClientExecutionParams<UpdateApiCacheRequest, UpdateApiCacheResponse>()
                    .withOperationName("UpdateApiCache").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateApiCacheRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApiCacheRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates an API key. You can update the key as long as it's not deleted.
     * </p>
     *
     * @param updateApiKeyRequest
     * @return Result of the UpdateApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiKeyValidityOutOfBoundsException
     *         The API key expiration must be set to a value between 1 and 365 days from creation (for
     *         <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateApiKeyResponse updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, LimitExceededException, InternalFailureException,
            ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateApiKeyResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateApiKeyResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateApiKeyRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateApiKeyRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateApiKey");

            return clientHandler.execute(new ClientExecutionParams<UpdateApiKeyRequest, UpdateApiKeyResponse>()
                    .withOperationName("UpdateApiKey").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateApiKeyRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateApiKeyRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>DataSource</code> object.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDataSourceResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDataSourceResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDataSourceRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDataSourceRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDataSource");

            return clientHandler.execute(new ClientExecutionParams<UpdateDataSourceRequest, UpdateDataSourceResponse>()
                    .withOperationName("UpdateDataSource").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDataSourceRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDataSourceRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a custom <code>DomainName</code> object.
     * </p>
     *
     * @param updateDomainNameRequest
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateDomainNameResponse updateDomainName(UpdateDomainNameRequest updateDomainNameRequest)
            throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException,
            NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateDomainNameResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateDomainNameResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateDomainNameRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateDomainNameRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateDomainName");

            return clientHandler.execute(new ClientExecutionParams<UpdateDomainNameRequest, UpdateDomainNameResponse>()
                    .withOperationName("UpdateDomainName").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateDomainNameRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateDomainNameRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>Function</code> object.
     * </p>
     *
     * @param updateFunctionRequest
     * @return Result of the UpdateFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateFunctionResponse updateFunction(UpdateFunctionRequest updateFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateFunctionResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateFunctionResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateFunctionRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateFunctionRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateFunction");

            return clientHandler.execute(new ClientExecutionParams<UpdateFunctionRequest, UpdateFunctionResponse>()
                    .withOperationName("UpdateFunction").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateFunctionRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateFunctionRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param updateGraphqlApiRequest
     * @return Result of the UpdateGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateGraphqlApiResponse updateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateGraphqlApiResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateGraphqlApiResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateGraphqlApiRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateGraphqlApiRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateGraphqlApi");

            return clientHandler.execute(new ClientExecutionParams<UpdateGraphqlApiRequest, UpdateGraphqlApiResponse>()
                    .withOperationName("UpdateGraphqlApi").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateGraphqlApiRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateGraphqlApiRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>Resolver</code> object.
     * </p>
     *
     * @param updateResolverRequest
     * @return Result of the UpdateResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateResolverResponse updateResolver(UpdateResolverRequest updateResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateResolverResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateResolverResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateResolverRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateResolverRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateResolver");

            return clientHandler.execute(new ClientExecutionParams<UpdateResolverRequest, UpdateResolverResponse>()
                    .withOperationName("UpdateResolver").withProtocolMetadata(protocolMetadata)
                    .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                    .withRequestConfiguration(clientConfiguration).withInput(updateResolverRequest)
                    .withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateResolverRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates some of the configuration choices of a particular source API association.
     * </p>
     *
     * @param updateSourceApiAssociationRequest
     * @return Result of the UpdateSourceApiAssociation operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateSourceApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateSourceApiAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    @Override
    public UpdateSourceApiAssociationResponse updateSourceApiAssociation(
            UpdateSourceApiAssociationRequest updateSourceApiAssociationRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateSourceApiAssociationResponse> responseHandler = protocolFactory.createResponseHandler(
                operationMetadata, UpdateSourceApiAssociationResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateSourceApiAssociationRequest,
                this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateSourceApiAssociationRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateSourceApiAssociation");

            return clientHandler
                    .execute(new ClientExecutionParams<UpdateSourceApiAssociationRequest, UpdateSourceApiAssociationResponse>()
                            .withOperationName("UpdateSourceApiAssociation").withProtocolMetadata(protocolMetadata)
                            .withResponseHandler(responseHandler).withErrorResponseHandler(errorResponseHandler)
                            .withRequestConfiguration(clientConfiguration).withInput(updateSourceApiAssociationRequest)
                            .withMetricCollector(apiCallMetricCollector)
                            .withMarshaller(new UpdateSourceApiAssociationRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    /**
     * <p>
     * Updates a <code>Type</code> object.
     * </p>
     *
     * @param updateTypeRequest
     * @return Result of the UpdateType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType" target="_top">AWS API
     *      Documentation</a>
     */
    @Override
    public UpdateTypeResponse updateType(UpdateTypeRequest updateTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        JsonOperationMetadata operationMetadata = JsonOperationMetadata.builder().hasStreamingSuccessResponse(false)
                .isPayloadJson(true).build();

        HttpResponseHandler<UpdateTypeResponse> responseHandler = protocolFactory.createResponseHandler(operationMetadata,
                UpdateTypeResponse::builder);

        HttpResponseHandler<AwsServiceException> errorResponseHandler = createErrorResponseHandler(protocolFactory,
                operationMetadata);
        SdkClientConfiguration clientConfiguration = updateSdkClientConfiguration(updateTypeRequest, this.clientConfiguration);
        List<MetricPublisher> metricPublishers = resolveMetricPublishers(clientConfiguration, updateTypeRequest
                .overrideConfiguration().orElse(null));
        MetricCollector apiCallMetricCollector = metricPublishers.isEmpty() ? NoOpMetricCollector.create() : MetricCollector
                .create("ApiCall");
        try {
            apiCallMetricCollector.reportMetric(CoreMetric.SERVICE_ID, "AppSync");
            apiCallMetricCollector.reportMetric(CoreMetric.OPERATION_NAME, "UpdateType");

            return clientHandler.execute(new ClientExecutionParams<UpdateTypeRequest, UpdateTypeResponse>()
                    .withOperationName("UpdateType").withProtocolMetadata(protocolMetadata).withResponseHandler(responseHandler)
                    .withErrorResponseHandler(errorResponseHandler).withRequestConfiguration(clientConfiguration)
                    .withInput(updateTypeRequest).withMetricCollector(apiCallMetricCollector)
                    .withMarshaller(new UpdateTypeRequestMarshaller(protocolFactory)));
        } finally {
            metricPublishers.forEach(p -> p.publish(apiCallMetricCollector.collect()));
        }
    }

    @Override
    public final String serviceName() {
        return SERVICE_NAME;
    }

    private static List<MetricPublisher> resolveMetricPublishers(SdkClientConfiguration clientConfiguration,
            RequestOverrideConfiguration requestOverrideConfiguration) {
        List<MetricPublisher> publishers = null;
        if (requestOverrideConfiguration != null) {
            publishers = requestOverrideConfiguration.metricPublishers();
        }
        if (publishers == null || publishers.isEmpty()) {
            publishers = clientConfiguration.option(SdkClientOption.METRIC_PUBLISHERS);
        }
        if (publishers == null) {
            publishers = Collections.emptyList();
        }
        return publishers;
    }

    private HttpResponseHandler<AwsServiceException> createErrorResponseHandler(BaseAwsJsonProtocolFactory protocolFactory,
            JsonOperationMetadata operationMetadata) {
        return protocolFactory.createErrorResponseHandler(operationMetadata);
    }

    private SdkClientConfiguration updateSdkClientConfiguration(SdkRequest request, SdkClientConfiguration clientConfiguration) {
        List<SdkPlugin> plugins = request.overrideConfiguration().map(c -> c.plugins()).orElse(Collections.emptyList());
        SdkClientConfiguration.Builder configuration = clientConfiguration.toBuilder();
        if (plugins.isEmpty()) {
            return configuration.build();
        }
        AppSyncServiceClientConfigurationBuilder serviceConfigBuilder = new AppSyncServiceClientConfigurationBuilder(
                configuration);
        for (SdkPlugin plugin : plugins) {
            plugin.configureClient(serviceConfigBuilder);
        }
        return configuration.build();
    }

    private <T extends BaseAwsJsonProtocolFactory.Builder<T>> T init(T builder) {
        return builder
                .clientConfiguration(clientConfiguration)
                .defaultServiceExceptionSupplier(AppSyncException::builder)
                .protocol(AwsJsonProtocol.REST_JSON)
                .protocolVersion("1.1")
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ConcurrentModificationException")
                                .exceptionBuilderSupplier(ConcurrentModificationException::builder).httpStatusCode(409).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("InternalFailureException")
                                .exceptionBuilderSupplier(InternalFailureException::builder).httpStatusCode(500).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("GraphQLSchemaException")
                                .exceptionBuilderSupplier(GraphQlSchemaException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApiKeyLimitExceededException")
                                .exceptionBuilderSupplier(ApiKeyLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("LimitExceededException")
                                .exceptionBuilderSupplier(LimitExceededException::builder).httpStatusCode(429).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApiLimitExceededException")
                                .exceptionBuilderSupplier(ApiLimitExceededException::builder).httpStatusCode(400).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("NotFoundException")
                                .exceptionBuilderSupplier(NotFoundException::builder).httpStatusCode(404).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("UnauthorizedException")
                                .exceptionBuilderSupplier(UnauthorizedException::builder).httpStatusCode(401).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("AccessDeniedException")
                                .exceptionBuilderSupplier(AccessDeniedException::builder).httpStatusCode(403).build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("ApiKeyValidityOutOfBoundsException")
                                .exceptionBuilderSupplier(ApiKeyValidityOutOfBoundsException::builder).httpStatusCode(400)
                                .build())
                .registerModeledException(
                        ExceptionMetadata.builder().errorCode("BadRequestException")
                                .exceptionBuilderSupplier(BadRequestException::builder).httpStatusCode(400).build());
    }

    @Override
    public final AppSyncServiceClientConfiguration serviceClientConfiguration() {
        return new AppSyncServiceClientConfigurationBuilder(this.clientConfiguration.toBuilder()).build();
    }

    @Override
    public void close() {
        clientHandler.close();
    }
}
