/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateFunctionRequest extends AppSyncRequest implements
        ToCopyableBuilder<CreateFunctionRequest.Builder, CreateFunctionRequest> {
    private static final SdkField<String> API_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("apiId")
            .getter(getter(CreateFunctionRequest::apiId)).setter(setter(Builder::apiId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("apiId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateFunctionRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateFunctionRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> DATA_SOURCE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("dataSourceName").getter(getter(CreateFunctionRequest::dataSourceName))
            .setter(setter(Builder::dataSourceName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataSourceName").build()).build();

    private static final SdkField<String> REQUEST_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("requestMappingTemplate").getter(getter(CreateFunctionRequest::requestMappingTemplate))
            .setter(setter(Builder::requestMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestMappingTemplate").build())
            .build();

    private static final SdkField<String> RESPONSE_MAPPING_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("responseMappingTemplate").getter(getter(CreateFunctionRequest::responseMappingTemplate))
            .setter(setter(Builder::responseMappingTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("responseMappingTemplate").build())
            .build();

    private static final SdkField<String> FUNCTION_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("functionVersion").getter(getter(CreateFunctionRequest::functionVersion))
            .setter(setter(Builder::functionVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("functionVersion").build()).build();

    private static final SdkField<SyncConfig> SYNC_CONFIG_FIELD = SdkField.<SyncConfig> builder(MarshallingType.SDK_POJO)
            .memberName("syncConfig").getter(getter(CreateFunctionRequest::syncConfig)).setter(setter(Builder::syncConfig))
            .constructor(SyncConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("syncConfig").build()).build();

    private static final SdkField<Integer> MAX_BATCH_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxBatchSize").getter(getter(CreateFunctionRequest::maxBatchSize)).setter(setter(Builder::maxBatchSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxBatchSize").build()).build();

    private static final SdkField<AppSyncRuntime> RUNTIME_FIELD = SdkField.<AppSyncRuntime> builder(MarshallingType.SDK_POJO)
            .memberName("runtime").getter(getter(CreateFunctionRequest::runtime)).setter(setter(Builder::runtime))
            .constructor(AppSyncRuntime::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final SdkField<String> CODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("code")
            .getter(getter(CreateFunctionRequest::code)).setter(setter(Builder::code))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(API_ID_FIELD, NAME_FIELD,
            DESCRIPTION_FIELD, DATA_SOURCE_NAME_FIELD, REQUEST_MAPPING_TEMPLATE_FIELD, RESPONSE_MAPPING_TEMPLATE_FIELD,
            FUNCTION_VERSION_FIELD, SYNC_CONFIG_FIELD, MAX_BATCH_SIZE_FIELD, RUNTIME_FIELD, CODE_FIELD));

    private final String apiId;

    private final String name;

    private final String description;

    private final String dataSourceName;

    private final String requestMappingTemplate;

    private final String responseMappingTemplate;

    private final String functionVersion;

    private final SyncConfig syncConfig;

    private final Integer maxBatchSize;

    private final AppSyncRuntime runtime;

    private final String code;

    private CreateFunctionRequest(BuilderImpl builder) {
        super(builder);
        this.apiId = builder.apiId;
        this.name = builder.name;
        this.description = builder.description;
        this.dataSourceName = builder.dataSourceName;
        this.requestMappingTemplate = builder.requestMappingTemplate;
        this.responseMappingTemplate = builder.responseMappingTemplate;
        this.functionVersion = builder.functionVersion;
        this.syncConfig = builder.syncConfig;
        this.maxBatchSize = builder.maxBatchSize;
        this.runtime = builder.runtime;
        this.code = builder.code;
    }

    /**
     * <p>
     * The GraphQL API ID.
     * </p>
     * 
     * @return The GraphQL API ID.
     */
    public final String apiId() {
        return apiId;
    }

    /**
     * <p>
     * The <code>Function</code> name. The function name does not have to be unique.
     * </p>
     * 
     * @return The <code>Function</code> name. The function name does not have to be unique.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The <code>Function</code> description.
     * </p>
     * 
     * @return The <code>Function</code> description.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The <code>Function</code> <code>DataSource</code> name.
     * </p>
     * 
     * @return The <code>Function</code> <code>DataSource</code> name.
     */
    public final String dataSourceName() {
        return dataSourceName;
    }

    /**
     * <p>
     * The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the request
     * mapping template.
     * </p>
     * 
     * @return The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the
     *         request mapping template.
     */
    public final String requestMappingTemplate() {
        return requestMappingTemplate;
    }

    /**
     * <p>
     * The <code>Function</code> response mapping template.
     * </p>
     * 
     * @return The <code>Function</code> response mapping template.
     */
    public final String responseMappingTemplate() {
        return responseMappingTemplate;
    }

    /**
     * <p>
     * The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29. Note that
     * when using VTL and mapping templates, the <code>functionVersion</code> is required.
     * </p>
     * 
     * @return The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29.
     *         Note that when using VTL and mapping templates, the <code>functionVersion</code> is required.
     */
    public final String functionVersion() {
        return functionVersion;
    }

    /**
     * Returns the value of the SyncConfig property for this object.
     * 
     * @return The value of the SyncConfig property for this object.
     */
    public final SyncConfig syncConfig() {
        return syncConfig;
    }

    /**
     * <p>
     * The maximum batching size for a resolver.
     * </p>
     * 
     * @return The maximum batching size for a resolver.
     */
    public final Integer maxBatchSize() {
        return maxBatchSize;
    }

    /**
     * Returns the value of the Runtime property for this object.
     * 
     * @return The value of the Runtime property for this object.
     */
    public final AppSyncRuntime runtime() {
        return runtime;
    }

    /**
     * <p>
     * The <code>function</code> code that contains the request and response functions. When code is used, the
     * <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
     * </p>
     * 
     * @return The <code>function</code> code that contains the request and response functions. When code is used, the
     *         <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
     */
    public final String code() {
        return code;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(apiId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(dataSourceName());
        hashCode = 31 * hashCode + Objects.hashCode(requestMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(responseMappingTemplate());
        hashCode = 31 * hashCode + Objects.hashCode(functionVersion());
        hashCode = 31 * hashCode + Objects.hashCode(syncConfig());
        hashCode = 31 * hashCode + Objects.hashCode(maxBatchSize());
        hashCode = 31 * hashCode + Objects.hashCode(runtime());
        hashCode = 31 * hashCode + Objects.hashCode(code());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateFunctionRequest)) {
            return false;
        }
        CreateFunctionRequest other = (CreateFunctionRequest) obj;
        return Objects.equals(apiId(), other.apiId()) && Objects.equals(name(), other.name())
                && Objects.equals(description(), other.description()) && Objects.equals(dataSourceName(), other.dataSourceName())
                && Objects.equals(requestMappingTemplate(), other.requestMappingTemplate())
                && Objects.equals(responseMappingTemplate(), other.responseMappingTemplate())
                && Objects.equals(functionVersion(), other.functionVersion()) && Objects.equals(syncConfig(), other.syncConfig())
                && Objects.equals(maxBatchSize(), other.maxBatchSize()) && Objects.equals(runtime(), other.runtime())
                && Objects.equals(code(), other.code());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateFunctionRequest").add("ApiId", apiId()).add("Name", name())
                .add("Description", description()).add("DataSourceName", dataSourceName())
                .add("RequestMappingTemplate", requestMappingTemplate())
                .add("ResponseMappingTemplate", responseMappingTemplate()).add("FunctionVersion", functionVersion())
                .add("SyncConfig", syncConfig()).add("MaxBatchSize", maxBatchSize()).add("Runtime", runtime())
                .add("Code", code()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "apiId":
            return Optional.ofNullable(clazz.cast(apiId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "dataSourceName":
            return Optional.ofNullable(clazz.cast(dataSourceName()));
        case "requestMappingTemplate":
            return Optional.ofNullable(clazz.cast(requestMappingTemplate()));
        case "responseMappingTemplate":
            return Optional.ofNullable(clazz.cast(responseMappingTemplate()));
        case "functionVersion":
            return Optional.ofNullable(clazz.cast(functionVersion()));
        case "syncConfig":
            return Optional.ofNullable(clazz.cast(syncConfig()));
        case "maxBatchSize":
            return Optional.ofNullable(clazz.cast(maxBatchSize()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtime()));
        case "code":
            return Optional.ofNullable(clazz.cast(code()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CreateFunctionRequest, T> g) {
        return obj -> g.apply((CreateFunctionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateFunctionRequest> {
        /**
         * <p>
         * The GraphQL API ID.
         * </p>
         * 
         * @param apiId
         *        The GraphQL API ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder apiId(String apiId);

        /**
         * <p>
         * The <code>Function</code> name. The function name does not have to be unique.
         * </p>
         * 
         * @param name
         *        The <code>Function</code> name. The function name does not have to be unique.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>Function</code> description.
         * </p>
         * 
         * @param description
         *        The <code>Function</code> description.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The <code>Function</code> <code>DataSource</code> name.
         * </p>
         * 
         * @param dataSourceName
         *        The <code>Function</code> <code>DataSource</code> name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dataSourceName(String dataSourceName);

        /**
         * <p>
         * The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of the
         * request mapping template.
         * </p>
         * 
         * @param requestMappingTemplate
         *        The <code>Function</code> request mapping template. Functions support only the 2018-05-29 version of
         *        the request mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder requestMappingTemplate(String requestMappingTemplate);

        /**
         * <p>
         * The <code>Function</code> response mapping template.
         * </p>
         * 
         * @param responseMappingTemplate
         *        The <code>Function</code> response mapping template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder responseMappingTemplate(String responseMappingTemplate);

        /**
         * <p>
         * The <code>version</code> of the request mapping template. Currently, the supported value is 2018-05-29. Note
         * that when using VTL and mapping templates, the <code>functionVersion</code> is required.
         * </p>
         * 
         * @param functionVersion
         *        The <code>version</code> of the request mapping template. Currently, the supported value is
         *        2018-05-29. Note that when using VTL and mapping templates, the <code>functionVersion</code> is
         *        required.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder functionVersion(String functionVersion);

        /**
         * Sets the value of the SyncConfig property for this object.
         *
         * @param syncConfig
         *        The new value for the SyncConfig property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder syncConfig(SyncConfig syncConfig);

        /**
         * Sets the value of the SyncConfig property for this object.
         *
         * This is a convenience method that creates an instance of the {@link SyncConfig.Builder} avoiding the need to
         * create one manually via {@link SyncConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SyncConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #syncConfig(SyncConfig)}.
         * 
         * @param syncConfig
         *        a consumer that will call methods on {@link SyncConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #syncConfig(SyncConfig)
         */
        default Builder syncConfig(Consumer<SyncConfig.Builder> syncConfig) {
            return syncConfig(SyncConfig.builder().applyMutation(syncConfig).build());
        }

        /**
         * <p>
         * The maximum batching size for a resolver.
         * </p>
         * 
         * @param maxBatchSize
         *        The maximum batching size for a resolver.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxBatchSize(Integer maxBatchSize);

        /**
         * Sets the value of the Runtime property for this object.
         *
         * @param runtime
         *        The new value for the Runtime property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtime(AppSyncRuntime runtime);

        /**
         * Sets the value of the Runtime property for this object.
         *
         * This is a convenience method that creates an instance of the {@link AppSyncRuntime.Builder} avoiding the need
         * to create one manually via {@link AppSyncRuntime#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AppSyncRuntime.Builder#build()} is called immediately and its
         * result is passed to {@link #runtime(AppSyncRuntime)}.
         * 
         * @param runtime
         *        a consumer that will call methods on {@link AppSyncRuntime.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #runtime(AppSyncRuntime)
         */
        default Builder runtime(Consumer<AppSyncRuntime.Builder> runtime) {
            return runtime(AppSyncRuntime.builder().applyMutation(runtime).build());
        }

        /**
         * <p>
         * The <code>function</code> code that contains the request and response functions. When code is used, the
         * <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
         * </p>
         * 
         * @param code
         *        The <code>function</code> code that contains the request and response functions. When code is used,
         *        the <code>runtime</code> is required. The <code>runtime</code> value must be <code>APPSYNC_JS</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder code(String code);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String apiId;

        private String name;

        private String description;

        private String dataSourceName;

        private String requestMappingTemplate;

        private String responseMappingTemplate;

        private String functionVersion;

        private SyncConfig syncConfig;

        private Integer maxBatchSize;

        private AppSyncRuntime runtime;

        private String code;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateFunctionRequest model) {
            super(model);
            apiId(model.apiId);
            name(model.name);
            description(model.description);
            dataSourceName(model.dataSourceName);
            requestMappingTemplate(model.requestMappingTemplate);
            responseMappingTemplate(model.responseMappingTemplate);
            functionVersion(model.functionVersion);
            syncConfig(model.syncConfig);
            maxBatchSize(model.maxBatchSize);
            runtime(model.runtime);
            code(model.code);
        }

        public final String getApiId() {
            return apiId;
        }

        public final void setApiId(String apiId) {
            this.apiId = apiId;
        }

        @Override
        public final Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getDataSourceName() {
            return dataSourceName;
        }

        public final void setDataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
        }

        @Override
        public final Builder dataSourceName(String dataSourceName) {
            this.dataSourceName = dataSourceName;
            return this;
        }

        public final String getRequestMappingTemplate() {
            return requestMappingTemplate;
        }

        public final void setRequestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
        }

        @Override
        public final Builder requestMappingTemplate(String requestMappingTemplate) {
            this.requestMappingTemplate = requestMappingTemplate;
            return this;
        }

        public final String getResponseMappingTemplate() {
            return responseMappingTemplate;
        }

        public final void setResponseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
        }

        @Override
        public final Builder responseMappingTemplate(String responseMappingTemplate) {
            this.responseMappingTemplate = responseMappingTemplate;
            return this;
        }

        public final String getFunctionVersion() {
            return functionVersion;
        }

        public final void setFunctionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
        }

        @Override
        public final Builder functionVersion(String functionVersion) {
            this.functionVersion = functionVersion;
            return this;
        }

        public final SyncConfig.Builder getSyncConfig() {
            return syncConfig != null ? syncConfig.toBuilder() : null;
        }

        public final void setSyncConfig(SyncConfig.BuilderImpl syncConfig) {
            this.syncConfig = syncConfig != null ? syncConfig.build() : null;
        }

        @Override
        public final Builder syncConfig(SyncConfig syncConfig) {
            this.syncConfig = syncConfig;
            return this;
        }

        public final Integer getMaxBatchSize() {
            return maxBatchSize;
        }

        public final void setMaxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
        }

        @Override
        public final Builder maxBatchSize(Integer maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public final AppSyncRuntime.Builder getRuntime() {
            return runtime != null ? runtime.toBuilder() : null;
        }

        public final void setRuntime(AppSyncRuntime.BuilderImpl runtime) {
            this.runtime = runtime != null ? runtime.build() : null;
        }

        @Override
        public final Builder runtime(AppSyncRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        public final String getCode() {
            return code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateFunctionRequest build() {
            return new CreateFunctionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
