/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the type data for each field retrieved from the introspection.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DataSourceIntrospectionModelFieldType implements SdkPojo, Serializable,
        ToCopyableBuilder<DataSourceIntrospectionModelFieldType.Builder, DataSourceIntrospectionModelFieldType> {
    private static final SdkField<String> KIND_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("kind")
            .getter(getter(DataSourceIntrospectionModelFieldType::kind)).setter(setter(Builder::kind))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("kind").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(DataSourceIntrospectionModelFieldType::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<DataSourceIntrospectionModelFieldType> TYPE_FIELD = SdkField
            .<DataSourceIntrospectionModelFieldType> builder(MarshallingType.SDK_POJO).memberName("type")
            .getter(getter(DataSourceIntrospectionModelFieldType::type)).setter(setter(Builder::type))
            .constructor(DataSourceIntrospectionModelFieldType::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final SdkField<List<String>> VALUES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("values")
            .getter(getter(DataSourceIntrospectionModelFieldType::values))
            .setter(setter(Builder::values))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("values").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(KIND_FIELD, NAME_FIELD,
            TYPE_FIELD, VALUES_FIELD));

    private static final long serialVersionUID = 1L;

    private final String kind;

    private final String name;

    private final DataSourceIntrospectionModelFieldType type;

    private final List<String> values;

    private DataSourceIntrospectionModelFieldType(BuilderImpl builder) {
        this.kind = builder.kind;
        this.name = builder.name;
        this.type = builder.type;
        this.values = builder.values;
    }

    /**
     * <p>
     * Specifies the classification of data. For example, this could be set to values like <code>Scalar</code> or
     * <code>NonNull</code> to indicate a fundamental property of the field.
     * </p>
     * <p>
     * Valid values include:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>Scalar</code>: Indicates the value is a primitive type (scalar).
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>NonNull</code>: Indicates the field cannot be <code>null</code>.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>List</code>: Indicates the field contains a list.
     * </p>
     * </li>
     * </ul>
     * 
     * @return Specifies the classification of data. For example, this could be set to values like <code>Scalar</code>
     *         or <code>NonNull</code> to indicate a fundamental property of the field.</p>
     *         <p>
     *         Valid values include:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>Scalar</code>: Indicates the value is a primitive type (scalar).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>NonNull</code>: Indicates the field cannot be <code>null</code>.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>List</code>: Indicates the field contains a list.
     *         </p>
     *         </li>
     */
    public final String kind() {
        return kind;
    }

    /**
     * <p>
     * The name of the data type that represents the field. For example, <code>String</code> is a valid
     * <code>name</code> value.
     * </p>
     * 
     * @return The name of the data type that represents the field. For example, <code>String</code> is a valid
     *         <code>name</code> value.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The <code>DataSourceIntrospectionModelFieldType</code> object data. The <code>type</code> is only present if
     * <code>DataSourceIntrospectionModelFieldType.kind</code> is set to <code>NonNull</code> or <code>List</code>.
     * </p>
     * <p>
     * The <code>type</code> typically contains its own <code>kind</code> and <code>name</code> fields to represent the
     * actual type data. For instance, <code>type</code> could contain a <code>kind</code> value of <code>Scalar</code>
     * with a <code>name</code> value of <code>String</code>. The values <code>Scalar</code> and <code>String</code>
     * will be collectively stored in the <code>values</code> field.
     * </p>
     * 
     * @return The <code>DataSourceIntrospectionModelFieldType</code> object data. The <code>type</code> is only present
     *         if <code>DataSourceIntrospectionModelFieldType.kind</code> is set to <code>NonNull</code> or
     *         <code>List</code>. </p>
     *         <p>
     *         The <code>type</code> typically contains its own <code>kind</code> and <code>name</code> fields to
     *         represent the actual type data. For instance, <code>type</code> could contain a <code>kind</code> value
     *         of <code>Scalar</code> with a <code>name</code> value of <code>String</code>. The values
     *         <code>Scalar</code> and <code>String</code> will be collectively stored in the <code>values</code> field.
     */
    public final DataSourceIntrospectionModelFieldType type() {
        return type;
    }

    /**
     * For responses, this returns true if the service returned a value for the Values property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasValues() {
        return values != null && !(values instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The values of the <code>type</code> field. This field represents the AppSync data type equivalent of the
     * introspected field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasValues} method.
     * </p>
     * 
     * @return The values of the <code>type</code> field. This field represents the AppSync data type equivalent of the
     *         introspected field.
     */
    public final List<String> values() {
        return values;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(kind());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(type());
        hashCode = 31 * hashCode + Objects.hashCode(hasValues() ? values() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceIntrospectionModelFieldType)) {
            return false;
        }
        DataSourceIntrospectionModelFieldType other = (DataSourceIntrospectionModelFieldType) obj;
        return Objects.equals(kind(), other.kind()) && Objects.equals(name(), other.name())
                && Objects.equals(type(), other.type()) && hasValues() == other.hasValues()
                && Objects.equals(values(), other.values());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DataSourceIntrospectionModelFieldType").add("Kind", kind()).add("Name", name())
                .add("Type", type()).add("Values", hasValues() ? values() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "kind":
            return Optional.ofNullable(clazz.cast(kind()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "type":
            return Optional.ofNullable(clazz.cast(type()));
        case "values":
            return Optional.ofNullable(clazz.cast(values()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<DataSourceIntrospectionModelFieldType, T> g) {
        return obj -> g.apply((DataSourceIntrospectionModelFieldType) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DataSourceIntrospectionModelFieldType> {
        /**
         * <p>
         * Specifies the classification of data. For example, this could be set to values like <code>Scalar</code> or
         * <code>NonNull</code> to indicate a fundamental property of the field.
         * </p>
         * <p>
         * Valid values include:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>Scalar</code>: Indicates the value is a primitive type (scalar).
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>NonNull</code>: Indicates the field cannot be <code>null</code>.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>List</code>: Indicates the field contains a list.
         * </p>
         * </li>
         * </ul>
         * 
         * @param kind
         *        Specifies the classification of data. For example, this could be set to values like
         *        <code>Scalar</code> or <code>NonNull</code> to indicate a fundamental property of the field.</p>
         *        <p>
         *        Valid values include:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>Scalar</code>: Indicates the value is a primitive type (scalar).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>NonNull</code>: Indicates the field cannot be <code>null</code>.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>List</code>: Indicates the field contains a list.
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder kind(String kind);

        /**
         * <p>
         * The name of the data type that represents the field. For example, <code>String</code> is a valid
         * <code>name</code> value.
         * </p>
         * 
         * @param name
         *        The name of the data type that represents the field. For example, <code>String</code> is a valid
         *        <code>name</code> value.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The <code>DataSourceIntrospectionModelFieldType</code> object data. The <code>type</code> is only present if
         * <code>DataSourceIntrospectionModelFieldType.kind</code> is set to <code>NonNull</code> or <code>List</code>.
         * </p>
         * <p>
         * The <code>type</code> typically contains its own <code>kind</code> and <code>name</code> fields to represent
         * the actual type data. For instance, <code>type</code> could contain a <code>kind</code> value of
         * <code>Scalar</code> with a <code>name</code> value of <code>String</code>. The values <code>Scalar</code> and
         * <code>String</code> will be collectively stored in the <code>values</code> field.
         * </p>
         * 
         * @param type
         *        The <code>DataSourceIntrospectionModelFieldType</code> object data. The <code>type</code> is only
         *        present if <code>DataSourceIntrospectionModelFieldType.kind</code> is set to <code>NonNull</code> or
         *        <code>List</code>. </p>
         *        <p>
         *        The <code>type</code> typically contains its own <code>kind</code> and <code>name</code> fields to
         *        represent the actual type data. For instance, <code>type</code> could contain a <code>kind</code>
         *        value of <code>Scalar</code> with a <code>name</code> value of <code>String</code>. The values
         *        <code>Scalar</code> and <code>String</code> will be collectively stored in the <code>values</code>
         *        field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder type(DataSourceIntrospectionModelFieldType type);

        /**
         * <p>
         * The <code>DataSourceIntrospectionModelFieldType</code> object data. The <code>type</code> is only present if
         * <code>DataSourceIntrospectionModelFieldType.kind</code> is set to <code>NonNull</code> or <code>List</code>.
         * </p>
         * <p>
         * The <code>type</code> typically contains its own <code>kind</code> and <code>name</code> fields to represent
         * the actual type data. For instance, <code>type</code> could contain a <code>kind</code> value of
         * <code>Scalar</code> with a <code>name</code> value of <code>String</code>. The values <code>Scalar</code> and
         * <code>String</code> will be collectively stored in the <code>values</code> field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link DataSourceIntrospectionModelFieldType.Builder} avoiding the need to create one manually via
         * {@link DataSourceIntrospectionModelFieldType#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link DataSourceIntrospectionModelFieldType.Builder#build()} is called
         * immediately and its result is passed to {@link #type(DataSourceIntrospectionModelFieldType)}.
         * 
         * @param type
         *        a consumer that will call methods on {@link DataSourceIntrospectionModelFieldType.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #type(DataSourceIntrospectionModelFieldType)
         */
        default Builder type(Consumer<Builder> type) {
            return type(DataSourceIntrospectionModelFieldType.builder().applyMutation(type).build());
        }

        /**
         * <p>
         * The values of the <code>type</code> field. This field represents the AppSync data type equivalent of the
         * introspected field.
         * </p>
         * 
         * @param values
         *        The values of the <code>type</code> field. This field represents the AppSync data type equivalent of
         *        the introspected field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(Collection<String> values);

        /**
         * <p>
         * The values of the <code>type</code> field. This field represents the AppSync data type equivalent of the
         * introspected field.
         * </p>
         * 
         * @param values
         *        The values of the <code>type</code> field. This field represents the AppSync data type equivalent of
         *        the introspected field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder values(String... values);
    }

    static final class BuilderImpl implements Builder {
        private String kind;

        private String name;

        private DataSourceIntrospectionModelFieldType type;

        private List<String> values = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceIntrospectionModelFieldType model) {
            kind(model.kind);
            name(model.name);
            type(model.type);
            values(model.values);
        }

        public final String getKind() {
            return kind;
        }

        public final void setKind(String kind) {
            this.kind = kind;
        }

        @Override
        public final Builder kind(String kind) {
            this.kind = kind;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Builder getType() {
            return type != null ? type.toBuilder() : null;
        }

        public final void setType(BuilderImpl type) {
            this.type = type != null ? type.build() : null;
        }

        @Override
        public final Builder type(DataSourceIntrospectionModelFieldType type) {
            this.type = type;
            return this;
        }

        public final Collection<String> getValues() {
            if (values instanceof SdkAutoConstructList) {
                return null;
            }
            return values;
        }

        public final void setValues(Collection<String> values) {
            this.values = DataSourceIntrospectionModelFieldTypeValuesCopier.copy(values);
        }

        @Override
        public final Builder values(Collection<String> values) {
            this.values = DataSourceIntrospectionModelFieldTypeValuesCopier.copy(values);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder values(String... values) {
            values(Arrays.asList(values));
            return this;
        }

        @Override
        public DataSourceIntrospectionModelFieldType build() {
            return new DataSourceIntrospectionModelFieldType(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
