/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync;

import java.util.function.Consumer;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsClient;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.regions.ServiceMetadata;
import software.amazon.awssdk.services.appsync.model.AccessDeniedException;
import software.amazon.awssdk.services.appsync.model.ApiKeyLimitExceededException;
import software.amazon.awssdk.services.appsync.model.ApiKeyValidityOutOfBoundsException;
import software.amazon.awssdk.services.appsync.model.ApiLimitExceededException;
import software.amazon.awssdk.services.appsync.model.AppSyncException;
import software.amazon.awssdk.services.appsync.model.AssociateApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateApiResponse;
import software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.BadRequestException;
import software.amazon.awssdk.services.appsync.model.ConcurrentModificationException;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.CreateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.CreateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.CreateDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.CreateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.CreateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.CreateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.CreateResolverRequest;
import software.amazon.awssdk.services.appsync.model.CreateResolverResponse;
import software.amazon.awssdk.services.appsync.model.CreateTypeRequest;
import software.amazon.awssdk.services.appsync.model.CreateTypeResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.DeleteApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.DeleteDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest;
import software.amazon.awssdk.services.appsync.model.DeleteFunctionResponse;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DeleteResolverRequest;
import software.amazon.awssdk.services.appsync.model.DeleteResolverResponse;
import software.amazon.awssdk.services.appsync.model.DeleteTypeRequest;
import software.amazon.awssdk.services.appsync.model.DeleteTypeResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateApiResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest;
import software.amazon.awssdk.services.appsync.model.EvaluateCodeResponse;
import software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest;
import software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateResponse;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.FlushApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.GetApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.GetApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.GetApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceIntrospectionRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceIntrospectionResponse;
import software.amazon.awssdk.services.appsync.model.GetDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.GetDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.GetDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.GetDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.GetFunctionRequest;
import software.amazon.awssdk.services.appsync.model.GetFunctionResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiEnvironmentVariablesRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiEnvironmentVariablesResponse;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.GetGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest;
import software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaResponse;
import software.amazon.awssdk.services.appsync.model.GetResolverRequest;
import software.amazon.awssdk.services.appsync.model.GetResolverResponse;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest;
import software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusResponse;
import software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.GetTypeRequest;
import software.amazon.awssdk.services.appsync.model.GetTypeResponse;
import software.amazon.awssdk.services.appsync.model.GraphQlSchemaException;
import software.amazon.awssdk.services.appsync.model.InternalFailureException;
import software.amazon.awssdk.services.appsync.model.LimitExceededException;
import software.amazon.awssdk.services.appsync.model.ListApiKeysRequest;
import software.amazon.awssdk.services.appsync.model.ListApiKeysResponse;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest;
import software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest;
import software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse;
import software.amazon.awssdk.services.appsync.model.ListFunctionsRequest;
import software.amazon.awssdk.services.appsync.model.ListFunctionsResponse;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest;
import software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.ListResolversRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversResponse;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest;
import software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceRequest;
import software.amazon.awssdk.services.appsync.model.ListTagsForResourceResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse;
import software.amazon.awssdk.services.appsync.model.ListTypesRequest;
import software.amazon.awssdk.services.appsync.model.ListTypesResponse;
import software.amazon.awssdk.services.appsync.model.NotFoundException;
import software.amazon.awssdk.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest;
import software.amazon.awssdk.services.appsync.model.PutGraphqlApiEnvironmentVariablesResponse;
import software.amazon.awssdk.services.appsync.model.StartDataSourceIntrospectionRequest;
import software.amazon.awssdk.services.appsync.model.StartDataSourceIntrospectionResponse;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaCreationResponse;
import software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest;
import software.amazon.awssdk.services.appsync.model.StartSchemaMergeResponse;
import software.amazon.awssdk.services.appsync.model.TagResourceRequest;
import software.amazon.awssdk.services.appsync.model.TagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UnauthorizedException;
import software.amazon.awssdk.services.appsync.model.UntagResourceRequest;
import software.amazon.awssdk.services.appsync.model.UntagResourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiCacheResponse;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest;
import software.amazon.awssdk.services.appsync.model.UpdateApiKeyResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDataSourceResponse;
import software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest;
import software.amazon.awssdk.services.appsync.model.UpdateDomainNameResponse;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionRequest;
import software.amazon.awssdk.services.appsync.model.UpdateFunctionResponse;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest;
import software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiResponse;
import software.amazon.awssdk.services.appsync.model.UpdateResolverRequest;
import software.amazon.awssdk.services.appsync.model.UpdateResolverResponse;
import software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest;
import software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationResponse;
import software.amazon.awssdk.services.appsync.model.UpdateTypeRequest;
import software.amazon.awssdk.services.appsync.model.UpdateTypeResponse;
import software.amazon.awssdk.services.appsync.paginators.ListApiKeysIterable;
import software.amazon.awssdk.services.appsync.paginators.ListDataSourcesIterable;
import software.amazon.awssdk.services.appsync.paginators.ListDomainNamesIterable;
import software.amazon.awssdk.services.appsync.paginators.ListFunctionsIterable;
import software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable;
import software.amazon.awssdk.services.appsync.paginators.ListResolversByFunctionIterable;
import software.amazon.awssdk.services.appsync.paginators.ListResolversIterable;
import software.amazon.awssdk.services.appsync.paginators.ListSourceApiAssociationsIterable;
import software.amazon.awssdk.services.appsync.paginators.ListTypesByAssociationIterable;
import software.amazon.awssdk.services.appsync.paginators.ListTypesIterable;

/**
 * Service client for accessing AWSAppSync. This can be created using the static {@link #builder()} method.
 *
 * <p>
 * AppSync provides API actions for creating and interacting with data sources using GraphQL from your application.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
@SdkPublicApi
@ThreadSafe
public interface AppSyncClient extends AwsClient {
    String SERVICE_NAME = "appsync";

    /**
     * Value for looking up the service's metadata from the
     * {@link software.amazon.awssdk.regions.ServiceMetadataProvider}.
     */
    String SERVICE_METADATA_ID = "appsync";

    /**
     * <p>
     * Maps an endpoint to your custom domain.
     * </p>
     *
     * @param associateApiRequest
     * @return Result of the AssociateApi operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateApi" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateApiResponse associateApi(AssociateApiRequest associateApiRequest) throws AccessDeniedException,
            BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Maps an endpoint to your custom domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateApiRequest.Builder} avoiding the need to
     * create one manually via {@link AssociateApiRequest#builder()}
     * </p>
     *
     * @param associateApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.AssociateApiRequest.Builder} to create a request.
     * @return Result of the AssociateApi operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateApi" target="_top">AWS API
     *      Documentation</a>
     */
    default AssociateApiResponse associateApi(Consumer<AssociateApiRequest.Builder> associateApiRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, AppSyncException {
        return associateApi(AssociateApiRequest.builder().applyMutation(associateApiRequest).build());
    }

    /**
     * <p>
     * Creates an association between a Merged API and source API using the source API's identifier.
     * </p>
     *
     * @param associateMergedGraphqlApiRequest
     * @return Result of the AssociateMergedGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateMergedGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateMergedGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMergedGraphqlApiResponse associateMergedGraphqlApi(
            AssociateMergedGraphqlApiRequest associateMergedGraphqlApiRequest) throws UnauthorizedException, BadRequestException,
            InternalFailureException, NotFoundException, LimitExceededException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a Merged API and source API using the source API's identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateMergedGraphqlApiRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateMergedGraphqlApiRequest#builder()}
     * </p>
     *
     * @param associateMergedGraphqlApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.AssociateMergedGraphqlApiRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateMergedGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateMergedGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateMergedGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateMergedGraphqlApiResponse associateMergedGraphqlApi(
            Consumer<AssociateMergedGraphqlApiRequest.Builder> associateMergedGraphqlApiRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, LimitExceededException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        return associateMergedGraphqlApi(AssociateMergedGraphqlApiRequest.builder()
                .applyMutation(associateMergedGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Creates an association between a Merged API and source API using the Merged API's identifier.
     * </p>
     *
     * @param associateSourceGraphqlApiRequest
     * @return Result of the AssociateSourceGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateSourceGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateSourceGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSourceGraphqlApiResponse associateSourceGraphqlApi(
            AssociateSourceGraphqlApiRequest associateSourceGraphqlApiRequest) throws UnauthorizedException, BadRequestException,
            InternalFailureException, NotFoundException, LimitExceededException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates an association between a Merged API and source API using the Merged API's identifier.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link AssociateSourceGraphqlApiRequest.Builder} avoiding
     * the need to create one manually via {@link AssociateSourceGraphqlApiRequest#builder()}
     * </p>
     *
     * @param associateSourceGraphqlApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.AssociateSourceGraphqlApiRequest.Builder} to create a
     *        request.
     * @return Result of the AssociateSourceGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.AssociateSourceGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/AssociateSourceGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    default AssociateSourceGraphqlApiResponse associateSourceGraphqlApi(
            Consumer<AssociateSourceGraphqlApiRequest.Builder> associateSourceGraphqlApiRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, LimitExceededException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        return associateSourceGraphqlApi(AssociateSourceGraphqlApiRequest.builder()
                .applyMutation(associateSourceGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Creates a cache for the GraphQL API.
     * </p>
     *
     * @param createApiCacheRequest
     *        Represents the input of a <code>CreateApiCache</code> operation.
     * @return Result of the CreateApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateApiCacheResponse createApiCache(CreateApiCacheRequest createApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a cache for the GraphQL API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiCacheRequest#builder()}
     * </p>
     *
     * @param createApiCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.CreateApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>CreateApiCache</code> operation.
     * @return Result of the CreateApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateApiCacheResponse createApiCache(Consumer<CreateApiCacheRequest.Builder> createApiCacheRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return createApiCache(CreateApiCacheRequest.builder().applyMutation(createApiCacheRequest).build());
    }

    /**
     * <p>
     * Creates a unique key that you can distribute to clients who invoke your API.
     * </p>
     *
     * @param createApiKeyRequest
     * @return Result of the CreateApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiKeyLimitExceededException
     *         The API key exceeded a limit. Try your request again.
     * @throws ApiKeyValidityOutOfBoundsException
     *         The API key expiration must be set to a value between 1 and 365 days from creation (for
     *         <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateApiKeyResponse createApiKey(CreateApiKeyRequest createApiKeyRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException,
            ApiKeyLimitExceededException, ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a unique key that you can distribute to clients who invoke your API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link CreateApiKeyRequest#builder()}
     * </p>
     *
     * @param createApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.CreateApiKeyRequest.Builder} to create a request.
     * @return Result of the CreateApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiKeyLimitExceededException
     *         The API key exceeded a limit. Try your request again.
     * @throws ApiKeyValidityOutOfBoundsException
     *         The API key expiration must be set to a value between 1 and 365 days from creation (for
     *         <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateApiKeyResponse createApiKey(Consumer<CreateApiKeyRequest.Builder> createApiKeyRequest)
            throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException,
            InternalFailureException, ApiKeyLimitExceededException, ApiKeyValidityOutOfBoundsException, AwsServiceException,
            SdkClientException, AppSyncException {
        return createApiKey(CreateApiKeyRequest.builder().applyMutation(createApiKeyRequest).build());
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object.
     * </p>
     *
     * @param createDataSourceRequest
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(CreateDataSourceRequest createDataSourceRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>DataSource</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDataSourceRequest#builder()}
     * </p>
     *
     * @param createDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.CreateDataSourceRequest.Builder} to create a request.
     * @return Result of the CreateDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDataSourceResponse createDataSource(Consumer<CreateDataSourceRequest.Builder> createDataSourceRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return createDataSource(CreateDataSourceRequest.builder().applyMutation(createDataSourceRequest).build());
    }

    /**
     * <p>
     * Creates a custom <code>DomainName</code> object.
     * </p>
     *
     * @param createDomainNameRequest
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainNameResponse createDomainName(CreateDomainNameRequest createDomainNameRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a custom <code>DomainName</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link CreateDomainNameRequest#builder()}
     * </p>
     *
     * @param createDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.CreateDomainNameRequest.Builder} to create a request.
     * @return Result of the CreateDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateDomainNameResponse createDomainName(Consumer<CreateDomainNameRequest.Builder> createDomainNameRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return createDomainName(CreateDomainNameRequest.builder().applyMutation(createDomainNameRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Function</code> object.
     * </p>
     * <p>
     * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
     * </p>
     *
     * @param createFunctionRequest
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFunctionResponse createFunction(CreateFunctionRequest createFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Function</code> object.
     * </p>
     * <p>
     * A function is a reusable entity. You can use multiple functions to compose the resolver logic.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link CreateFunctionRequest#builder()}
     * </p>
     *
     * @param createFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.CreateFunctionRequest.Builder} to create a request.
     * @return Result of the CreateFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateFunctionResponse createFunction(Consumer<CreateFunctionRequest.Builder> createFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        return createFunction(CreateFunctionRequest.builder().applyMutation(createFunctionRequest).build());
    }

    /**
     * <p>
     * Creates a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param createGraphqlApiRequest
     * @return Result of the CreateGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiLimitExceededException
     *         The GraphQL API exceeded a limit. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGraphqlApiResponse createGraphqlApi(CreateGraphqlApiRequest createGraphqlApiRequest)
            throws BadRequestException, LimitExceededException, ConcurrentModificationException, UnauthorizedException,
            InternalFailureException, ApiLimitExceededException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>GraphqlApi</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateGraphqlApiRequest.Builder} avoiding the need
     * to create one manually via {@link CreateGraphqlApiRequest#builder()}
     * </p>
     *
     * @param createGraphqlApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.CreateGraphqlApiRequest.Builder} to create a request.
     * @return Result of the CreateGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiLimitExceededException
     *         The GraphQL API exceeded a limit. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateGraphqlApiResponse createGraphqlApi(Consumer<CreateGraphqlApiRequest.Builder> createGraphqlApiRequest)
            throws BadRequestException, LimitExceededException, ConcurrentModificationException, UnauthorizedException,
            InternalFailureException, ApiLimitExceededException, AwsServiceException, SdkClientException, AppSyncException {
        return createGraphqlApi(CreateGraphqlApiRequest.builder().applyMutation(createGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Resolver</code> object.
     * </p>
     * <p>
     * A resolver converts incoming requests into a format that a data source can understand, and converts the data
     * source's responses into GraphQL.
     * </p>
     *
     * @param createResolverRequest
     * @return Result of the CreateResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateResolverResponse createResolver(CreateResolverRequest createResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Resolver</code> object.
     * </p>
     * <p>
     * A resolver converts incoming requests into a format that a data source can understand, and converts the data
     * source's responses into GraphQL.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateResolverRequest.Builder} avoiding the need to
     * create one manually via {@link CreateResolverRequest#builder()}
     * </p>
     *
     * @param createResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.CreateResolverRequest.Builder} to create a request.
     * @return Result of the CreateResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateResolverResponse createResolver(Consumer<CreateResolverRequest.Builder> createResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        return createResolver(CreateResolverRequest.builder().applyMutation(createResolverRequest).build());
    }

    /**
     * <p>
     * Creates a <code>Type</code> object.
     * </p>
     *
     * @param createTypeRequest
     * @return Result of the CreateType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateType" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTypeResponse createType(CreateTypeRequest createTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a <code>Type</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link CreateTypeRequest.Builder} avoiding the need to
     * create one manually via {@link CreateTypeRequest#builder()}
     * </p>
     *
     * @param createTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.CreateTypeRequest.Builder} to create a request.
     * @return Result of the CreateType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.CreateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/CreateType" target="_top">AWS API
     *      Documentation</a>
     */
    default CreateTypeResponse createType(Consumer<CreateTypeRequest.Builder> createTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return createType(CreateTypeRequest.builder().applyMutation(createTypeRequest).build());
    }

    /**
     * <p>
     * Deletes an <code>ApiCache</code> object.
     * </p>
     *
     * @param deleteApiCacheRequest
     *        Represents the input of a <code>DeleteApiCache</code> operation.
     * @return Result of the DeleteApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteApiCacheResponse deleteApiCache(DeleteApiCacheRequest deleteApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an <code>ApiCache</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteApiCacheRequest#builder()}
     * </p>
     *
     * @param deleteApiCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DeleteApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>DeleteApiCache</code> operation.
     * @return Result of the DeleteApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteApiCacheResponse deleteApiCache(Consumer<DeleteApiCacheRequest.Builder> deleteApiCacheRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return deleteApiCache(DeleteApiCacheRequest.builder().applyMutation(deleteApiCacheRequest).build());
    }

    /**
     * <p>
     * Deletes an API key.
     * </p>
     *
     * @param deleteApiKeyRequest
     * @return Result of the DeleteApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteApiKeyResponse deleteApiKey(DeleteApiKeyRequest deleteApiKeyRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an API key.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteApiKeyRequest#builder()}
     * </p>
     *
     * @param deleteApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DeleteApiKeyRequest.Builder} to create a request.
     * @return Result of the DeleteApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteApiKeyResponse deleteApiKey(Consumer<DeleteApiKeyRequest.Builder> deleteApiKeyRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return deleteApiKey(DeleteApiKeyRequest.builder().applyMutation(deleteApiKeyRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>DataSource</code> object.
     * </p>
     *
     * @param deleteDataSourceRequest
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(DeleteDataSourceRequest deleteDataSourceRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>DataSource</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDataSourceRequest#builder()}
     * </p>
     *
     * @param deleteDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DeleteDataSourceRequest.Builder} to create a request.
     * @return Result of the DeleteDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDataSourceResponse deleteDataSource(Consumer<DeleteDataSourceRequest.Builder> deleteDataSourceRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return deleteDataSource(DeleteDataSourceRequest.builder().applyMutation(deleteDataSourceRequest).build());
    }

    /**
     * <p>
     * Deletes a custom <code>DomainName</code> object.
     * </p>
     *
     * @param deleteDomainNameRequest
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainNameResponse deleteDomainName(DeleteDomainNameRequest deleteDomainNameRequest)
            throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException,
            NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a custom <code>DomainName</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteDomainNameRequest#builder()}
     * </p>
     *
     * @param deleteDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DeleteDomainNameRequest.Builder} to create a request.
     * @return Result of the DeleteDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteDomainNameResponse deleteDomainName(Consumer<DeleteDomainNameRequest.Builder> deleteDomainNameRequest)
            throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException,
            NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        return deleteDomainName(DeleteDomainNameRequest.builder().applyMutation(deleteDomainNameRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Function</code>.
     * </p>
     *
     * @param deleteFunctionRequest
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFunctionResponse deleteFunction(DeleteFunctionRequest deleteFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Function</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteFunctionRequest#builder()}
     * </p>
     *
     * @param deleteFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DeleteFunctionRequest.Builder} to create a request.
     * @return Result of the DeleteFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteFunctionResponse deleteFunction(Consumer<DeleteFunctionRequest.Builder> deleteFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        return deleteFunction(DeleteFunctionRequest.builder().applyMutation(deleteFunctionRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param deleteGraphqlApiRequest
     * @return Result of the DeleteGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGraphqlApiResponse deleteGraphqlApi(DeleteGraphqlApiRequest deleteGraphqlApiRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>GraphqlApi</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteGraphqlApiRequest.Builder} avoiding the need
     * to create one manually via {@link DeleteGraphqlApiRequest#builder()}
     * </p>
     *
     * @param deleteGraphqlApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DeleteGraphqlApiRequest.Builder} to create a request.
     * @return Result of the DeleteGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteGraphqlApiResponse deleteGraphqlApi(Consumer<DeleteGraphqlApiRequest.Builder> deleteGraphqlApiRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        return deleteGraphqlApi(DeleteGraphqlApiRequest.builder().applyMutation(deleteGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Resolver</code> object.
     * </p>
     *
     * @param deleteResolverRequest
     * @return Result of the DeleteResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResolverResponse deleteResolver(DeleteResolverRequest deleteResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Resolver</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteResolverRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteResolverRequest#builder()}
     * </p>
     *
     * @param deleteResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DeleteResolverRequest.Builder} to create a request.
     * @return Result of the DeleteResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteResolverResponse deleteResolver(Consumer<DeleteResolverRequest.Builder> deleteResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        return deleteResolver(DeleteResolverRequest.builder().applyMutation(deleteResolverRequest).build());
    }

    /**
     * <p>
     * Deletes a <code>Type</code> object.
     * </p>
     *
     * @param deleteTypeRequest
     * @return Result of the DeleteType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTypeResponse deleteType(DeleteTypeRequest deleteTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes a <code>Type</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DeleteTypeRequest.Builder} avoiding the need to
     * create one manually via {@link DeleteTypeRequest#builder()}
     * </p>
     *
     * @param deleteTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DeleteTypeRequest.Builder} to create a request.
     * @return Result of the DeleteType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DeleteType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DeleteType" target="_top">AWS API
     *      Documentation</a>
     */
    default DeleteTypeResponse deleteType(Consumer<DeleteTypeRequest.Builder> deleteTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return deleteType(DeleteTypeRequest.builder().applyMutation(deleteTypeRequest).build());
    }

    /**
     * <p>
     * Removes an <code>ApiAssociation</code> object from a custom domain.
     * </p>
     *
     * @param disassociateApiRequest
     * @return Result of the DisassociateApi operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateApi" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateApiResponse disassociateApi(DisassociateApiRequest disassociateApiRequest) throws AccessDeniedException,
            BadRequestException, ConcurrentModificationException, InternalFailureException, NotFoundException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Removes an <code>ApiAssociation</code> object from a custom domain.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateApiRequest.Builder} avoiding the need
     * to create one manually via {@link DisassociateApiRequest#builder()}
     * </p>
     *
     * @param disassociateApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DisassociateApiRequest.Builder} to create a request.
     * @return Result of the DisassociateApi operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateApi" target="_top">AWS API
     *      Documentation</a>
     */
    default DisassociateApiResponse disassociateApi(Consumer<DisassociateApiRequest.Builder> disassociateApiRequest)
            throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException,
            NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        return disassociateApi(DisassociateApiRequest.builder().applyMutation(disassociateApiRequest).build());
    }

    /**
     * <p>
     * Deletes an association between a Merged API and source API using the source API's identifier and the association
     * ID.
     * </p>
     *
     * @param disassociateMergedGraphqlApiRequest
     * @return Result of the DisassociateMergedGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateMergedGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateMergedGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMergedGraphqlApiResponse disassociateMergedGraphqlApi(
            DisassociateMergedGraphqlApiRequest disassociateMergedGraphqlApiRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an association between a Merged API and source API using the source API's identifier and the association
     * ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateMergedGraphqlApiRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateMergedGraphqlApiRequest#builder()}
     * </p>
     *
     * @param disassociateMergedGraphqlApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DisassociateMergedGraphqlApiRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateMergedGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateMergedGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateMergedGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateMergedGraphqlApiResponse disassociateMergedGraphqlApi(
            Consumer<DisassociateMergedGraphqlApiRequest.Builder> disassociateMergedGraphqlApiRequest)
            throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        return disassociateMergedGraphqlApi(DisassociateMergedGraphqlApiRequest.builder()
                .applyMutation(disassociateMergedGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Deletes an association between a Merged API and source API using the Merged API's identifier and the association
     * ID.
     * </p>
     *
     * @param disassociateSourceGraphqlApiRequest
     * @return Result of the DisassociateSourceGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateSourceGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateSourceGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSourceGraphqlApiResponse disassociateSourceGraphqlApi(
            DisassociateSourceGraphqlApiRequest disassociateSourceGraphqlApiRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Deletes an association between a Merged API and source API using the Merged API's identifier and the association
     * ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link DisassociateSourceGraphqlApiRequest.Builder}
     * avoiding the need to create one manually via {@link DisassociateSourceGraphqlApiRequest#builder()}
     * </p>
     *
     * @param disassociateSourceGraphqlApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.DisassociateSourceGraphqlApiRequest.Builder} to
     *        create a request.
     * @return Result of the DisassociateSourceGraphqlApi operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.DisassociateSourceGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/DisassociateSourceGraphqlApi"
     *      target="_top">AWS API Documentation</a>
     */
    default DisassociateSourceGraphqlApiResponse disassociateSourceGraphqlApi(
            Consumer<DisassociateSourceGraphqlApiRequest.Builder> disassociateSourceGraphqlApiRequest)
            throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        return disassociateSourceGraphqlApi(DisassociateSourceGraphqlApiRequest.builder()
                .applyMutation(disassociateSourceGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Evaluates the given code and returns the response. The code definition requirements depend on the specified
     * runtime. For <code>APPSYNC_JS</code> runtimes, the code defines the request and response functions. The request
     * function takes the incoming request after a GraphQL operation is parsed and converts it into a request
     * configuration for the selected data source operation. The response function interprets responses from the data
     * source and maps it to the shape of the GraphQL field output type.
     * </p>
     *
     * @param evaluateCodeRequest
     * @return Result of the EvaluateCode operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.EvaluateCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/EvaluateCode" target="_top">AWS API
     *      Documentation</a>
     */
    default EvaluateCodeResponse evaluateCode(EvaluateCodeRequest evaluateCodeRequest) throws AccessDeniedException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates the given code and returns the response. The code definition requirements depend on the specified
     * runtime. For <code>APPSYNC_JS</code> runtimes, the code defines the request and response functions. The request
     * function takes the incoming request after a GraphQL operation is parsed and converts it into a request
     * configuration for the selected data source operation. The response function interprets responses from the data
     * source and maps it to the shape of the GraphQL field output type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluateCodeRequest.Builder} avoiding the need to
     * create one manually via {@link EvaluateCodeRequest#builder()}
     * </p>
     *
     * @param evaluateCodeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.EvaluateCodeRequest.Builder} to create a request.
     * @return Result of the EvaluateCode operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.EvaluateCode
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/EvaluateCode" target="_top">AWS API
     *      Documentation</a>
     */
    default EvaluateCodeResponse evaluateCode(Consumer<EvaluateCodeRequest.Builder> evaluateCodeRequest)
            throws AccessDeniedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            AppSyncException {
        return evaluateCode(EvaluateCodeRequest.builder().applyMutation(evaluateCodeRequest).build());
    }

    /**
     * <p>
     * Evaluates a given template and returns the response. The mapping template can be a request or response template.
     * </p>
     * <p>
     * Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request
     * configuration for the selected data source operation. Response templates interpret responses from the data source
     * and map it to the shape of the GraphQL field output type.
     * </p>
     * <p>
     * Mapping templates are written in the Apache Velocity Template Language (VTL).
     * </p>
     *
     * @param evaluateMappingTemplateRequest
     * @return Result of the EvaluateMappingTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.EvaluateMappingTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/EvaluateMappingTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default EvaluateMappingTemplateResponse evaluateMappingTemplate(EvaluateMappingTemplateRequest evaluateMappingTemplateRequest)
            throws AccessDeniedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Evaluates a given template and returns the response. The mapping template can be a request or response template.
     * </p>
     * <p>
     * Request templates take the incoming request after a GraphQL operation is parsed and convert it into a request
     * configuration for the selected data source operation. Response templates interpret responses from the data source
     * and map it to the shape of the GraphQL field output type.
     * </p>
     * <p>
     * Mapping templates are written in the Apache Velocity Template Language (VTL).
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link EvaluateMappingTemplateRequest.Builder} avoiding
     * the need to create one manually via {@link EvaluateMappingTemplateRequest#builder()}
     * </p>
     *
     * @param evaluateMappingTemplateRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.EvaluateMappingTemplateRequest.Builder} to create a
     *        request.
     * @return Result of the EvaluateMappingTemplate operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.EvaluateMappingTemplate
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/EvaluateMappingTemplate"
     *      target="_top">AWS API Documentation</a>
     */
    default EvaluateMappingTemplateResponse evaluateMappingTemplate(
            Consumer<EvaluateMappingTemplateRequest.Builder> evaluateMappingTemplateRequest) throws AccessDeniedException,
            InternalFailureException, BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        return evaluateMappingTemplate(EvaluateMappingTemplateRequest.builder().applyMutation(evaluateMappingTemplateRequest)
                .build());
    }

    /**
     * <p>
     * Flushes an <code>ApiCache</code> object.
     * </p>
     *
     * @param flushApiCacheRequest
     *        Represents the input of a <code>FlushApiCache</code> operation.
     * @return Result of the FlushApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.FlushApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/FlushApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default FlushApiCacheResponse flushApiCache(FlushApiCacheRequest flushApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Flushes an <code>ApiCache</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link FlushApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link FlushApiCacheRequest#builder()}
     * </p>
     *
     * @param flushApiCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.FlushApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>FlushApiCache</code> operation.
     * @return Result of the FlushApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.FlushApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/FlushApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default FlushApiCacheResponse flushApiCache(Consumer<FlushApiCacheRequest.Builder> flushApiCacheRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return flushApiCache(FlushApiCacheRequest.builder().applyMutation(flushApiCacheRequest).build());
    }

    /**
     * <p>
     * Retrieves an <code>ApiAssociation</code> object.
     * </p>
     *
     * @param getApiAssociationRequest
     * @return Result of the GetApiAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApiAssociationResponse getApiAssociation(GetApiAssociationRequest getApiAssociationRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an <code>ApiAssociation</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiAssociationRequest.Builder} avoiding the need
     * to create one manually via {@link GetApiAssociationRequest#builder()}
     * </p>
     *
     * @param getApiAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetApiAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the GetApiAssociation operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiAssociation" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApiAssociationResponse getApiAssociation(Consumer<GetApiAssociationRequest.Builder> getApiAssociationRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, AppSyncException {
        return getApiAssociation(GetApiAssociationRequest.builder().applyMutation(getApiAssociationRequest).build());
    }

    /**
     * <p>
     * Retrieves an <code>ApiCache</code> object.
     * </p>
     *
     * @param getApiCacheRequest
     *        Represents the input of a <code>GetApiCache</code> operation.
     * @return Result of the GetApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApiCacheResponse getApiCache(GetApiCacheRequest getApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves an <code>ApiCache</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link GetApiCacheRequest#builder()}
     * </p>
     *
     * @param getApiCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>GetApiCache</code> operation.
     * @return Result of the GetApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default GetApiCacheResponse getApiCache(Consumer<GetApiCacheRequest.Builder> getApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return getApiCache(GetApiCacheRequest.builder().applyMutation(getApiCacheRequest).build());
    }

    /**
     * <p>
     * Retrieves a <code>DataSource</code> object.
     * </p>
     *
     * @param getDataSourceRequest
     * @return Result of the GetDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSourceResponse getDataSource(GetDataSourceRequest getDataSourceRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>DataSource</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceRequest.Builder} avoiding the need to
     * create one manually via {@link GetDataSourceRequest#builder()}
     * </p>
     *
     * @param getDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetDataSourceRequest.Builder} to create a request.
     * @return Result of the GetDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDataSourceResponse getDataSource(Consumer<GetDataSourceRequest.Builder> getDataSourceRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return getDataSource(GetDataSourceRequest.builder().applyMutation(getDataSourceRequest).build());
    }

    /**
     * <p>
     * Retrieves the record of an existing introspection. If the retrieval is successful, the result of the
     * instrospection will also be returned. If the retrieval fails the operation, an error message will be returned
     * instead.
     * </p>
     *
     * @param getDataSourceIntrospectionRequest
     * @return Result of the GetDataSourceIntrospection operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDataSourceIntrospection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSourceIntrospection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataSourceIntrospectionResponse getDataSourceIntrospection(
            GetDataSourceIntrospectionRequest getDataSourceIntrospectionRequest) throws BadRequestException, NotFoundException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the record of an existing introspection. If the retrieval is successful, the result of the
     * instrospection will also be returned. If the retrieval fails the operation, an error message will be returned
     * instead.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDataSourceIntrospectionRequest.Builder} avoiding
     * the need to create one manually via {@link GetDataSourceIntrospectionRequest#builder()}
     * </p>
     *
     * @param getDataSourceIntrospectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetDataSourceIntrospectionRequest.Builder} to create
     *        a request.
     * @return Result of the GetDataSourceIntrospection operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDataSourceIntrospection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDataSourceIntrospection"
     *      target="_top">AWS API Documentation</a>
     */
    default GetDataSourceIntrospectionResponse getDataSourceIntrospection(
            Consumer<GetDataSourceIntrospectionRequest.Builder> getDataSourceIntrospectionRequest) throws BadRequestException,
            NotFoundException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return getDataSourceIntrospection(GetDataSourceIntrospectionRequest.builder()
                .applyMutation(getDataSourceIntrospectionRequest).build());
    }

    /**
     * <p>
     * Retrieves a custom <code>DomainName</code> object.
     * </p>
     *
     * @param getDomainNameRequest
     * @return Result of the GetDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainNameResponse getDomainName(GetDomainNameRequest getDomainNameRequest) throws AccessDeniedException,
            BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a custom <code>DomainName</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetDomainNameRequest.Builder} avoiding the need to
     * create one manually via {@link GetDomainNameRequest#builder()}
     * </p>
     *
     * @param getDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetDomainNameRequest.Builder} to create a request.
     * @return Result of the GetDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    default GetDomainNameResponse getDomainName(Consumer<GetDomainNameRequest.Builder> getDomainNameRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, AppSyncException {
        return getDomainName(GetDomainNameRequest.builder().applyMutation(getDomainNameRequest).build());
    }

    /**
     * <p>
     * Get a <code>Function</code>.
     * </p>
     *
     * @param getFunctionRequest
     * @return Result of the GetFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFunctionResponse getFunction(GetFunctionRequest getFunctionRequest) throws ConcurrentModificationException,
            NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Get a <code>Function</code>.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link GetFunctionRequest#builder()}
     * </p>
     *
     * @param getFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetFunctionRequest.Builder} to create a request.
     * @return Result of the GetFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default GetFunctionResponse getFunction(Consumer<GetFunctionRequest.Builder> getFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, AwsServiceException,
            SdkClientException, AppSyncException {
        return getFunction(GetFunctionRequest.builder().applyMutation(getFunctionRequest).build());
    }

    /**
     * <p>
     * Retrieves a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param getGraphqlApiRequest
     * @return Result of the GetGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGraphqlApiResponse getGraphqlApi(GetGraphqlApiRequest getGraphqlApiRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>GraphqlApi</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGraphqlApiRequest.Builder} avoiding the need to
     * create one manually via {@link GetGraphqlApiRequest#builder()}
     * </p>
     *
     * @param getGraphqlApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetGraphqlApiRequest.Builder} to create a request.
     * @return Result of the GetGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default GetGraphqlApiResponse getGraphqlApi(Consumer<GetGraphqlApiRequest.Builder> getGraphqlApiRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        return getGraphqlApi(GetGraphqlApiRequest.builder().applyMutation(getGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Retrieves the list of environmental variable key-value pairs associated with an API by its ID value.
     * </p>
     *
     * @param getGraphqlApiEnvironmentVariablesRequest
     * @return Result of the GetGraphqlApiEnvironmentVariables operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetGraphqlApiEnvironmentVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApiEnvironmentVariables"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGraphqlApiEnvironmentVariablesResponse getGraphqlApiEnvironmentVariables(
            GetGraphqlApiEnvironmentVariablesRequest getGraphqlApiEnvironmentVariablesRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the list of environmental variable key-value pairs associated with an API by its ID value.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetGraphqlApiEnvironmentVariablesRequest.Builder}
     * avoiding the need to create one manually via {@link GetGraphqlApiEnvironmentVariablesRequest#builder()}
     * </p>
     *
     * @param getGraphqlApiEnvironmentVariablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetGraphqlApiEnvironmentVariablesRequest.Builder} to
     *        create a request.
     * @return Result of the GetGraphqlApiEnvironmentVariables operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetGraphqlApiEnvironmentVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetGraphqlApiEnvironmentVariables"
     *      target="_top">AWS API Documentation</a>
     */
    default GetGraphqlApiEnvironmentVariablesResponse getGraphqlApiEnvironmentVariables(
            Consumer<GetGraphqlApiEnvironmentVariablesRequest.Builder> getGraphqlApiEnvironmentVariablesRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        return getGraphqlApiEnvironmentVariables(GetGraphqlApiEnvironmentVariablesRequest.builder()
                .applyMutation(getGraphqlApiEnvironmentVariablesRequest).build());
    }

    /**
     * <p>
     * Retrieves the introspection schema for a GraphQL API.
     * </p>
     *
     * @param getIntrospectionSchemaRequest
     * @return Result of the GetIntrospectionSchema operation returned by the service.
     * @throws GraphQlSchemaException
     *         The GraphQL schema is not valid.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetIntrospectionSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIntrospectionSchemaResponse getIntrospectionSchema(GetIntrospectionSchemaRequest getIntrospectionSchemaRequest)
            throws GraphQlSchemaException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the introspection schema for a GraphQL API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetIntrospectionSchemaRequest.Builder} avoiding the
     * need to create one manually via {@link GetIntrospectionSchemaRequest#builder()}
     * </p>
     *
     * @param getIntrospectionSchemaRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetIntrospectionSchemaRequest.Builder} to create a
     *        request.
     * @return Result of the GetIntrospectionSchema operation returned by the service.
     * @throws GraphQlSchemaException
     *         The GraphQL schema is not valid.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetIntrospectionSchema
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetIntrospectionSchema"
     *      target="_top">AWS API Documentation</a>
     */
    default GetIntrospectionSchemaResponse getIntrospectionSchema(
            Consumer<GetIntrospectionSchemaRequest.Builder> getIntrospectionSchemaRequest) throws GraphQlSchemaException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return getIntrospectionSchema(GetIntrospectionSchemaRequest.builder().applyMutation(getIntrospectionSchemaRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a <code>Resolver</code> object.
     * </p>
     *
     * @param getResolverRequest
     * @return Result of the GetResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResolverResponse getResolver(GetResolverRequest getResolverRequest) throws ConcurrentModificationException,
            NotFoundException, UnauthorizedException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>Resolver</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetResolverRequest.Builder} avoiding the need to
     * create one manually via {@link GetResolverRequest#builder()}
     * </p>
     *
     * @param getResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetResolverRequest.Builder} to create a request.
     * @return Result of the GetResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default GetResolverResponse getResolver(Consumer<GetResolverRequest.Builder> getResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, AwsServiceException,
            SdkClientException, AppSyncException {
        return getResolver(GetResolverRequest.builder().applyMutation(getResolverRequest).build());
    }

    /**
     * <p>
     * Retrieves the current status of a schema creation operation.
     * </p>
     *
     * @param getSchemaCreationStatusRequest
     * @return Result of the GetSchemaCreationStatus operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetSchemaCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSchemaCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSchemaCreationStatusResponse getSchemaCreationStatus(GetSchemaCreationStatusRequest getSchemaCreationStatusRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves the current status of a schema creation operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSchemaCreationStatusRequest.Builder} avoiding
     * the need to create one manually via {@link GetSchemaCreationStatusRequest#builder()}
     * </p>
     *
     * @param getSchemaCreationStatusRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetSchemaCreationStatusRequest.Builder} to create a
     *        request.
     * @return Result of the GetSchemaCreationStatus operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetSchemaCreationStatus
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSchemaCreationStatus"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSchemaCreationStatusResponse getSchemaCreationStatus(
            Consumer<GetSchemaCreationStatusRequest.Builder> getSchemaCreationStatusRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return getSchemaCreationStatus(GetSchemaCreationStatusRequest.builder().applyMutation(getSchemaCreationStatusRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a <code>SourceApiAssociation</code> object.
     * </p>
     *
     * @param getSourceApiAssociationRequest
     * @return Result of the GetSourceApiAssociation operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetSourceApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSourceApiAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSourceApiAssociationResponse getSourceApiAssociation(GetSourceApiAssociationRequest getSourceApiAssociationRequest)
            throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException, AwsServiceException,
            SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>SourceApiAssociation</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetSourceApiAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link GetSourceApiAssociationRequest#builder()}
     * </p>
     *
     * @param getSourceApiAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetSourceApiAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the GetSourceApiAssociation operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetSourceApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetSourceApiAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default GetSourceApiAssociationResponse getSourceApiAssociation(
            Consumer<GetSourceApiAssociationRequest.Builder> getSourceApiAssociationRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            AppSyncException {
        return getSourceApiAssociation(GetSourceApiAssociationRequest.builder().applyMutation(getSourceApiAssociationRequest)
                .build());
    }

    /**
     * <p>
     * Retrieves a <code>Type</code> object.
     * </p>
     *
     * @param getTypeRequest
     * @return Result of the GetType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetType" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTypeResponse getType(GetTypeRequest getTypeRequest) throws BadRequestException, ConcurrentModificationException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Retrieves a <code>Type</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link GetTypeRequest.Builder} avoiding the need to create
     * one manually via {@link GetTypeRequest#builder()}
     * </p>
     *
     * @param getTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.GetTypeRequest.Builder} to create a request.
     * @return Result of the GetType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.GetType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/GetType" target="_top">AWS API
     *      Documentation</a>
     */
    default GetTypeResponse getType(Consumer<GetTypeRequest.Builder> getTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return getType(GetTypeRequest.builder().applyMutation(getTypeRequest).build());
    }

    /**
     * <p>
     * Lists the API keys for a given API.
     * </p>
     * <note>
     * <p>
     * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response
     * until they have actually been deleted. You can safely call <code>DeleteApiKey</code> to manually delete a key
     * before it's automatically deleted.
     * </p>
     * </note>
     *
     * @param listApiKeysRequest
     * @return Result of the ListApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListApiKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApiKeysResponse listApiKeys(ListApiKeysRequest listApiKeysRequest) throws BadRequestException, NotFoundException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the API keys for a given API.
     * </p>
     * <note>
     * <p>
     * API keys are deleted automatically 60 days after they expire. However, they may still be included in the response
     * until they have actually been deleted. You can safely call <code>DeleteApiKey</code> to manually delete a key
     * before it's automatically deleted.
     * </p>
     * </note><br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListApiKeysRequest#builder()}
     * </p>
     *
     * @param listApiKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListApiKeysRequest.Builder} to create a request.
     * @return Result of the ListApiKeys operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListApiKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApiKeysResponse listApiKeys(Consumer<ListApiKeysRequest.Builder> listApiKeysRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listApiKeys(ListApiKeysRequest.builder().applyMutation(listApiKeysRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listApiKeys(software.amazon.awssdk.services.appsync.model.ListApiKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListApiKeysIterable responses = client.listApiKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListApiKeysIterable responses = client.listApiKeysPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListApiKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListApiKeysIterable responses = client.listApiKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApiKeys(software.amazon.awssdk.services.appsync.model.ListApiKeysRequest)} operation.</b>
     * </p>
     *
     * @param listApiKeysRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListApiKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApiKeysIterable listApiKeysPaginator(ListApiKeysRequest listApiKeysRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return new ListApiKeysIterable(this, listApiKeysRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listApiKeys(software.amazon.awssdk.services.appsync.model.ListApiKeysRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListApiKeysIterable responses = client.listApiKeysPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListApiKeysIterable responses = client.listApiKeysPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListApiKeysResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListApiKeysIterable responses = client.listApiKeysPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listApiKeys(software.amazon.awssdk.services.appsync.model.ListApiKeysRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListApiKeysRequest.Builder} avoiding the need to
     * create one manually via {@link ListApiKeysRequest#builder()}
     * </p>
     *
     * @param listApiKeysRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListApiKeysRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListApiKeys
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListApiKeys" target="_top">AWS API
     *      Documentation</a>
     */
    default ListApiKeysIterable listApiKeysPaginator(Consumer<ListApiKeysRequest.Builder> listApiKeysRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return listApiKeysPaginator(ListApiKeysRequest.builder().applyMutation(listApiKeysRequest).build());
    }

    /**
     * <p>
     * Lists the data sources for a given API.
     * </p>
     *
     * @param listDataSourcesRequest
     * @return Result of the ListDataSources operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(ListDataSourcesRequest listDataSourcesRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the data sources for a given API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest.Builder} to create a request.
     * @return Result of the ListDataSources operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesResponse listDataSources(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return listDataSources(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     *
     * @param listDataSourcesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(ListDataSourcesRequest listDataSourcesRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return new ListDataSourcesIterable(this, listDataSourcesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDataSources(software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListDataSourcesIterable responses = client
     *             .listDataSourcesPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListDataSourcesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListDataSourcesIterable responses = client.listDataSourcesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDataSources(software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDataSourcesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDataSourcesRequest#builder()}
     * </p>
     *
     * @param listDataSourcesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListDataSourcesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDataSources
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDataSources" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDataSourcesIterable listDataSourcesPaginator(Consumer<ListDataSourcesRequest.Builder> listDataSourcesRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return listDataSourcesPaginator(ListDataSourcesRequest.builder().applyMutation(listDataSourcesRequest).build());
    }

    /**
     * <p>
     * Lists multiple custom domain names.
     * </p>
     *
     * @param listDomainNamesRequest
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDomainNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDomainNames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainNamesResponse listDomainNames(ListDomainNamesRequest listDomainNamesRequest) throws AccessDeniedException,
            BadRequestException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists multiple custom domain names.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainNamesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainNamesRequest#builder()}
     * </p>
     *
     * @param listDomainNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest.Builder} to create a request.
     * @return Result of the ListDomainNames operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDomainNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDomainNames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainNamesResponse listDomainNames(Consumer<ListDomainNamesRequest.Builder> listDomainNamesRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listDomainNames(ListDomainNamesRequest.builder().applyMutation(listDomainNamesRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainNames(software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListDomainNamesIterable responses = client.listDomainNamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListDomainNamesIterable responses = client
     *             .listDomainNamesPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListDomainNamesIterable responses = client.listDomainNamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainNames(software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest)} operation.</b>
     * </p>
     *
     * @param listDomainNamesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDomainNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDomainNames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainNamesIterable listDomainNamesPaginator(ListDomainNamesRequest listDomainNamesRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return new ListDomainNamesIterable(this, listDomainNamesRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listDomainNames(software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListDomainNamesIterable responses = client.listDomainNamesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListDomainNamesIterable responses = client
     *             .listDomainNamesPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListDomainNamesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListDomainNamesIterable responses = client.listDomainNamesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listDomainNames(software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListDomainNamesRequest.Builder} avoiding the need
     * to create one manually via {@link ListDomainNamesRequest#builder()}
     * </p>
     *
     * @param listDomainNamesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListDomainNamesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListDomainNames
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListDomainNames" target="_top">AWS API
     *      Documentation</a>
     */
    default ListDomainNamesIterable listDomainNamesPaginator(Consumer<ListDomainNamesRequest.Builder> listDomainNamesRequest)
            throws AccessDeniedException, BadRequestException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listDomainNamesPaginator(ListDomainNamesRequest.builder().applyMutation(listDomainNamesRequest).build());
    }

    /**
     * <p>
     * List multiple functions.
     * </p>
     *
     * @param listFunctionsRequest
     * @return Result of the ListFunctions operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions(ListFunctionsRequest listFunctionsRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List multiple functions.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListFunctionsRequest.Builder} to create a request.
     * @return Result of the ListFunctions operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsResponse listFunctions(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return listFunctions(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.appsync.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.appsync.model.ListFunctionsRequest)} operation.</b>
     * </p>
     *
     * @param listFunctionsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsIterable listFunctionsPaginator(ListFunctionsRequest listFunctionsRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return new ListFunctionsIterable(this, listFunctionsRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listFunctions(software.amazon.awssdk.services.appsync.model.ListFunctionsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListFunctionsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListFunctionsIterable responses = client.listFunctionsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listFunctions(software.amazon.awssdk.services.appsync.model.ListFunctionsRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListFunctionsRequest.Builder} avoiding the need to
     * create one manually via {@link ListFunctionsRequest#builder()}
     * </p>
     *
     * @param listFunctionsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListFunctionsRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListFunctions
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListFunctions" target="_top">AWS API
     *      Documentation</a>
     */
    default ListFunctionsIterable listFunctionsPaginator(Consumer<ListFunctionsRequest.Builder> listFunctionsRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return listFunctionsPaginator(ListFunctionsRequest.builder().applyMutation(listFunctionsRequest).build());
    }

    /**
     * <p>
     * Lists your GraphQL APIs.
     * </p>
     *
     * @param listGraphqlApisRequest
     * @return Result of the ListGraphqlApis operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListGraphqlApis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphqlApisResponse listGraphqlApis(ListGraphqlApisRequest listGraphqlApisRequest) throws BadRequestException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists your GraphQL APIs.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphqlApisRequest.Builder} avoiding the need
     * to create one manually via {@link ListGraphqlApisRequest#builder()}
     * </p>
     *
     * @param listGraphqlApisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest.Builder} to create a request.
     * @return Result of the ListGraphqlApis operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListGraphqlApis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphqlApisResponse listGraphqlApis(Consumer<ListGraphqlApisRequest.Builder> listGraphqlApisRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listGraphqlApis(ListGraphqlApisRequest.builder().applyMutation(listGraphqlApisRequest).build());
    }

    /**
     * <p>
     * Lists your GraphQL APIs.
     * </p>
     *
     * @return Result of the ListGraphqlApis operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListGraphqlApis
     * @see #listGraphqlApis(ListGraphqlApisRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphqlApisResponse listGraphqlApis() throws BadRequestException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return listGraphqlApis(ListGraphqlApisRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGraphqlApis(software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client.listGraphqlApisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client
     *             .listGraphqlApisPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client.listGraphqlApisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphqlApis(software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest)} operation.</b>
     * </p>
     *
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListGraphqlApis
     * @see #listGraphqlApisPaginator(ListGraphqlApisRequest)
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphqlApisIterable listGraphqlApisPaginator() throws BadRequestException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return listGraphqlApisPaginator(ListGraphqlApisRequest.builder().build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGraphqlApis(software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client.listGraphqlApisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client
     *             .listGraphqlApisPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client.listGraphqlApisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphqlApis(software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest)} operation.</b>
     * </p>
     *
     * @param listGraphqlApisRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListGraphqlApis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphqlApisIterable listGraphqlApisPaginator(ListGraphqlApisRequest listGraphqlApisRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return new ListGraphqlApisIterable(this, listGraphqlApisRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listGraphqlApis(software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest)} operation. The
     * return type is a custom iterable that can be used to iterate through all the pages. SDK will internally handle
     * making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client.listGraphqlApisPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client
     *             .listGraphqlApisPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListGraphqlApisResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListGraphqlApisIterable responses = client.listGraphqlApisPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listGraphqlApis(software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListGraphqlApisRequest.Builder} avoiding the need
     * to create one manually via {@link ListGraphqlApisRequest#builder()}
     * </p>
     *
     * @param listGraphqlApisRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListGraphqlApisRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListGraphqlApis
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListGraphqlApis" target="_top">AWS API
     *      Documentation</a>
     */
    default ListGraphqlApisIterable listGraphqlApisPaginator(Consumer<ListGraphqlApisRequest.Builder> listGraphqlApisRequest)
            throws BadRequestException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listGraphqlApisPaginator(ListGraphqlApisRequest.builder().applyMutation(listGraphqlApisRequest).build());
    }

    /**
     * <p>
     * Lists the resolvers for a given API and type.
     * </p>
     *
     * @param listResolversRequest
     * @return Result of the ListResolvers operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResolversResponse listResolvers(ListResolversRequest listResolversRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the resolvers for a given API and type.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolversRequest.Builder} avoiding the need to
     * create one manually via {@link ListResolversRequest#builder()}
     * </p>
     *
     * @param listResolversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListResolversRequest.Builder} to create a request.
     * @return Result of the ListResolvers operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResolversResponse listResolvers(Consumer<ListResolversRequest.Builder> listResolversRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return listResolvers(ListResolversRequest.builder().applyMutation(listResolversRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listResolvers(software.amazon.awssdk.services.appsync.model.ListResolversRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListResolversIterable responses = client.listResolversPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListResolversIterable responses = client.listResolversPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListResolversResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListResolversIterable responses = client.listResolversPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolvers(software.amazon.awssdk.services.appsync.model.ListResolversRequest)} operation.</b>
     * </p>
     *
     * @param listResolversRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResolversIterable listResolversPaginator(ListResolversRequest listResolversRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return new ListResolversIterable(this, listResolversRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listResolvers(software.amazon.awssdk.services.appsync.model.ListResolversRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListResolversIterable responses = client.listResolversPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListResolversIterable responses = client.listResolversPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListResolversResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListResolversIterable responses = client.listResolversPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolvers(software.amazon.awssdk.services.appsync.model.ListResolversRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolversRequest.Builder} avoiding the need to
     * create one manually via {@link ListResolversRequest#builder()}
     * </p>
     *
     * @param listResolversRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListResolversRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolvers
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolvers" target="_top">AWS API
     *      Documentation</a>
     */
    default ListResolversIterable listResolversPaginator(Consumer<ListResolversRequest.Builder> listResolversRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        return listResolversPaginator(ListResolversRequest.builder().applyMutation(listResolversRequest).build());
    }

    /**
     * <p>
     * List the resolvers that are associated with a specific function.
     * </p>
     *
     * @param listResolversByFunctionRequest
     * @return Result of the ListResolversByFunction operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolversByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolversByFunctionResponse listResolversByFunction(ListResolversByFunctionRequest listResolversByFunctionRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException,
            SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * List the resolvers that are associated with a specific function.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolversByFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link ListResolversByFunctionRequest#builder()}
     * </p>
     *
     * @param listResolversByFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest.Builder} to create a
     *        request.
     * @return Result of the ListResolversByFunction operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolversByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolversByFunctionResponse listResolversByFunction(
            Consumer<ListResolversByFunctionRequest.Builder> listResolversByFunctionRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listResolversByFunction(ListResolversByFunctionRequest.builder().applyMutation(listResolversByFunctionRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResolversByFunction(software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListResolversByFunctionIterable responses = client.listResolversByFunctionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListResolversByFunctionIterable responses = client
     *             .listResolversByFunctionPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListResolversByFunctionIterable responses = client.listResolversByFunctionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolversByFunction(software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest)}
     * operation.</b>
     * </p>
     *
     * @param listResolversByFunctionRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolversByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolversByFunctionIterable listResolversByFunctionPaginator(
            ListResolversByFunctionRequest listResolversByFunctionRequest) throws BadRequestException, NotFoundException,
            UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return new ListResolversByFunctionIterable(this, listResolversByFunctionRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listResolversByFunction(software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListResolversByFunctionIterable responses = client.listResolversByFunctionPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListResolversByFunctionIterable responses = client
     *             .listResolversByFunctionPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListResolversByFunctionIterable responses = client.listResolversByFunctionPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listResolversByFunction(software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListResolversByFunctionRequest.Builder} avoiding
     * the need to create one manually via {@link ListResolversByFunctionRequest#builder()}
     * </p>
     *
     * @param listResolversByFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListResolversByFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListResolversByFunction"
     *      target="_top">AWS API Documentation</a>
     */
    default ListResolversByFunctionIterable listResolversByFunctionPaginator(
            Consumer<ListResolversByFunctionRequest.Builder> listResolversByFunctionRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, InternalFailureException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listResolversByFunctionPaginator(ListResolversByFunctionRequest.builder()
                .applyMutation(listResolversByFunctionRequest).build());
    }

    /**
     * <p>
     * Lists the <code>SourceApiAssociationSummary</code> data.
     * </p>
     *
     * @param listSourceApiAssociationsRequest
     * @return Result of the ListSourceApiAssociations operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListSourceApiAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListSourceApiAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceApiAssociationsResponse listSourceApiAssociations(
            ListSourceApiAssociationsRequest listSourceApiAssociationsRequest) throws UnauthorizedException, BadRequestException,
            InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the <code>SourceApiAssociationSummary</code> data.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceApiAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSourceApiAssociationsRequest#builder()}
     * </p>
     *
     * @param listSourceApiAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest.Builder} to create a
     *        request.
     * @return Result of the ListSourceApiAssociations operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListSourceApiAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListSourceApiAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceApiAssociationsResponse listSourceApiAssociations(
            Consumer<ListSourceApiAssociationsRequest.Builder> listSourceApiAssociationsRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listSourceApiAssociations(ListSourceApiAssociationsRequest.builder()
                .applyMutation(listSourceApiAssociationsRequest).build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSourceApiAssociations(software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListSourceApiAssociationsIterable responses = client.listSourceApiAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListSourceApiAssociationsIterable responses = client
     *             .listSourceApiAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListSourceApiAssociationsIterable responses = client.listSourceApiAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceApiAssociations(software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest)}
     * operation.</b>
     * </p>
     *
     * @param listSourceApiAssociationsRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListSourceApiAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListSourceApiAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceApiAssociationsIterable listSourceApiAssociationsPaginator(
            ListSourceApiAssociationsRequest listSourceApiAssociationsRequest) throws UnauthorizedException, BadRequestException,
            InternalFailureException, NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        return new ListSourceApiAssociationsIterable(this, listSourceApiAssociationsRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listSourceApiAssociations(software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListSourceApiAssociationsIterable responses = client.listSourceApiAssociationsPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListSourceApiAssociationsIterable responses = client
     *             .listSourceApiAssociationsPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListSourceApiAssociationsIterable responses = client.listSourceApiAssociationsPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listSourceApiAssociations(software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListSourceApiAssociationsRequest.Builder} avoiding
     * the need to create one manually via {@link ListSourceApiAssociationsRequest#builder()}
     * </p>
     *
     * @param listSourceApiAssociationsRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListSourceApiAssociationsRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListSourceApiAssociations
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListSourceApiAssociations"
     *      target="_top">AWS API Documentation</a>
     */
    default ListSourceApiAssociationsIterable listSourceApiAssociationsPaginator(
            Consumer<ListSourceApiAssociationsRequest.Builder> listSourceApiAssociationsRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, AwsServiceException, SdkClientException,
            AppSyncException {
        return listSourceApiAssociationsPaginator(ListSourceApiAssociationsRequest.builder()
                .applyMutation(listSourceApiAssociationsRequest).build());
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     *
     * @param listTagsForResourceRequest
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(ListTagsForResourceRequest listTagsForResourceRequest)
            throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the tags for a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTagsForResourceRequest.Builder} avoiding the
     * need to create one manually via {@link ListTagsForResourceRequest#builder()}
     * </p>
     *
     * @param listTagsForResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListTagsForResourceRequest.Builder} to create a
     *        request.
     * @return Result of the ListTagsForResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTagsForResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTagsForResource" target="_top">AWS
     *      API Documentation</a>
     */
    default ListTagsForResourceResponse listTagsForResource(
            Consumer<ListTagsForResourceRequest.Builder> listTagsForResourceRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppSyncException {
        return listTagsForResource(ListTagsForResourceRequest.builder().applyMutation(listTagsForResourceRequest).build());
    }

    /**
     * <p>
     * Lists the types for a given API.
     * </p>
     *
     * @param listTypesRequest
     * @return Result of the ListTypes operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesResponse listTypes(ListTypesRequest listTypesRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists the types for a given API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListTypesRequest.Builder} to create a request.
     * @return Result of the ListTypes operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesResponse listTypes(Consumer<ListTypesRequest.Builder> listTypesRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return listTypes(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.appsync.model.ListTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.appsync.model.ListTypesRequest)} operation.</b>
     * </p>
     *
     * @param listTypesRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesIterable listTypesPaginator(ListTypesRequest listTypesRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return new ListTypesIterable(this, listTypesRequest);
    }

    /**
     * <p>
     * This is a variant of {@link #listTypes(software.amazon.awssdk.services.appsync.model.ListTypesRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListTypesResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListTypesIterable responses = client.listTypesPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypes(software.amazon.awssdk.services.appsync.model.ListTypesRequest)} operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesRequest.Builder} avoiding the need to
     * create one manually via {@link ListTypesRequest#builder()}
     * </p>
     *
     * @param listTypesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListTypesRequest.Builder} to create a request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypes
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypes" target="_top">AWS API
     *      Documentation</a>
     */
    default ListTypesIterable listTypesPaginator(Consumer<ListTypesRequest.Builder> listTypesRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return listTypesPaginator(ListTypesRequest.builder().applyMutation(listTypesRequest).build());
    }

    /**
     * <p>
     * Lists <code>Type</code> objects by the source API association ID.
     * </p>
     *
     * @param listTypesByAssociationRequest
     * @return Result of the ListTypesByAssociation operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypesByAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypesByAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypesByAssociationResponse listTypesByAssociation(ListTypesByAssociationRequest listTypesByAssociationRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Lists <code>Type</code> objects by the source API association ID.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesByAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link ListTypesByAssociationRequest#builder()}
     * </p>
     *
     * @param listTypesByAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest.Builder} to create a
     *        request.
     * @return Result of the ListTypesByAssociation operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypesByAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypesByAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypesByAssociationResponse listTypesByAssociation(
            Consumer<ListTypesByAssociationRequest.Builder> listTypesByAssociationRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return listTypesByAssociation(ListTypesByAssociationRequest.builder().applyMutation(listTypesByAssociationRequest)
                .build());
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTypesByAssociation(software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListTypesByAssociationIterable responses = client.listTypesByAssociationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListTypesByAssociationIterable responses = client
     *             .listTypesByAssociationPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListTypesByAssociationIterable responses = client.listTypesByAssociationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypesByAssociation(software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest)}
     * operation.</b>
     * </p>
     *
     * @param listTypesByAssociationRequest
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypesByAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypesByAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypesByAssociationIterable listTypesByAssociationPaginator(
            ListTypesByAssociationRequest listTypesByAssociationRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return new ListTypesByAssociationIterable(this, listTypesByAssociationRequest);
    }

    /**
     * <p>
     * This is a variant of
     * {@link #listTypesByAssociation(software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest)}
     * operation. The return type is a custom iterable that can be used to iterate through all the pages. SDK will
     * internally handle making service calls for you.
     * </p>
     * <p>
     * When this operation is called, a custom iterable is returned but no service calls are made yet. So there is no
     * guarantee that the request is valid. As you iterate through the iterable, SDK will start lazily loading response
     * pages by making service calls until there are no pages left or your iteration stops. If there are errors in your
     * request, you will see the failures only after you start iterating through the iterable.
     * </p>
     *
     * <p>
     * The following are few ways to iterate through the response pages:
     * </p>
     * 1) Using a Stream
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListTypesByAssociationIterable responses = client.listTypesByAssociationPaginator(request);
     * responses.stream().forEach(....);
     * }
     * </pre>
     *
     * 2) Using For loop
     * 
     * <pre>
     * {
     *     &#064;code
     *     software.amazon.awssdk.services.appsync.paginators.ListTypesByAssociationIterable responses = client
     *             .listTypesByAssociationPaginator(request);
     *     for (software.amazon.awssdk.services.appsync.model.ListTypesByAssociationResponse response : responses) {
     *         // do something;
     *     }
     * }
     * </pre>
     *
     * 3) Use iterator directly
     * 
     * <pre>
     * {@code
     * software.amazon.awssdk.services.appsync.paginators.ListTypesByAssociationIterable responses = client.listTypesByAssociationPaginator(request);
     * responses.iterator().forEachRemaining(....);
     * }
     * </pre>
     * <p>
     * <b>Please notice that the configuration of maxResults won't limit the number of results you get with the
     * paginator. It only limits the number of results in each page.</b>
     * </p>
     * <p>
     * <b>Note: If you prefer to have control on service calls, use the
     * {@link #listTypesByAssociation(software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest)}
     * operation.</b>
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link ListTypesByAssociationRequest.Builder} avoiding the
     * need to create one manually via {@link ListTypesByAssociationRequest#builder()}
     * </p>
     *
     * @param listTypesByAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.ListTypesByAssociationRequest.Builder} to create a
     *        request.
     * @return A custom iterable that can be used to iterate through all the response pages.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.ListTypesByAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/ListTypesByAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default ListTypesByAssociationIterable listTypesByAssociationPaginator(
            Consumer<ListTypesByAssociationRequest.Builder> listTypesByAssociationRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return listTypesByAssociationPaginator(ListTypesByAssociationRequest.builder()
                .applyMutation(listTypesByAssociationRequest).build());
    }

    /**
     * <p>
     * Creates a list of environmental variables in an API by its ID value.
     * </p>
     * <p>
     * When creating an environmental variable, it must follow the constraints below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Both JavaScript and VTL templates support environmental variables.
     * </p>
     * </li>
     * <li>
     * <p>
     * Environmental variables are not evaluated before function invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Environmental variables only support string values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any defined value in an environmental variable is considered a string literal and not expanded.
     * </p>
     * </li>
     * <li>
     * <p>
     * Variable evaluations should ideally be performed in the function code.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When creating an environmental variable key-value pair, it must follow the additional constraints below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Keys must begin with a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys must be at least two characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys can only contain letters, numbers, and the underscore character (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Values can be up to 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure up to 50 key-value pairs in a GraphQL API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can create a list of environmental variables by adding it to the <code>environmentVariables</code> payload as
     * a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call of the
     * <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the existing
     * environmental variable list of that API. This means the existing environmental variables will be lost. To avoid
     * this, you must include all existing and new environmental variables in the list each time you call this action.
     * </p>
     *
     * @param putGraphqlApiEnvironmentVariablesRequest
     * @return Result of the PutGraphqlApiEnvironmentVariables operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.PutGraphqlApiEnvironmentVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/PutGraphqlApiEnvironmentVariables"
     *      target="_top">AWS API Documentation</a>
     */
    default PutGraphqlApiEnvironmentVariablesResponse putGraphqlApiEnvironmentVariables(
            PutGraphqlApiEnvironmentVariablesRequest putGraphqlApiEnvironmentVariablesRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a list of environmental variables in an API by its ID value.
     * </p>
     * <p>
     * When creating an environmental variable, it must follow the constraints below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Both JavaScript and VTL templates support environmental variables.
     * </p>
     * </li>
     * <li>
     * <p>
     * Environmental variables are not evaluated before function invocation.
     * </p>
     * </li>
     * <li>
     * <p>
     * Environmental variables only support string values.
     * </p>
     * </li>
     * <li>
     * <p>
     * Any defined value in an environmental variable is considered a string literal and not expanded.
     * </p>
     * </li>
     * <li>
     * <p>
     * Variable evaluations should ideally be performed in the function code.
     * </p>
     * </li>
     * </ul>
     * <p>
     * When creating an environmental variable key-value pair, it must follow the additional constraints below:
     * </p>
     * <ul>
     * <li>
     * <p>
     * Keys must begin with a letter.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys must be at least two characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * Keys can only contain letters, numbers, and the underscore character (_).
     * </p>
     * </li>
     * <li>
     * <p>
     * Values can be up to 512 characters long.
     * </p>
     * </li>
     * <li>
     * <p>
     * You can configure up to 50 key-value pairs in a GraphQL API.
     * </p>
     * </li>
     * </ul>
     * <p>
     * You can create a list of environmental variables by adding it to the <code>environmentVariables</code> payload as
     * a list in the format <code>{"key1":"value1","key2":"value2", …}</code>. Note that each call of the
     * <code>PutGraphqlApiEnvironmentVariables</code> action will result in the overwriting of the existing
     * environmental variable list of that API. This means the existing environmental variables will be lost. To avoid
     * this, you must include all existing and new environmental variables in the list each time you call this action.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link PutGraphqlApiEnvironmentVariablesRequest.Builder}
     * avoiding the need to create one manually via {@link PutGraphqlApiEnvironmentVariablesRequest#builder()}
     * </p>
     *
     * @param putGraphqlApiEnvironmentVariablesRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.PutGraphqlApiEnvironmentVariablesRequest.Builder} to
     *        create a request.
     * @return Result of the PutGraphqlApiEnvironmentVariables operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.PutGraphqlApiEnvironmentVariables
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/PutGraphqlApiEnvironmentVariables"
     *      target="_top">AWS API Documentation</a>
     */
    default PutGraphqlApiEnvironmentVariablesResponse putGraphqlApiEnvironmentVariables(
            Consumer<PutGraphqlApiEnvironmentVariablesRequest.Builder> putGraphqlApiEnvironmentVariablesRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        return putGraphqlApiEnvironmentVariables(PutGraphqlApiEnvironmentVariablesRequest.builder()
                .applyMutation(putGraphqlApiEnvironmentVariablesRequest).build());
    }

    /**
     * <p>
     * Creates a new introspection. Returns the <code>introspectionId</code> of the new introspection after its
     * creation.
     * </p>
     *
     * @param startDataSourceIntrospectionRequest
     * @return Result of the StartDataSourceIntrospection operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartDataSourceIntrospection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartDataSourceIntrospection"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDataSourceIntrospectionResponse startDataSourceIntrospection(
            StartDataSourceIntrospectionRequest startDataSourceIntrospectionRequest) throws NotFoundException,
            UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Creates a new introspection. Returns the <code>introspectionId</code> of the new introspection after its
     * creation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartDataSourceIntrospectionRequest.Builder}
     * avoiding the need to create one manually via {@link StartDataSourceIntrospectionRequest#builder()}
     * </p>
     *
     * @param startDataSourceIntrospectionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.StartDataSourceIntrospectionRequest.Builder} to
     *        create a request.
     * @return Result of the StartDataSourceIntrospection operation returned by the service.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartDataSourceIntrospection
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartDataSourceIntrospection"
     *      target="_top">AWS API Documentation</a>
     */
    default StartDataSourceIntrospectionResponse startDataSourceIntrospection(
            Consumer<StartDataSourceIntrospectionRequest.Builder> startDataSourceIntrospectionRequest) throws NotFoundException,
            UnauthorizedException, InternalFailureException, BadRequestException, AwsServiceException, SdkClientException,
            AppSyncException {
        return startDataSourceIntrospection(StartDataSourceIntrospectionRequest.builder()
                .applyMutation(startDataSourceIntrospectionRequest).build());
    }

    /**
     * <p>
     * Adds a new schema to your GraphQL API.
     * </p>
     * <p>
     * This operation is asynchronous. Use to determine when it has completed.
     * </p>
     *
     * @param startSchemaCreationRequest
     * @return Result of the StartSchemaCreation operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartSchemaCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaCreation" target="_top">AWS
     *      API Documentation</a>
     */
    default StartSchemaCreationResponse startSchemaCreation(StartSchemaCreationRequest startSchemaCreationRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Adds a new schema to your GraphQL API.
     * </p>
     * <p>
     * This operation is asynchronous. Use to determine when it has completed.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSchemaCreationRequest.Builder} avoiding the
     * need to create one manually via {@link StartSchemaCreationRequest#builder()}
     * </p>
     *
     * @param startSchemaCreationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.StartSchemaCreationRequest.Builder} to create a
     *        request.
     * @return Result of the StartSchemaCreation operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartSchemaCreation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaCreation" target="_top">AWS
     *      API Documentation</a>
     */
    default StartSchemaCreationResponse startSchemaCreation(
            Consumer<StartSchemaCreationRequest.Builder> startSchemaCreationRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return startSchemaCreation(StartSchemaCreationRequest.builder().applyMutation(startSchemaCreationRequest).build());
    }

    /**
     * <p>
     * Initiates a merge operation. Returns a status that shows the result of the merge operation.
     * </p>
     *
     * @param startSchemaMergeRequest
     * @return Result of the StartSchemaMerge operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartSchemaMerge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaMerge" target="_top">AWS API
     *      Documentation</a>
     */
    default StartSchemaMergeResponse startSchemaMerge(StartSchemaMergeRequest startSchemaMergeRequest)
            throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Initiates a merge operation. Returns a status that shows the result of the merge operation.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link StartSchemaMergeRequest.Builder} avoiding the need
     * to create one manually via {@link StartSchemaMergeRequest#builder()}
     * </p>
     *
     * @param startSchemaMergeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.StartSchemaMergeRequest.Builder} to create a request.
     * @return Result of the StartSchemaMerge operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.StartSchemaMerge
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/StartSchemaMerge" target="_top">AWS API
     *      Documentation</a>
     */
    default StartSchemaMergeResponse startSchemaMerge(Consumer<StartSchemaMergeRequest.Builder> startSchemaMergeRequest)
            throws UnauthorizedException, BadRequestException, InternalFailureException, NotFoundException,
            ConcurrentModificationException, AwsServiceException, SdkClientException, AppSyncException {
        return startSchemaMerge(StartSchemaMergeRequest.builder().applyMutation(startSchemaMergeRequest).build());
    }

    /**
     * <p>
     * Tags a resource with user-supplied tags.
     * </p>
     *
     * @param tagResourceRequest
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(TagResourceRequest tagResourceRequest) throws BadRequestException, NotFoundException,
            LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException, AwsServiceException,
            SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Tags a resource with user-supplied tags.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link TagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link TagResourceRequest#builder()}
     * </p>
     *
     * @param tagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.TagResourceRequest.Builder} to create a request.
     * @return Result of the TagResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.TagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/TagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default TagResourceResponse tagResource(Consumer<TagResourceRequest.Builder> tagResourceRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppSyncException {
        return tagResource(TagResourceRequest.builder().applyMutation(tagResourceRequest).build());
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     *
     * @param untagResourceRequest
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(UntagResourceRequest untagResourceRequest) throws BadRequestException,
            NotFoundException, LimitExceededException, UnauthorizedException, InternalFailureException, AccessDeniedException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Untags a resource.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UntagResourceRequest.Builder} avoiding the need to
     * create one manually via {@link UntagResourceRequest#builder()}
     * </p>
     *
     * @param untagResourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UntagResourceRequest.Builder} to create a request.
     * @return Result of the UntagResource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UntagResource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UntagResource" target="_top">AWS API
     *      Documentation</a>
     */
    default UntagResourceResponse untagResource(Consumer<UntagResourceRequest.Builder> untagResourceRequest)
            throws BadRequestException, NotFoundException, LimitExceededException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        return untagResource(UntagResourceRequest.builder().applyMutation(untagResourceRequest).build());
    }

    /**
     * <p>
     * Updates the cache for the GraphQL API.
     * </p>
     *
     * @param updateApiCacheRequest
     *        Represents the input of a <code>UpdateApiCache</code> operation.
     * @return Result of the UpdateApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateApiCacheResponse updateApiCache(UpdateApiCacheRequest updateApiCacheRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates the cache for the GraphQL API.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiCacheRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateApiCacheRequest#builder()}
     * </p>
     *
     * @param updateApiCacheRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateApiCacheRequest.Builder} to create a request.
     *        Represents the input of a <code>UpdateApiCache</code> operation.
     * @return Result of the UpdateApiCache operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateApiCache
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiCache" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateApiCacheResponse updateApiCache(Consumer<UpdateApiCacheRequest.Builder> updateApiCacheRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return updateApiCache(UpdateApiCacheRequest.builder().applyMutation(updateApiCacheRequest).build());
    }

    /**
     * <p>
     * Updates an API key. You can update the key as long as it's not deleted.
     * </p>
     *
     * @param updateApiKeyRequest
     * @return Result of the UpdateApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiKeyValidityOutOfBoundsException
     *         The API key expiration must be set to a value between 1 and 365 days from creation (for
     *         <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateApiKeyResponse updateApiKey(UpdateApiKeyRequest updateApiKeyRequest) throws BadRequestException,
            NotFoundException, UnauthorizedException, LimitExceededException, InternalFailureException,
            ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates an API key. You can update the key as long as it's not deleted.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateApiKeyRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateApiKeyRequest#builder()}
     * </p>
     *
     * @param updateApiKeyRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateApiKeyRequest.Builder} to create a request.
     * @return Result of the UpdateApiKey operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws LimitExceededException
     *         The request exceeded a limit. Try your request again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws ApiKeyValidityOutOfBoundsException
     *         The API key expiration must be set to a value between 1 and 365 days from creation (for
     *         <code>CreateApiKey</code>) or from update (for <code>UpdateApiKey</code>).
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateApiKey
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateApiKey" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateApiKeyResponse updateApiKey(Consumer<UpdateApiKeyRequest.Builder> updateApiKeyRequest)
            throws BadRequestException, NotFoundException, UnauthorizedException, LimitExceededException,
            InternalFailureException, ApiKeyValidityOutOfBoundsException, AwsServiceException, SdkClientException,
            AppSyncException {
        return updateApiKey(UpdateApiKeyRequest.builder().applyMutation(updateApiKeyRequest).build());
    }

    /**
     * <p>
     * Updates a <code>DataSource</code> object.
     * </p>
     *
     * @param updateDataSourceRequest
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDataSourceResponse updateDataSource(UpdateDataSourceRequest updateDataSourceRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>DataSource</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDataSourceRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDataSourceRequest#builder()}
     * </p>
     *
     * @param updateDataSourceRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateDataSourceRequest.Builder} to create a request.
     * @return Result of the UpdateDataSource operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateDataSource
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDataSource" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDataSourceResponse updateDataSource(Consumer<UpdateDataSourceRequest.Builder> updateDataSourceRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AwsServiceException, SdkClientException, AppSyncException {
        return updateDataSource(UpdateDataSourceRequest.builder().applyMutation(updateDataSourceRequest).build());
    }

    /**
     * <p>
     * Updates a custom <code>DomainName</code> object.
     * </p>
     *
     * @param updateDomainNameRequest
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDomainNameResponse updateDomainName(UpdateDomainNameRequest updateDomainNameRequest)
            throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException,
            NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a custom <code>DomainName</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateDomainNameRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateDomainNameRequest#builder()}
     * </p>
     *
     * @param updateDomainNameRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateDomainNameRequest.Builder} to create a request.
     * @return Result of the UpdateDomainName operation returned by the service.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateDomainName
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateDomainName" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateDomainNameResponse updateDomainName(Consumer<UpdateDomainNameRequest.Builder> updateDomainNameRequest)
            throws AccessDeniedException, BadRequestException, ConcurrentModificationException, InternalFailureException,
            NotFoundException, AwsServiceException, SdkClientException, AppSyncException {
        return updateDomainName(UpdateDomainNameRequest.builder().applyMutation(updateDomainNameRequest).build());
    }

    /**
     * <p>
     * Updates a <code>Function</code> object.
     * </p>
     *
     * @param updateFunctionRequest
     * @return Result of the UpdateFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFunctionResponse updateFunction(UpdateFunctionRequest updateFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>Function</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateFunctionRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateFunctionRequest#builder()}
     * </p>
     *
     * @param updateFunctionRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateFunctionRequest.Builder} to create a request.
     * @return Result of the UpdateFunction operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateFunction
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateFunction" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateFunctionResponse updateFunction(Consumer<UpdateFunctionRequest.Builder> updateFunctionRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        return updateFunction(UpdateFunctionRequest.builder().applyMutation(updateFunctionRequest).build());
    }

    /**
     * <p>
     * Updates a <code>GraphqlApi</code> object.
     * </p>
     *
     * @param updateGraphqlApiRequest
     * @return Result of the UpdateGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGraphqlApiResponse updateGraphqlApi(UpdateGraphqlApiRequest updateGraphqlApiRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>GraphqlApi</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateGraphqlApiRequest.Builder} avoiding the need
     * to create one manually via {@link UpdateGraphqlApiRequest#builder()}
     * </p>
     *
     * @param updateGraphqlApiRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateGraphqlApiRequest.Builder} to create a request.
     * @return Result of the UpdateGraphqlApi operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws AccessDeniedException
     *         You don't have access to perform this operation on this resource.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateGraphqlApi
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateGraphqlApi" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateGraphqlApiResponse updateGraphqlApi(Consumer<UpdateGraphqlApiRequest.Builder> updateGraphqlApiRequest)
            throws BadRequestException, ConcurrentModificationException, NotFoundException, UnauthorizedException,
            InternalFailureException, AccessDeniedException, AwsServiceException, SdkClientException, AppSyncException {
        return updateGraphqlApi(UpdateGraphqlApiRequest.builder().applyMutation(updateGraphqlApiRequest).build());
    }

    /**
     * <p>
     * Updates a <code>Resolver</code> object.
     * </p>
     *
     * @param updateResolverRequest
     * @return Result of the UpdateResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateResolverResponse updateResolver(UpdateResolverRequest updateResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>Resolver</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateResolverRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateResolverRequest#builder()}
     * </p>
     *
     * @param updateResolverRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateResolverRequest.Builder} to create a request.
     * @return Result of the UpdateResolver operation returned by the service.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateResolver
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateResolver" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateResolverResponse updateResolver(Consumer<UpdateResolverRequest.Builder> updateResolverRequest)
            throws ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            BadRequestException, AwsServiceException, SdkClientException, AppSyncException {
        return updateResolver(UpdateResolverRequest.builder().applyMutation(updateResolverRequest).build());
    }

    /**
     * <p>
     * Updates some of the configuration choices of a particular source API association.
     * </p>
     *
     * @param updateSourceApiAssociationRequest
     * @return Result of the UpdateSourceApiAssociation operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateSourceApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateSourceApiAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSourceApiAssociationResponse updateSourceApiAssociation(
            UpdateSourceApiAssociationRequest updateSourceApiAssociationRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates some of the configuration choices of a particular source API association.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateSourceApiAssociationRequest.Builder} avoiding
     * the need to create one manually via {@link UpdateSourceApiAssociationRequest#builder()}
     * </p>
     *
     * @param updateSourceApiAssociationRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateSourceApiAssociationRequest.Builder} to create
     *        a request.
     * @return Result of the UpdateSourceApiAssociation operation returned by the service.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateSourceApiAssociation
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateSourceApiAssociation"
     *      target="_top">AWS API Documentation</a>
     */
    default UpdateSourceApiAssociationResponse updateSourceApiAssociation(
            Consumer<UpdateSourceApiAssociationRequest.Builder> updateSourceApiAssociationRequest) throws UnauthorizedException,
            BadRequestException, InternalFailureException, NotFoundException, ConcurrentModificationException,
            AwsServiceException, SdkClientException, AppSyncException {
        return updateSourceApiAssociation(UpdateSourceApiAssociationRequest.builder()
                .applyMutation(updateSourceApiAssociationRequest).build());
    }

    /**
     * <p>
     * Updates a <code>Type</code> object.
     * </p>
     *
     * @param updateTypeRequest
     * @return Result of the UpdateType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTypeResponse updateType(UpdateTypeRequest updateTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        throw new UnsupportedOperationException();
    }

    /**
     * <p>
     * Updates a <code>Type</code> object.
     * </p>
     * <br/>
     * <p>
     * This is a convenience which creates an instance of the {@link UpdateTypeRequest.Builder} avoiding the need to
     * create one manually via {@link UpdateTypeRequest#builder()}
     * </p>
     *
     * @param updateTypeRequest
     *        A {@link Consumer} that will call methods on
     *        {@link software.amazon.awssdk.services.appsync.model.UpdateTypeRequest.Builder} to create a request.
     * @return Result of the UpdateType operation returned by the service.
     * @throws BadRequestException
     *         The request is not well formed. For example, a value is invalid or a required field is missing. Check the
     *         field values, and then try again.
     * @throws ConcurrentModificationException
     *         Another modification is in progress at this time and it must complete before you can make your change.
     * @throws NotFoundException
     *         The resource specified in the request was not found. Check the resource, and then try again.
     * @throws UnauthorizedException
     *         You aren't authorized to perform this operation.
     * @throws InternalFailureException
     *         An internal AppSync error occurred. Try your request again.
     * @throws SdkException
     *         Base class for all exceptions that can be thrown by the SDK (both service and client). Can be used for
     *         catch all scenarios.
     * @throws SdkClientException
     *         If any client side error occurs such as an IO related failure, failure to get credentials, etc.
     * @throws AppSyncException
     *         Base class for all service exceptions. Unknown exceptions will be thrown as an instance of this type.
     * @sample AppSyncClient.UpdateType
     * @see <a href="https://docs.aws.amazon.com/goto/WebAPI/appsync-2017-07-25/UpdateType" target="_top">AWS API
     *      Documentation</a>
     */
    default UpdateTypeResponse updateType(Consumer<UpdateTypeRequest.Builder> updateTypeRequest) throws BadRequestException,
            ConcurrentModificationException, NotFoundException, UnauthorizedException, InternalFailureException,
            AwsServiceException, SdkClientException, AppSyncException {
        return updateType(UpdateTypeRequest.builder().applyMutation(updateTypeRequest).build());
    }

    /**
     * Create a {@link AppSyncClient} with the region loaded from the
     * {@link software.amazon.awssdk.regions.providers.DefaultAwsRegionProviderChain} and credentials loaded from the
     * {@link software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider}.
     */
    static AppSyncClient create() {
        return builder().build();
    }

    /**
     * Create a builder that can be used to configure and create a {@link AppSyncClient}.
     */
    static AppSyncClientBuilder builder() {
        return new DefaultAppSyncClientBuilder();
    }

    static ServiceMetadata serviceMetadata() {
        return ServiceMetadata.of(SERVICE_METADATA_ID);
    }

    @Override
    default AppSyncServiceClientConfiguration serviceClientConfiguration() {
        throw new UnsupportedOperationException();
    }
}
