/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateMergedGraphqlApiRequest extends AppSyncRequest implements
        ToCopyableBuilder<AssociateMergedGraphqlApiRequest.Builder, AssociateMergedGraphqlApiRequest> {
    private static final SdkField<String> SOURCE_API_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourceApiIdentifier").getter(getter(AssociateMergedGraphqlApiRequest::sourceApiIdentifier))
            .setter(setter(Builder::sourceApiIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sourceApiIdentifier").build()).build();

    private static final SdkField<String> MERGED_API_IDENTIFIER_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("mergedApiIdentifier").getter(getter(AssociateMergedGraphqlApiRequest::mergedApiIdentifier))
            .setter(setter(Builder::mergedApiIdentifier))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mergedApiIdentifier").build())
            .build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(AssociateMergedGraphqlApiRequest::description))
            .setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<SourceApiAssociationConfig> SOURCE_API_ASSOCIATION_CONFIG_FIELD = SdkField
            .<SourceApiAssociationConfig> builder(MarshallingType.SDK_POJO)
            .memberName("sourceApiAssociationConfig")
            .getter(getter(AssociateMergedGraphqlApiRequest::sourceApiAssociationConfig))
            .setter(setter(Builder::sourceApiAssociationConfig))
            .constructor(SourceApiAssociationConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceApiAssociationConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_API_IDENTIFIER_FIELD,
            MERGED_API_IDENTIFIER_FIELD, DESCRIPTION_FIELD, SOURCE_API_ASSOCIATION_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sourceApiIdentifier;

    private final String mergedApiIdentifier;

    private final String description;

    private final SourceApiAssociationConfig sourceApiAssociationConfig;

    private AssociateMergedGraphqlApiRequest(BuilderImpl builder) {
        super(builder);
        this.sourceApiIdentifier = builder.sourceApiIdentifier;
        this.mergedApiIdentifier = builder.mergedApiIdentifier;
        this.description = builder.description;
        this.sourceApiAssociationConfig = builder.sourceApiAssociationConfig;
    }

    /**
     * <p>
     * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source APIs
     * (especially in your account) only require the API ID value or ARN of the source API. However, source APIs from
     * other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
     * </p>
     * 
     * @return The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source
     *         APIs (especially in your account) only require the API ID value or ARN of the source API. However, source
     *         APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source
     *         API.
     */
    public final String sourceApiIdentifier() {
        return sourceApiIdentifier;
    }

    /**
     * <p>
     * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged APIs
     * (especially in your account) only require the API ID value or ARN of the merged API. However, Merged APIs in
     * other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
     * </p>
     * 
     * @return The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
     *         APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
     *         APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged
     *         API.
     */
    public final String mergedApiIdentifier() {
        return mergedApiIdentifier;
    }

    /**
     * <p>
     * The description field.
     * </p>
     * 
     * @return The description field.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The <code>SourceApiAssociationConfig</code> object data.
     * </p>
     * 
     * @return The <code>SourceApiAssociationConfig</code> object data.
     */
    public final SourceApiAssociationConfig sourceApiAssociationConfig() {
        return sourceApiAssociationConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sourceApiIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(mergedApiIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(sourceApiAssociationConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateMergedGraphqlApiRequest)) {
            return false;
        }
        AssociateMergedGraphqlApiRequest other = (AssociateMergedGraphqlApiRequest) obj;
        return Objects.equals(sourceApiIdentifier(), other.sourceApiIdentifier())
                && Objects.equals(mergedApiIdentifier(), other.mergedApiIdentifier())
                && Objects.equals(description(), other.description())
                && Objects.equals(sourceApiAssociationConfig(), other.sourceApiAssociationConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateMergedGraphqlApiRequest").add("SourceApiIdentifier", sourceApiIdentifier())
                .add("MergedApiIdentifier", mergedApiIdentifier()).add("Description", description())
                .add("SourceApiAssociationConfig", sourceApiAssociationConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourceApiIdentifier":
            return Optional.ofNullable(clazz.cast(sourceApiIdentifier()));
        case "mergedApiIdentifier":
            return Optional.ofNullable(clazz.cast(mergedApiIdentifier()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "sourceApiAssociationConfig":
            return Optional.ofNullable(clazz.cast(sourceApiAssociationConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourceApiIdentifier", SOURCE_API_IDENTIFIER_FIELD);
        map.put("mergedApiIdentifier", MERGED_API_IDENTIFIER_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sourceApiAssociationConfig", SOURCE_API_ASSOCIATION_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateMergedGraphqlApiRequest, T> g) {
        return obj -> g.apply((AssociateMergedGraphqlApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateMergedGraphqlApiRequest> {
        /**
         * <p>
         * The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases, source
         * APIs (especially in your account) only require the API ID value or ARN of the source API. However, source
         * APIs from other accounts (cross-account use cases) strictly require the full resource ARN of the source API.
         * </p>
         * 
         * @param sourceApiIdentifier
         *        The identifier of the AppSync Source API. This is generated by the AppSync service. In most cases,
         *        source APIs (especially in your account) only require the API ID value or ARN of the source API.
         *        However, source APIs from other accounts (cross-account use cases) strictly require the full resource
         *        ARN of the source API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApiIdentifier(String sourceApiIdentifier);

        /**
         * <p>
         * The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases, Merged
         * APIs (especially in your account) only require the API ID value or ARN of the merged API. However, Merged
         * APIs in other accounts (cross-account use cases) strictly require the full resource ARN of the merged API.
         * </p>
         * 
         * @param mergedApiIdentifier
         *        The identifier of the AppSync Merged API. This is generated by the AppSync service. In most cases,
         *        Merged APIs (especially in your account) only require the API ID value or ARN of the merged API.
         *        However, Merged APIs in other accounts (cross-account use cases) strictly require the full resource
         *        ARN of the merged API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder mergedApiIdentifier(String mergedApiIdentifier);

        /**
         * <p>
         * The description field.
         * </p>
         * 
         * @param description
         *        The description field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The <code>SourceApiAssociationConfig</code> object data.
         * </p>
         * 
         * @param sourceApiAssociationConfig
         *        The <code>SourceApiAssociationConfig</code> object data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourceApiAssociationConfig(SourceApiAssociationConfig sourceApiAssociationConfig);

        /**
         * <p>
         * The <code>SourceApiAssociationConfig</code> object data.
         * </p>
         * This is a convenience method that creates an instance of the {@link SourceApiAssociationConfig.Builder}
         * avoiding the need to create one manually via {@link SourceApiAssociationConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SourceApiAssociationConfig.Builder#build()} is called immediately
         * and its result is passed to {@link #sourceApiAssociationConfig(SourceApiAssociationConfig)}.
         * 
         * @param sourceApiAssociationConfig
         *        a consumer that will call methods on {@link SourceApiAssociationConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sourceApiAssociationConfig(SourceApiAssociationConfig)
         */
        default Builder sourceApiAssociationConfig(Consumer<SourceApiAssociationConfig.Builder> sourceApiAssociationConfig) {
            return sourceApiAssociationConfig(SourceApiAssociationConfig.builder().applyMutation(sourceApiAssociationConfig)
                    .build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String sourceApiIdentifier;

        private String mergedApiIdentifier;

        private String description;

        private SourceApiAssociationConfig sourceApiAssociationConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateMergedGraphqlApiRequest model) {
            super(model);
            sourceApiIdentifier(model.sourceApiIdentifier);
            mergedApiIdentifier(model.mergedApiIdentifier);
            description(model.description);
            sourceApiAssociationConfig(model.sourceApiAssociationConfig);
        }

        public final String getSourceApiIdentifier() {
            return sourceApiIdentifier;
        }

        public final void setSourceApiIdentifier(String sourceApiIdentifier) {
            this.sourceApiIdentifier = sourceApiIdentifier;
        }

        @Override
        public final Builder sourceApiIdentifier(String sourceApiIdentifier) {
            this.sourceApiIdentifier = sourceApiIdentifier;
            return this;
        }

        public final String getMergedApiIdentifier() {
            return mergedApiIdentifier;
        }

        public final void setMergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
        }

        @Override
        public final Builder mergedApiIdentifier(String mergedApiIdentifier) {
            this.mergedApiIdentifier = mergedApiIdentifier;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final SourceApiAssociationConfig.Builder getSourceApiAssociationConfig() {
            return sourceApiAssociationConfig != null ? sourceApiAssociationConfig.toBuilder() : null;
        }

        public final void setSourceApiAssociationConfig(SourceApiAssociationConfig.BuilderImpl sourceApiAssociationConfig) {
            this.sourceApiAssociationConfig = sourceApiAssociationConfig != null ? sourceApiAssociationConfig.build() : null;
        }

        @Override
        public final Builder sourceApiAssociationConfig(SourceApiAssociationConfig sourceApiAssociationConfig) {
            this.sourceApiAssociationConfig = sourceApiAssociationConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateMergedGraphqlApiRequest build() {
            return new AssociateMergedGraphqlApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
