/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The caching configuration for a resolver that has caching activated.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CachingConfig implements SdkPojo, Serializable, ToCopyableBuilder<CachingConfig.Builder, CachingConfig> {
    private static final SdkField<Long> TTL_FIELD = SdkField.<Long> builder(MarshallingType.LONG).memberName("ttl")
            .getter(getter(CachingConfig::ttl)).setter(setter(Builder::ttl))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ttl").build()).build();

    private static final SdkField<List<String>> CACHING_KEYS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("cachingKeys")
            .getter(getter(CachingConfig::cachingKeys))
            .setter(setter(Builder::cachingKeys))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachingKeys").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(TTL_FIELD, CACHING_KEYS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Long ttl;

    private final List<String> cachingKeys;

    private CachingConfig(BuilderImpl builder) {
        this.ttl = builder.ttl;
        this.cachingKeys = builder.cachingKeys;
    }

    /**
     * <p>
     * The TTL in seconds for a resolver that has caching activated.
     * </p>
     * <p>
     * Valid values are 1–3,600 seconds.
     * </p>
     * 
     * @return The TTL in seconds for a resolver that has caching activated.</p>
     *         <p>
     *         Valid values are 1–3,600 seconds.
     */
    public final Long ttl() {
        return ttl;
    }

    /**
     * For responses, this returns true if the service returned a value for the CachingKeys property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCachingKeys() {
        return cachingKeys != null && !(cachingKeys instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The caching keys for a resolver that has caching activated.
     * </p>
     * <p>
     * Valid values are entries from the <code>$context.arguments</code>, <code>$context.source</code>, and
     * <code>$context.identity</code> maps.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCachingKeys} method.
     * </p>
     * 
     * @return The caching keys for a resolver that has caching activated.</p>
     *         <p>
     *         Valid values are entries from the <code>$context.arguments</code>, <code>$context.source</code>, and
     *         <code>$context.identity</code> maps.
     */
    public final List<String> cachingKeys() {
        return cachingKeys;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(ttl());
        hashCode = 31 * hashCode + Objects.hashCode(hasCachingKeys() ? cachingKeys() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CachingConfig)) {
            return false;
        }
        CachingConfig other = (CachingConfig) obj;
        return Objects.equals(ttl(), other.ttl()) && hasCachingKeys() == other.hasCachingKeys()
                && Objects.equals(cachingKeys(), other.cachingKeys());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CachingConfig").add("Ttl", ttl()).add("CachingKeys", hasCachingKeys() ? cachingKeys() : null)
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "ttl":
            return Optional.ofNullable(clazz.cast(ttl()));
        case "cachingKeys":
            return Optional.ofNullable(clazz.cast(cachingKeys()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("ttl", TTL_FIELD);
        map.put("cachingKeys", CACHING_KEYS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CachingConfig, T> g) {
        return obj -> g.apply((CachingConfig) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CachingConfig> {
        /**
         * <p>
         * The TTL in seconds for a resolver that has caching activated.
         * </p>
         * <p>
         * Valid values are 1–3,600 seconds.
         * </p>
         * 
         * @param ttl
         *        The TTL in seconds for a resolver that has caching activated.</p>
         *        <p>
         *        Valid values are 1–3,600 seconds.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ttl(Long ttl);

        /**
         * <p>
         * The caching keys for a resolver that has caching activated.
         * </p>
         * <p>
         * Valid values are entries from the <code>$context.arguments</code>, <code>$context.source</code>, and
         * <code>$context.identity</code> maps.
         * </p>
         * 
         * @param cachingKeys
         *        The caching keys for a resolver that has caching activated.</p>
         *        <p>
         *        Valid values are entries from the <code>$context.arguments</code>, <code>$context.source</code>, and
         *        <code>$context.identity</code> maps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingKeys(Collection<String> cachingKeys);

        /**
         * <p>
         * The caching keys for a resolver that has caching activated.
         * </p>
         * <p>
         * Valid values are entries from the <code>$context.arguments</code>, <code>$context.source</code>, and
         * <code>$context.identity</code> maps.
         * </p>
         * 
         * @param cachingKeys
         *        The caching keys for a resolver that has caching activated.</p>
         *        <p>
         *        Valid values are entries from the <code>$context.arguments</code>, <code>$context.source</code>, and
         *        <code>$context.identity</code> maps.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cachingKeys(String... cachingKeys);
    }

    static final class BuilderImpl implements Builder {
        private Long ttl;

        private List<String> cachingKeys = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CachingConfig model) {
            ttl(model.ttl);
            cachingKeys(model.cachingKeys);
        }

        public final Long getTtl() {
            return ttl;
        }

        public final void setTtl(Long ttl) {
            this.ttl = ttl;
        }

        @Override
        public final Builder ttl(Long ttl) {
            this.ttl = ttl;
            return this;
        }

        public final Collection<String> getCachingKeys() {
            if (cachingKeys instanceof SdkAutoConstructList) {
                return null;
            }
            return cachingKeys;
        }

        public final void setCachingKeys(Collection<String> cachingKeys) {
            this.cachingKeys = CachingKeysCopier.copy(cachingKeys);
        }

        @Override
        public final Builder cachingKeys(Collection<String> cachingKeys) {
            this.cachingKeys = CachingKeysCopier.copy(cachingKeys);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder cachingKeys(String... cachingKeys) {
            cachingKeys(Arrays.asList(cachingKeys));
            return this;
        }

        @Override
        public CachingConfig build() {
            return new CachingConfig(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
