/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateApiRequest extends AppSyncRequest implements
        ToCopyableBuilder<CreateApiRequest.Builder, CreateApiRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreateApiRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> OWNER_CONTACT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("ownerContact").getter(getter(CreateApiRequest::ownerContact)).setter(setter(Builder::ownerContact))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ownerContact").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreateApiRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<EventConfig> EVENT_CONFIG_FIELD = SdkField.<EventConfig> builder(MarshallingType.SDK_POJO)
            .memberName("eventConfig").getter(getter(CreateApiRequest::eventConfig)).setter(setter(Builder::eventConfig))
            .constructor(EventConfig::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eventConfig").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD,
            OWNER_CONTACT_FIELD, TAGS_FIELD, EVENT_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String name;

    private final String ownerContact;

    private final Map<String, String> tags;

    private final EventConfig eventConfig;

    private CreateApiRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.ownerContact = builder.ownerContact;
        this.tags = builder.tags;
        this.eventConfig = builder.eventConfig;
    }

    /**
     * <p>
     * The name for the <code>Api</code>.
     * </p>
     * 
     * @return The name for the <code>Api</code>.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The owner contact information for the <code>Api</code>.
     * </p>
     * 
     * @return The owner contact information for the <code>Api</code>.
     */
    public final String ownerContact() {
        return ownerContact;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * Returns the value of the Tags property for this object.
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The value of the Tags property for this object.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    /**
     * <p>
     * The Event API configuration. This includes the default authorization configuration for connecting, publishing,
     * and subscribing to an Event API.
     * </p>
     * 
     * @return The Event API configuration. This includes the default authorization configuration for connecting,
     *         publishing, and subscribing to an Event API.
     */
    public final EventConfig eventConfig() {
        return eventConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(ownerContact());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        hashCode = 31 * hashCode + Objects.hashCode(eventConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateApiRequest)) {
            return false;
        }
        CreateApiRequest other = (CreateApiRequest) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(ownerContact(), other.ownerContact())
                && hasTags() == other.hasTags() && Objects.equals(tags(), other.tags())
                && Objects.equals(eventConfig(), other.eventConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateApiRequest").add("Name", name()).add("OwnerContact", ownerContact())
                .add("Tags", hasTags() ? tags() : null).add("EventConfig", eventConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "ownerContact":
            return Optional.ofNullable(clazz.cast(ownerContact()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        case "eventConfig":
            return Optional.ofNullable(clazz.cast(eventConfig()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("ownerContact", OWNER_CONTACT_FIELD);
        map.put("tags", TAGS_FIELD);
        map.put("eventConfig", EVENT_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateApiRequest, T> g) {
        return obj -> g.apply((CreateApiRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends AppSyncRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateApiRequest> {
        /**
         * <p>
         * The name for the <code>Api</code>.
         * </p>
         * 
         * @param name
         *        The name for the <code>Api</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The owner contact information for the <code>Api</code>.
         * </p>
         * 
         * @param ownerContact
         *        The owner contact information for the <code>Api</code>.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ownerContact(String ownerContact);

        /**
         * Sets the value of the Tags property for this object.
         *
         * @param tags
         *        The new value for the Tags property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        /**
         * <p>
         * The Event API configuration. This includes the default authorization configuration for connecting,
         * publishing, and subscribing to an Event API.
         * </p>
         * 
         * @param eventConfig
         *        The Event API configuration. This includes the default authorization configuration for connecting,
         *        publishing, and subscribing to an Event API.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eventConfig(EventConfig eventConfig);

        /**
         * <p>
         * The Event API configuration. This includes the default authorization configuration for connecting,
         * publishing, and subscribing to an Event API.
         * </p>
         * This is a convenience method that creates an instance of the {@link EventConfig.Builder} avoiding the need to
         * create one manually via {@link EventConfig#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EventConfig.Builder#build()} is called immediately and its result
         * is passed to {@link #eventConfig(EventConfig)}.
         * 
         * @param eventConfig
         *        a consumer that will call methods on {@link EventConfig.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eventConfig(EventConfig)
         */
        default Builder eventConfig(Consumer<EventConfig.Builder> eventConfig) {
            return eventConfig(EventConfig.builder().applyMutation(eventConfig).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends AppSyncRequest.BuilderImpl implements Builder {
        private String name;

        private String ownerContact;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private EventConfig eventConfig;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateApiRequest model) {
            super(model);
            name(model.name);
            ownerContact(model.ownerContact);
            tags(model.tags);
            eventConfig(model.eventConfig);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getOwnerContact() {
            return ownerContact;
        }

        public final void setOwnerContact(String ownerContact) {
            this.ownerContact = ownerContact;
        }

        @Override
        public final Builder ownerContact(String ownerContact) {
            this.ownerContact = ownerContact;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagMapCopier.copy(tags);
            return this;
        }

        public final EventConfig.Builder getEventConfig() {
            return eventConfig != null ? eventConfig.toBuilder() : null;
        }

        public final void setEventConfig(EventConfig.BuilderImpl eventConfig) {
            this.eventConfig = eventConfig != null ? eventConfig.build() : null;
        }

        @Override
        public final Builder eventConfig(EventConfig eventConfig) {
            this.eventConfig = eventConfig;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateApiRequest build() {
            return new CreateApiRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
